/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.XMLUtil;
import com.ibm.ecm.util.p8.P8BaseAnnotation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8InboundAnnotation
extends P8BaseAnnotation {
    private static final String ANNOTATION_VALIDATOR_CLASS = "com.filenet.engine.is.pd.AnnotValidator";
    private static final String ANNOTATION_VALIDATOR_METHOD = "validate";
    private static final String STATE_ATTRIBUTE = "STATE";
    private static ExceptionCode IS_ANNOT_TOO_LARGE = P8InboundAnnotation.getExceptionCode(null, "IS_ANNOT_TOO_LARGE");
    private static ExceptionCode IS_ANNOT_ATTR_INVALID = P8InboundAnnotation.getExceptionCode(null, "IS_ANNOT_ATTR_INVALID");
    private static ExceptionCode IS_ANNOT_NOT_SUPPORTED = P8InboundAnnotation.getExceptionCode(null, "IS_ANNOT_NOT_SUPPORTED");
    private static Boolean ANNOTATION_VALIDATOR_SUPPORTED;
    private static final String ANNOT_ID_ATTRIBUTE_NAME = "F_ANNOTATEDID";
    private static final String ID_ATTRIBUTE_NAME = "F_ID";
    private static final String CLASSNAME_ATTRIBUTE_NAME = "";
    private String operation;

    private static ExceptionCode getExceptionCode(HttpServletRequest request, String variableName) {
        ExceptionCode returnValue;
        String methodName;
        block3: {
            methodName = "getExceptionCode";
            Logger.logEntry(P8InboundAnnotation.class, methodName, (ServletRequest)request);
            returnValue = null;
            Class<ExceptionCode> ecClass = ExceptionCode.class;
            Field field = null;
            try {
                field = ecClass.getDeclaredField(variableName);
                if (field != null) {
                    returnValue = (ExceptionCode)field.get(null);
                }
            }
            catch (Exception exc) {
                if (!Logger.isDebugLogged()) break block3;
                Logger.logError(P8InboundAnnotation.class, methodName, (ServletRequest)request, exc.toString());
            }
        }
        Logger.logExit(P8InboundAnnotation.class, methodName, (ServletRequest)request);
        return returnValue;
    }

    public static List<P8InboundAnnotation> getInboundAnnotations(HttpServletRequest request, String annotationUpdateXml) throws IOException, SAXException, ParserConfigurationException {
        Document annotationXml = XMLUtil.getDocumentFromString(annotationUpdateXml);
        NodeList annoNodes = annotationXml.getElementsByTagName("FnAnno");
        int listSize = annoNodes.getLength();
        ArrayList<P8InboundAnnotation> annotUpdates = new ArrayList<P8InboundAnnotation>();
        for (int n = 0; n < listSize; ++n) {
            Node fnAnno = annoNodes.item(n);
            P8InboundAnnotation annotUpdate = new P8InboundAnnotation(request, XMLUtil.saveToString(fnAnno));
            annotUpdates.add(annotUpdate);
        }
        return annotUpdates;
    }

    public P8InboundAnnotation(HttpServletRequest request, String annotXml) {
        super(request, annotXml);
        this.loadAnnotOperation();
    }

    public String getOperation() {
        return this.operation;
    }

    public InputStream getXmlInputStream() {
        String theXml = XMLUtil.saveToString(this.fnAnno);
        ByteArrayInputStream is = new ByteArrayInputStream(theXml.getBytes());
        return is;
    }

    public String getAnnotId() {
        Node idNode = this.getAnnotIdNode();
        String annotId = null;
        if (idNode != null) {
            annotId = idNode.getNodeValue();
        }
        return annotId != null ? annotId.toUpperCase() : null;
    }

    public void setAnnotId(String id) {
        NamedNodeMap nnMap = this.getPropDescMap();
        if (nnMap != null) {
            Node node = nnMap.getNamedItem(ANNOT_ID_ATTRIBUTE_NAME);
            node.setNodeValue(id);
            node = nnMap.getNamedItem(ID_ATTRIBUTE_NAME);
            node.setNodeValue(id);
        }
    }

    public void validate() throws InvocationTargetException, Exception {
        boolean useDummyAnnotId;
        String methodName;
        block16: {
            methodName = ANNOTATION_VALIDATOR_METHOD;
            Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
            String annotId = this.getAnnotId();
            boolean bl = useDummyAnnotId = this.operation.equalsIgnoreCase("add") && (annotId == null || annotId.length() == 0);
            if (useDummyAnnotId) {
                this.setAnnotId("{93ad6358-48cf-42be-b27b-8a2530617446}");
            }
            String encoding = this.text != null ? this.text.encoding : null;
            try {
                if (!this.isAnnotationValidatorSupported()) break block16;
                Method method = null;
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, MessageFormat.format("Retrieve validator method: {0}", ANNOTATION_VALIDATOR_METHOD));
                try {
                    Class<?> annotationValidatorClass = Class.forName(ANNOTATION_VALIDATOR_CLASS);
                    Class[] params = new Class[]{InputStream.class, String.class, String.class};
                    method = annotationValidatorClass.getMethod(ANNOTATION_VALIDATOR_METHOD, params);
                }
                catch (Exception e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, MessageFormat.format("Failed to get the method {0}", ANNOTATION_VALIDATOR_METHOD));
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    method = null;
                }
                if (method != null) {
                    if (encoding == null || encoding.length() == 0) {
                        encoding = "unicode";
                    }
                    byte[] bytes = XMLUtil.saveToString(this.fnAnno).getBytes(encoding);
                    ByteArrayInputStream inStream = new ByteArrayInputStream(bytes);
                    String id = this.getAnnotId();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, MessageFormat.format("Invoke validate method. Annot Id={0}, Char Encoding={1}", id, encoding));
                    method.invoke(null, inStream, id, encoding);
                }
            }
            catch (InvocationTargetException ie) {
                Throwable t = ie.getTargetException();
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, MessageFormat.format("Failed to invoke the method validate - content = {1}, encoding = {2}", XMLUtil.saveToString(this.fnAnno), encoding));
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)ie);
                if (t instanceof EngineRuntimeException) {
                    String errorMessage;
                    EngineRuntimeException ere = (EngineRuntimeException)t;
                    ExceptionCode ec = ere.getExceptionCode();
                    if (ec != null && ec == IS_ANNOT_TOO_LARGE) {
                        errorMessage = "Annotation length is larger than 800 characters";
                    } else if (ec != null && ec == IS_ANNOT_ATTR_INVALID) {
                        errorMessage = MessageFormat.format("Annotation attribute is invalid - {0}", t.getLocalizedMessage());
                    } else if (ec != null && ec == IS_ANNOT_NOT_SUPPORTED) {
                        String className = (String)this.propDescMap.get(CLASSNAME_ATTRIBUTE_NAME);
                        errorMessage = MessageFormat.format("The annotation type {0} is invalid. The annotation ID is {1}.", className, this.getAnnotId());
                    } else {
                        errorMessage = MessageFormat.format("server.WcmAnnotXSLModule.AnnotationsError", "Annotation error - {0}", t.getLocalizedMessage());
                    }
                    throw new Exception(errorMessage, t);
                }
                throw ie;
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, MessageFormat.format("Failed to invoke the method validate - content = {1}, encoding = {2} ", XMLUtil.saveToString(this.fnAnno), encoding));
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                throw e;
            }
        }
        if (useDummyAnnotId) {
            this.setAnnotId(CLASSNAME_ATTRIBUTE_NAME);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    private boolean isAnnotationValidatorSupported() {
        return ANNOTATION_VALIDATOR_SUPPORTED;
    }

    private NamedNodeMap getPropDescMap() {
        NamedNodeMap nnMap = null;
        Node propDescNode = XMLUtil.getChildNode(this.fnAnno, "PropDesc");
        if (propDescNode != null) {
            nnMap = propDescNode.getAttributes();
        }
        return nnMap;
    }

    private Node getAnnotIdNode() {
        NamedNodeMap nnMap = this.getPropDescMap();
        Node idNode = null;
        if (nnMap != null) {
            idNode = nnMap.getNamedItem(ANNOT_ID_ATTRIBUTE_NAME);
        }
        return idNode;
    }

    private void loadAnnotOperation() {
        NamedNodeMap nnMap = this.fnAnno.getAttributes();
        Node stateNode = nnMap.getNamedItem(STATE_ATTRIBUTE);
        if (stateNode != null) {
            this.operation = stateNode.getNodeValue();
            this.fnAnno.removeAttribute(STATE_ATTRIBUTE);
        } else {
            this.operation = null;
        }
    }

    static {
        try {
            Class.forName(ANNOTATION_VALIDATOR_CLASS);
            ANNOTATION_VALIDATOR_SUPPORTED = true;
        }
        catch (ClassNotFoundException e) {
            Logger.logDebug(P8InboundAnnotation.class, "static initializer", (ServletRequest)((HttpServletRequest)null), "Annotation Validator is not available in this release.");
            ANNOTATION_VALIDATOR_SUPPORTED = false;
        }
    }
}

