/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.collection.AnnotationSet;
import com.filenet.api.collection.ContentElementList;
import com.filenet.api.collection.DocumentSet;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.Annotation;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.core.Document;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.query.SearchSQL;
import com.filenet.api.query.SearchScope;
import com.filenet.api.util.Id;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.ecm.util.p8.P8WcmPrefsObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8FolderTemplates
extends P8WcmPrefsObject {
    public static final String MIME_TYPE_TEMPLATE_ASSOCIATIONS = "application/x-filenet-folderprefs-templates";
    private static final String CLASS_ID_FOLDER_PREFERENCES = "{4775D110-30E7-4142-87A3-BFFECCC5E996}";
    private static final String CURRENT_XML_SCHEMA_VERSION = "1.0";
    private static final String FOLDER_TEMPLATES = "folderTemplates";
    private List<P8FolderTemplate> folderTemplates;

    public static void associateTemplatesWithFolder(P8Connection connection, ObjectStore objectStore, List<String> templateIds, String folderId) throws Exception {
        Annotation annot;
        StringBuilder where;
        SearchSQL search;
        DocumentSet templates = null;
        if (templateIds != null && !templateIds.isEmpty()) {
            search = new SearchSQL();
            search.setSelectList("VersionSeries");
            search.setFromClauseInitialValue("EntryTemplate", null, true);
            where = new StringBuilder();
            for (String templateId : templateIds) {
                if (where.length() > 0) {
                    where.append(" OR ");
                }
                where.append("Id").append(" = '").append(P8Util.getObjectIdentity(templateId)).append("'");
            }
            where.insert(0, "(").append(")");
            where.append(" AND ").append("MimeType").append(" = '").append("application/x-filenet-documententrytemplate").append("'");
            search.setWhereClause(where.toString());
            SearchScope scope = new SearchScope(objectStore);
            templates = (DocumentSet)scope.fetchObjects(search, null, null, Boolean.valueOf(false));
        }
        search = new SearchSQL();
        search.setSelectList("DateLastModified");
        search.setFromClauseInitialValue("Annotation", null, true);
        where = new StringBuilder();
        String folderObjectId = P8Util.getObjectIdentity(folderId);
        where.append("(").append("AnnotatedObject").append(" = Object('").append(folderObjectId).append("'))");
        where.append(" AND ").append("MimeType").append(" = '").append(MIME_TYPE_TEMPLATE_ASSOCIATIONS).append("'");
        search.setWhereClause(where.toString());
        SearchScope scope = new SearchScope(objectStore);
        AnnotationSet annots = (AnnotationSet)scope.fetchObjects(search, null, null, Boolean.valueOf(false));
        Annotation annotation = annot = annots != null && !annots.isEmpty() ? (Annotation)annots.iterator().next() : null;
        if (templates == null || templates.isEmpty()) {
            if (annot != null) {
                annot.delete();
                annot.save(RefreshMode.NO_REFRESH);
            }
            return;
        }
        P8FolderTemplates folderTemplates = new P8FolderTemplates();
        ArrayList<P8FolderTemplate> folderTemplatesList = new ArrayList<P8FolderTemplate>();
        for (Document template : templates) {
            P8FolderTemplate folderTemplate = new P8FolderTemplate();
            folderTemplate.setTemplateObjectStoreName(objectStore.get_Name());
            folderTemplate.setTemplateVersionSeriesId(template.get_VersionSeries().get_Id().toString());
            folderTemplatesList.add(folderTemplate);
        }
        folderTemplates.setFolderTemplates(folderTemplatesList);
        if (annot == null) {
            Folder folder = Factory.Folder.getInstance((ObjectStore)objectStore, (String)"Folder", (Id)new Id(folderObjectId));
            annot = Factory.Annotation.createInstance((ObjectStore)objectStore, (String)CLASS_ID_FOLDER_PREFERENCES);
            annot.set_AnnotatedObject((IndependentObject)folder);
            annot.set_MimeType(MIME_TYPE_TEMPLATE_ASSOCIATIONS);
        }
        ContentElementList contents = Factory.ContentElement.createList();
        ContentTransfer content = Factory.ContentTransfer.createInstance();
        ByteArrayInputStream is = new ByteArrayInputStream(folderTemplates.toByteArrayXML());
        content.setCaptureSource((InputStream)is);
        content.set_ContentType("application/xml");
        contents.add((Object)content);
        annot.set_ContentElements(contents);
        annot.save(RefreshMode.NO_REFRESH);
    }

    public List<P8FolderTemplate> getFolderTemplates() {
        return this.folderTemplates;
    }

    public void setFolderTemplates(List<P8FolderTemplate> folderTemplates) {
        this.folderTemplates = folderTemplates;
    }

    @Override
    protected void initialize() {
        this.folderTemplates = (List)this.remove(FOLDER_TEMPLATES);
    }

    @Override
    protected void saveToXML(Writer w) throws IOException {
        if (this.folderTemplates != null) {
            this.writeSetting(w, FOLDER_TEMPLATES, this.folderTemplates);
        }
    }

    @Override
    protected void persist() {
        this.setVersion(CURRENT_XML_SCHEMA_VERSION);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        P8FolderTemplates clone = (P8FolderTemplates)super.clone();
        if (this.folderTemplates != null) {
            ArrayList<P8FolderTemplate> templates = new ArrayList<P8FolderTemplate>(this.folderTemplates.size());
            for (P8FolderTemplate template : this.folderTemplates) {
                templates.add((P8FolderTemplate)template.clone());
            }
            clone.folderTemplates = templates;
        }
        return clone;
    }

    public static class P8FolderTemplate
    extends P8WcmPrefsObject
    implements Cloneable {
        private static final String TEMPLATE_OBJECT_STORE_NAME = "templateObjectStoreName";
        private static final String TEMPLATE_VERSION_SERIES_ID = "templateVersionSeriesId";
        private static final String FILE_TYPES = "fileTypes";
        private String templateObjectStoreName;
        private String templateVersionSeriesId;
        private String[] fileTypes;

        public String getTemplateObjectStoreName() {
            return this.templateObjectStoreName;
        }

        public void setTemplateObjectStoreName(String templateObjectStoreName) {
            this.templateObjectStoreName = templateObjectStoreName;
        }

        public String getTemplateVersionSeriesId() {
            return this.templateVersionSeriesId;
        }

        public void setTemplateVersionSeriesId(String templateVersionSeriesId) {
            this.templateVersionSeriesId = templateVersionSeriesId;
        }

        public String[] getFileTypes() {
            return this.fileTypes;
        }

        public void setFileTypes(String[] fileTypes) {
            this.fileTypes = fileTypes;
        }

        protected void initialize() {
            this.templateObjectStoreName = (String)this.remove(TEMPLATE_OBJECT_STORE_NAME);
            this.templateVersionSeriesId = (String)this.remove(TEMPLATE_VERSION_SERIES_ID);
            this.fileTypes = (String[])this.remove(FILE_TYPES);
        }

        protected void saveToXML(Writer w) throws IOException {
            this.writeSetting(w, TEMPLATE_OBJECT_STORE_NAME, this.templateObjectStoreName);
            this.writeSetting(w, TEMPLATE_VERSION_SERIES_ID, this.templateVersionSeriesId);
            this.writeSetting(w, FILE_TYPES, this.fileTypes);
        }

        public Object clone() throws CloneNotSupportedException {
            P8FolderTemplate clone = (P8FolderTemplate)super.clone();
            clone.fileTypes = (String[])this.fileTypes.clone();
            return clone;
        }
    }
}

