/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.Document;
import com.filenet.api.core.Factory;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.VersionSeries;
import com.filenet.api.core.Versionable;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.Properties;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.ecm.util.p8.P8Workflow;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWParameter;
import filenet.vw.api.VWRoster;
import filenet.vw.api.VWRosterQuery;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class P8EntryTemplateWorkflow {
    public static final String ENTRY_TEMPLATE_MODE = "et";
    public static final String CURRENT = "current";
    public static final String RELEASE = "release";
    public static final String ENTRY_TEMPLATE_LAUNCH_WORKFLOW_NUMBER = "EntryTemplateLaunchedWorkflowNumber";
    public static final String STYLE_APROVAL = "Approval";
    public static final String STYLE_SEQUENCE = "Sequence";
    public static final String STYLE_DESIGNER = "Designer";
    public static final String WORKFLOW_GROUP = "WorkflowGroup";
    public static final String VOTING_TOTAL = "VotingTotal";

    public static VWStepElement createWorkflow(HttpServletRequest request, VWSession vwSession, String workflowVersion, String subject, VWAttachment attachment) throws Exception {
        String methodName = "createWorkflow";
        Logger.logEntry(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request);
        VWStepElement stepElement = null;
        if (vwSession.checkWorkflowIdentifier(workflowVersion)) {
            stepElement = vwSession.createWorkflow(workflowVersion);
            if (subject != null && subject.length() > 0) {
                stepElement.setParameterValue("F_Subject", (Object)subject, true);
            }
            String mainAttachmentParameterName = null;
            try {
                VWParameter mainAttachmentParameter;
                mainAttachmentParameterName = (String)stepElement.getParameterValue("F_MAINATTACHMENT");
                if (mainAttachmentParameterName != null && attachment != null && (mainAttachmentParameter = stepElement.getParameter(mainAttachmentParameterName)) != null) {
                    P8Workflow.addMainAttachment(request, stepElement, mainAttachmentParameter, attachment, mainAttachmentParameterName);
                }
            }
            catch (Exception e) {}
        } else {
            Logger.logDebug(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request, "Invalid workflow version = " + workflowVersion);
        }
        Logger.logExit(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request);
        return stepElement;
    }

    public static String getAttachmentId(HttpServletRequest request, P8Connection connection, String objectStoreName, String objectType, String objectLabel, String objectId) {
        String methodName = "getAttachmentId";
        Logger.logEntry(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request);
        String id = objectId;
        if (objectType.equals("document")) {
            id = P8EntryTemplateWorkflow.getVsIdFromId(request, connection, objectStoreName, objectId);
        }
        String attachmentId = P8Workflow.getWorkflowAttachmentId(objectStoreName, id, objectLabel, objectType);
        Logger.logDebug(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request, "Attachment id = " + attachmentId);
        Logger.logExit(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request);
        return attachmentId;
    }

    public static String getVsIdFromId(HttpServletRequest request, P8Connection connection, String objectStoreName, String id) {
        String methodName = "getVsIdFromId";
        Logger.logEntry(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request);
        String vsId = null;
        if (id != null) {
            VersionSeries versionSeries;
            Logger.logDebug(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request, "Get vsId from id = " + id + ", os = " + objectStoreName);
            ObjectStore os = P8Util.getObjectStore(connection, objectStoreName);
            PropertyFilter pf = new PropertyFilter();
            pf.addIncludeProperty(1, null, null, "VersionSeries", null);
            pf.addIncludeProperty(1, null, null, "Id", null);
            Document doc = Factory.Document.fetchInstance((ObjectStore)os, (Id)new Id(id), (PropertyFilter)pf);
            if (doc != null && (versionSeries = doc.get_VersionSeries()) != null) {
                vsId = versionSeries.get_Id().toString();
                Logger.logDebug(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request, "vi id = " + vsId);
            }
        }
        Logger.logExit(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request);
        return vsId;
    }

    public static void saveWorkflowNumber(HttpServletRequest request, P8Connection connection, String objectStoreName, String objectId, String vsId, String workflowNumber) {
        String methodName = "saveWorkflowNumber";
        Logger.logEntry(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request);
        ObjectStore os = P8Util.getObjectStore(connection, objectStoreName);
        Id id = null;
        if (objectId == null && vsId != null) {
            id = new Id(vsId);
            VersionSeries versionSeries = Factory.VersionSeries.fetchInstance((ObjectStore)os, (Id)id, null);
            Versionable currentVersionObject = versionSeries.get_CurrentVersion();
            Document document = (Document)currentVersionObject;
            id = document.get_Id();
        } else {
            id = new Id(objectId);
        }
        Document doc = (Document)os.getObject("Document", id);
        Properties props = doc.getProperties();
        props.putValue(ENTRY_TEMPLATE_LAUNCH_WORKFLOW_NUMBER, workflowNumber);
        doc.save(RefreshMode.NO_REFRESH);
        Logger.logExit(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request);
    }

    public static boolean isWorkflowRunning(HttpServletRequest request, P8Connection connection, String objectStoreName, String objectId) {
        String methodName = "isWorkflowRunning";
        Logger.logEntry(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request);
        boolean workflowRunning = false;
        try {
            ObjectStore os = P8Util.getObjectStore(connection, objectStoreName);
            PropertyFilter pf = new PropertyFilter();
            pf.addIncludeProperty(new FilterElement(Integer.valueOf(0), null, null, ENTRY_TEMPLATE_LAUNCH_WORKFLOW_NUMBER, null));
            Document doc = (Document)os.fetchObject("Document", objectId, pf);
            Properties props = doc.getProperties();
            String workflowNumber = props.getStringValue(ENTRY_TEMPLATE_LAUNCH_WORKFLOW_NUMBER);
            if (workflowNumber != null && workflowNumber.length() > 0) {
                VWSession vwSession = P8Workflow.getVWSession(connection, request);
                Logger.logDebug(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request, "Check if the workflow is running, workflowNumber = " + workflowNumber);
                workflowRunning = P8EntryTemplateWorkflow.isWorkflowRunningOnProcessEngine(request, connection, vwSession, workflowNumber);
                if (workflowRunning) {
                    Logger.logDebug(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request, "Workflow is running");
                }
            }
        }
        catch (Exception e) {
            Logger.logDebug(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request, "Failed to determine if the workflow is running.");
        }
        Logger.logExit(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request);
        return workflowRunning;
    }

    private static boolean isWorkflowRunningOnProcessEngine(HttpServletRequest request, P8Connection connection, VWSession vwSession, String workflowNumber) throws Exception {
        String methodName = "isWorkflowRunningOnProcessEngine";
        Logger.logEntry(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request);
        if (workflowNumber.equalsIgnoreCase(STYLE_DESIGNER)) {
            return true;
        }
        String[] rosterNames = vwSession.fetchRosterNames(false);
        String queryParameters = "F_TrackerStatus=0";
        Object[] minMaxValues = new Object[]{vwSession.getDatabaseType() == 2 ? "0x" + workflowNumber : workflowNumber};
        int queryFlags = 100;
        for (int i = 0; i < rosterNames.length; ++i) {
            String rosterName = rosterNames[i];
            VWRoster vwRoster = vwSession.getRoster(rosterName);
            try {
                VWRosterQuery query = vwRoster.createQuery("F_WorkFlowNumber", minMaxValues, minMaxValues, queryFlags, queryParameters, null, 4);
                if (query == null || !query.hasNext()) continue;
                Logger.logExit(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request);
                return true;
            }
            catch (VWException ex) {
                Logger.logDebug(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request, "Error running query for running workflow, message = " + ex.getLocalizedMessage());
            }
        }
        Logger.logExit(P8EntryTemplateWorkflow.class, methodName, (ServletRequest)request);
        return false;
    }
}

