/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.collection.ContentElementList;
import com.filenet.api.collection.ObjectStoreSet;
import com.filenet.api.constants.AutoClassify;
import com.filenet.api.constants.Cardinality;
import com.filenet.api.constants.CheckinType;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.constants.TypeID;
import com.filenet.api.core.ContentElement;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.core.Document;
import com.filenet.api.core.Factory;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.VersionSeries;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Permission;
import com.ibm.ecm.util.p8.P8SearchTemplate;
import com.ibm.ecm.util.p8.P8Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RegexMatcher;
import org.apache.commons.digester.RegexRules;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.SimpleRegexMatcher;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8EntryTemplate {
    public static final String NAMESPACE_URI = "http://filenet.com/namespaces/wcm/apps/1.0";
    public static final String XML_DATE_FORMAT = "YYYY-MM-DDThh:mm:ssTZD";
    public static final String ENTRY_TEMPLATE_CLASS = "EntryTemplate";
    public static final String ENTRY_TEMPLATE_CLASS_ID = "{0D6EE258-EC6A-4366-9DB5-257584686044}";
    public static final String FORM_DATA_CLASS_ID = "{F007569B-B179-40CB-8EE8-D236AEA6C157}";
    public static final String MIME_TYPE = "application/x-filenet-entrytemplate";
    public static final String MIME_TYPE_DOCUMENT = "application/x-filenet-documententrytemplate";
    public static final String MIME_TYPE_FOLDER = "application/x-filenet-folderentrytemplate";
    public static final String MIME_TYPE_CUSTOMOBJECT = "application/x-filenet-customobjectentrytemplate";
    private static final String TEMPLATE_TYPE = "templatetype";
    private static final String ELEM_AUTO_CLASSIFY = "autoclassify";
    private static final String ELEM_CLASS_DESC = "classdesc";
    private static final String ELEM_FOLDER = "folder";
    private static final String ELEM_INSTRUCTIONS = "instructions";
    private static final String ELEM_INSTRUCTION = "instruction";
    private static final String INST_AUTO_CLASSIFY = "autoclassify";
    private static final String INST_AUTO_UNIQUE = "autounique";
    private static final String INST_CLASSIFY_RECORD = "classifyrecord";
    private static final String INST_CONSTRAIN_FOLDER = "constrainfolder";
    private static final String INST_PROMPT_WORKFLOW = "promptworkflow";
    private static final String INST_RECORDS_TEMPLATE = "recordstemplate";
    private static final String INST_RUN_WORKFLOW = "runworkflow";
    private static final String INST_SELECT_FILE = "selectfile";
    private static final String INST_SELECT_FOLDER = "selectfolder";
    private static final String INST_SELECT_PARTICIPANT = "selectparticipant";
    private static final String INST_SELECT_PROPERTIES = "setproperties";
    private static final String INST_SET_SECURITY = "setsecurity";
    private static final String INST_USE_FOR_CHECKIN = "useforcheckin";
    private static final String ELEM_OBJECT_STORE = "objectstore";
    private static final String ELEM_PROP_DESCS = "propdescs";
    private static final String ELEM_PROP_DESC = "propdesc";
    private static final String ELEM_PERMISSIONS = "permissions";
    private static final String ELEM_PERMISSION = "permission";
    private static final String ELEM_REQCLASS = "reqclass";
    private static final String ELEM_SECURITY_POLICY = "securitypolicy";
    private static final String ELEM_TYPE = "type";
    private static final String ELEM_RECORD = "record";
    private static final String ELEM_VERSION = "version";
    private static final String ELEM_WEB = "web";
    private static final String ELEM_WORKFLOW = "workflow";
    private static final String TYPE_CUSTOMOBJECT = "customobject";
    private static final String TYPE_DOCUMENT = "document";
    private static final String TYPE_FOLDER = "folder";
    private static final String ELEM_ALLOWS_FOREIGN_OBJECT = "allowsforeignobject";
    private static final String ELEM_BEHAVIOR = "behavior";
    private static final String ELEM_CARDINALITY = "cardinality";
    private static final String ELEM_CONVERT = "convert";
    private static final String ELEM_DATA_TYPE = "datatype";
    private static final String ELEM_DEFINED = "defined";
    private static final String ELEM_DESCTEXT = "desctext";
    private static final String ELEM_DISP_NAME = "dispname";
    private static final String ELEM_ID = "id";
    private static final String ELEM_IS_HIDDEN = "ishidden";
    private static final String ELEM_IS_HIERARCHICAL = "ishierarchical";
    private static final String ELEM_IS_ORDERABLE = "isorderable";
    private static final String ELEM_IS_READONLY = "isreadonly";
    private static final String ELEM_IS_SEARCHABLE = "issearchable";
    private static final String ELEM_IS_SECURITY_PROXY = "issecurityproxy";
    private static final String ELEM_IS_SELECTABLE = "isselectable";
    private static final String ELEM_IS_SYS_GEN = "issysgen";
    private static final String ELEM_IS_SYS_OWNED = "issysowned";
    private static final String ELEM_IS_VAL_REQ = "isvalreq";
    private static final String ELEM_MAXLEN = "maxlen";
    private static final String ELEM_NAME = "name";
    private static final String ELEM_OBJECT_TYPE = "objecttype";
    private static final String ELEM_PROP_DEF = "propdef";
    private static final String ELEM_PROP_MAX = "propmax";
    private static final String ELEM_PROP_MIN = "propmin";
    private static final String ELEM_PROP_REQCLASS = "reqclass";
    private static final String ELEM_REQ_UNI_ELEM = "requnielem";
    private static final String ELEM_SETABILITY = "setability";
    private static final String ELEM_STYLE = "style";
    private static final String ELEM_SYM_NAME = "symname";
    private static final String ELEM_USES_LONG_COLUMN = "useslongcolumn";
    private static final String ELEM_VALUE = "value";
    private static final String ELEM_VERSER_ID = "verserid";
    private static final String TRUE = "1";
    public static final String ENTRY_TEMPLATE_DESCRIPTION = "EntryTemplateDescription";
    private ObjectReference templateReference;
    private String displayName;
    private String description;
    private TemplateType type = TemplateType.DOCUMENT;
    private Reference objectStore;
    private boolean selectFile = true;
    private boolean selectFolder = true;
    private boolean constrainFolder;
    private Reference folder = new Reference();
    private String addClassId;
    private String addClassDisplayName;
    private boolean setProperties = true;
    private LinkedHashMap<String, PropertyOptions> propertiesOptions;
    public Option addAsMinorVersion = new Option(false, false, false);
    public Option autoClassify = new Option(false, true, true);
    private boolean useForCheckin = true;
    private boolean allowDuplicateFileNames = true;
    private boolean setSecurity = true;
    private Reference securityPolicy = new Reference();
    private List<P8Permission> permissions;
    private boolean promptToLaunchWorkflow;
    private boolean runWorkflow;
    private boolean selectParticipant;
    public WebPublish webPublish;
    public Workflow workflow;
    private DeclareRecord declareRecord;

    public P8EntryTemplate() {
        this.propertiesOptions = new LinkedHashMap();
        this.permissions = new ArrayList<P8Permission>();
        this.webPublish = new WebPublish();
        this.declareRecord = DeclareRecord.NEVER_DECLARE;
    }

    public ObjectReference getTemplateReference() {
        return this.templateReference;
    }

    public void setTemplateReference(ObjectReference templateReference) {
        this.templateReference = templateReference;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TemplateType getType() {
        return this.type;
    }

    public void setType(TemplateType type) {
        this.type = type;
    }

    public String getTypeName() {
        return this.type.toString();
    }

    public void setTypeName(String typeName) {
        try {
            this.setType(TemplateType.valueOf(typeName.toUpperCase()));
        }
        catch (Exception e) {
            this.setType(TemplateType.DOCUMENT);
        }
    }

    private String getMimeType() {
        String mimeType;
        switch (this.getType()) {
            case DOCUMENT: {
                mimeType = MIME_TYPE_DOCUMENT;
                break;
            }
            case FOLDER: {
                mimeType = MIME_TYPE_FOLDER;
                break;
            }
            case CUSTOMOBJECT: {
                mimeType = MIME_TYPE_CUSTOMOBJECT;
                break;
            }
            default: {
                mimeType = MIME_TYPE_DOCUMENT;
            }
        }
        return mimeType;
    }

    public Reference getObjectStore() {
        return this.objectStore;
    }

    public void setObjectStore(Reference objectStore) {
        this.objectStore = objectStore;
    }

    public void applyInstruction(Instruction instruction) {
        if (instruction.getName().equals("autoclassify")) {
            this.setAutoClassify(new Option(instruction.isOn(), true, true));
        } else if (instruction.getName().equals(INST_AUTO_UNIQUE)) {
            this.setIsAllowDuplicateFileNames(instruction.isOn());
        } else if (instruction.getName().equals(INST_RECORDS_TEMPLATE)) {
            this.setDeclareRecord(DeclareRecord.values()[Integer.parseInt(instruction.getValue())]);
        } else if (instruction.getName().equals(INST_CONSTRAIN_FOLDER)) {
            this.setIsConstrainFolder(instruction.isOn());
        } else if (instruction.getName().equals(INST_PROMPT_WORKFLOW)) {
            this.setIsPromptToLaunchWorkflow(instruction.isOn());
        } else if (!instruction.getName().equals(INST_RECORDS_TEMPLATE)) {
            if (instruction.getName().equals(INST_RUN_WORKFLOW)) {
                this.setIsRunWorkflow(instruction.isOn());
            } else if (instruction.getName().equals(INST_SELECT_FILE)) {
                this.setIsSelectFile(instruction.isOn());
            } else if (instruction.getName().equals(INST_SELECT_FOLDER)) {
                this.setIsSelectFolder(instruction.isOn());
            } else if (instruction.getName().equals(INST_SELECT_PARTICIPANT)) {
                this.setIsSelectParticipant(instruction.isOn());
            } else if (instruction.getName().equals(INST_SELECT_PROPERTIES)) {
                this.setIsSetProperties(instruction.isOn());
            } else if (instruction.getName().equals(INST_SET_SECURITY)) {
                this.setIsSetSecurity(instruction.isOn());
            } else if (instruction.getName().equals(INST_USE_FOR_CHECKIN)) {
                this.setIsUseForCheckin(instruction.isOn());
            }
        }
    }

    public boolean isSelectFile() {
        return this.selectFile;
    }

    public void setIsSelectFile(boolean selectFile) {
        this.selectFile = selectFile;
    }

    public boolean isSelectFolder() {
        return this.selectFolder;
    }

    public void setIsSelectFolder(boolean selectFolder) {
        this.selectFolder = selectFolder;
    }

    public boolean isConstrainFolder() {
        return this.constrainFolder;
    }

    public void setIsConstrainFolder(boolean constrainFolder) {
        this.constrainFolder = constrainFolder;
    }

    public Reference getFolder() {
        return this.folder;
    }

    public void setFolder(Reference folder) {
        this.folder = folder;
    }

    public String getAddClassId() {
        return this.addClassId;
    }

    public void setAddClassId(String addClassId) {
        this.addClassId = addClassId;
    }

    public String getAddClassDisplayName() {
        return this.addClassDisplayName;
    }

    public void setAddClassDisplayName(String addClassDisplayName) {
        this.addClassDisplayName = addClassDisplayName;
    }

    public boolean isSetProperties() {
        return this.setProperties;
    }

    public void setIsSetProperties(boolean setProperties) {
        this.setProperties = setProperties;
    }

    public LinkedHashMap<String, PropertyOptions> getPropertiesOptions() {
        return this.propertiesOptions;
    }

    public void setPropertiesOptions(LinkedHashMap<String, PropertyOptions> propertiesOptions) {
        this.propertiesOptions = propertiesOptions;
    }

    public void addPropertyOptions(PropertyOptions propertyConfiguration) {
        this.propertiesOptions.put(propertyConfiguration.getId(), propertyConfiguration);
    }

    public boolean isUseForCheckin() {
        return this.useForCheckin;
    }

    public void setIsUseForCheckin(boolean useForCheckin) {
        this.useForCheckin = useForCheckin;
    }

    public Option getAddAsMinorVersion() {
        return this.addAsMinorVersion;
    }

    public void setAddAsMinorVersion(Option addAsMinorVersion) {
        this.addAsMinorVersion = addAsMinorVersion;
    }

    public Option getAutoClassify() {
        return this.autoClassify;
    }

    public void setAutoClassify(Option autoClassify) {
        this.autoClassify = autoClassify;
    }

    public boolean isAllowDuplicateFileNames() {
        return this.allowDuplicateFileNames;
    }

    public void setIsAllowDuplicateFileNames(boolean allowDuplicateFileNames) {
        this.allowDuplicateFileNames = allowDuplicateFileNames;
    }

    public DeclareRecord getDeclareRecord() {
        return this.declareRecord;
    }

    public void setDeclareRecord(DeclareRecord declareRecord) {
        this.declareRecord = declareRecord;
    }

    public boolean isSetSecurity() {
        return this.setSecurity;
    }

    public void setIsSetSecurity(boolean setSecurity) {
        this.setSecurity = setSecurity;
    }

    public List<P8Permission> getPermissions() {
        return this.permissions;
    }

    public void addPermission(P8Permission permission) {
        this.permissions.add(permission);
    }

    public Reference getSecurityPolicy() {
        return this.securityPolicy;
    }

    public void setSecurityPolicy(Reference securityPolicy) {
        this.securityPolicy = securityPolicy;
    }

    public boolean isPromptToLaunchWorkflow() {
        return this.promptToLaunchWorkflow;
    }

    public void setIsPromptToLaunchWorkflow(boolean promptToLaunchWorkflow) {
        this.promptToLaunchWorkflow = promptToLaunchWorkflow;
    }

    public void setPromptToLaunchWorkflowValue(String value) {
        this.setIsPromptToLaunchWorkflow(TRUE.equals(value));
    }

    public boolean isRunWorkflow() {
        return this.runWorkflow;
    }

    public void setIsRunWorkflow(boolean runWorkflow) {
        this.runWorkflow = runWorkflow;
    }

    public void setRunWorkflow(String value) {
        this.setIsRunWorkflow(TRUE.equals(value));
    }

    public boolean isSelectParticipant() {
        return this.selectParticipant;
    }

    public void setIsSelectParticipant(boolean selectParticipant) {
        this.selectParticipant = selectParticipant;
    }

    public void setIsSelectParticipantValue(String value) {
        this.setIsSelectParticipant(TRUE.equals(value));
    }

    public WebPublish getWebPublish() {
        return this.webPublish;
    }

    public void setWebPublish(WebPublish webPublish) {
        this.webPublish = webPublish;
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(Workflow workflow) {
        this.workflow = workflow;
    }

    public static P8EntryTemplate loadEntryTemplate(HttpServletRequest request, P8Connection connection, String templateId, boolean loadCurrentVersion) throws Exception {
        String methodName = "loadEntryTemplate";
        Logger.logDebug(P8EntryTemplate.class, methodName, (ServletRequest)request, "retrieving search template document");
        Document document = P8Util.getDocument(request, connection, templateId);
        VersionSeries vs = (VersionSeries)document.getProperties().getEngineObjectValue("VersionSeries");
        if (loadCurrentVersion) {
            document = (Document)vs.get_CurrentVersion();
        } else {
            document = (Document)vs.get_ReleasedVersion();
            if (document == null) {
                document = (Document)vs.get_CurrentVersion();
            }
        }
        ContentElement contentElement = (ContentElement)document.get_ContentElements().get(0);
        ContentTransfer contentTransfer = (ContentTransfer)contentElement;
        InputStream contentStream = contentTransfer.accessContentStream();
        Logger.logDebug(P8SearchTemplate.class, methodName, (ServletRequest)request, "parsing entry template");
        P8EntryTemplate entryTemplate = P8EntryTemplate.parse(request, contentStream);
        for (P8Permission permission : entryTemplate.getPermissions()) {
            P8Permission.updatePermissionNames(connection, permission, true);
        }
        entryTemplate.setTemplateReference(document.getObjectReference());
        entryTemplate.setDisplayName(document.get_Name());
        entryTemplate.setDescription(document.getProperties().getStringValue(ENTRY_TEMPLATE_DESCRIPTION));
        String templateOSName = entryTemplate.getObjectStore().getName();
        ObjectStore templateOS = P8Util.getObjectStore(request, connection, null);
        if (templateOS.get_Name().equalsIgnoreCase(templateOSName)) {
            entryTemplate.getObjectStore().setId(templateOS.get_ObjectStoreId().toString());
            entryTemplate.getObjectStore().setName(templateOS.get_SymbolicName());
        } else {
            ObjectStoreSet objectStoreSet = templateOS.get_Domain().get_ObjectStores();
            for (ObjectStore domOS : objectStoreSet) {
                if (!domOS.get_Name().equals(templateOSName)) continue;
                entryTemplate.getObjectStore().setId(domOS.get_ObjectStoreId().toString());
                entryTemplate.getObjectStore().setName(domOS.get_SymbolicName());
                break;
            }
        }
        return entryTemplate;
    }

    public void save(HttpServletRequest request, P8Connection connection, String templateId) throws Exception {
        Document document = P8Util.getDocument(request, connection, templateId);
        document.checkout(null, null, null, null);
        try {
            document.save(RefreshMode.NO_REFRESH);
        }
        catch (Exception e) {
            // empty catch block
        }
        Document updatedDocument = (Document)document.get_Reservation();
        updatedDocument.fetchProperties(new PropertyFilter(){});
        ContentElementList contentElementList = Factory.ContentElement.createList();
        ContentTransfer contentTransfer = Factory.ContentTransfer.createInstance();
        contentTransfer.set_ContentType(this.getMimeType());
        byte[] templateBytes = this.toXML().getBytes("UTF-8");
        contentTransfer.setCaptureSource((InputStream)new ByteArrayInputStream(templateBytes));
        contentElementList.add((Object)contentTransfer);
        updatedDocument.set_ContentElements(contentElementList);
        updatedDocument.checkin(null, CheckinType.MAJOR_VERSION);
        updatedDocument.save(RefreshMode.NO_REFRESH);
    }

    public Document saveAs(P8Connection connection, String templateName, String description) throws Exception {
        ObjectStore objectStore = connection.getObjectStore();
        ClassDescription classDescription = P8Util.getCachedCD(objectStore, ENTRY_TEMPLATE_CLASS);
        Id id = classDescription.get_Id();
        Document document = Factory.Document.createInstance((ObjectStore)objectStore, (String)id.toString());
        String mimeType = this.getMimeType();
        document.set_MimeType(mimeType);
        document.getProperties().putObjectValue("DocumentTitle", (Object)templateName);
        document.getProperties().putObjectValue("Description", (Object)description);
        ContentElementList contentElementList = Factory.ContentElement.createList();
        ContentTransfer contentTransfer = Factory.ContentTransfer.createInstance();
        contentTransfer.set_ContentType(mimeType);
        byte[] templateBytes = this.toXML().getBytes("UTF-8");
        contentTransfer.setCaptureSource((InputStream)new ByteArrayInputStream(templateBytes));
        contentElementList.add((Object)contentTransfer);
        document.set_ContentElements(contentElementList);
        document.checkin(AutoClassify.DO_NOT_AUTO_CLASSIFY, CheckinType.MAJOR_VERSION);
        document.save(RefreshMode.REFRESH);
        return document;
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer();
        return xml.toString();
    }

    static P8EntryTemplate parse(HttpServletRequest request, InputStream definition) throws IOException, SAXException {
        String methodName = "parse";
        Logger.logEntry(P8EntryTemplate.class, methodName, (ServletRequest)request);
        Digester digester = new Digester();
        SimpleRegexMatcher m = new SimpleRegexMatcher();
        digester.setRules((Rules)new RegexRules((RegexMatcher)m));
        digester.setValidating(false);
        P8EntryTemplate.addEntryTemplateParsingRules(request, digester);
        P8EntryTemplate entryTemplate = (P8EntryTemplate)digester.parse(definition);
        Logger.logExit(P8EntryTemplate.class, methodName, (ServletRequest)request);
        return entryTemplate;
    }

    private static void addEntryTemplateParsingRules(HttpServletRequest request, Digester digester) {
        String methodName = "addSearchDefinitionParsingRules";
        Logger.logEntry(P8EntryTemplate.class, methodName, (ServletRequest)request);
        digester.addObjectCreate("entrytemplate", P8EntryTemplate.class);
        digester.addBeanPropertySetter("entrytemplate/type", "typeName");
        digester.addBeanPropertySetter("entrytemplate/classdesc/id", "addClassId");
        digester.addBeanPropertySetter("entrytemplate/classdesc/name", "addClassDisplayName");
        digester.addObjectCreate("entrytemplate/objectstore", Reference.class);
        digester.addBeanPropertySetter("entrytemplate/objectstore/id", ELEM_ID);
        digester.addBeanPropertySetter("entrytemplate/objectstore/name", ELEM_NAME);
        digester.addSetNext("entrytemplate/objectstore", "setObjectStore");
        digester.addObjectCreate("entrytemplate/folder", Reference.class);
        digester.addBeanPropertySetter("entrytemplate/folder/id", ELEM_ID);
        digester.addSetNext("entrytemplate/folder", "setFolder");
        digester.addObjectCreate("entrytemplate/propdescs/propdesc", PropertyOptions.class);
        digester.addBeanPropertySetter("entrytemplate/propdescs/propdesc/id", ELEM_ID);
        digester.addBeanPropertySetter("entrytemplate/propdescs/propdesc/symname", ELEM_NAME);
        digester.addBeanPropertySetter("entrytemplate/propdescs/propdesc/isvalreq", "isRequiredValue");
        digester.addBeanPropertySetter("entrytemplate/propdescs/propdesc/isreadonly", "isReadOnlyValue");
        digester.addBeanPropertySetter("entrytemplate/propdescs/propdesc/ishidden", "isHiddenValue");
        digester.addBeanPropertySetter("entrytemplate/propdescs/propdesc/setability", ELEM_SETABILITY);
        digester.addBeanPropertySetter("entrytemplate/propdescs/propdesc/cardinality", "cardinalityValue");
        digester.addBeanPropertySetter("entrytemplate/propdescs/propdesc/datatype", "dataTypeValue");
        digester.addBeanPropertySetter("entrytemplate/propdescs/propdesc/reqclass/symname", "requiredClassName");
        digester.addBeanPropertySetter("entrytemplate/propdescs/propdesc/reqclass/dispname", "requiredClassDisplayName");
        digester.addRule("entrytemplate/propdescs/propdesc/propdef", (Rule)new DefaultSingleValueRule(request));
        digester.addRule("entrytemplate/propdescs/propdesc/propdef/values/value", (Rule)new DefaultMultipleValuesRule(request));
        digester.addBeanPropertySetter("entrytemplate/propdescs/propdesc/propdef/namevalue", "defaultObjectValueName");
        digester.addBeanPropertySetter("entrytemplate/propdescs/propdesc/propdef/id", "defaultObjectValueId");
        digester.addObjectCreate("entrytemplate/propdescs/propdesc/propdef/objectstore", Reference.class);
        digester.addBeanPropertySetter("entrytemplate/propdescs/propdesc/propdef/objectstore/id", ELEM_ID);
        digester.addBeanPropertySetter("entrytemplate/propdescs/propdesc/propdef/objectstore/name", ELEM_NAME);
        digester.addSetNext("entrytemplate/propdescs/propdesc/propdef/objectstore", "setDefaultObjectValueObjectStore");
        digester.addSetNext("entrytemplate/propdescs/propdesc", "addPropertyOptions");
        digester.addObjectCreate("entrytemplate/version", Option.class);
        digester.addBeanPropertySetter("entrytemplate/version/value", "isOnValue");
        digester.addBeanPropertySetter("entrytemplate/version/isreadonly", "isReadOnlyValue");
        digester.addBeanPropertySetter("entrytemplate/version/ishidden", "isHiddenValue");
        digester.addSetNext("entrytemplate/version", "setAddAsMinorVersion");
        digester.addObjectCreate("entrytemplate/autoclassify", Option.class);
        digester.addBeanPropertySetter("entrytemplate/autoclassify/value", "isOnValue");
        digester.addBeanPropertySetter("entrytemplate/autoclassify/isreadonly", "isReadOnlyValue");
        digester.addBeanPropertySetter("entrytemplate/autoclassify/ishidden", "isHiddenValue");
        digester.addSetNext("entrytemplate/autoclassify", "setAutoClassify");
        digester.addObjectCreate("entrytemplate/instructions/instruction", Instruction.class);
        digester.addBeanPropertySetter("entrytemplate/instructions/instruction/name", ELEM_NAME);
        digester.addBeanPropertySetter("entrytemplate/instructions/instruction/value", "isOnValue");
        digester.addSetNext("entrytemplate/instructions/instruction", "applyInstruction");
        digester.addObjectCreate("entrytemplate/securitypolicy", Reference.class);
        digester.addBeanPropertySetter("entrytemplate/securitypolicy/id", ELEM_ID);
        digester.addBeanPropertySetter("entrytemplate/securitypolicy/name", ELEM_NAME);
        digester.addSetNext("entrytemplate/securitypolicy", "setSecurityPolicy");
        digester.addObjectCreate("entrytemplate/permissions/permission", P8Permission.class);
        digester.addBeanPropertySetter("entrytemplate/permissions/permission/accessmask", "accessMaskValue");
        digester.addBeanPropertySetter("entrytemplate/permissions/permission/accesstype", "accessTypeValue");
        digester.addBeanPropertySetter("entrytemplate/permissions/permission/inheritdepth", "inheritableDepthValue");
        digester.addBeanPropertySetter("entrytemplate/permissions/permission/permissionsource", "permissionSourceValue");
        digester.addBeanPropertySetter("entrytemplate/permissions/permission/granteeid", ELEM_ID);
        digester.addBeanPropertySetter("entrytemplate/permissions/permission/granteetype", "granteeTypeValue");
        digester.addBeanPropertySetter("entrytemplate/permissions/permission/granteename", "granteeName");
        digester.addBeanPropertySetter("entrytemplate/permissions/permission/dispname", "displayName");
        digester.addSetNext("entrytemplate/permissions/permission", "addPermission");
        digester.addObjectCreate("entrytemplate/web", WebPublish.class);
        digester.addBeanPropertySetter("entrytemplate/web/convert", "convertValue");
        digester.addBeanPropertySetter("entrytemplate/web/behavior", "behaviorValue");
        digester.addBeanPropertySetter("entrytemplate/web/defined", "userDefined");
        digester.addBeanPropertySetter("entrytemplate/web/isreadonly", "isReadOnlyValue");
        digester.addBeanPropertySetter("entrytemplate/web/ishidden", "isHiddenValue");
        digester.addSetNext("entrytemplate/web", "setWebPublish");
        digester.addObjectCreate("entrytemplate/workflow", Workflow.class);
        digester.addBeanPropertySetter("entrytemplate/workflow/style", "styleName");
        digester.addBeanPropertySetter("entrytemplate/workflow/id", ELEM_ID);
        digester.addBeanPropertySetter("entrytemplate/workflow/name", ELEM_NAME);
        digester.addBeanPropertySetter("entrytemplate/workflow/verserid", "versionSeriesId");
        digester.addBeanPropertySetter("entrytemplate/workflow/objectstore/name", "objectStoreName");
        digester.addSetNext("entrytemplate/workflow", "setWorkflow");
        Logger.logExit(P8EntryTemplate.class, methodName, (ServletRequest)request);
    }

    private static Object getObjectValue(String value, TypeID dataType) {
        Object objValue = null;
        if (dataType == TypeID.BOOLEAN) {
            objValue = TRUE.equals(value);
        } else if (dataType == TypeID.DATE) {
            if (value != null && value.length() > 0) {
                Calendar cal = WCDateFormat.parseW3CDate(value, null);
                objValue = new Date(cal.getTimeInMillis());
            }
        } else {
            objValue = dataType == TypeID.DOUBLE ? Double.valueOf(value) : (dataType == TypeID.GUID ? new Id(value) : (dataType == TypeID.LONG ? Integer.valueOf(value) : (dataType == TypeID.STRING ? value : value.toString())));
        }
        return objValue;
    }

    private static class DefaultMultipleValuesRule
    extends Rule {
        private HttpServletRequest request;

        public DefaultMultipleValuesRule(HttpServletRequest request) {
            this.request = request;
        }

        public void body(String namespace, String name, String text) {
            String methodName = "DefaultMultipleValueRule.body";
            Digester digester = this.getDigester();
            PropertyOptions propOptions = (PropertyOptions)digester.peek();
            if (text != null && text.length() > 0) {
                TypeID dataType = propOptions.getDataType();
                Object values = (List)propOptions.getDefaultValue();
                if (values == null) {
                    values = dataType == TypeID.BOOLEAN ? Factory.BooleanList.createList() : (dataType == TypeID.DATE ? Factory.DateTimeList.createList() : (dataType == TypeID.DOUBLE ? Factory.Float64List.createList() : (dataType == TypeID.GUID ? Factory.IdList.createList() : (dataType == TypeID.LONG ? Factory.Integer32List.createList() : (dataType == TypeID.STRING ? Factory.StringList.createList() : Factory.StringList.createList())))));
                }
                if (values != null) {
                    Object value = P8EntryTemplate.getObjectValue(text, propOptions.getDataType());
                    values.add(value);
                    propOptions.setDefaultValue(values);
                    Logger.logDebug(P8EntryTemplate.class, methodName, (ServletRequest)this.request, "Added entry template property " + propOptions.getName() + " default multiple value: " + value);
                }
            }
        }
    }

    private static class DefaultSingleValueRule
    extends Rule {
        private HttpServletRequest request;

        public DefaultSingleValueRule(HttpServletRequest request) {
            this.request = request;
        }

        public void body(String namespace, String name, String text) {
            String methodName = "DefaultSingleValueRule.body";
            Digester digester = this.getDigester();
            PropertyOptions propOptions = (PropertyOptions)digester.peek();
            if (text != null && text.length() > 0) {
                propOptions.setDefaultValue(P8EntryTemplate.getObjectValue(text, propOptions.getDataType()));
            }
            Logger.logDebug(P8EntryTemplate.class, methodName, (ServletRequest)this.request, "Set entry template property " + propOptions.getName() + " default single value to: " + propOptions.getDefaultValue());
        }
    }

    public static class Reference {
        private String id;
        private String name;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class PropertyOptions {
        private String id;
        private String name;
        private boolean required;
        private boolean readOnly;
        private boolean hidden;
        private String setability;
        private Cardinality cardinality;
        private TypeID dataType;
        private Object defaultValue;
        private String requiredClassName;
        private String requiredClassDisplayName;
        private Reference defaultObjectValue;
        private Reference defaultObjectValueObjectStore;

        public Cardinality getCardinality() {
            return this.cardinality;
        }

        public String getCardinalityName() {
            return this.cardinality.toString();
        }

        public void setCardinality(Cardinality cardinality) {
            this.cardinality = cardinality;
        }

        public void setCardinalityName(String cardinalityName) {
            if (cardinalityName.equalsIgnoreCase(Cardinality.SINGLE.toString())) {
                this.setCardinality(Cardinality.SINGLE);
            } else if (cardinalityName.equalsIgnoreCase(Cardinality.ENUM.toString())) {
                this.setCardinality(Cardinality.ENUM);
            } else if (cardinalityName.equalsIgnoreCase(Cardinality.LIST.toString())) {
                this.setCardinality(Cardinality.LIST);
            } else {
                this.setCardinality(Cardinality.SINGLE);
            }
        }

        public void setCardinalityValue(String cardinalityValue) {
            try {
                this.setCardinality(Cardinality.getInstanceFromInt((int)Integer.parseInt(cardinalityValue)));
            }
            catch (Exception e) {
                this.setCardinality(Cardinality.SINGLE);
            }
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public void setIsHidden(boolean hidden) {
            this.hidden = hidden;
        }

        public void setIsHiddenValue(String hidden) {
            this.setIsHidden(P8EntryTemplate.TRUE.equals(hidden));
        }

        public String getSetability() {
            return this.setability;
        }

        public void setSetability(String setability) {
            this.setability = setability;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public void setIsReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public void setIsReadOnlyValue(String readOnly) {
            this.setIsReadOnly(P8EntryTemplate.TRUE.equals(readOnly));
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setIsRequired(boolean required) {
            this.required = required;
        }

        public void setIsRequiredValue(String required) {
            this.setIsRequired(P8EntryTemplate.TRUE.equals(required));
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public TypeID getDataType() {
            return this.dataType;
        }

        public void setDataType(TypeID dataType) {
            this.dataType = dataType;
        }

        public void setDataTypeValue(String dataTypeValue) {
            try {
                this.setDataType(TypeID.getInstanceFromInt((int)Integer.parseInt(dataTypeValue)));
            }
            catch (Exception e) {
                this.setDataType(TypeID.STRING);
            }
        }

        public String getDataTypeName() {
            return P8Util.getDataType(this.dataType);
        }

        public void setDataTypeName(String dataTypeName) {
            this.setDataType(P8Util.getTypeId(dataTypeName));
        }

        public String getRequiredClassDisplayName() {
            return this.requiredClassDisplayName;
        }

        public void setRequiredClassDisplayName(String requiredClassDisplayName) {
            this.requiredClassDisplayName = requiredClassDisplayName;
        }

        public String getRequiredClassName() {
            return this.requiredClassName;
        }

        public void setRequiredClassName(String requiredClassName) {
            this.requiredClassName = requiredClassName;
        }

        public Reference getDefaultObjectValue() {
            return this.defaultObjectValue;
        }

        public void setDefaultObjectValue(Reference defaultObjectValue) {
            this.defaultObjectValue = defaultObjectValue;
        }

        public Reference getDefaultObjectValueObjectStore() {
            return this.defaultObjectValueObjectStore;
        }

        public void setDefaultObjectValueObjectStore(Reference defaultObjectValueObjectStore) {
            this.defaultObjectValueObjectStore = defaultObjectValueObjectStore;
        }

        public void setDefaultObjectValueName(String defaultObjectValueName) {
            if (this.defaultObjectValue == null) {
                this.setDefaultObjectValue(new Reference());
            }
            this.defaultObjectValue.setName(defaultObjectValueName);
        }

        public void setDefaultObjectValueId(String defaultObjectValueId) {
            if (this.defaultObjectValue == null) {
                this.setDefaultObjectValue(new Reference());
            }
            this.defaultObjectValue.setId(defaultObjectValueId);
        }
    }

    public static class Instruction {
        private String name;
        private boolean on;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isOn() {
            return this.on;
        }

        public void setIsOn(boolean on) {
            this.on = on;
        }

        public void setIsOnValue(String value) {
            if (this.name.equals(P8EntryTemplate.INST_RECORDS_TEMPLATE)) {
                this.setIsOn(true);
                this.setValue(value);
            } else {
                this.setIsOn(P8EntryTemplate.TRUE.equals(value));
            }
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class Workflow {
        private Style style;
        private String id;
        private String name;
        private String versionSeriesId;
        private String objectStoreName;

        public Style getStyle() {
            return this.style;
        }

        public String getStyleName() {
            return this.style.toString();
        }

        public void setStyle(Style style) {
            this.style = style;
        }

        public void setStyleName(String styleName) {
            try {
                this.setStyle(Style.valueOf(styleName.toUpperCase()));
            }
            catch (Exception e) {
                this.setStyle(Style.APPROVAL);
            }
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setWorkflow(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getObjectStoreName() {
            return this.objectStoreName;
        }

        public void setObjectStoreName(String objectStoreName) {
            this.objectStoreName = objectStoreName;
        }

        public String getVersionSeriesId() {
            return this.versionSeriesId;
        }

        public void setVersionSeriesId(String versionSeriesId) {
            this.versionSeriesId = versionSeriesId;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Style {
            APPROVAL,
            SEQUENCE,
            DESIGNER;

        }
    }

    public static class WebPublish {
        private boolean userDefined;
        private Convert convert;
        private Behavior behavior;
        private boolean readOnly;
        private boolean hidden;

        public boolean getUserDefined() {
            return this.userDefined;
        }

        public void setUserDefined(boolean userDefined) {
            this.userDefined = userDefined;
        }

        public void setUserDefinedValue(String userDefined) {
            this.setUserDefined(P8EntryTemplate.TRUE.equals(userDefined));
        }

        public Convert getConvert() {
            return this.convert;
        }

        public String getConvertName() {
            return this.convert.toString();
        }

        public void setConvert(Convert convert) {
            this.convert = convert;
        }

        public void setConvertName(String convertName) {
            try {
                this.setConvert(Convert.valueOf(convertName.toUpperCase()));
            }
            catch (Exception e) {
                this.setConvert(Convert.NO_CONVERSION);
            }
        }

        public void setConvertValue(String convertValue) {
            try {
                this.setConvert(Convert.values()[Integer.parseInt(convertValue)]);
            }
            catch (Exception e) {
                this.setConvert(Convert.NO_CONVERSION);
            }
        }

        public Behavior getBehavior() {
            return this.behavior;
        }

        public String getBehaviorName() {
            return this.behavior.toString();
        }

        public void setBehavior(Behavior behavior) {
            this.behavior = behavior;
        }

        public void setBehaviorName(String behaviorName) {
            try {
                this.setBehavior(Behavior.valueOf(behaviorName.toUpperCase()));
            }
            catch (Exception e) {
                this.setBehavior(Behavior.NEXT_MAJOR_VERSION_ONLY);
            }
        }

        public void setBehaviorValue(String behaviorValue) {
            try {
                this.setBehavior(Behavior.values()[Integer.parseInt(behaviorValue)]);
            }
            catch (Exception e) {
                this.setBehavior(Behavior.NEXT_MAJOR_VERSION_ONLY);
            }
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public void setIsReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public void setIsReadOnlyValue(String readOnly) {
            this.setIsReadOnly(P8EntryTemplate.TRUE.equals(readOnly));
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public void setIsHidden(boolean hidden) {
            this.hidden = hidden;
        }

        public void setIsHiddenValue(String hidden) {
            this.setIsHidden(P8EntryTemplate.TRUE.equals(hidden));
        }

        public WebPublish() {
            this.setWebPublish(false, Convert.NO_CONVERSION, Behavior.NEXT_MAJOR_VERSION_ONLY, false, true);
        }

        public void setWebPublish(boolean userDefined, Convert convert, Behavior behavior, boolean readOnly, boolean hidden) {
            this.userDefined = userDefined;
            this.convert = convert;
            this.behavior = behavior;
            this.readOnly = readOnly;
            this.hidden = hidden;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Behavior {
            NEXT_MAJOR_VERSION_ONLY,
            ON_EVERY_MAJOR_VERSION;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Convert {
            NO_CONVERSION,
            TO_HTML,
            TO_HTML_AND_ASSIGN_TEMPLATE;

        }
    }

    public static class Option {
        private boolean on;
        private boolean readOnly;
        private boolean hidden;

        public Option() {
            this.setOption(true, false, false);
        }

        public Option(boolean on, boolean readOnly, boolean hidden) {
            this.setOption(on, readOnly, hidden);
        }

        public void setOption(boolean on, boolean readOnly, boolean hidden) {
            this.on = on;
            this.readOnly = readOnly;
            this.hidden = hidden;
        }

        public boolean isOn() {
            return this.on;
        }

        public void setIsOn(boolean on) {
            this.on = on;
        }

        public void setIsOnValue(String value) {
            this.setIsOn(P8EntryTemplate.TRUE.equals(value));
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public void setIsReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public void setIsReadOnlyValue(String readOnly) {
            this.setIsReadOnly(P8EntryTemplate.TRUE.equals(readOnly));
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public void setIsHidden(boolean hidden) {
            this.hidden = hidden;
        }

        public void setIsHiddenValue(String hidden) {
            this.setIsHidden(P8EntryTemplate.TRUE.equals(hidden));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeclareRecord {
        ALWAYS_DECLARE,
        OPTIONALY_DECLARE,
        CLASSIFY_DECLARE,
        CLASSIFY_OPTIONALLY,
        NEVER_DECLARE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TemplateType {
        DOCUMENT,
        FOLDER,
        CUSTOMOBJECT;

    }
}

