/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.collection.AnnotationSet;
import com.filenet.api.collection.ContentElementList;
import com.filenet.api.core.ContentElement;
import com.filenet.api.core.ContentReference;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.core.Document;
import com.filenet.api.core.Domain;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.RetrievingBatch;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.UserContext;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.extension.PluginServiceUtil;
import com.ibm.ecm.mediator.p8.P8AnnotationsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.ContentUtil;
import com.ibm.ecm.util.DocumentContent;
import com.ibm.ecm.util.p8.P8Annotation;
import com.ibm.ecm.util.p8.P8AnnotationExporter;
import com.ibm.ecm.util.p8.P8AnnotationImporter;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8DocID;
import com.ibm.ecm.util.p8.P8Util;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.util.MessageResources;

public class P8ContentUtil {
    public static Document retrieveDocument(HttpServletRequest request, String repositoryId, String documentId, String vsId, String version) {
        Document document = null;
        P8Connection connection = PluginServiceUtil.getP8Connection(request, repositoryId);
        if (connection != null) {
            UserContext uc = UserContext.get();
            uc.pushSubject(connection.getSubject());
            document = P8ContentUtil.retrieveDocument(connection, uc, request, repositoryId, documentId, vsId, version);
            uc.popSubject();
        }
        return document;
    }

    public static DocumentContent retrieveContent(HttpServletRequest request, String repositoryId, String documentId, String vsId, String version, int elementNum) throws Exception {
        P8DocumentContent documentContent = null;
        P8Connection connection = PluginServiceUtil.getP8Connection(request, repositoryId);
        if (connection != null) {
            UserContext uc = UserContext.get();
            uc.pushSubject(connection.getSubject());
            Document document = P8ContentUtil.retrieveDocument(connection, uc, request, repositoryId, documentId, vsId, version);
            ContentElementList contentElementList = document.get_ContentElements();
            if (elementNum >= contentElementList.size()) {
                throw new Exception("The requested content element does not exist.");
            }
            ContentElement contentElement = (ContentElement)contentElementList.get(elementNum);
            if (contentElement instanceof ContentTransfer) {
                documentContent = new P8DocumentContent((ContentTransfer)contentElement, contentElementList.size(), connection);
            } else if (contentElement instanceof ContentReference) {
                documentContent = new P8DocumentContent((ContentReference)contentElement, contentElementList.size(), connection);
            }
            uc.popSubject();
        }
        return documentContent;
    }

    private static PropertyFilter getPropertyFilter(String[] properties) {
        PropertyFilter propertyFilter = new PropertyFilter();
        propertyFilter.setMaxRecursion(1);
        propertyFilter.addIncludeProperty(new FilterElement(null, null, null, "Id", null));
        propertyFilter.addIncludeProperty(new FilterElement(null, null, null, "ContentElements", null));
        propertyFilter.addIncludeProperty(new FilterElement(null, null, null, "Content", null));
        if (properties != null && properties.length > 0) {
            for (int n = 0; n < properties.length; ++n) {
                if (properties[n].equalsIgnoreCase("Id") || properties[n].equalsIgnoreCase("ContentElements") || properties[n].equalsIgnoreCase("Content")) continue;
                propertyFilter.addIncludeProperty(new FilterElement(null, null, null, properties[n], null));
            }
        }
        return propertyFilter;
    }

    public static AnnotationSet retrieveNativeAnnotations(HttpServletRequest request, String repositoryId, String documentId, String vsId, String version, String[] properties) {
        AnnotationSet annotations = null;
        P8Connection connection = PluginServiceUtil.getP8Connection(request, repositoryId);
        if (connection != null) {
            UserContext uc = UserContext.get();
            uc.pushSubject(connection.getSubject());
            Document document = P8ContentUtil.retrieveDocument(connection, uc, request, repositoryId, documentId, vsId, version);
            annotations = document.get_Annotations();
            if (annotations.iterator().hasNext()) {
                RetrievingBatch batch = RetrievingBatch.createRetrievingBatchInstance((Domain)connection.getDomain());
                PropertyFilter filter = P8ContentUtil.getPropertyFilter(properties);
                Iterator i = annotations.iterator();
                while (i.hasNext()) {
                    batch.add((IndependentObject)i.next(), filter);
                }
                batch.retrieveBatch();
            }
            uc.popSubject();
        }
        return annotations;
    }

    public static AnnotationSet retrieveNativeAnnotations(HttpServletRequest request, String repositoryId, Document document, String[] properties) {
        AnnotationSet annotations = null;
        P8Connection connection = PluginServiceUtil.getP8Connection(request, repositoryId);
        if (connection != null) {
            UserContext uc = UserContext.get();
            uc.pushSubject(connection.getSubject());
            annotations = document.get_Annotations();
            if (annotations.iterator().hasNext()) {
                RetrievingBatch batch = RetrievingBatch.createRetrievingBatchInstance((Domain)connection.getDomain());
                PropertyFilter filter = P8ContentUtil.getPropertyFilter(properties);
                Iterator i = annotations.iterator();
                while (i.hasNext()) {
                    batch.add((IndependentObject)i.next(), filter);
                }
                batch.retrieveBatch();
            }
            uc.popSubject();
        }
        return annotations;
    }

    public static String retrieveAnnotationsXml(HttpServletRequest request, Document document, String repositoryId) throws Exception {
        String annotationXml = null;
        P8Connection connection = PluginServiceUtil.getP8Connection(request, repositoryId);
        if (connection != null) {
            UserContext uc = UserContext.get();
            uc.pushSubject(connection.getSubject());
            List<P8Annotation> p8Annotations = P8Annotation.getDocumentAnnotations(request, connection, document);
            P8AnnotationExporter annotationExporter = new P8AnnotationExporter(p8Annotations);
            annotationXml = annotationExporter.getAnnotationXml().toString();
            uc.popSubject();
        }
        return annotationXml;
    }

    public static P8AnnotationsMediator retrieveAnnotations(HttpServletRequest request, MessageResources resources, String repositoryId, String documentId, String vsId, String version) {
        String methodName = "retrieveAnnotations";
        P8AnnotationsMediator mediator = new P8AnnotationsMediator(request, resources, request.getLocale());
        P8Connection connection = PluginServiceUtil.getP8Connection(request, repositoryId);
        if (connection != null) {
            Document document = P8ContentUtil.retrieveDocument(request, repositoryId, documentId, vsId, version);
            if (document != null) {
                mediator.setDocument(connection, document);
            } else {
                Exception exc = new Exception("The document could not be retrieved.");
                Logger.logError(P8ContentUtil.class, methodName, (ServletRequest)request, (Throwable)exc);
                mediator.addError("error.exception.general", exc.getMessage());
            }
        } else {
            mediator.addError("error.no.connection");
        }
        return mediator;
    }

    public static P8AnnotationsMediator updateAnnotations(HttpServletRequest request, MessageResources resources, String repositoryId, String documentId, String vsId, String version) {
        String methodName = "updateAnnotations";
        P8AnnotationsMediator mediator = new P8AnnotationsMediator(request, resources, request.getLocale());
        P8Connection connection = PluginServiceUtil.getP8Connection(request, repositoryId);
        if (connection != null) {
            Document document = P8ContentUtil.retrieveDocument(request, repositoryId, documentId, vsId, version);
            P8AnnotationImporter annotationImporter = new P8AnnotationImporter(request, connection, document);
            try {
                String theXml = P8ContentUtil.getAnnotationData(request);
                boolean useAnnotationClassSecurity = false;
                RepositoryConfig repoConfig = null;
                if (Config.hasRepositoryConfigUsingIdOrServerName(request, repositoryId) && (repoConfig = Config.getRepositoryConfigUsingIdOrServerName(request, repositoryId)) != null) {
                    String annotationSecurity = repoConfig.getAnnotationSecurity();
                    useAnnotationClassSecurity = annotationSecurity != null && annotationSecurity.equalsIgnoreCase("default");
                }
                Logger.logDebug(P8ContentUtil.class, methodName, (ServletRequest)request, "Importing updates: " + theXml);
                annotationImporter.importUpdates(request, connection, theXml, useAnnotationClassSecurity);
            }
            catch (Exception exc) {
                mediator.addError("error.exception.general", exc.getMessage());
                Logger.logError(P8ContentUtil.class, methodName, (ServletRequest)request, (Throwable)exc);
            }
            mediator.setDocument(connection, document);
        } else {
            mediator.addError("error.no.connection");
        }
        return mediator;
    }

    private static String getAnnotationData(HttpServletRequest request) throws Exception {
        byte[] data = ContentUtil.getRequestData(request);
        return new String(data, "UTF8");
    }

    private static Document retrieveDocument(P8Connection connection, UserContext uc, HttpServletRequest request, String repositoryId, String documentId, String vsId, String version) {
        String methodName = "retrieveDocument";
        Document document = null;
        P8DocID p8DocID = new P8DocID(documentId);
        HttpSession session = request.getSession();
        LastDocument lastDocument = P8ContentUtil.getLastDocument(session);
        if (lastDocument != null) {
            String key = P8ContentUtil.getDocumentKey(p8DocID.toString(), vsId, version);
            Logger.logDebug(P8ContentUtil.class, methodName, (ServletRequest)request, MessageFormat.format("Current document key is: {0}", key));
            Logger.logDebug(P8ContentUtil.class, methodName, (ServletRequest)request, MessageFormat.format("Last document key is: {0}", lastDocument.key));
            if (key.equals(lastDocument.key)) {
                Logger.logDebug(P8ContentUtil.class, methodName, (ServletRequest)request, "Using the cached LastDocument");
                document = lastDocument.document;
            }
        }
        if (connection != null && document == null) {
            uc.setLocale(request.getLocale());
            document = P8Util.getDocument(request, connection, p8DocID, vsId, version, null, null);
            P8ContentUtil.saveAsLastDocument(session, document, documentId, vsId, version);
        }
        return document;
    }

    public static void saveAsLastDocument(HttpSession session, Document document, String id, String vsId, String version) {
        LastDocument lastDocument = new LastDocument(document, id, vsId, version);
        session.setAttribute("P8ContentUtil.LastDocument", (Object)lastDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LastDocument getLastDocument(HttpSession session) {
        LastDocument lastDocument = null;
        HttpSession httpSession = session;
        synchronized (httpSession) {
            long age;
            lastDocument = (LastDocument)session.getAttribute("P8ContentUtil.LastDocument");
            if (lastDocument != null && (age = System.currentTimeMillis() - lastDocument.timestamp) > 15000L) {
                session.removeAttribute("P8ContentUtil.LastDocument");
                lastDocument = null;
            }
        }
        return lastDocument;
    }

    private static String getDocumentKey(String id, String vsId, String version) {
        return String.valueOf(id) + String.valueOf(vsId) + String.valueOf(version);
    }

    private static class LastDocument {
        private static final String LAST_DOCUMENT_KEY = "P8ContentUtil.LastDocument";
        long timestamp = System.currentTimeMillis();
        transient Document document;
        String id;
        String vsId;
        String key;
        String version;

        private LastDocument(Document document, String id, String vsId, String version) {
            this.document = document;
            this.id = id;
            this.vsId = vsId;
            this.version = version;
            this.key = P8ContentUtil.getDocumentKey(id, vsId, version);
        }
    }

    private static class P8DocumentContent
    extends DocumentContent {
        private ContentTransfer p8ContentTransfer = null;
        private P8Connection p8Connection = null;
        private boolean viaUrl;
        private String url;
        private int contentPartCount;

        private P8DocumentContent(ContentTransfer p8ContentTransfer, int contentElementListSize, P8Connection connection) {
            this.p8ContentTransfer = p8ContentTransfer;
            this.p8Connection = connection;
            this.type = p8ContentTransfer.get_ContentType();
            this.size = Math.round(p8ContentTransfer.get_ContentSize());
            this.name = p8ContentTransfer.get_RetrievalName();
            this.contentPartCount = contentElementListSize;
            this.viaUrl = false;
            this.url = null;
        }

        private P8DocumentContent(ContentReference p8ContentReference, int contentElementListSize, P8Connection connection) {
            this.type = p8ContentReference.get_ContentType();
            this.size = 0L;
            this.name = "";
            this.contentPartCount = contentElementListSize;
            this.viaUrl = true;
            this.url = p8ContentReference.get_ContentLocation();
        }

        public InputStream getInputStream() throws Exception {
            InputStream inputStream = null;
            if (this.p8ContentTransfer != null) {
                UserContext uc = UserContext.get();
                uc.pushSubject(this.p8Connection.getSubject());
                inputStream = this.p8ContentTransfer.accessContentStream();
                uc.popSubject();
            }
            return inputStream;
        }

        public boolean isViaUrl() {
            return this.viaUrl;
        }

        public String getContentUrl() {
            return this.url;
        }

        public int getContentPartCount() {
            return this.contentPartCount;
        }
    }
}

