/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.admin.ClassDefinition;
import com.filenet.api.admin.PropertyDefinition;
import com.filenet.api.collection.ObjectStoreSet;
import com.filenet.api.collection.PropertyDefinitionList;
import com.filenet.api.constants.AccessRight;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Domain;
import com.filenet.api.core.EntireNetwork;
import com.filenet.api.core.Factory;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.meta.MetadataCache;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.security.User;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.meta.Cache;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8LogonAction;
import com.ibm.ecm.util.p8.P8RecordsUtil;
import com.ibm.ecm.util.p8.P8TextSearchUtil;
import filenet.vw.api.VWSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class P8Connection
implements Serializable {
    private static final long serialVersionUID = 2604500774612674002L;
    private String userId;
    private String userName;
    private String distinguishedName;
    private String userDisplayName;
    private LoginContext loginContext;
    private UserContext userContext;
    private Connection ceConnection;
    private Subject subject;
    private Domain domain;
    private ObjectStore objectStore;
    private VWSession vwSession;
    private String domainName;
    private String objectStoreName;
    private String objectStoreRecordType;
    private String p8ConnectionType = null;
    private ArrayList domainObjectStoreNames;
    private Map<String, ObjectStore> objectStores = new HashMap<String, ObjectStore>();
    private Map<String, VWSession> vwSessionsByConnectionPoint = new HashMap<String, VWSession>();
    private String privAddItem = null;
    private String privAddDoc = null;
    private String privAddSearch = null;
    private String privAddItemTeamspaceTemplate = null;
    private String privAddItemTeamspace = null;
    private String privWorkflow = null;
    private String searchTemplateSupported = null;
    public static String CONTAINER_CONNECTION = "CONTAINER";
    public static String SSO_CONNECTION = "SSO";

    public P8Connection(String userId, String distinguishedName, LoginContext loginContext, UserContext userContext, Connection ceConnection, Subject subject, Domain domain, ObjectStore objectStore, String userName, String userDisplayName) {
        this.userId = userId;
        this.userName = userName;
        this.distinguishedName = distinguishedName;
        this.loginContext = loginContext;
        this.userContext = userContext;
        this.ceConnection = ceConnection;
        this.subject = subject;
        this.domain = domain;
        this.objectStore = objectStore;
        this.userDisplayName = userDisplayName;
    }

    public P8Connection(String userId, String distinguishedName, LoginContext loginContext, UserContext userContext, Connection ceConnection, Subject subject, String domainName, String objectStoreName, String userName, String userDisplayName) {
        this.userId = userId;
        this.userName = userName;
        this.distinguishedName = distinguishedName;
        this.loginContext = loginContext;
        this.userContext = userContext;
        this.ceConnection = ceConnection;
        this.subject = subject;
        this.domain = null;
        this.objectStore = null;
        this.domainName = domainName;
        this.objectStoreName = objectStoreName;
        this.userDisplayName = userDisplayName;
    }

    private void establishP8Connection() {
        Connection connection = this.getCEConnection();
        EntireNetwork entireNetwork = Factory.EntireNetwork.fetchInstance((Connection)connection, null);
        User user = entireNetwork.get_CurrentUser();
        this.distinguishedName = user.get_DistinguishedName();
        this.userName = user.get_Name();
        this.userDisplayName = user.get_DisplayName();
        this.domain = this.domainName == null || this.domainName.length() == 0 ? entireNetwork.get_LocalDomain() : Factory.Domain.getInstance((Connection)connection, (String)this.domainName);
        if (this.domain != null) {
            this.domain.fetchProperty("ObjectStores", null);
            ObjectStoreSet objectStoreSet = this.domain.get_ObjectStores();
            this.domainObjectStoreNames = new ArrayList();
            for (ObjectStore store : objectStoreSet) {
                this.domainObjectStoreNames.add(store.get_SymbolicName());
                if (!store.get_SymbolicName().equals(this.objectStoreName)) continue;
                this.objectStore = store;
                Integer accessRights = this.objectStore.getAccessAllowed();
                boolean canAddDoc = (accessRights & AccessRight.STORE_OBJECTS.getValue()) == AccessRight.STORE_OBJECTS.getValue();
                this.setPrivAddDoc(canAddDoc ? "true" : "false");
                this.setPrivAddItem(canAddDoc ? "true" : "false");
                boolean canAddSearch = false;
                boolean searchAddOnInstalled = false;
                try {
                    PropertyFilter filter = new PropertyFilter();
                    filter.addIncludeProperty(0, null, null, "PropertyDefinitions", null);
                    ClassDefinition classDefinition = Factory.ClassDefinition.fetchInstance((ObjectStore)this.objectStore, (String)"StoredSearch", (PropertyFilter)filter);
                    PropertyDefinitionList properties = classDefinition.get_PropertyDefinitions();
                    for (PropertyDefinition prop : properties) {
                        if (!prop.get_SymbolicName().equals("IcnShowInTree")) continue;
                        searchAddOnInstalled = true;
                        break;
                    }
                    canAddSearch = searchAddOnInstalled && canAddDoc && (classDefinition.getAccessAllowed() & 0x100) == 256;
                }
                catch (EngineRuntimeException e) {
                    Logger.logError(P8LogonAction.class, "establishP8Connection", "StoredSearch class was not found", (Throwable)e);
                }
                boolean canAddTeamspace = false;
                boolean canAddTeamspaceTemplate = false;
                if (canAddDoc) {
                    ClassDefinition classDefinition;
                    PropertyFilter filter = new PropertyFilter();
                    filter.addIncludeProperty(0, null, null, "PropertyDefinitions", null);
                    try {
                        classDefinition = Factory.ClassDefinition.fetchInstance((ObjectStore)this.objectStore, (String)"ClbTeamspace", (PropertyFilter)filter);
                        if ((classDefinition.getAccessAllowed() & 0x100) == 256 && (classDefinition.getAccessAllowed() & 0x200) == 512) {
                            canAddTeamspace = true;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        classDefinition = Factory.ClassDefinition.fetchInstance((ObjectStore)this.objectStore, (String)"ClbTeamspaceTemplate", (PropertyFilter)filter);
                        if ((classDefinition.getAccessAllowed() & 0x100) == 256 && (classDefinition.getAccessAllowed() & 0x200) == 512) {
                            canAddTeamspaceTemplate = true;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.setPrivAddItemTeamspace(canAddTeamspace ? "true" : "false");
                this.setPrivAddItemTeamspaceTemplate(canAddTeamspaceTemplate ? "true" : "false");
                this.setPrivAddSearch(canAddSearch ? "true" : "false");
                this.setSearchTemplateSupported(searchAddOnInstalled ? "true" : "false");
                break;
            }
        }
    }

    public void cleanUp(HttpSession session) {
        Subject sub;
        do {
            sub = null;
            P8Connection p8Connection = this;
            sub = p8Connection.userContext.get().popSubject();
            Logger.logDebug((Object)this, "cleanUp", session, "Cleaning up the subject from User context " + sub);
        } while (sub != null);
        MetadataCache metadataCache = Factory.MetadataCache.getDefaultInstance();
        if (metadataCache instanceof Cache) {
            Logger.logDebug((Object)this, "cleanUp", session, "Evicting all the Class descriptions from the cache");
            ((Cache)metadataCache).evictAllClassDescriptions();
        }
        this.userId = null;
        this.userName = null;
        this.distinguishedName = null;
        this.loginContext = null;
        this.userContext = null;
        this.ceConnection = null;
        this.subject = null;
        this.domain = null;
        this.objectStore = null;
        this.domainName = null;
        this.objectStoreName = null;
        this.userDisplayName = null;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserName() {
        if (this.userName == null) {
            this.establishP8Connection();
        }
        return this.userName;
    }

    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    public LoginContext getLoginContext() {
        return this.loginContext;
    }

    public UserContext getUserContext() {
        return this.userContext;
    }

    public Connection getCEConnection() {
        UserContext.get().popSubject();
        UserContext.get().pushSubject(this.subject);
        return this.ceConnection;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Domain getDomain() {
        if (this.domain == null) {
            this.establishP8Connection();
        }
        return this.domain;
    }

    public ObjectStore getObjectStore() {
        if (this.objectStore == null) {
            this.establishP8Connection();
        }
        return this.objectStore;
    }

    public ArrayList getDomainObjectStoreNames() {
        if (this.domainObjectStoreNames == null) {
            this.establishP8Connection();
        }
        return this.domainObjectStoreNames;
    }

    void addObjectStore(String id, ObjectStore objectStore) {
        this.objectStores.put(id, objectStore);
    }

    ObjectStore getObjectStore(String id) {
        return this.objectStores.get(id);
    }

    public String getDistinguishedName() {
        if (this.distinguishedName == null) {
            this.establishP8Connection();
        }
        return this.distinguishedName;
    }

    public void setVWSession(VWSession vwSession) {
        this.vwSession = vwSession;
    }

    public VWSession getVWSession() {
        return this.vwSession;
    }

    void setVWSessionByConnectionPoint(String id, VWSession vwSession) {
        this.vwSessionsByConnectionPoint.put(id, vwSession);
    }

    VWSession getVWSessionByConnectionPoint(String id) {
        return this.vwSessionsByConnectionPoint.get(id);
    }

    public String getP8ConnectionType() {
        return this.p8ConnectionType;
    }

    public void setP8ConnectionType(String p8ConnectionType) {
        this.p8ConnectionType = p8ConnectionType;
    }

    public String getPrivAddItemTeamspaceTemplate() {
        return this.privAddItemTeamspaceTemplate;
    }

    public void setPrivAddItemTeamspaceTemplate(String privAddItemTeamspaceTemplate) {
        this.privAddItemTeamspaceTemplate = privAddItemTeamspaceTemplate;
    }

    public String getPrivAddItemTeamspace() {
        return this.privAddItemTeamspace;
    }

    public void setPrivAddItemTeamspace(String privAddItemTeamspace) {
        this.privAddItemTeamspace = privAddItemTeamspace;
    }

    public String getPrivAddItem() {
        return this.privAddItem;
    }

    public void setPrivAddItem(String privAddItem) {
        this.privAddItem = privAddItem;
    }

    public String getPrivAddDoc() {
        return this.privAddDoc;
    }

    public void setPrivAddDoc(String privAddDoc) {
        this.privAddDoc = privAddDoc;
    }

    public String getPrivAddSearch() {
        return this.privAddSearch;
    }

    public void setPrivAddSearch(String privAddSearch) {
        this.privAddSearch = privAddSearch;
    }

    public String getSearchTemplateSupported() {
        return this.searchTemplateSupported;
    }

    public void setSearchTemplateSupported(String searchTemplateSupported) {
        this.searchTemplateSupported = searchTemplateSupported;
    }

    public void setPrivWorkflow(String privWorkflow) {
        this.privWorkflow = privWorkflow;
    }

    public String getPrivWorkflow() {
        return this.privWorkflow;
    }

    public String getTextSearchType(HttpServletRequest request) {
        return P8TextSearchUtil.getTextSearchType(request);
    }

    public void setObjectStoreRecordType(String recordType) {
        this.objectStoreRecordType = recordType;
    }

    public String getObjectStoreRecordType() {
        if (this.objectStoreRecordType == null) {
            this.objectStoreRecordType = P8RecordsUtil.getRecordRepositoryType(this.objectStore).toString();
        }
        return this.objectStoreRecordType;
    }

    public boolean isRecordObjectStore() {
        return this.objectStoreRecordType != null && (this.objectStoreRecordType.equals(P8RecordsUtil.RecordRepositoryType.FilePlan.toString()) || this.objectStoreRecordType.equals(P8RecordsUtil.RecordRepositoryType.Content.toString()));
    }

    public boolean isSearchAddOnInstalled() {
        return "true".equals(this.getSearchTemplateSupported());
    }
}

