/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.admin.Choice;
import com.filenet.api.collection.ChoiceList;
import com.filenet.api.collection.ChoiceListSet;
import com.filenet.api.collection.DependentObjectList;
import com.filenet.api.constants.AccessRight;
import com.filenet.api.constants.ChoiceType;
import com.filenet.api.constants.PropertyState;
import com.filenet.api.constants.TypeID;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.meta.PropertyDescription;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.Properties;
import com.filenet.api.property.Property;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.query.SearchSQL;
import com.filenet.api.query.SearchScope;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8ChoiceListUtil
extends Util {
    private static Map<String, com.filenet.api.admin.ChoiceList> choiceListCache = new HashMap<String, com.filenet.api.admin.ChoiceList>();

    public static void loadChoiceLists(HttpServletRequest request, List<PropertyDescription> propertyDescriptions, ObjectStore objectStore) {
        Logger.logEntry(P8ChoiceListUtil.class, "loadChoiceLists", (ServletRequest)request);
        List<String> ids = P8ChoiceListUtil.getChoiceListIds(propertyDescriptions);
        P8ChoiceListUtil.removeLoadedChoiceListIds(request, ids);
        if (ids.size() < 1) {
            return;
        }
        List<String> retrieveIds = P8ChoiceListUtil.getUpdatedChoiceListIds(request, ids, objectStore);
        if (retrieveIds.size() > 0) {
            P8ChoiceListUtil.loadChoiceList(request, retrieveIds, objectStore);
        }
        Logger.logExit(P8ChoiceListUtil.class, "loadChoiceLists", (ServletRequest)request);
    }

    private static List<String> removeLoadedChoiceListIds(HttpServletRequest request, List<String> choiceListIds) {
        ArrayList<String> requestedIds = (ArrayList<String>)request.getAttribute("requestedChoiceListIds");
        if (requestedIds == null) {
            requestedIds = new ArrayList<String>();
        }
        choiceListIds.removeAll(requestedIds);
        requestedIds.addAll(choiceListIds);
        request.setAttribute("requestedChoiceListIds", requestedIds);
        return choiceListIds;
    }

    private static boolean isLoadedChoiceListId(HttpServletRequest request, String choiceListId) {
        List requestedIds = (List)request.getAttribute("requestedChoiceListIds");
        if (requestedIds == null) {
            return false;
        }
        return requestedIds.contains(choiceListId);
    }

    private static List<String> getChoiceListIds(List<PropertyDescription> propertyDescriptions) {
        ArrayList<String> ids = new ArrayList<String>();
        for (PropertyDescription pd : propertyDescriptions) {
            String id = P8ChoiceListUtil.getChoiceListId(pd);
            if (id == null || id.isEmpty() || ids.contains(id)) continue;
            ids.add(id);
        }
        return ids;
    }

    private static List<String> getUpdatedChoiceListIds(HttpServletRequest request, List<String> choiceListIds, ObjectStore objectStore) {
        if (choiceListIds == null || choiceListIds.size() < 1) {
            return choiceListIds;
        }
        ArrayList<String> retrieveIds = new ArrayList<String>(choiceListIds.size());
        ChoiceListSet cls = objectStore.get_ChoiceLists();
        for (com.filenet.api.admin.ChoiceList cl : cls) {
            Date expiration;
            com.filenet.api.admin.ChoiceList cache;
            String id = cl.getObjectReference().getObjectIdentity();
            if (!choiceListIds.contains(id) || (cache = P8ChoiceListUtil.getCachedChoiceList(id, objectStore, expiration = cl.get_DateLastModified())) != null) continue;
            retrieveIds.add(id);
        }
        String log = "objectStoreId: " + objectStore.get_Id() + ", choiceListIds: " + choiceListIds + ", retrieveIds: " + retrieveIds;
        Logger.logDebug(P8ChoiceListUtil.class, "getChoiceListIdsWithUpdatedValues", (ServletRequest)request, log);
        return retrieveIds;
    }

    private static synchronized com.filenet.api.admin.ChoiceList getCachedChoiceList(String choiceListId, ObjectStore objectStore, Date expiration) {
        com.filenet.api.admin.ChoiceList cl = choiceListCache.get(objectStore.get_Id().toString() + "-" + choiceListId);
        if (cl != null && expiration != null && expiration.after(cl.get_DateLastModified())) {
            cl = null;
        }
        return cl;
    }

    private static boolean isAccessibleChoiceList(HttpServletRequest request, String choiceListId, ObjectStore objectStore) {
        ArrayList<String> accessibleIds = (ArrayList<String>)request.getAttribute("accessibleChoiceListIds");
        if (accessibleIds == null) {
            accessibleIds = new ArrayList<String>();
            ChoiceListSet cls = objectStore.get_ChoiceLists();
            for (com.filenet.api.admin.ChoiceList cl : cls) {
                if ((cl.getAccessAllowed() & AccessRight.READ.getValue()) == 0) continue;
                accessibleIds.add(cl.getObjectReference().getObjectIdentity());
            }
            request.setAttribute("accessibleChoiceListIds", accessibleIds);
        }
        return accessibleIds.contains(choiceListId);
    }

    private static void loadChoiceList(HttpServletRequest request, List<String> choiceListIds, ObjectStore objectStore) {
        if (choiceListIds == null || choiceListIds.size() < 1) {
            return;
        }
        SearchSQL search = new SearchSQL();
        search.setSelectList("DisplayName, DateLastModified, DataType, ChoiceValues");
        search.setFromClauseInitialValue("ChoiceList", null, true);
        StringBuilder where = new StringBuilder();
        for (String id : choiceListIds) {
            if (where.length() > 0) {
                where.append(" OR ");
            }
            where.append("Id").append(" = ").append(id);
        }
        search.setWhereClause(where.toString());
        SearchScope scope = new SearchScope(objectStore);
        PropertyFilter pf = new PropertyFilter();
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(0), null, Boolean.valueOf(true), "ChoiceValues ChoiceType ChoiceIntegerValue ChoiceStringValue DisplayName", null));
        ChoiceListSet choiceLists = (ChoiceListSet)scope.fetchObjects(search, null, pf, Boolean.valueOf(false));
        P8ChoiceListUtil.setCachedChoiceLists(request, choiceLists, objectStore);
    }

    private static synchronized void setCachedChoiceLists(HttpServletRequest request, ChoiceListSet choiceLists, ObjectStore objectStore) {
        Iterator itr = choiceLists.iterator();
        String osId = objectStore.get_Id().toString();
        ArrayList<String> retrievedIds = new ArrayList<String>();
        while (itr.hasNext()) {
            com.filenet.api.admin.ChoiceList cl = (com.filenet.api.admin.ChoiceList)itr.next();
            String id = cl.getObjectReference().getObjectIdentity();
            retrievedIds.add(id);
            choiceListCache.put(osId + "-" + id, cl);
        }
        Logger.logDebug(P8ChoiceListUtil.class, "setCachedChoiceLists", (ServletRequest)request, "osId: " + osId + ", retrievedIds: " + retrievedIds);
    }

    public static com.filenet.api.admin.ChoiceList getChoiceList(HttpServletRequest request, PropertyDescription propertyDescription, ObjectStore objectStore) {
        String id;
        if (objectStore == null) {
            return null;
        }
        com.filenet.api.admin.ChoiceList choiceList = null;
        if (propertyDescription != null && (id = P8ChoiceListUtil.getChoiceListId(propertyDescription)) != null && !id.isEmpty()) {
            choiceList = P8ChoiceListUtil.getChoiceList(request, id, objectStore);
        }
        return choiceList;
    }

    private static com.filenet.api.admin.ChoiceList getChoiceList(HttpServletRequest request, String choiceListId, ObjectStore objectStore) {
        boolean fetchNeeded;
        Logger.logEntry(P8ChoiceListUtil.class, "getChoiceList", (ServletRequest)request);
        if (!P8ChoiceListUtil.isAccessibleChoiceList(request, choiceListId, objectStore)) {
            return null;
        }
        ArrayList<String> id = new ArrayList<String>(1);
        id.add(choiceListId);
        com.filenet.api.admin.ChoiceList cl = P8ChoiceListUtil.getCachedChoiceList(choiceListId, objectStore, null);
        boolean bl = fetchNeeded = cl == null || !P8ChoiceListUtil.isLoadedChoiceListId(request, choiceListId) && P8ChoiceListUtil.getUpdatedChoiceListIds(request, id, objectStore).size() > 0;
        if (fetchNeeded) {
            P8ChoiceListUtil.loadChoiceList(request, id, objectStore);
            cl = P8ChoiceListUtil.getCachedChoiceList(choiceListId, objectStore, null);
        }
        Logger.logExit(P8ChoiceListUtil.class, "getChoiceList", (ServletRequest)request);
        return cl;
    }

    private static String getChoiceListId(PropertyDescription propertyDescription) {
        if (propertyDescription == null) {
            return null;
        }
        Properties properties = propertyDescription.getProperties();
        Property prop = properties.get("ChoiceList");
        PropertyState propertyState = prop.getState();
        return propertyState.getValue() == 3 ? prop.getIdValue().toString() : null;
    }

    public static com.filenet.api.admin.ChoiceList getChoiceList(HttpServletRequest request, String propName, ObjectStore objectStore, ClassDescription cd) {
        return P8ChoiceListUtil.getChoiceList(request, P8Util.getPropertyDescription(cd, propName), objectStore);
    }

    public static String lookupDisplayNameInChoiceList(EngineObject choiceList, Object value) {
        if (choiceList == null) {
            return null;
        }
        String choiceDispName = null;
        Properties props = choiceList.getProperties();
        DependentObjectList values = props.getDependentObjectListValue("ChoiceValues");
        for (Choice choice : values) {
            ChoiceType chtype = choice.get_ChoiceType();
            int type = chtype.getValue();
            if (type == 2 || type == 3) {
                String dispname = P8ChoiceListUtil.lookupDisplayNameInChoiceList((EngineObject)choice, value);
                if (dispname == null) continue;
                choiceDispName = dispname;
                break;
            }
            if (value instanceof String) {
                if (!value.equals(choice.get_ChoiceStringValue())) continue;
                choiceDispName = choice.get_DisplayName();
                break;
            }
            if (!(value instanceof Integer) || !value.equals(choice.get_ChoiceIntegerValue())) continue;
            choiceDispName = choice.get_DisplayName();
            break;
        }
        return choiceDispName;
    }

    public static void addChoiceList(HttpServletRequest request, PropertyDescription propertyDescription, ObjectStore objectStore, JSONObject jsonObj) {
        com.filenet.api.admin.ChoiceList choiceList = P8ChoiceListUtil.getChoiceList(request, propertyDescription, objectStore);
        P8ChoiceListUtil.addChoiceList(request, choiceList, propertyDescription, jsonObj);
    }

    public static void addChoiceList(HttpServletRequest request, PropertyDescription propertyDescription, String choiceListId, ObjectStore objectStore, JSONObject jsonObj) {
        com.filenet.api.admin.ChoiceList choiceList = P8ChoiceListUtil.getChoiceList(request, choiceListId, objectStore);
        P8ChoiceListUtil.addChoiceList(request, choiceList, propertyDescription, jsonObj);
    }

    private static void addChoiceList(HttpServletRequest request, com.filenet.api.admin.ChoiceList choiceList, PropertyDescription propertyDescription, JSONObject jsonObj) {
        if (choiceList != null) {
            jsonObj.put("cardinality", propertyDescription.get_Cardinality().toString());
            JSONObject jsonChoiceList = new JSONObject();
            jsonChoiceList.put("displayName", choiceList.get_DisplayName());
            jsonChoiceList.put("choices", P8ChoiceListUtil.addChoiceValues(request, choiceList.get_ChoiceValues(), choiceList.get_DataType()));
            jsonObj.put("choiceList", jsonChoiceList);
        }
    }

    private static JSONArray addChoiceValues(HttpServletRequest request, ChoiceList cl, TypeID typeID) {
        JSONArray jsonChoices = new JSONArray();
        for (Choice c : cl) {
            String cValue = null;
            if (typeID.equals(TypeID.LONG)) {
                if (c.get_ChoiceIntegerValue() != null) {
                    cValue = c.get_ChoiceIntegerValue() + "";
                }
            } else if (typeID.equals(TypeID.STRING)) {
                cValue = c.get_ChoiceStringValue();
            }
            JSONObject jsonChoice = new JSONObject();
            jsonChoice.put("displayName", c.get_DisplayName());
            if (cValue != null) {
                jsonChoice.put("value", cValue);
            } else {
                jsonChoice.put("choices", P8ChoiceListUtil.addChoiceValues(request, c.get_ChoiceValues(), typeID));
            }
            jsonChoices.add(jsonChoice);
        }
        return jsonChoices;
    }

    public static synchronized void clearCachedChoiceLists(HttpServletRequest request) {
        choiceListCache.clear();
    }
}

