/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.collection.EngineSet;
import com.filenet.api.collection.PageIterator;
import com.filenet.api.core.Document;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.query.SearchScope;
import com.filenet.api.util.Id;
import com.ibm.ecm.util.p8.P8CeSearchUtil;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8SearchDefinition;

public class P8CeSearchUtilProxy {
    public static final String STORED_SEARCH = "StoredSearch";
    private static Boolean cascadeSupported;
    private static Boolean storedSearchSupported;
    private static Boolean pageIteratorCheckpointSupported;

    public static boolean isCascadeSupported() {
        if (cascadeSupported != null) {
            return cascadeSupported;
        }
        try {
            Class<?> cbrSearchType = Class.forName("com.filenet.api.constants.CBRSearchType");
            cbrSearchType.getDeclaredField("TEXT_SEARCH");
            cascadeSupported = true;
        }
        catch (Exception e) {
            cascadeSupported = false;
        }
        return cascadeSupported;
    }

    public static boolean isStoredSearchSupported() {
        if (storedSearchSupported != null) {
            return storedSearchSupported;
        }
        try {
            Class.forName("com.filenet.api.query.StoredSearch");
            Class.forName("com.filenet.api.query.SearchTemplateParameters");
            storedSearchSupported = true;
        }
        catch (Exception e) {
            storedSearchSupported = false;
        }
        return storedSearchSupported;
    }

    public static boolean isPageIteratorCheckpointSupported() {
        if (cascadeSupported != null) {
            return cascadeSupported;
        }
        try {
            PageIterator.class.getDeclaredMethod("getNextPageCheckpoint", new Class[0]);
            pageIteratorCheckpointSupported = true;
        }
        catch (Exception e) {
            pageIteratorCheckpointSupported = false;
        }
        return pageIteratorCheckpointSupported;
    }

    public static PageIterator resumePageIterator(P8Connection connection, byte[] checkpoint) {
        if (!P8CeSearchUtilProxy.isPageIteratorCheckpointSupported()) {
            return null;
        }
        return P8CeSearchUtil.resumePageIterator(connection, checkpoint);
    }

    public static byte[] getNextPageCheckpoint(PageIterator pageIterator) {
        if (!P8CeSearchUtilProxy.isPageIteratorCheckpointSupported()) {
            return null;
        }
        return P8CeSearchUtil.getNextPageCheckpoint(pageIterator);
    }

    public static IndependentlyPersistableObject fetchStoredSearch(ObjectStore objectStore, Id searchId) {
        if (!P8CeSearchUtilProxy.isStoredSearchSupported()) {
            return null;
        }
        return P8CeSearchUtil.fetchStoredSearch(objectStore, searchId);
    }

    static Document getStoredSearch(ObjectStore objectStore, String storedSearchId) {
        if (!P8CeSearchUtilProxy.isStoredSearchSupported()) {
            return null;
        }
        return P8CeSearchUtil.getStoredSearch(objectStore, storedSearchId);
    }

    public static boolean isContentSearchInvalidException(EngineRuntimeException exception) {
        if (!P8CeSearchUtilProxy.isCascadeSupported()) {
            return false;
        }
        return P8CeSearchUtil.isContentSearchInvalidException(exception);
    }

    public static Object convertToCeSearchParameters(P8Connection connection, P8SearchDefinition.SearchClause searchClause, String sortProp, boolean sortDescending, boolean selectOnly) throws Exception {
        if (!P8CeSearchUtilProxy.isStoredSearchSupported()) {
            return null;
        }
        return P8CeSearchUtil.convertToCeSearchParameters(connection, searchClause, sortProp, sortDescending, selectOnly);
    }

    public static EngineSet executeStoredSearch(SearchScope searchScope, Document storedSearch, String fromClass, Object searchParameters, int pageSize, PropertyFilter propertyFilter, boolean orderByRank) {
        if (!P8CeSearchUtilProxy.isStoredSearchSupported()) {
            return null;
        }
        return P8CeSearchUtil.executeStoredSearch(searchScope, storedSearch, fromClass, searchParameters, pageSize, propertyFilter, orderByRank);
    }
}

