/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.collection.EngineSet;
import com.filenet.api.collection.PageIterator;
import com.filenet.api.constants.GroupAction;
import com.filenet.api.constants.RequiredState;
import com.filenet.api.constants.SearchModifier;
import com.filenet.api.constants.SortOrder;
import com.filenet.api.constants.VersionSelection;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Document;
import com.filenet.api.core.Factory;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.query.SearchScope;
import com.filenet.api.query.SearchTemplateContent;
import com.filenet.api.query.SearchTemplateContentItem;
import com.filenet.api.query.SearchTemplateParameters;
import com.filenet.api.query.SearchTemplateSelectProperty;
import com.filenet.api.query.SearchTemplateSubclass;
import com.filenet.api.query.SearchTemplateWhereProperty;
import com.filenet.api.query.StoredSearch;
import com.filenet.api.util.Id;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8DocID;
import com.ibm.ecm.util.p8.P8SearchDefinition;
import com.ibm.ecm.util.p8.P8SearchUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class P8CeSearchUtil {
    public static final String SELECT_RANK_COLUMN = "CS.Rank";
    private static final String[] AUGMENT_DOCUMENT_SELECT_PROPERTIES = new String[]{"ClassDescription", "IsCurrentVersion", "IsReserved", "MimeType", "VersionStatus", "MajorVersionNumber", "MinorVersionNumber", "VersionSeries", "Id", "CompoundDocumentState", "Reservation", "ReservationType", "IsVersioningEnabled", "ReplicationGroup"};
    private static final String[] AUGMENT_FOLDER_SELECT_PROPERTIES = new String[]{"ClassDescription", "Id", "ContainerType"};

    private P8CeSearchUtil() {
    }

    static PageIterator resumePageIterator(P8Connection connection, byte[] checkpoint) {
        return Factory.PageIterator.resumeInstance((Connection)connection.getCEConnection(), (byte[])checkpoint);
    }

    static byte[] getNextPageCheckpoint(PageIterator pageIterator) {
        return pageIterator == null ? null : pageIterator.getNextPageCheckpoint();
    }

    static IndependentlyPersistableObject fetchStoredSearch(ObjectStore objectStore, Id searchId) {
        return Factory.StoredSearch.fetchInstance((ObjectStore)objectStore, (Id)searchId, null);
    }

    static Document getStoredSearch(ObjectStore objectStore, String storedSearchId) {
        P8DocID docId = new P8DocID(storedSearchId);
        return (Document)objectStore.getObject("StoredSearch", new Id(docId.getObjectID()));
    }

    static EngineSet executeStoredSearch(SearchScope searchScope, Document storedSearch, String fromClass, Object searchParameters, int pageSize, PropertyFilter propertyFilter, boolean orderByRank) {
        Object results;
        try {
            results = orderByRank ? searchScope.fetchRows((StoredSearch)storedSearch, fromClass, (SearchTemplateParameters)searchParameters, Integer.valueOf(pageSize), propertyFilter, Boolean.TRUE) : searchScope.fetchObjects((StoredSearch)storedSearch, fromClass, (SearchTemplateParameters)searchParameters, Integer.valueOf(pageSize), propertyFilter, Boolean.TRUE);
        }
        catch (Exception e) {
            Throwable cause;
            if (e instanceof InvocationTargetException && (cause = e.getCause()) instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)cause;
            }
            throw new RuntimeException("Failed to invoke fetchRows method", e);
        }
        return results;
    }

    static boolean isContentSearchInvalidException(EngineRuntimeException exception) {
        return exception.getExceptionCode() == ExceptionCode.CBR_INVALID_SEARCH;
    }

    static Object convertToCeSearchParameters(P8Connection connection, P8SearchDefinition.SearchClause searchClause, String sortProp, boolean sortDescending, boolean selectOnly) throws Exception {
        List<SearchTemplateSubclass> subclasses;
        SearchTemplateContent content;
        P8SearchDefinition.ContentCriteria contentCriteria;
        SearchTemplate.ObjectType objectType;
        boolean showRank;
        SearchTemplateParameters searchParameters = new SearchTemplateParameters();
        P8SearchDefinition definition = searchClause.getSearchDefinition();
        List<P8SearchDefinition.SelectProperty> searchSelectProps = searchClause.getSelectProperties();
        List<SearchTemplateSelectProperty> ceSelectProps = P8CeSearchUtil.convertSelectClause(searchSelectProps, sortProp, sortDescending, showRank = searchClause.isContentCriteriaDefined() && searchClause.getContentCriteria().isShowRank());
        if (ceSelectProps != null) {
            searchParameters.setSelectProperties(ceSelectProps);
        }
        if ((objectType = searchClause.getFrom()) == SearchTemplate.ObjectType.document) {
            searchParameters.setAugmentedSelectList(Arrays.asList(AUGMENT_DOCUMENT_SELECT_PROPERTIES));
        } else if (objectType == SearchTemplate.ObjectType.folder) {
            searchParameters.setAugmentedSelectList(Arrays.asList(AUGMENT_FOLDER_SELECT_PROPERTIES));
        }
        if (selectOnly) {
            return searchParameters;
        }
        List<SearchTemplateWhereProperty> whereProps = P8CeSearchUtil.convertWhereClause(searchClause.retrieveWhereClauseConditions());
        if (whereProps != null) {
            searchParameters.setWhereProperties(whereProps);
        }
        if ((contentCriteria = searchClause.getContentCriteria()) != null && (content = P8CeSearchUtil.convertContentClause(searchClause.retrieveContentClauseItems(), contentCriteria.isCascade())) != null) {
            content.setRank(Boolean.valueOf(searchClause.getContentCriteria().isShowRank()));
            content.setSummary(Boolean.valueOf(searchClause.getContentCriteria().isShowContentSummary()));
            searchParameters.setContent(content);
        }
        if ((subclasses = P8CeSearchUtil.convertSubclasses(searchClause.getSubclasses())) != null) {
            searchParameters.setSubclasses(subclasses);
        }
        searchParameters.setVersionSelection((VersionSelection)(definition.isVersionSelectionAll() ? VersionSelection.ALL_VERSIONS : (definition.isVersionSelectionReleased() ? VersionSelection.RELEASED_VERSION : (definition.isVersionSelectionCurrent() ? VersionSelection.CURRENT_VERSION : null))));
        return searchParameters;
    }

    static List<SearchTemplateSelectProperty> convertSelectClause(List<P8SearchDefinition.SelectProperty> searchSelectProps, String sortProp, boolean sortDescending, boolean showRank) throws Exception {
        boolean selectAll;
        boolean bl = selectAll = searchSelectProps.size() == 1 && searchSelectProps.get(0) == P8SearchDefinition.SELECT_PROPERTY_ALL;
        if (!(searchSelectProps.size() >= 1 && !selectAll || sortProp != null && sortProp.length() >= 1)) {
            return null;
        }
        ArrayList<SearchTemplateSelectProperty> ceSelectProps = new ArrayList<SearchTemplateSelectProperty>();
        boolean sorted = false;
        for (P8SearchDefinition.SelectProperty selectProp : searchSelectProps) {
            if (selectProp == P8SearchDefinition.SELECT_PROPERTY_ALL) continue;
            String selectPropName = selectProp.getSymbolicName();
            SearchTemplateSelectProperty ceSelectProp = new SearchTemplateSelectProperty();
            ceSelectProp.setItemId(selectProp.getItemId());
            ceSelectProp.setSymbolicName(selectPropName);
            if (sortProp == null) {
                ceSelectProp.setSortLevel(Integer.valueOf(selectProp.getSortLevel()));
                ceSelectProp.setSortOrder(selectProp.isSortOrderDescending() ? SortOrder.DESCENDING : SortOrder.ASCENDING);
                sorted = sorted || selectProp.getSortLevel() > 0;
            } else if (selectPropName.equalsIgnoreCase(sortProp)) {
                ceSelectProp.setSortLevel(Integer.valueOf(1));
                ceSelectProp.setSortOrder(sortDescending ? SortOrder.DESCENDING : SortOrder.ASCENDING);
                sorted = true;
            } else {
                ceSelectProp.setSortLevel(Integer.valueOf(0));
                ceSelectProp.setSortOrder(sortDescending ? SortOrder.DESCENDING : SortOrder.ASCENDING);
            }
            ceSelectProps.add(ceSelectProp);
        }
        if (!sorted && sortProp != null && sortProp.length() > 0 && !sortProp.equals("Rank")) {
            SearchTemplateSelectProperty newSortProp = new SearchTemplateSelectProperty();
            newSortProp.setItemId(UUID.randomUUID().toString());
            newSortProp.setSymbolicName(sortProp);
            newSortProp.setSortLevel(Integer.valueOf(1));
            newSortProp.setSortOrder(sortDescending ? SortOrder.DESCENDING : SortOrder.ASCENDING);
            ceSelectProps.add(newSortProp);
            sorted = true;
        }
        if (showRank) {
            SearchTemplateSelectProperty rankProp = new SearchTemplateSelectProperty();
            rankProp.setItemId(UUID.randomUUID().toString());
            rankProp.setSymbolicName(SELECT_RANK_COLUMN);
            rankProp.setSortLevel(Integer.valueOf(sorted ? 0 : 1));
            rankProp.setSortOrder(sortDescending ? SortOrder.DESCENDING : SortOrder.ASCENDING);
            ceSelectProps.add(rankProp);
        }
        return ceSelectProps;
    }

    static List<SearchTemplateWhereProperty> convertWhereClause(Map<String, P8SearchDefinition.ClauseItem> whereClause) throws Exception {
        if (whereClause == null || whereClause.size() < 1) {
            return null;
        }
        ArrayList<SearchTemplateWhereProperty> whereProps = new ArrayList<SearchTemplateWhereProperty>();
        Set<String> itemIds = whereClause.keySet();
        for (String itemId : itemIds) {
            boolean exclude;
            P8SearchDefinition.WhereClauseCondition condition = (P8SearchDefinition.WhereClauseCondition)whereClause.get(itemId);
            SearchTemplateWhereProperty whereProp = new SearchTemplateWhereProperty();
            whereProp.setItemId(itemId);
            String value = condition.getLiteral();
            boolean bl = exclude = (value == null || value.length() < 1) && !condition.isOperatorNullOrNotNull();
            if (exclude) {
                whereProp.setExcludeFromQuery(Boolean.valueOf(exclude));
            } else {
                if (condition.getPropDataType() == P8SearchDefinition.DataType.typedate && value.length() > 19) {
                    value = value.substring(0, 10) + value.substring(19);
                }
                whereProp.setLiteral(value);
            }
            whereProps.add(whereProp);
        }
        return whereProps;
    }

    static SearchTemplateContent convertContentClause(Map<String, P8SearchDefinition.ClauseItem> contentClause, boolean cascade) throws Exception {
        if (contentClause == null || contentClause.size() < 1) {
            return null;
        }
        SearchTemplateContent content = new SearchTemplateContent();
        ArrayList<SearchTemplateContentItem> contentItems = new ArrayList<SearchTemplateContentItem>();
        Set<String> itemIds = contentClause.keySet();
        for (String itemId : itemIds) {
            boolean exclude;
            P8SearchDefinition.ContentClauseItem item = (P8SearchDefinition.ContentClauseItem)contentClause.get(itemId);
            SearchTemplateContentItem contentItem = new SearchTemplateContentItem();
            contentItem.setItemId(itemId);
            String value = item.getUserText();
            boolean bl = exclude = value == null || value.length() < 1;
            if (exclude) {
                contentItem.setExcludeFromQuery(Boolean.valueOf(exclude));
            } else {
                ArrayList<String> itemData = new ArrayList<String>();
                List<P8SearchDefinition.ContentTerm> terms = item.getContentTerms();
                StringBuilder cascadeProximity = new StringBuilder();
                for (P8SearchDefinition.ContentTerm term : terms) {
                    String v = term.getValue();
                    if (term.isPhrase() && (!cascade || !item.isSearchModifierProximity()) || cascade && term.isProhibited()) {
                        v = "\"" + v + "\"";
                    }
                    if (cascade && item.isSearchModifierProximity()) {
                        if (cascadeProximity.length() > 0) {
                            cascadeProximity.append(" ");
                        }
                        cascadeProximity.append(v);
                        continue;
                    }
                    itemData.add(v);
                }
                if (cascade && item.isSearchModifierProximity()) {
                    itemData.add(cascadeProximity.toString());
                }
                if (item.isGroupActionVql()) {
                    itemData.add(item.getUserText());
                }
                contentItem.setGroupAction((GroupAction)(item.isGroupActionAll() ? GroupAction.ALL : (item.isGroupActionAny() ? GroupAction.ANY : null)));
                contentItem.setItemData(itemData);
                contentItem.setItemId(itemId);
                contentItem.setRequiredState((RequiredState)(item.isRequiredStateProhibited() ? RequiredState.PROHIBITED : null));
                if (cascade && item.isSearchModifierProximity()) {
                    contentItem.setSearchModifier(SearchModifier.PROXIMITY);
                    contentItem.setSearchModifierRange(Double.valueOf(item.getSearchModifierRange()));
                }
            }
            contentItems.add(contentItem);
        }
        content.setContentItems(contentItems);
        return content;
    }

    static List<SearchTemplateSubclass> convertSubclasses(List<P8SearchDefinition.Subclass> subclasses) throws Exception {
        if (P8SearchUtil.isSearchingAllClasses(subclasses)) {
            return null;
        }
        ArrayList<SearchTemplateSubclass> ceSubclasses = new ArrayList<SearchTemplateSubclass>();
        for (P8SearchDefinition.Subclass subclass : subclasses) {
            SearchTemplateSubclass ceSubclass = new SearchTemplateSubclass();
            ceSubclass.setItemId(subclass.getItemId());
            ceSubclass.setExcludeFromQuery(Boolean.valueOf(subclass.isUnselected()));
            if (!subclass.isUnselected()) {
                ceSubclass.setIncludeSubclasses(Boolean.valueOf(false));
                ceSubclass.setSymbolicName(subclass.getSymbolicName());
            }
            ceSubclasses.add(ceSubclass);
        }
        return ceSubclasses;
    }
}

