/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.XMLUtil;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class P8BaseAnnotation {
    protected static final String PROP_DESC_NODE_NAME = "PropDesc";
    protected static final String POINTS_NODE_NAME = "F_POINTS";
    protected static final String CUSTOM_BYTES_NODE_NAME = "F_CUSTOM_BYTES";
    protected static final String TEXT_NODE_NAME = "F_TEXT";
    protected static final String DOC_ACCESS_LEVEL_NODE_NAME = "docaccesslevel";
    protected Element fnAnno;
    protected Text text;
    protected Map<String, String> propDescMap = new Hashtable<String, String>();
    protected HttpServletRequest request;

    private P8BaseAnnotation(HttpServletRequest request) {
        this.request = request;
    }

    public P8BaseAnnotation(HttpServletRequest request, String annotXmlString) {
        String methodName = "P8BaseAnnotation(String)";
        this.request = request;
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        this.initialize(annotXmlString);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    public P8BaseAnnotation(HttpServletRequest request, InputStream xmlInputStream) {
        String methodName = "P8BaseAnnotation(InputStream)";
        this.request = request;
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        this.initialize(xmlInputStream);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void initialize(Object xmlObject) {
        Document annotXml = this.getAnnotXml(xmlObject);
        if (annotXml != null) {
            this.fnAnno = annotXml.getDocumentElement();
            this.loadPropDescMap();
            this.loadText();
        } else {
            this.fnAnno = null;
        }
    }

    private Document getAnnotXml(Object xmlObject) {
        String methodName = "getAnnotXml";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Document annotXml = null;
        try {
            if (xmlObject instanceof InputStream) {
                annotXml = XMLUtil.getDocumentFromInputStream((InputStream)xmlObject);
            } else if (xmlObject instanceof String) {
                annotXml = XMLUtil.getDocumentFromString((String)xmlObject);
            } else {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, MessageFormat.format("getAnnotXml was called with an unrecognized class: {0}", xmlObject.getClass().getName()));
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return annotXml;
    }

    protected Element getElement(String elementName) {
        NodeList nodeList = this.fnAnno.getElementsByTagName(elementName);
        Element element = (Element)nodeList.item(0);
        return element;
    }

    private void loadPropDescMap() {
        Element propDescNode = this.getElement(PROP_DESC_NODE_NAME);
        NamedNodeMap nnMap = propDescNode.getAttributes();
        for (int n = 0; n < nnMap.getLength(); ++n) {
            Node attribute = nnMap.item(n);
            String key = attribute.getNodeName();
            String value = attribute.getNodeValue();
            this.propDescMap.put(key, value);
        }
    }

    private void loadText() {
        Element textNode = this.getElement(TEXT_NODE_NAME);
        if (textNode != null) {
            Attr encodingNode = textNode.getAttributeNode("Encoding");
            String encoding = encodingNode != null ? encodingNode.getNodeValue() : null;
            String nodeContent = XMLUtil.getElementText(textNode);
            this.text = null;
            if (encoding != null && nodeContent != null && nodeContent.length() > 0) {
                this.text = new Text(encoding, nodeContent);
            }
        }
    }

    protected class Text {
        int[] value;
        String encoding;
        String toStringValue = null;

        public Text(String encoding, String hexString) {
            int length = hexString.length() / 2;
            this.value = new int[length];
            for (int n = 0; n < length; ++n) {
                int pos = n * 2;
                String oneByte = hexString.substring(pos, pos + 2);
                this.value[n] = Integer.valueOf(oneByte, 16);
            }
            this.encoding = encoding;
        }

        public String toString() {
            if (this.toStringValue == null) {
                StringBuffer sBuf = new StringBuffer();
                if (this.encoding != null && this.encoding.equals("unicode")) {
                    int stringLength = this.value.length / 2;
                    for (int n = 0; n < stringLength; ++n) {
                        int pos = n * 2;
                        int intValue = (this.value[pos] << 8) + this.value[pos + 1];
                        sBuf.append((char)intValue);
                    }
                } else {
                    for (int n = 0; n < this.value.length; ++n) {
                        sBuf.append((char)this.value[n]);
                    }
                }
                this.toStringValue = sBuf.toString();
            }
            return this.toStringValue;
        }
    }
}

