/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.collection.AccessPermissionList;
import com.filenet.api.collection.AnnotationSet;
import com.filenet.api.collection.ContentElementList;
import com.filenet.api.collection.ContentTransferList;
import com.filenet.api.constants.AccessType;
import com.filenet.api.constants.PermissionSource;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.Annotation;
import com.filenet.api.core.ContentElement;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.core.Document;
import com.filenet.api.core.Factory;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.Scope;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.replication.ReplicationGroup;
import com.filenet.api.security.AccessPermission;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8InboundAnnotation;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class P8AnnotationImporter {
    private Document document;
    private Map<String, Annotation> annotations;
    private ReplicationGroup replicationGroup;
    private boolean isCFSFederated = false;
    private String user;
    private HttpServletRequest request;

    private P8AnnotationImporter() {
    }

    public P8AnnotationImporter(HttpServletRequest request, P8Connection connection, Document document) {
        this.request = request;
        AnnotationSet annotationSet = document.get_Annotations();
        this.user = connection.getUserId();
        this.replicationGroup = document.get_ReplicationGroup();
        this.isCFSFederated = this.replicationGroup != null;
        this.annotations = new HashMap<String, Annotation>();
        for (Annotation annotation : annotationSet) {
            this.annotations.put(annotation.get_Id().toString().toUpperCase(), annotation);
        }
        this.document = document;
    }

    public void importUpdates(HttpServletRequest request, P8Connection connection, String annotationUpdateXml, Boolean useAnnotationClassSecurity) throws IOException, SAXException, ParserConfigurationException, Exception {
        List<P8InboundAnnotation> annotationUpdates = P8InboundAnnotation.getInboundAnnotations(request, annotationUpdateXml);
        for (P8InboundAnnotation inboundAnnotation : annotationUpdates) {
            String operation = inboundAnnotation.getOperation();
            if (operation.equalsIgnoreCase("add")) {
                if (this.isCFSFederated) {
                    inboundAnnotation.validate();
                }
                this.addAnnotation(inboundAnnotation, useAnnotationClassSecurity);
                continue;
            }
            Annotation annotation = this.annotations.get(inboundAnnotation.getAnnotId());
            if (annotation == null) continue;
            if (operation.equalsIgnoreCase("change")) {
                if (this.isCFSFederated) {
                    inboundAnnotation.validate();
                }
                this.changeAnnotation(annotation, inboundAnnotation);
                continue;
            }
            if (!operation.equalsIgnoreCase("remove")) continue;
            this.deleteAnnotation(annotation);
        }
    }

    private AccessPermissionList getAnnotationDefaultPermissions(String user, ObjectStore objectStore) {
        String methodName = "getAnnotationDefaultPermissions";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        String creatorOwner = "#CREATOR-OWNER";
        ClassDescription des = Factory.ClassDescription.fetchInstance((Scope)objectStore, (String)"annotation", null);
        AccessPermissionList perms = des.get_DefaultInstancePermissions();
        AccessPermissionList newPerms = Factory.AccessPermission.createList();
        for (AccessPermission permission : perms) {
            String granteeName = permission.get_GranteeName();
            if (granteeName.equalsIgnoreCase(creatorOwner)) {
                newPerms.add((Object)this.copyCreatorOwnerPermission(permission, user));
                continue;
            }
            if (granteeName.equalsIgnoreCase(user)) continue;
            newPerms.add((Object)permission);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return newPerms;
    }

    private AccessPermissionList getDocumentPermissions(String user) {
        String methodName = "getDocumentPermissions";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        AccessPermissionList perms = this.document.get_Permissions();
        AccessPermissionList newPerms = Factory.AccessPermission.createList();
        boolean addCreator = false;
        for (AccessPermission permission : perms) {
            boolean isInherited;
            String granteeName = permission.get_GranteeName();
            PermissionSource permSource = permission.get_PermissionSource();
            boolean bl = isInherited = permSource == PermissionSource.SOURCE_PARENT;
            if (granteeName.equals(user) && !isInherited) {
                addCreator = true;
                continue;
            }
            newPerms.add((Object)permission);
        }
        if (addCreator) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Replacing current user access with ALLOW FULL_CONTROL_ANNOTATION access for the new annotation.");
            AccessPermission perm = Factory.AccessPermission.createInstance();
            perm.set_GranteeName(user);
            perm.set_AccessType(AccessType.ALLOW);
            perm.set_AccessMask(Integer.valueOf(983427));
            newPerms.add((Object)perm);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return newPerms;
    }

    private AccessPermission copyCreatorOwnerPermission(AccessPermission perm, String user) {
        String methodName = "copyCreatorOwnerPermission";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        AccessPermission newPerm = Factory.AccessPermission.createInstance();
        newPerm.set_AccessMask(perm.get_AccessMask());
        newPerm.set_AccessType(perm.get_AccessType());
        newPerm.set_GranteeName(user);
        newPerm.set_InheritableDepth(perm.get_InheritableDepth());
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return newPerm;
    }

    private int getElementSequenceNumber() {
        ContentElementList docContentElements = this.document.get_ContentElements();
        ContentElement docContentElement = (ContentElement)docContentElements.get(0);
        Integer elementSequenceNumber = docContentElement.get_ElementSequenceNumber();
        return elementSequenceNumber;
    }

    private Annotation createNewAnnotation() {
        ObjectStore objectStore = this.document.getObjectStore();
        Annotation annotation = Factory.Annotation.createInstance((ObjectStore)objectStore, (String)"Annotation");
        annotation.set_AnnotatedObject((IndependentObject)this.document);
        annotation.set_AnnotatedContentElement(Integer.valueOf(this.getElementSequenceNumber()));
        return annotation;
    }

    private void setContent(Annotation annotation, InputStream is) {
        ContentTransfer contentTransfer = Factory.ContentTransfer.createInstance();
        ContentTransferList contentElements = Factory.ContentTransfer.createList();
        contentTransfer.setCaptureSource(is);
        contentElements.add((Object)contentTransfer);
        annotation.set_ContentElements((ContentElementList)contentElements);
    }

    private void addAnnotation(P8InboundAnnotation inboundAnnotation, Boolean useAnnotationClassSecurity) {
        String methodName = "addAnnotation";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Annotation annotation = this.createNewAnnotation();
        annotation.save(RefreshMode.REFRESH);
        inboundAnnotation.setAnnotId(annotation.get_Id().toString());
        this.setContent(annotation, inboundAnnotation.getXmlInputStream());
        ObjectStore objectStore = this.document.getObjectStore();
        AccessPermissionList perms = null;
        if (useAnnotationClassSecurity.booleanValue()) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Initializing security from Annotation default security for the new annotation.");
            perms = this.getAnnotationDefaultPermissions(this.user, objectStore);
        } else {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Initializing security from the Document security for the new annotation.");
            perms = this.getDocumentPermissions(this.user);
        }
        annotation.set_Permissions(perms);
        if (this.isCFSFederated) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "The document is federated.  Setting the replicationGroup on the new annotation.");
            annotation.set_ReplicationGroup(this.replicationGroup);
        }
        annotation.save(RefreshMode.NO_REFRESH);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    private void changeAnnotation(Annotation annotation, P8InboundAnnotation inboundAnnotation) {
        this.setContent(annotation, inboundAnnotation.getXmlInputStream());
        annotation.save(RefreshMode.NO_REFRESH);
    }

    private void deleteAnnotation(Annotation annotation) {
        annotation.delete();
        annotation.save(RefreshMode.NO_REFRESH);
    }
}

