/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.ibm.ecm.util.p8.P8Annotation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8AnnotationExporter {
    private static TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static Templates templates = null;
    private static Object templatesLock = new Object();
    private Map<String, List<P8Annotation>> pageMap = new TreeMap<String, List<P8Annotation>>();

    private P8AnnotationExporter() {
    }

    public P8AnnotationExporter(List<P8Annotation> p8Annotations) {
        this.addP8Annotations(p8Annotations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(ServletContext servletContext) throws TransformerConfigurationException {
        if (templates == null) {
            Object object = templatesLock;
            synchronized (object) {
                InputStream is = servletContext.getResourceAsStream("/WEB-INF/xsl/Annot.xsl");
                templates = transformerFactory.newTemplates(new StreamSource(is));
            }
        }
    }

    public void export(OutputStream os) throws IOException {
        StringBuffer annotationXml = this.getAnnotationXml();
        try {
            this.applyXslTransform(os, annotationXml);
        }
        catch (TransformerException tce) {
            throw new IOException(tce);
        }
    }

    public StringBuffer getAnnotationXml() {
        StringBuffer annotationXml = new StringBuffer();
        this.appendDaejaHeader(annotationXml, null, null, null);
        for (Map.Entry<String, List<P8Annotation>> entry : this.pageMap.entrySet()) {
            String page = entry.getKey();
            List<P8Annotation> p8Annotations = entry.getValue();
            this.appendDaejaPageHeader(annotationXml, page);
            for (P8Annotation p8Annotation : p8Annotations) {
                annotationXml.append(p8Annotation.getXml());
            }
            this.appendDaejaPageFooter(annotationXml);
        }
        this.appendDaejaFooters(annotationXml);
        return annotationXml;
    }

    private void addP8Annotation(P8Annotation p8Annotation) {
        String page = p8Annotation.getPage();
        List<P8Annotation> pageList = this.pageMap.get(page);
        if (pageList == null) {
            pageList = new ArrayList<P8Annotation>();
            this.pageMap.put(page, pageList);
        }
        pageList.add(p8Annotation);
    }

    private void addP8Annotations(List<P8Annotation> p8Annotations) {
        Iterator<P8Annotation> i = p8Annotations.iterator();
        while (i.hasNext()) {
            this.addP8Annotation(i.next());
        }
    }

    private void applyXslTransform(OutputStream os, StringBuffer annotationXml) throws TransformerException {
        Transformer transformer = templates.newTransformer();
        StringReader xmlReader = new StringReader(annotationXml.toString());
        StreamSource in = new StreamSource(xmlReader);
        StreamResult out = new StreamResult(os);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(in, out);
    }

    private void appendDaejaHeader(StringBuffer annotationXml, String docID, String libName, String systemType) {
        annotationXml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<FnDocAnnoList DocID=\"");
        if (docID != null) {
            annotationXml.append(docID);
        }
        annotationXml.append("\" LibName=\"");
        if (libName != null) {
            annotationXml.append(libName);
        }
        annotationXml.append("\" SystemType=\"");
        annotationXml.append(systemType != null ? systemType : "0");
        annotationXml.append("\" xmlns:xsd=\"http:www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n");
    }

    private void appendDaejaPageHeader(StringBuffer annotationXml, String page) {
        annotationXml.append("    <FnPageAnnoList Page=\"");
        annotationXml.append(page);
        annotationXml.append("\">\n");
    }

    private void appendDaejaPageFooter(StringBuffer annotationXml) {
        annotationXml.append("    </FnPageAnnoList>\n");
    }

    public void appendDaejaFooters(StringBuffer annotationXml) {
        annotationXml.append("</FnDocAnnoList>\n");
    }
}

