/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.p8;

import com.filenet.api.collection.AnnotationSet;
import com.filenet.api.core.Annotation;
import com.filenet.api.core.Document;
import com.filenet.api.core.Domain;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.RetrievingBatch;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.PropertyFilter;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.p8.P8BaseAnnotation;
import com.ibm.ecm.util.p8.P8Connection;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8Annotation
extends P8BaseAnnotation {
    public static int CFSIS_MODIFY_CONTENT = 262146;
    public static int CFSIS_VIEW_CONTENT = 131201;
    public static int CFSIS_MODIFY_OWNER = 65536;
    public static int LEVEL_CFSIS_FULL_CONTROL_WITHOUT_CREATE_INSTANCE_AND_MODIFY_OWNER = CFSIS_MODIFY_OWNER + CFSIS_MODIFY_CONTENT + CFSIS_VIEW_CONTENT;
    public static int LEVEL_CFSIS_MODIFY_CONTENT = CFSIS_MODIFY_CONTENT + CFSIS_VIEW_CONTENT;
    public static int LEVEL_CFSIS_VIEW_CONTENT = CFSIS_VIEW_CONTENT;
    private static PropertyFilter propertyFilter = null;
    private Annotation annotation;
    private String annotId;
    private String annotClassName;
    private Integer accessMask;
    private String docAccessLevel;
    private String customBytes;
    private String points;
    private boolean cfsDocument = false;
    private String page;
    private String distinguishedName;
    private Exception initException = null;
    private String permUserName;
    private String permLevel;

    private static PropertyFilter getPropertyFilter() {
        if (propertyFilter == null) {
            propertyFilter = new PropertyFilter();
            propertyFilter.setMaxRecursion(1);
            propertyFilter.addIncludeProperty(new FilterElement(null, null, null, "Id", null));
            propertyFilter.addIncludeProperty(new FilterElement(null, null, null, "ContentElements", null));
            propertyFilter.addIncludeProperty(new FilterElement(null, null, null, "Content", null));
        }
        return propertyFilter;
    }

    private static AnnotationSet fetchDocumentAnnotations(P8Connection connection, Document document) {
        AnnotationSet annotations = document.get_Annotations();
        if (annotations.iterator().hasNext()) {
            RetrievingBatch batch = RetrievingBatch.createRetrievingBatchInstance((Domain)connection.getDomain());
            PropertyFilter filter = P8Annotation.getPropertyFilter();
            Iterator i = annotations.iterator();
            while (i.hasNext()) {
                batch.add((IndependentObject)i.next(), filter);
            }
            batch.retrieveBatch();
        }
        return annotations;
    }

    public static List<P8Annotation> getDocumentAnnotations(HttpServletRequest request, P8Connection connection, Document document) {
        AnnotationSet annotations = P8Annotation.fetchDocumentAnnotations(connection, document);
        return P8Annotation.getDocumentAnnotations(request, connection, annotations);
    }

    public static List<P8Annotation> getDocumentAnnotations(HttpServletRequest request, P8Connection connection, AnnotationSet annotations) {
        String methodName = "getDocumentAnnotations";
        Logger.logEntry(P8Annotation.class, methodName, (ServletRequest)request);
        ArrayList<P8Annotation> p8Annotations = new ArrayList<P8Annotation>();
        for (Annotation annotation : annotations) {
            try {
                P8Annotation p8Annotation = new P8Annotation(request, connection, annotation);
                if (p8Annotation.initException != null) continue;
                p8Annotations.add(p8Annotation);
            }
            catch (EngineRuntimeException ere) {
                Logger.logDebug(P8Annotation.class, methodName, (ServletRequest)request, MessageFormat.format("Failed to load annotation {0}.", annotation.get_Id()));
                Logger.logError(P8Annotation.class, methodName, (ServletRequest)request, (Throwable)ere);
            }
        }
        Logger.logExit(P8Annotation.class, methodName, (ServletRequest)request);
        return p8Annotations;
    }

    public P8Annotation(HttpServletRequest request, P8Connection connection, Annotation annotation) {
        super(request, annotation.accessContentStream(0));
        String methodName = "P8Annotation(connection, annotation)";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        try {
            this.annotation = annotation;
            this.permUserName = connection.getUserId();
            this.distinguishedName = connection.getDistinguishedName();
            this.initialize();
        }
        catch (Exception exc) {
            this.initException = exc;
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Exception trying to parse annotation: message = " + exc.getMessage());
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)exc);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    public String getXml() {
        StringBuffer xmlBuffer = new StringBuffer();
        xmlBuffer.append("        <FnAnno>\n");
        xmlBuffer.append("            <PropDesc");
        Iterator<Map.Entry<String, String>> i = this.getPropDescIterator();
        while (i.hasNext()) {
            Map.Entry<String, String> propDesc = i.next();
            xmlBuffer.append(" ");
            xmlBuffer.append(propDesc.getKey());
            xmlBuffer.append("=\"");
            xmlBuffer.append(propDesc.getValue());
            xmlBuffer.append("\"");
        }
        xmlBuffer.append(">\n\n");
        this.appendTagXml(xmlBuffer, "F_CUSTOM_BYTES", this.customBytes);
        xmlBuffer.append("\n\n");
        this.appendTagXml(xmlBuffer, "F_POINTS", this.points);
        xmlBuffer.append("\n\n");
        this.appendTagXml(xmlBuffer, "F_TEXT", this.getText());
        xmlBuffer.append("\n\n");
        xmlBuffer.append("            </PropDesc>\n");
        this.appendCESecurityXml(xmlBuffer);
        xmlBuffer.append("        </FnAnno>\n");
        return xmlBuffer.toString();
    }

    public String getAnnotId() {
        return this.annotId;
    }

    private void initialize() throws IOException, SAXException, ParserConfigurationException {
        this.annotId = this.annotation.get_Id().toString();
        this.annotClassName = this.annotation.getClassName();
        this.accessMask = this.annotation.getAccessAllowed();
        this.cfsDocument = this.annotClassName.equals("ISAnnotation");
        this.loadPage();
        this.loadCustomBytes();
        this.loadDocAccessLevel();
        this.loadPoints();
        this.initializeCeSecurity();
    }

    private void initializeCeSecurity() {
        boolean canCFSView;
        boolean canDelete = (this.accessMask & 0xF0183) == 983427;
        boolean canEdit = (this.accessMask & 0x205F3) == 132595;
        boolean canModifyContent = (this.accessMask & 0x20183) == 131459;
        boolean canView = (this.accessMask & 0x20081) == 131201;
        boolean canCFSDelete = this.cfsDocument && (this.accessMask & LEVEL_CFSIS_FULL_CONTROL_WITHOUT_CREATE_INSTANCE_AND_MODIFY_OWNER) == LEVEL_CFSIS_FULL_CONTROL_WITHOUT_CREATE_INSTANCE_AND_MODIFY_OWNER;
        boolean canCFSModify = this.cfsDocument && (this.accessMask & LEVEL_CFSIS_MODIFY_CONTENT) == LEVEL_CFSIS_MODIFY_CONTENT;
        boolean bl = canCFSView = this.cfsDocument && (this.accessMask & LEVEL_CFSIS_VIEW_CONTENT) == LEVEL_CFSIS_VIEW_CONTENT;
        this.permLevel = canDelete || canCFSDelete ? "delete" : (canEdit || canModifyContent || canCFSModify ? "edit" : (canView || canCFSView ? "view" : "none"));
    }

    private void loadPoints() {
        Element pointsNode = this.getElement("F_POINTS");
        if (pointsNode != null) {
            this.points = pointsNode.getTextContent();
        }
    }

    private void loadCustomBytes() {
        Element customBytesNode = this.getElement("F_CUSTOM_BYTES");
        if (customBytesNode != null) {
            this.customBytes = customBytesNode.getTextContent();
        }
    }

    private void loadDocAccessLevel() {
        Element docAccessLevelNode = this.getElement("docaccesslevel");
        if (docAccessLevelNode != null) {
            this.docAccessLevel = docAccessLevelNode.getTextContent();
        }
    }

    private void appendTagXml(StringBuffer xmlBuffer, String tag, String value) {
        xmlBuffer.append("            <");
        xmlBuffer.append(tag);
        if (value != null && value.length() > 0) {
            xmlBuffer.append(">");
            xmlBuffer.append(value);
            xmlBuffer.append("</");
            xmlBuffer.append(tag);
            xmlBuffer.append(">");
        } else {
            xmlBuffer.append("/>");
        }
    }

    private void appendCESecurityXml(StringBuffer xmlBuffer) {
        xmlBuffer.append("            <security>\n");
        xmlBuffer.append("                <securityobject clientpermission=\"change\" objectid=\"one\" objecttype=\"annotation\" systemtype=\"ce\">\n");
        xmlBuffer.append("                    <permission id=\"1\" level=\"");
        xmlBuffer.append(this.permLevel);
        xmlBuffer.append("\" name=\"");
        xmlBuffer.append(this.distinguishedName);
        xmlBuffer.append("\" type=\"user\"/>\n");
        xmlBuffer.append("                </securityobject>\n");
        xmlBuffer.append("            </security>\n");
    }

    private Iterator<Map.Entry<String, String>> getPropDescIterator() {
        return this.propDescMap.entrySet().iterator();
    }

    private String getText() {
        return this.text != null ? this.text.toString() : null;
    }

    public String getPage() {
        return this.page;
    }

    private void loadPage() {
        String pageNumber;
        String mtPageNumber = (String)this.propDescMap.get("F_MULTIPAGETIFFPAGENUMBER");
        this.page = mtPageNumber != null && Integer.valueOf(mtPageNumber) > 0 ? mtPageNumber : ((pageNumber = (String)this.propDescMap.get("F_PAGENUMBER")) != null && Integer.valueOf(pageNumber) > 0 ? pageNumber : "1");
    }
}

