/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.od;

import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.od.ODStringValuesSorter;
import com.ibm.edms.od.ODCriteria;
import com.ibm.edms.od.ODServer;
import com.ibm.edms.od.ODUser;
import com.ibm.json.java.JSONArray;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.DateFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class ODUtil
extends Util {
    public static final String[] COLORS = new String[]{String.valueOf('D'), String.valueOf('N'), String.valueOf('B'), String.valueOf('L'), String.valueOf('C'), String.valueOf('G'), String.valueOf('X'), String.valueOf('0'), String.valueOf('M'), String.valueOf('R'), String.valueOf('W'), String.valueOf('Y')};
    private static final String[] OD_LANGUAGES = new String[]{"CZE", "DAN", "DEU", "ELL", "ENU", "ESP", "FIN", "FRA", "HRV", "HUN", "ITA", "NLD", "NOR", "PLK", "PTB", "RUS", "SKY", "SLO", "SVE", "KOR", "CHT", "CHS", "JPN"};
    private static final String[] OD_MONTH_ABBREVS = new String[]{"led", "\u00fano", "b\u0159e", "dub", "kv\u011b", "\u010dvn", "\u010dvc", "srp", "z\u00e1\u0159", "\u0159\u00edj", "lis", "pro", "Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dec", "Jan", "Feb", "Mrz", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez", "\u0399\u03b1\u03bd", "\u03a6\u03b5\u03b2", "\u039c\u03b1\u03c1", "\u0391\u03c0\u03c1", "\u039c\u03b1\u03ca", "\u0399\u03bf\u03c5\u03bd", "\u0399\u03bf\u03c5\u03bb", "\u0391\u03c5\u03b3", "\u03a3\u03b5\u03c0", "\u039f\u03ba\u03c4", "\u039d\u03bf\u03b5", "\u0394\u03b5\u03ba", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Ene", "Feb", "Mar", "Abr", "Mayo", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic", "Tam", "Hel", "Maa", "Huh", "Toukokuu", "Kes", "Hei", "Elo", "Syy", "Lok", "Mar", "Jou", "Jan", "F\u00e9v", "Mar", "Avr", "Mai", "Jun", "Jul", "Ao\u00fb", "Sep", "Oct", "Nov", "D\u00e9c", "Sij", "Vel", "O\u017eu", "Tra", "Svibanj", "Lip", "Srp", "Kol", "Ruj", "Lis", "Stu", "Pro", "Jan", "Febr", "M\u00e1rc", "\u00c1pr", "M\u00e1jus", "J\u00fan", "J\u00fal", "Aug", "Szept", "Okt", "Nov", "Dec", "Gen", "Feb", "Mar", "Apr", "Maggio", "Giu", "Lug", "Ago", "Set", "Ott", "Nov", "Dic", "jan", "feb", "mrt", "apr", "mei", "jun", "jul", "aug", "sep", "okt", "nov", "dec", "jan", "feb", "mar", "apr", "mai", "jun", "jul", "aug", "sep", "okt", "nov", "des", "sty", "lut", "mar", "kwi", "maj", "cze", "lip", "sie", "wrz", "pa\u017a", "lis", "gru", "Jan", "Fev", "Mar", "Abr", "Maio", "Jun", "Jul", "Ago", "Set", "Out", "Nov", "Dez", "\u044f\u043d\u0432", "\u0444\u0435\u0432", "\u043c\u0430\u0440", "\u0430\u043f\u0440", "\u043c\u0430\u0439", "\u0438\u044e\u043d", "\u0438\u044e\u043b", "\u0430\u0432\u0433", "\u0441\u0435\u043d", "\u043e\u043a\u0442", "\u043d\u043e\u044f", "\u0434\u0435\u043a", "Jan", "Feb", "Mar", "Apr", "M\u00e1j", "J\u00fan", "J\u00fal", "Aug", "Sep", "Okt", "Nov", "Dec", "Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Avg", "Sep", "Okt", "Nov", "Dec", "jan", "feb", "mar", "apr", "maj", "jun", "jul", "aug", "sep", "okt", "nov", "dec", "1\uc6d4", "2\uc6d4", "3\uc6d4", "4\uc6d4", "5\uc6d4", "6\uc6d4", "7\uc6d4", "8\uc6d4", "9\uc6d4", "10\uc6d4", "11\uc6d4", "12\uc6d4", "\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708", "1 \u6708", "2 \u6708", "3 \u6708", "4 \u6708", "5 \u6708", "6 \u6708", "7 \u6708", "8 \u6708", "9 \u6708", "10 \u6708", "11 \u6708", "12 \u6708", "Jan", "Feb", "Mar", "Apr", "5", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] OD_MONTH_STRINGS = new String[]{"leden", "\u00fanor", "b\u0159ezen", "duben", "kv\u011b", "\u010derven", "\u010dervenec", "srpen", "z\u00e1\u0159\u00ed", "\u0159\u00edjen", "listopad", "prosinec", "Januar", "Februar", "Marts", "April", "Maj", "Juni", "Juli", "August", "September", "Oktober", "November", "December", "Januar", "Februar", "M\u00e4rz", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember", "\u0399\u03b1\u03bd\u03bf\u03c5\u03b1\u03c1\u03af\u03bf\u03c5", "\u03a6\u03b5\u03b2\u03c1\u03bf\u03c5\u03b1\u03c1\u03af\u03bf\u03c5", "\u039c\u03b1\u03c1\u03c4\u03af\u03bf\u03c5", "\u0391\u03c0\u03c1\u03b9\u03bb\u03af\u03bf\u03c5", "\u039c\u03b1\u0390\u03bf\u03c5", "\u0399\u03bf\u03c5\u03bd\u03af\u03bf\u03c5", "\u0399\u03bf\u03c5\u03bb\u03af\u03bf\u03c5", "\u0391\u03c5\u03b3\u03bf\u03cd\u03c3\u03c4\u03bf\u03c5", "\u03a3\u03b5\u03c0\u03c4\u03b5\u03bc\u03b2\u03c1\u03af\u03bf\u03c5", "\u039f\u03ba\u03c4\u03c9\u03b2\u03c1\u03af\u03bf\u03c5", "\u039d\u03bf\u03b5\u03bc\u03b2\u03c1\u03af\u03bf\u03c5", "\u0394\u03b5\u03ba\u03b5\u03bc\u03b2\u03c1\u03af\u03bf\u03c5", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", "Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre", "Tammikuu", "Helmikuu", "Maaliskuu", "Huhtikuu", "Toukokuu", "Kes\u00e4kuu", "Hein\u00e4kuu", "Elokuu", "Syyskuu", "Lokakuu", "Marraskuu", "Joulukuu", "Janvier", "F\u00e9vrier", "Mars", "Avril", "Mai", "Juin", "Juillet", "Ao\u00fbt", "Septembre", "Octobre", "Novembre", "D\u00e9cembre", "Sije\u010danj", "Velja\u010da", "O\u017eujak", "Travanj", "Svibanj", "Lipanj", "Srpanj", "Kolovoz", "Rujan", "Listopad", "Studeni", "Prosinac", "Janu\u00e1r", "Febru\u00e1r", "M\u00e1rcius", "\u00c1prilis", "M\u00e1jus", "J\u00fanius", "J\u00falius", "Augusztus", "Szeptember", "Okt\u00f3ber", "November", "December", "Gennaio", "Febbraio", "Marzo", "Aprile", "Maggio", "Giugno", "Luglio", "Agosto", "Settembre", "Ottobre", "Novembre", "Dicembre", "januari", "februari", "maart", "april", "mei", "juni", "juli", "augustus", "september", "oktober", "november", "december", "januar", "februar", "mars", "april", "mai", "juni", "juli", "august", "september", "oktober", "november", "desember", "stycze\u0144", "luty", "marzec", "kwiecie\u0144", "maj", "czerwiec", "lipiec", "sierpie\u0144", "wrzesie\u0144", "pa\u017adziernik", "listopad", "grudzie\u0144", "Janeiro", "Fevereiro", "Mar\u00e7o", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro", "\u044f\u043d\u0432\u0430\u0440\u044c", "\u0444\u0435\u0432\u0440\u0430\u043b\u044c", "\u043c\u0430\u0440\u0442", "\u0430\u043f\u0440\u0435\u043b\u044c", "\u043c\u0430\u0439", "\u0438\u044e\u043d\u044c", "\u0438\u044e\u043b\u044c", "\u0430\u0432\u0433\u0443\u0441\u0442", "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044c", "\u043e\u043a\u0442\u044f\u0431\u0440\u044c", "\u043d\u043e\u044f\u0431\u0440\u044c", "\u0434\u0435\u043a\u0430\u0431\u0440\u044c", "Janu\u00e1r", "Febru\u00e1r", "Marec", "Apr\u00edl", "M\u00e1j", "J\u00fan", "J\u00fal", "August", "September", "Okt\u00f3ber", "November", "December", "Januar", "Februar", "Marec", "April", "Maj", "Junij", "Julij", "Avgust", "September", "Oktober", "November", "December", "januari", "februari", "mars", "april", "maj", "juni", "juli", "augusti", "september", "oktober", "november", "december", "1\uc6d4", "2\uc6d4", "3\uc6d4", "4\uc6d4", "5\uc6d4", "6\uc6d4", "7\uc6d4", "8\uc6d4", "9\uc6d4", "10\uc6d4", "11\uc6d4", "12\uc6d4", "\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708", "1 \u6708", "2 \u6708", "3 \u6708", "4 \u6708", "5 \u6708", "6 \u6708", "7 \u6708", "8 \u6708", "9 \u6708", "10 \u6708", "11 \u6708", "12 \u6708", "1 \u6708", "2 \u6708", "3 \u6708", "4 \u6708", "5 \u6708", "6 \u6708", "7 \u6708", "8 \u6708", "9 \u6708", "10 \u6708", "11 \u6708", "12 \u6708"};

    public static String[] getDefaultValues(ODCriteria criteria) {
        String OD_WILDCARD = "%";
        String FORM_WILDCARD = "*";
        String[] values = criteria.getSearchValues();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || values[i].indexOf(37) < 0) continue;
            values[i] = values[i].replaceAll("[%]", "*");
        }
        return values;
    }

    public static Vector getItemsFromJson(String jsonString) {
        String methodName = "getItemsFromJson";
        Vector<String> items = null;
        try {
            JSONArray jsonArray = JSONArray.parse(jsonString);
            items = new Vector<String>(jsonArray.size());
            for (int i = 0; i < jsonArray.size(); ++i) {
                String value = jsonArray.get(i).toString();
                items.add(value);
            }
        }
        catch (IOException e) {
            Logger.logError(ODUtil.class, methodName, (ServletRequest)((HttpServletRequest)null), (Throwable)e);
        }
        return items;
    }

    public static String getSelectedOperator(ODCriteria criteria) {
        return ODUtil.getOperand(criteria.getOperator());
    }

    public static String[] getDefinedOperators(ODCriteria criteria, MessageResources resources, Locale locale) {
        ArrayList<String> definedOperators = new ArrayList<String>();
        int[] operators = criteria.getValidOperators();
        for (int i = 0; i < operators.length; ++i) {
            if (!criteria.isDefaultValueFixed()) {
                definedOperators.add(ODUtil.getOperand(operators[i]));
                continue;
            }
            if (criteria.getOperator() == 1024 || criteria.getOperator() == 2048) {
                definedOperators.add(ODUtil.getOperand(operators[i]));
                continue;
            }
            if (operators[i] == 1024 || operators[i] == 2048) continue;
            definedOperators.add(ODUtil.getOperand(operators[i]));
        }
        String[] validOperators = new String[definedOperators.size()];
        definedOperators.toArray(validOperators);
        return validOperators;
    }

    public static String[] getValidValues(ODCriteria criteria, MessageResources messageResources, Locale locale) {
        ArrayList searchValues = new ArrayList();
        Object aSearchValue = null;
        switch (criteria.getType()) {
            case 'C': 
            case 'S': {
                String[] fixedValues = criteria.getFixedValues();
                LinkedHashSet<String> set = new LinkedHashSet<String>();
                for (int i = 0; i < fixedValues.length; ++i) {
                    String value = fixedValues[i];
                    if (set.contains(value)) continue;
                    set.add(value);
                }
                searchValues.addAll(set);
                break;
            }
            case 'Z': {
                String[] colors = new String[]{String.valueOf('D'), String.valueOf('N'), String.valueOf('B'), String.valueOf('L'), String.valueOf('C'), String.valueOf('G'), String.valueOf('X'), String.valueOf('0'), String.valueOf('M'), String.valueOf('R'), String.valueOf('W'), String.valueOf('Y')};
                for (String color : COLORS) {
                    searchValues.add(messageResources.getMessage(locale, "color_" + String.valueOf(color)));
                }
                break;
            }
        }
        ODStringValuesSorter sorter = new ODStringValuesSorter(true);
        Collections.sort(searchValues, sorter);
        return searchValues.toArray(new String[searchValues.size()]);
    }

    public static String getCriteriaType(ODCriteria criteria, String criteriaFormat) {
        char type = criteria.getType();
        char subType = criteria.getSubType();
        char displayFmtQualifier = criteria.getDisplayFmtQual();
        char fieldQualifier = criteria.getFieldQualifier();
        String returnType = null;
        switch (subType) {
            case 'D': {
                returnType = "xs:decimal";
                break;
            }
            case '8': 
            case '9': {
                returnType = "xs:double";
                break;
            }
            case 'I': {
                returnType = "xs:integer";
                break;
            }
            case 'N': {
                returnType = "xs:short";
                break;
            }
            case 'B': {
                returnType = "xs:long";
                break;
            }
            case '`': {
                returnType = "xs:highlight";
                break;
            }
            case 'Y': {
                returnType = "xs:summary";
                break;
            }
            default: {
                returnType = "xs:string";
            }
        }
        switch (fieldQualifier) {
            case 'D': {
                if (criteriaFormat.equalsIgnoreCase("%Y")) {
                    returnType = "xs:short";
                    break;
                }
                returnType = "xs:date";
                break;
            }
            case 'T': {
                returnType = "xs:time";
                break;
            }
            case 'C': {
                returnType = "xs:timestamp";
                break;
            }
            case 'Z': {
                returnType = "xs:timestamp";
            }
        }
        return returnType;
    }

    public static String getOperand(int operand) {
        String returnString = null;
        switch (operand) {
            case 2: {
                returnString = "NOTEQUAL";
                break;
            }
            case 4: {
                returnString = "LESS";
                break;
            }
            case 8: {
                returnString = "LESSOREQUAL";
                break;
            }
            case 16: {
                returnString = "GREATER";
                break;
            }
            case 32: {
                returnString = "GREATEROREQUAL";
                break;
            }
            case 64: {
                returnString = "IN";
                break;
            }
            case 128: {
                returnString = "NOTIN";
                break;
            }
            case 256: {
                returnString = "LIKE";
                break;
            }
            case 512: {
                returnString = "NOTLIKE";
                break;
            }
            case 1024: {
                returnString = "BETWEEN";
                break;
            }
            case 2048: {
                returnString = "NOTBETWEEN";
                break;
            }
            default: {
                returnString = "EQUAL";
            }
        }
        return returnString;
    }

    public static int getOperand(String operand) {
        int returnInt = 1;
        if (operand == null) {
            return returnInt;
        }
        if (operand.equalsIgnoreCase("Not Equal") || operand.equals("NOTEQUAL")) {
            returnInt = 2;
        } else if (operand.equalsIgnoreCase("Less Than") || operand.equals("LESS")) {
            returnInt = 4;
        } else if (operand.equalsIgnoreCase("Less Than Or Equal") || operand.equals("LESSOREQUAL")) {
            returnInt = 8;
        } else if (operand.equalsIgnoreCase("Greater Than") || operand.equals("GREATER")) {
            returnInt = 16;
        } else if (operand.equalsIgnoreCase("Greater Than Or Equal") || operand.equals("GREATEROREQUAL")) {
            returnInt = 32;
        } else if (operand.equalsIgnoreCase("In") || operand.equals("IN")) {
            returnInt = 64;
        } else if (operand.equalsIgnoreCase("Not In") || operand.equals("NOTIN")) {
            returnInt = 128;
        } else if (operand.equalsIgnoreCase("Like") || operand.equals("LIKE")) {
            returnInt = 256;
        } else if (operand.equalsIgnoreCase("Not Like") || operand.equals("NOTLIKE")) {
            returnInt = 512;
        } else if (operand.equalsIgnoreCase("Between") || operand.equals("BETWEEN")) {
            returnInt = 1024;
        } else if (operand.equalsIgnoreCase("Not Between") || operand.equals("NOTBETWEEN")) {
            returnInt = 2048;
        } else if (operand.equalsIgnoreCase("Equals") || operand.equals("EQUAL")) {
            returnInt = 1;
        }
        return returnInt;
    }

    public static String getSimpleDateFormat(String odDateFormat) {
        String simpleDateFormat = odDateFormat;
        simpleDateFormat = simpleDateFormat.replaceAll("%y", "yy");
        simpleDateFormat = simpleDateFormat.replaceAll("%Y", "yyyy");
        simpleDateFormat = simpleDateFormat.replaceAll("%m", "MM");
        simpleDateFormat = simpleDateFormat.replaceAll("%f", "M");
        simpleDateFormat = simpleDateFormat.replaceAll("%b", "MMM");
        simpleDateFormat = simpleDateFormat.replaceAll("%B", "MMMM");
        simpleDateFormat = simpleDateFormat.replaceAll("%d", "dd");
        simpleDateFormat = simpleDateFormat.replaceAll("%e", "d");
        simpleDateFormat = simpleDateFormat.replaceAll("%j", "DDD");
        simpleDateFormat = simpleDateFormat.replaceAll("%x", "MM/dd/yy");
        simpleDateFormat = simpleDateFormat.replaceAll("%H", "HH");
        simpleDateFormat = simpleDateFormat.replaceAll("%M", "mm");
        simpleDateFormat = simpleDateFormat.replaceAll("%S", "ss");
        simpleDateFormat = simpleDateFormat.replaceAll("%T", "HH:mm:ss");
        simpleDateFormat = simpleDateFormat.replaceAll("\"", "'");
        return simpleDateFormat;
    }

    public static String getISODateString(HttpServletRequest request, String odDateString, String odFormat, boolean timeZoneAdjust) {
        String isoDateString;
        block10: {
            String methodName = "getISODateString";
            isoDateString = "";
            SimpleDateFormat odDateFormatter = new SimpleDateFormat(ODUtil.getSimpleDateFormat(odFormat));
            try {
                if (odDateFormatter.toPattern().indexOf(" HH:mm:ss") > -1 && !odDateString.matches("\\d\\d:\\d\\d:\\d\\d")) {
                    String[] today = new Date().toString().split(" ");
                    for (int i = 0; i < today.length; ++i) {
                        if (!today[i].matches("\\d\\d:\\d\\d:\\d\\d")) continue;
                        odDateString = odDateString + " " + today[i];
                        break;
                    }
                }
                Date date = odDateFormatter.parse(odDateString.trim());
                isoDateString = DateUtil.getISODateString(date, timeZoneAdjust);
            }
            catch (ParseException e) {
                Date date;
                String javaMonth;
                String[] months;
                DateFormatSymbols symbols;
                int index;
                int i;
                for (i = 0; i < OD_MONTH_STRINGS.length; ++i) {
                    index = odDateString.indexOf(OD_MONTH_STRINGS[i]);
                    if ((index <= 0 || odDateString.charAt(index - 1) != ' ') && (index != 0 || odDateString.charAt(OD_MONTH_STRINGS[i].length()) != ' ')) continue;
                    symbols = odDateFormatter.getDateFormatSymbols();
                    months = symbols.getMonths();
                    javaMonth = months[i % 12];
                    odDateString = odDateString.replace(OD_MONTH_STRINGS[i], javaMonth);
                    try {
                        date = odDateFormatter.parse(odDateString.trim());
                        isoDateString = DateUtil.getISODateString(date, timeZoneAdjust);
                    }
                    catch (ParseException e2) {}
                    break;
                }
                if (isoDateString.length() != 0) break block10;
                for (i = 0; i < OD_MONTH_ABBREVS.length; ++i) {
                    index = odDateString.indexOf(OD_MONTH_ABBREVS[i]);
                    if (index <= 0 && (index != 0 || odDateString.charAt(OD_MONTH_ABBREVS[i].length()) != ' ')) continue;
                    symbols = odDateFormatter.getDateFormatSymbols();
                    months = symbols.getShortMonths();
                    javaMonth = months[i % 12];
                    odDateString = odDateString.replace(OD_MONTH_ABBREVS[i], javaMonth);
                    try {
                        date = odDateFormatter.parse(odDateString.trim());
                        isoDateString = DateUtil.getISODateString(date, timeZoneAdjust);
                    }
                    catch (ParseException e2) {}
                    break;
                }
            }
        }
        return isoDateString;
    }

    public static DateFormatSymbols getDateFormatSymbols(String language) {
        int start;
        Locale odLocale = Util.getLanguageLocale(language);
        DateFormatSymbols symbols = new DateFormatSymbols(odLocale);
        String[] shortMonths = symbols.getShortMonths();
        String[] months = symbols.getMonths();
        int index = -1;
        for (int i = 0; i < OD_LANGUAGES.length; ++i) {
            if (!OD_LANGUAGES[i].equals(language)) continue;
            index = i;
        }
        if (index > -1 && OD_MONTH_ABBREVS.length >= (start = index * 12) + 12 && OD_MONTH_STRINGS.length >= start + 12) {
            for (int i = 0; i < 12; ++i) {
                shortMonths[i] = OD_MONTH_ABBREVS[start + i];
                months[i] = OD_MONTH_STRINGS[start + i];
            }
        }
        symbols.setShortMonths(shortMonths);
        symbols.setMonths(months);
        return symbols;
    }

    public static String getODDateString(HttpServletRequest request, String isoDateString, String odFormat, boolean timeZoneAdjust) {
        String methodName = "getODDateString";
        String odDateString = "";
        try {
            Date date = DateUtil.parseISODate(isoDateString, timeZoneAdjust);
            SimpleDateFormat odDateFormatter = new SimpleDateFormat(ODUtil.getSimpleDateFormat(odFormat));
            odDateString = odDateFormatter.format(date);
        }
        catch (Exception e) {
            Logger.logError(ODUtil.class, "getODDateString", (ServletRequest)request, (Throwable)e);
        }
        return isoDateString;
    }

    public static boolean hasHoldPriv(HttpServletRequest request, ODServer server) {
        ODUser user;
        String methodName = "hasHoldPriv";
        try {
            user = server.getUser();
        }
        catch (Exception e) {
            Logger.logError(ODUtil.class, methodName, (ServletRequest)request, (Throwable)e);
            return false;
        }
        return (user.getAuthority() & 0xC08L) != 0L;
    }

    public static String getJSONValueString(HttpServletRequest request, String value, ODCriteria criteria, boolean isSearchResults) {
        String returnValue = value;
        try {
            char subType = criteria.getSubType();
            char fieldQualifier = criteria.getFieldQualifier();
            switch (subType) {
                case 'D': {
                    returnValue = value;
                    break;
                }
                case '8': 
                case '9': {
                    if (value.indexOf("e") > -1 || value.indexOf("E") > -1) {
                        returnValue = Double.toString(NumberFormat.getNumberInstance().parse(value).doubleValue());
                        break;
                    }
                    returnValue = value;
                    break;
                }
                case 'I': {
                    returnValue = value;
                    break;
                }
                case 'N': {
                    returnValue = value;
                    break;
                }
                case 'B': {
                    returnValue = value;
                    break;
                }
                default: {
                    returnValue = value;
                }
            }
            switch (fieldQualifier) {
                case 'C': 
                case 'D': 
                case 'T': {
                    String criteriaFormat = isSearchResults ? criteria.getDisplayFmt() : criteria.getDefaultFmt();
                    returnValue = ODUtil.getISODateString(request, value, criteriaFormat, false);
                    break;
                }
                case 'Z': {
                    String criteriaFormat = isSearchResults ? criteria.getDisplayFmt() : criteria.getDefaultFmt();
                    returnValue = ODUtil.getISODateString(request, value, criteriaFormat, true);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (returnValue != null && returnValue.startsWith("NaN")) {
            returnValue = "";
        }
        return returnValue;
    }

    public static String getMax(ODCriteria criteria) {
        char subType = criteria.getSubType();
        String returnValue = "";
        switch (subType) {
            case 'D': {
                returnValue = "999999999999.99999";
                break;
            }
            case '8': 
            case '9': {
                returnValue = new Double(Double.MAX_VALUE).toString();
                break;
            }
            case 'B': 
            case 'I': {
                returnValue = "2147483647";
                break;
            }
            case 'N': {
                returnValue = "32767";
                break;
            }
        }
        return returnValue;
    }

    public static String getMin(ODCriteria criteria) {
        char subType = criteria.getSubType();
        String returnValue = "";
        switch (subType) {
            case 'D': {
                returnValue = "-999999999999.99999";
                break;
            }
            case '8': 
            case '9': {
                returnValue = new Double(-1.7976931348623157E308).toString();
                break;
            }
            case 'B': 
            case 'I': {
                returnValue = "-2147483648";
                break;
            }
            case 'N': {
                returnValue = "-32768";
                break;
            }
            default: {
                returnValue = "";
            }
        }
        return returnValue;
    }

    public static Method getMethodFromClass(String className, String methodName) {
        try {
            Method[] allMethods;
            Class<?> c = Class.forName(className);
            for (Method m : allMethods = c.getDeclaredMethods()) {
                if (!m.getName().equals(methodName)) continue;
                return m;
            }
        }
        catch (ClassNotFoundException ce) {
            ce.printStackTrace();
        }
        return null;
    }
}

