/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.od;

import com.ibm.ecm.serviceability.Logger;
import com.ibm.edms.od.ODException;
import com.ibm.edms.od.ODServer;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public class ODSessionListener
implements HttpSessionBindingListener {
    public void valueBound(HttpSessionBindingEvent event) {
        String methodName = "valueBound";
        HttpSession session = event.getSession();
        Logger.logEntry((Object)this, "valueBound", session);
        Logger.logDebug((Object)this, "valueBound", event.getSession(), "Session" + event.getSession() + "    maxInactiveInterval=" + event.getSession().getMaxInactiveInterval());
        Logger.logExit((Object)this, "valueBound", session);
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        String methodName = "valueUnbound";
        HttpSession session = event.getSession();
        Logger.logEntry((Object)this, "valueUnbound", session);
        Hashtable servers = null;
        ODServer theServer = null;
        try {
            if (session != null && (servers = (Hashtable)session.getAttribute("od_servers")) != null) {
                if (servers.keySet() == null) {
                    return;
                }
                Enumeration eLoop = servers.keys();
                while (eLoop.hasMoreElements()) {
                    String serverName = (String)eLoop.nextElement();
                    theServer = (ODServer)servers.get(serverName);
                    if (theServer == null || !theServer.isInitialized()) continue;
                    Logger.logInfo((Object)this, "valueUnbound", session, "invalidate " + serverName + " for " + Logger.getFormattedUser(theServer.getUserId(), null));
                    try {
                        theServer.cancel();
                        theServer.logoff();
                        theServer.terminate();
                    }
                    catch (ODException e) {
                        Logger.logError((Object)this, "valueUnbound", session, (Throwable)e);
                    }
                }
            }
        }
        catch (ODException ode) {
            Logger.logError((Object)this, "valueUnbound", session, (Throwable)ode);
        }
        catch (Exception e) {
            Logger.logError((Object)this, "valueUnbound", session, (Throwable)e);
        }
        session.removeAttribute("od_servers");
        Logger.logExit((Object)this, "valueUnbound", session);
    }
}

