/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.od;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.extension.PluginServiceUtil;
import com.ibm.ecm.mediator.od.ODAnnotationMediator;
import com.ibm.ecm.mediator.od.ODAnnotationsMediator;
import com.ibm.ecm.mediator.od.ODSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.DocumentContent;
import com.ibm.ecm.util.MimeTypeUtil;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.od.ODSearchResultsBean;
import com.ibm.ecm.util.p8.P8ContentUtil;
import com.ibm.edms.od.ODConstant;
import com.ibm.edms.od.ODException;
import com.ibm.edms.od.ODFolder;
import com.ibm.edms.od.ODHit;
import com.ibm.edms.od.ODNote;
import com.ibm.edms.od.ODServer;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class ODContentUtil {
    public static Object getSynchObject(HttpServletRequest request, String repositoryId) {
        return PluginServiceUtil.getODServer(request, repositoryId);
    }

    public static ODHit retrieveDocument(HttpServletRequest request, String repositoryId, String documentId, String templateName) throws Exception {
        String methodName = "retrieveDocument";
        Logger.logEntry(ODContentUtil.class, methodName, (ServletRequest)request);
        ODHit hit = null;
        ODServer server = PluginServiceUtil.getODServer(request, repositoryId);
        if (server != null) {
            Object tempFile = null;
            ODFolder folder = ODContentUtil.openODFolder(request, server, templateName);
            Logger.logDebug(ODContentUtil.class, methodName, (ServletRequest)request, "Opened folder: " + templateName);
            hit = folder.recreateHit(documentId);
            Logger.logDebug(ODContentUtil.class, methodName, (ServletRequest)request, "Recreated hit. " + templateName);
        }
        Logger.logExit(ODContentUtil.class, methodName, (ServletRequest)request);
        return hit;
    }

    public static DocumentContent retrieveContent(HttpServletRequest request, String repositoryId, String documentId, String templateName, int segmentNum, boolean asciiTransform) throws Exception {
        long approxDocLength;
        int nSegments;
        long maxInMemoryRetrieveLength;
        String fileExtension;
        String methodName = "retrieveContent";
        Logger.logEntry(ODContentUtil.class, methodName, (ServletRequest)request);
        ODDocumentContent documentContent = null;
        String transform = asciiTransform ? ODConstant.ASCII : ODConstant.NATIVE;
        File tempFile = null;
        ODHit hit = ODContentUtil.retrieveDocument(request, repositoryId, documentId, templateName);
        String mimetype = MimeTypeUtil.getMimeTypeForOD(hit.getMimeType());
        if (mimetype == null || mimetype.equals("application/unknown")) {
            String extension = hit.getFileExt();
            mimetype = MimeTypeUtil.getMimeType(extension);
        }
        if ((fileExtension = hit.getFileExt()) == null || fileExtension.equals("")) {
            fileExtension = MimeTypeUtil.getExtFromMimeType(mimetype);
        }
        String fileName = Util.getValidFileName(hit.getDocumentName() + "." + fileExtension);
        long maxDocLength = ODContentUtil.getMaxDownloadSizeProperty(repositoryId, null);
        if (maxDocLength == 0L) {
            maxDocLength = 0x7FFFFFF3L;
        }
        if ((maxInMemoryRetrieveLength = ODContentUtil.getMaxInMemoryRetrieveSizeProperty(repositoryId, null)) == 0L) {
            maxInMemoryRetrieveLength = 0x100000L;
        }
        long firstSegmentLength = hit.getProperties().getLength();
        byte[] tempData = null;
        if (firstSegmentLength <= maxDocLength) {
            if (firstSegmentLength > maxInMemoryRetrieveLength) {
                tempFile = File.createTempFile("ContentNavigator", ".dat");
                hit.retrieve(transform, tempFile.getCanonicalPath());
            } else {
                tempData = hit.retrieve(transform);
                firstSegmentLength = tempData.length;
            }
        }
        if ((nSegments = hit.getNumSegments()) == 0) {
            nSegments = 1;
        }
        if ((approxDocLength = firstSegmentLength * (long)nSegments) <= maxDocLength) {
            ODInputStream ois = new ODInputStream(hit, segmentNum, nSegments, tempFile, tempData, maxInMemoryRetrieveLength, transform);
            documentContent = new ODDocumentContent(ois, hit, mimetype, fileName);
        }
        Logger.logExit(ODContentUtil.class, methodName, (ServletRequest)request);
        return documentContent;
    }

    public static Vector[] retrieveNativeAnnotations(HttpServletRequest request, String repositoryId, String documentId, String templateName) throws Exception {
        ODAnnotationRetriever odar = new ODAnnotationRetriever(request, repositoryId);
        return odar.retrieveNativeAnnotations(request, repositoryId, documentId, templateName);
    }

    public static ODAnnotationsMediator retrieveAnnotations(HttpServletRequest request, MessageResources resources, String repositoryId, String documentId, String templateName) {
        ODAnnotationRetriever odar = new ODAnnotationRetriever(request, repositoryId);
        return odar.retrieveAnnotations(request, resources, repositoryId, documentId, templateName);
    }

    public static ODAnnotationMediator addNote(HttpServletRequest request, MessageResources resources, String repositoryId, String documentId, String templateName, String noteGroupName, String noteText, boolean noteIsOKToCopy, boolean noteIsPublic) {
        ODAnnotationRetriever odar = new ODAnnotationRetriever(request, repositoryId);
        return odar.addNote(request, resources, repositoryId, documentId, templateName, noteGroupName, noteText, noteIsOKToCopy, noteIsPublic);
    }

    public static ODFolder openODFolder(HttpServletRequest request, ODServer server, String folderName) throws ODException, Exception {
        String methodName = "openFolder";
        Logger.logDebug(PluginServiceUtil.class, methodName, (ServletRequest)request, "ENTER parms => repositoryId: " + server.getServerName() + " , folderName: " + folderName);
        ODFolder folder = null;
        try {
            Logger.logDebug(PluginServiceUtil.class, methodName, (ServletRequest)request, "attempting to openFolder");
            folder = server.openFolder(folderName);
        }
        catch (Exception e) {
            Logger.logWarning(PluginServiceUtil.class, methodName, (ServletRequest)request, "attempting to openFolder failed, calling getFolders first");
            server.getFolders(folderName);
            folder = server.openFolder(folderName);
        }
        return folder;
    }

    public static long getMaxInMemoryRetrieveSizeProperty(String repositoryId, RepositoryConfig repositoryConfig) {
        String methodName = "getMaxInMemoryRetrieveSizeProperty";
        long maxInMemoryRetrieveSize = 0x100000L;
        try {
            if (repositoryConfig == null) {
                repositoryConfig = Config.getRepositoryConfig("navigator", repositoryId);
            }
            if (repositoryConfig != null) {
                maxInMemoryRetrieveSize = repositoryConfig.getMaxInMemoryRetrieveSize();
            }
        }
        catch (Exception e) {
            Logger.logError(PluginServiceUtil.class, methodName, e.getMessage(), (Throwable)e);
        }
        return maxInMemoryRetrieveSize;
    }

    public static long getMaxDownloadSizeProperty(String repositoryId, RepositoryConfig repositoryConfig) {
        String methodName = "getMaxDownloadSizeProperty";
        long maxDownloadSize = 0x7FFFFFF3L;
        try {
            if (repositoryConfig == null) {
                repositoryConfig = Config.getRepositoryConfig("navigator", repositoryId);
            }
            if (repositoryConfig != null) {
                maxDownloadSize = repositoryConfig.getMaxDownloadSize();
            }
        }
        catch (Exception e) {
            Logger.logError(PluginServiceUtil.class, methodName, e.getMessage(), (Throwable)e);
        }
        return maxDownloadSize;
    }

    private static class ODInputStream
    extends InputStream {
        byte[] inputBuffer;
        int inputBufferPos;
        boolean endReached = false;
        ODHit hit;
        int segmentNum;
        int nSegments;
        File tempFile;
        long maxInMemoryRetrieveLength;
        String transform;
        byte[] tempData;
        int startSegment;
        int endSegment;
        int segment;
        long contentLength = 0L;

        public ODInputStream(ODHit hit, int segmentNum, int nSegments, File tempFile, byte[] tempData, long maxInMemoryRetrieveLength, String transform) throws Exception {
            this.hit = hit;
            this.segmentNum = segmentNum;
            this.tempData = tempData;
            this.tempFile = tempFile;
            this.nSegments = nSegments;
            this.maxInMemoryRetrieveLength = maxInMemoryRetrieveLength;
            this.transform = transform;
            if (segmentNum >= 0) {
                this.startSegment = segmentNum;
                this.endSegment = segmentNum;
            } else {
                this.startSegment = 0;
                this.endSegment = nSegments - 1;
            }
            this.segment = -1;
            this.loadNextBuffer();
        }

        public int read() throws IOException {
            int data = -1;
            boolean loaded = true;
            if (this.inputBufferPos >= this.inputBuffer.length) {
                try {
                    loaded = this.loadNextBuffer();
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            if (loaded && this.inputBufferPos < this.inputBuffer.length) {
                data = this.inputBuffer[this.inputBufferPos++] & 0xFF;
            }
            return data;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int remaining;
            boolean loaded = true;
            int nRead = -1;
            if (this.inputBufferPos >= this.inputBuffer.length) {
                try {
                    loaded = this.loadNextBuffer();
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            if (loaded && (remaining = this.inputBuffer.length - this.inputBufferPos) > 0) {
                nRead = remaining < len ? remaining : len;
                for (int n = 0; n < nRead; ++n) {
                    b[off + n] = this.inputBuffer[this.inputBufferPos++];
                }
            }
            return nRead;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        private boolean loadNextBuffer() throws Exception {
            boolean segmentLoaded = false;
            int n = this.segment = this.segment == -1 ? this.startSegment : (this.segment = this.segment + 1);
            if (this.segment <= this.endSegment) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                if (this.tempFile != null) {
                    if (this.segment > 0) {
                        this.tempFile = File.createTempFile("ContentNavigator", ".dat");
                        this.hit.retrieveSegment(this.segment, this.tempFile.getCanonicalPath());
                    }
                    if (this.startSegment == this.endSegment & this.hit.getResourceID() == null) {
                        this.contentLength = this.tempFile.length();
                    }
                    BufferedInputStream tempFileInputStream = new BufferedInputStream(new FileInputStream(this.tempFile));
                    byte[] buffer = new byte[(int)this.maxInMemoryRetrieveLength];
                    int readLen = ((InputStream)tempFileInputStream).read(buffer);
                    while (readLen > 0) {
                        os.write(buffer, 0, readLen);
                        readLen = ((InputStream)tempFileInputStream).read(buffer);
                    }
                    if (this.transform.equals(ODConstant.ASCII) && this.segment != this.endSegment) {
                        os.write(12);
                    }
                    ((InputStream)tempFileInputStream).close();
                    this.tempFile.delete();
                } else {
                    if (this.segment > 0) {
                        this.tempData = this.hit.retrieveSegment(this.segment);
                    }
                    if (this.startSegment == this.endSegment && this.hit.getResourceID() == null) {
                        this.contentLength = this.tempData.length;
                    }
                    os.write(this.tempData);
                    if (this.transform.equals(ODConstant.ASCII) && this.segment != this.endSegment) {
                        os.write(12);
                    }
                }
                this.inputBuffer = os.toByteArray();
                this.inputBufferPos = 0;
                segmentLoaded = true;
            } else {
                try {
                    if (this.hit.getResourceID() != null) {
                        this.inputBuffer = this.hit.getResources();
                        if (this.inputBuffer != null) {
                            this.inputBufferPos = 0;
                            segmentLoaded = true;
                        }
                    }
                }
                catch (ODException oDException) {
                    // empty catch block
                }
            }
            return segmentLoaded;
        }
    }

    private static class ODDocumentContent
    extends DocumentContent {
        private ODInputStream odInputStream = null;
        private ODHit odHit = null;

        private ODDocumentContent(ODInputStream ois, ODHit hit, String mimeType, String fileName) {
            this.odInputStream = ois;
            this.odHit = hit;
            this.type = mimeType;
            this.size = ois.getContentLength();
            this.name = fileName;
        }

        public InputStream getInputStream() throws Exception {
            return this.odInputStream;
        }

        public int getNumSegments() {
            return this.odHit != null ? this.odHit.getNumSegments() : -1;
        }

        public int getNumPagesInSegment() {
            return this.odHit != null ? this.odHit.getNumPagesInSegment() : -1;
        }

        public int getNumPagesInLastSegment() {
            return this.odHit != null ? this.odHit.getNumPagesInLastSegment() : -1;
        }
    }

    private static class ODAnnotationRetriever {
        ODServer server;

        ODAnnotationRetriever(HttpServletRequest request, String repositoryId) {
            this.server = PluginServiceUtil.getODServer(request, repositoryId);
        }

        public Vector[] retrieveNativeAnnotations(HttpServletRequest request, String repositoryId, String documentId, String templateName) throws Exception {
            String methodName = "retrieveNativeAnnotations";
            Vector[] nativeHitsAndNotes = new Vector[]{null, null};
            ODFolder folder = ODContentUtil.openODFolder(request, this.server, templateName);
            ODHit hit = folder.recreateHit(documentId);
            Logger.logDebug(ODContentUtil.class, methodName, (ServletRequest)request, "Recreated hit. " + templateName);
            nativeHitsAndNotes[0] = new Vector(1);
            nativeHitsAndNotes[0].add(hit);
            nativeHitsAndNotes[1] = hit.getNotes();
            Logger.logDebug(ODContentUtil.class, methodName, (ServletRequest)request, "Got Notes [" + nativeHitsAndNotes[1].size() + "]. " + templateName);
            return nativeHitsAndNotes;
        }

        public ODAnnotationsMediator retrieveAnnotations(HttpServletRequest request, MessageResources resources, String repositoryId, String documentId, String templateName) {
            String methodName = "retrieveAnnotations";
            ODAnnotationsMediator annotationsMediator = new ODAnnotationsMediator(request, resources, request.getLocale());
            try {
                ODFolder folder = ODContentUtil.openODFolder(request, this.server, templateName);
                Vector[] hitsAndNotes = this.retrieveNativeAnnotations(request, repositoryId, documentId, templateName);
                if (hitsAndNotes[0] != null && hitsAndNotes[1] != null) {
                    annotationsMediator.setFolderName(templateName);
                    annotationsMediator.setDocumentId(documentId);
                    annotationsMediator.setNotes((Vector)hitsAndNotes[1].clone());
                    annotationsMediator.setUserGroupNames(this.server.getUser().getGroupNames());
                    annotationsMediator.addMessage("annotations.retrieveAnnotation.successful", new Object[0]);
                    if (hitsAndNotes[1].size() > 0) {
                        ODSearchResultsBean searchResultsBean = new ODSearchResultsBean(request, (Vector)hitsAndNotes[0].clone());
                        ODSearchResultsMediator searchResultsMediator = this.createSearchResultsMediator(request, resources, repositoryId);
                        searchResultsMediator.setFolder(folder);
                        searchResultsMediator.setSearchMessage(folder.getSearchMessage());
                        searchResultsMediator.setSearchResultsBean(searchResultsBean);
                        searchResultsMediator.setAnnotationsByDefault(true);
                        annotationsMediator.setSearchResultsMediator(searchResultsMediator);
                    }
                    Logger.logInfo((Object)this, methodName, (ServletRequest)request, "User Group Names =" + this.server.getUser().getGroupNames());
                } else {
                    Exception exc = new Exception("The document could not be retrieved.");
                    Logger.logError(P8ContentUtil.class, methodName, (ServletRequest)request, (Throwable)exc);
                    annotationsMediator.addError("error.exception.general", exc.getMessage());
                }
            }
            catch (Exception exc) {
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)exc);
                annotationsMediator.addError("error.exception.general", exc.getMessage());
            }
            return annotationsMediator;
        }

        public ODAnnotationMediator addNote(HttpServletRequest request, MessageResources resources, String repositoryId, String documentId, String templateName, String noteGroupName, String noteText, boolean noteIsOKToCopy, boolean noteIsPublic) {
            String methodName = "addNode";
            ODAnnotationMediator annotationMediator = new ODAnnotationMediator(request, resources, request.getLocale());
            ODNote newNote = new ODNote();
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Entering code area...");
            try {
                ODFolder folder = ODContentUtil.openODFolder(request, this.server, templateName);
                ODSearchResultsMediator searchResultsMediator = this.createSearchResultsMediator(request, resources, repositoryId);
                searchResultsMediator.setFolder(folder);
                ODHit hit = folder.recreateHit(documentId);
                if (noteGroupName != null) {
                    newNote.setGroupName(noteGroupName);
                }
                newNote.setText(noteText);
                newNote.setOkToCopy(noteIsOKToCopy);
                newNote.setPublic(noteIsPublic);
                Vector notes = hit.getNotes();
                hit.addNote(newNote);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Added Note. ");
                Vector<ODHit> vectorHits = new Vector<ODHit>(1);
                ODHit newHit = folder.recreateHit(documentId);
                vectorHits.add(newHit);
                ODSearchResultsBean searchResultsBean = new ODSearchResultsBean(request, (Vector)vectorHits.clone());
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, " number of hits found -->  [OD Vector = " + vectorHits.size() + "] [SearchResults Bean = " + searchResultsBean.size() + "]");
                searchResultsMediator.setAnnotationsByDefault(true);
                searchResultsMediator.setSearchMessage(folder.getSearchMessage());
                searchResultsMediator.setSearchResultsBean(searchResultsBean);
                annotationMediator.setFolderName(templateName);
                annotationMediator.setDocumentId(documentId);
                annotationMediator.setNote(newNote);
                annotationMediator.setCanAddNotes(hit.hasPermToAddNotes());
                annotationMediator.setCanPrintNotes(hit.hasPermToViewNotes());
                annotationMediator.setSearchResultsMediator(searchResultsMediator);
                annotationMediator.addMessage("annotations.addNewAnnotation.successful", new Object[0]);
            }
            catch (Exception exc) {
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)exc);
                annotationMediator.addError("error.exception.general", exc.getMessage());
            }
            return annotationMediator;
        }

        private ODSearchResultsMediator createSearchResultsMediator(HttpServletRequest request, MessageResources resources, String repositoryId) throws Exception {
            String methodName = "createSearchResultsMediator";
            ODSearchResultsMediator searchResultsMediator = new ODSearchResultsMediator(request, resources, request.getLocale());
            int pageSizeInt = 50;
            boolean showDocLocationBoolean = false;
            RepositoryConfig repositoryConfig = Config.getRepositoryConfig("navigator", repositoryId);
            if (repositoryId != null) {
                pageSizeInt = repositoryConfig.getPageSize();
                showDocLocationBoolean = repositoryConfig.isShowDocLocation();
            }
            searchResultsMediator.setPageSize(pageSizeInt);
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "pageSize = " + pageSizeInt);
            searchResultsMediator.setShowDocLocation(showDocLocationBoolean);
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "showDocLocation = " + showDocLocationBoolean);
            return searchResultsMediator;
        }
    }
}

