/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cmis;

import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.cmis.CMISConnection;
import java.util.Hashtable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.chemistry.opencmis.client.api.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionUtils {
    public static void storeConnectionInHttpSession(HttpServletRequest request, String userid, Session session) {
        String methodName = "storeConnectionInHttpSession";
        Logger.logEntry(ConnectionUtils.class, methodName, (ServletRequest)request);
        Hashtable<String, CMISConnection> connectionList = (Hashtable<String, CMISConnection>)request.getSession(true).getAttribute("CMIS_servers");
        if (connectionList == null) {
            connectionList = ConnectionUtils.createCmisConnectionListInHttpSession(request);
        }
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug(ConnectionUtils.class, methodName, (ServletRequest)request, "serverName: " + serverName);
        CMISConnection connection = new CMISConnection(userid, session);
        connectionList.put(serverName, connection);
        Logger.logExit(ConnectionUtils.class, methodName, (ServletRequest)request);
    }

    private static Hashtable<String, CMISConnection> createCmisConnectionListInHttpSession(HttpServletRequest request) {
        Hashtable<String, CMISConnection> connections = new Hashtable<String, CMISConnection>();
        request.getSession(true).setAttribute("CMIS_servers", connections);
        return connections;
    }

    public static CMISConnection getConnection(HttpServletRequest request) {
        String userId;
        Hashtable connectionList;
        HttpSession httpSession;
        CMISConnection connection = null;
        String serverName = request.getParameter("repositoryId");
        if (serverName != null && (httpSession = request.getSession(false)) != null && (connectionList = (Hashtable)httpSession.getAttribute("CMIS_servers")) != null && (connection = (CMISConnection)connectionList.get(serverName)) != null && (userId = connection.getUserId()) != null) {
            httpSession.setAttribute("session_userid", (Object)userId);
        }
        return connection;
    }

    public static void removeConnection(HttpServletRequest request) {
        String serverName = request.getParameter("repositoryId");
        Hashtable connectionList = (Hashtable)request.getSession(true).getAttribute("CMIS_servers");
        if (connectionList != null) {
            connectionList.remove(serverName);
        }
    }
}

