/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cmis;

import com.ibm.ecm.mediator.cmis.CMISDocumentMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.cmis.CMISConnection;
import com.ibm.ecm.util.cmis.CMISObjectUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumBaseObjectTypeIds;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumPropertyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISUtil
extends Util {
    public static final String DOCID_SEPARATOR = ",";

    public static CmisObject getPersistableObject(HttpServletRequest request, CMISConnection connection, String docId) {
        String methodName = "IndependentlyPersistableObject";
        if (docId.startsWith("/")) {
            return connection.getCMISSession().getObjectByPath(docId);
        }
        CmisObject independentlyPersistableObject = null;
        String objectIdentity = null;
        int firstSeparator = docId.indexOf(DOCID_SEPARATOR);
        int secondSeparator = docId.indexOf(DOCID_SEPARATOR, firstSeparator + 1);
        Logger.logDebug(CMISUtil.class, methodName, (ServletRequest)request, "firstSeparator " + firstSeparator + "   secondSeparator= " + secondSeparator);
        Logger.logDebug(CMISUtil.class, methodName, (ServletRequest)request, "docId.length= " + docId.length());
        objectIdentity = firstSeparator == -1 || secondSeparator == -1 ? docId : docId.substring(secondSeparator + 1);
        independentlyPersistableObject = CMISObjectUtils.getNonCachedObject(connection.getCMISSession(), objectIdentity, true);
        Logger.logDebug(CMISUtil.class, methodName, (ServletRequest)request, "retrieved cmis object = " + independentlyPersistableObject.getId());
        return independentlyPersistableObject;
    }

    public static boolean isNumericDataType(PropertyDefinition propertyDefinition) {
        PropertyType dataType = propertyDefinition.getPropertyType();
        return dataType.equals((Object)PropertyType.DECIMAL) || dataType.equals((Object)PropertyType.INTEGER);
    }

    public static String getObjectIdentity(String id) {
        int firstSeparator = id.indexOf(DOCID_SEPARATOR);
        if (firstSeparator == -1) {
            return id;
        }
        int secondSeparator = id.indexOf(DOCID_SEPARATOR, firstSeparator + 1);
        if (secondSeparator == -1) {
            return id;
        }
        String objectIdentity = id.substring(secondSeparator + 1);
        return objectIdentity;
    }

    public static boolean isPropertyHidden(PropertyDefinition pd) {
        boolean isHidden;
        List extensions = pd.getExtensions();
        if (extensions == null) {
            isHidden = false;
        } else {
            isHidden = false;
            for (CmisExtensionElement e : extensions) {
                if (!e.getName().equals("isHidden")) continue;
                isHidden = Boolean.valueOf(e.getValue());
                break;
            }
        }
        return isHidden;
    }

    public static String getDataType(PropertyDefinition pd) {
        return CMISUtil.getDataType(pd.getPropertyType());
    }

    public static String getDataType(PropertyType propertyType) {
        String dataType = propertyType.value().equals(EnumPropertyType.BOOLEAN.value()) ? "xs:boolean" : (propertyType.value().equals(EnumPropertyType.DATETIME.value()) ? "xs:timestamp" : (propertyType.value().equals(EnumPropertyType.DECIMAL.value()) ? "xs:double" : (propertyType.value().equals(EnumPropertyType.HTML.value()) ? "xs:string" : (propertyType.value().equals(EnumPropertyType.ID.value()) ? "xs:string:cmisid" : (propertyType.value().equals(EnumPropertyType.INTEGER.value()) ? "xs:long" : (propertyType.value().equals(EnumPropertyType.STRING.value()) ? "xs:string" : (propertyType.value().equals(EnumPropertyType.URI.value()) ? "xs:string" : "")))))));
        return dataType;
    }

    public static String getDocId(CmisObject hit) {
        return hit.getId();
    }

    public static PropertyDefinition getPropertyDescription(Property property) {
        return property.getDefinition();
    }

    public static Document getDocument(HttpServletRequest request, CMISConnection connection, String docID) {
        return CMISUtil.getDocument(request, connection, docID, null);
    }

    public static Document getDocument(HttpServletRequest request, CMISConnection connection, String CMISDocID, CMISDocumentMediator documentMediator) {
        Document document = null;
        CmisObject obj = connection.getCMISSession().getObject(CMISDocID);
        if (!(obj instanceof Document)) {
            String baseType = obj.getBaseTypeId().toString();
            Logger.logError((Object)obj, "getDocument", (ServletRequest)request, "Expected a Document, but returned object is type: " + baseType);
            if (documentMediator != null) {
                documentMediator.addError("viewingServices.verSeriesErrorOnRetrieve", CMISDocID, connection.getCMISSession().getRepositoryInfo().getId(), baseType);
            }
        } else {
            document = (Document)obj;
        }
        return document;
    }

    public static void printProperties(String reason, CmisObject item) {
    }

    public static String mapBaseType(String className) {
        String cmisClassName = className.equals("Document") ? EnumBaseObjectTypeIds.CMIS_DOCUMENT.value() : (className.equals("Folder") ? EnumBaseObjectTypeIds.CMIS_FOLDER.value() : className);
        return cmisClassName;
    }

    public static ArrayList<PropertyDefinition> getPropertyDefinitions(TypeDefinition typeDef, boolean includeSubclasses, boolean searchableOnly) {
        ArrayList propertyDescriptionList = new ArrayList();
        Map pdmap = typeDef.getPropertyDefinitions();
        propertyDescriptionList.addAll(pdmap.values());
        int capacity = propertyDescriptionList.size();
        ArrayList<PropertyDefinition> pdl1 = new ArrayList<PropertyDefinition>();
        for (PropertyDefinition propertyDesc : propertyDescriptionList) {
            if (!propertyDesc.isQueryable().booleanValue() && searchableOnly) continue;
            pdl1.add(propertyDesc);
        }
        return pdl1;
    }
}

