/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cmis;

import com.ibm.ecm.serviceability.Logger;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.enums.BindingType;

public class CMISSessionUtils {
    public static Session createSession(HttpServletRequest request, String serviceDocUrl, String repositoryId, String user, String password, String compressResponse) {
        Session session;
        String methodName = "createSession";
        SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.apache.chemistry.opencmis.user", user);
        parameters.put("org.apache.chemistry.opencmis.password", password);
        parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", serviceDocUrl);
        parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
        parameters.put("org.apache.chemistry.opencmis.locale.iso639", request.getLocale().getLanguage());
        if (compressResponse != null) {
            parameters.put("org.apache.chemistry.opencmis.binding.compression", compressResponse);
        }
        parameters.put("org.apache.chemistry.opencmis.cache.objects.size", "1000");
        parameters.put("org.apache.chemistry.opencmis.binding.cache.types.size", "300");
        parameters.put("org.apache.chemistry.opencmis.cache.objects.ttl", "600000");
        if (repositoryId.trim().equals("*")) {
            List repositories = factory.getRepositories(parameters);
            session = ((Repository)repositories.get(0)).createSession();
        } else {
            parameters.put("org.apache.chemistry.opencmis.session.repository.id", repositoryId);
            session = factory.createSession(parameters);
        }
        OperationContext operationContext = session.createOperationContext();
        operationContext.setCacheEnabled(true);
        session.setDefaultContext(operationContext);
        Logger.logDebug(CMISSessionUtils.class, methodName, (ServletRequest)request, "created CMIS Session object, repositoryId = " + session.getRepositoryInfo().getId());
        return session;
    }
}

