/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cmis;

import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.cmis.CMISConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public class CMISSessionListener
implements HttpSessionBindingListener {
    public void valueBound(HttpSessionBindingEvent event) {
        String methodName = "valueBound";
        HttpSession session = event.getSession();
        Logger.logEntry((Object)this, "valueBound", session);
        Logger.logDebug((Object)this, "valueBound", event.getSession(), "Session" + event.getSession() + "    maxInactiveInterval=" + event.getSession().getMaxInactiveInterval());
        Logger.logExit((Object)this, "valueBound", session);
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        String methodName = "valueUnbound";
        HttpSession session = event.getSession();
        Logger.logEntry((Object)this, "valueUnbound", session);
        Hashtable servers = null;
        CMISConnection theServer = null;
        try {
            if (session != null && (servers = (Hashtable)session.getAttribute("CMIS_servers")) != null) {
                if (servers.keySet() == null) {
                    return;
                }
                Enumeration eLoop = servers.keys();
                while (eLoop.hasMoreElements()) {
                    String serverName = (String)eLoop.nextElement();
                    theServer = (CMISConnection)servers.get(serverName);
                    if (theServer == null) continue;
                    Logger.logInfo((Object)this, "valueUnbound", session, "invalidate " + serverName + " for " + Logger.getFormattedUser(theServer.getUserId(), null));
                }
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, "valueUnbound", session, (Throwable)e);
        }
        Logger.logExit((Object)this, "valueUnbound", session);
    }
}

