/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cmis;

import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.SearchCriteria;
import com.ibm.ecm.util.SearchCriterion;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.cmis.CMISSearchDefinition;
import com.ibm.ecm.util.cmis.CMISSearchTemplate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CMISSearchUtil {
    private static final String TABLE_ALIAS = "t";

    private CMISSearchUtil() {
    }

    private static Map<String, CMISSearchDefinition.SelectProperty> getSortedProperties(List<CMISSearchDefinition.SelectProperty> selectProps) {
        if (selectProps == null || selectProps.size() < 1) {
            return null;
        }
        TreeMap<String, CMISSearchDefinition.SelectProperty> sortProps = new TreeMap<String, CMISSearchDefinition.SelectProperty>();
        for (CMISSearchDefinition.SelectProperty selectProp : selectProps) {
            int sl = selectProp.getSortLevel();
            if (sl <= 0) continue;
            String sortLevel = String.valueOf(sl);
            sortProps.put(sortLevel, selectProp);
        }
        return sortProps;
    }

    static Map<SearchTemplate.ObjectType, String> getQueries(HttpServletRequest request, CMISSearchDefinition searchDefinition) {
        HashMap<SearchTemplate.ObjectType, String> queries = new HashMap<SearchTemplate.ObjectType, String>();
        List<CMISSearchDefinition.SearchInFolder> folders = searchDefinition.getFolders();
        CMISSearchDefinition.SearchClause commonClause = searchDefinition.getSearchClause(SearchTemplate.ObjectType.common);
        SearchTemplate.VersionOption versionSelection = searchDefinition.getVersionSelection();
        CMISSearchDefinition.SearchClause searchClause = searchDefinition.getSearchClause(SearchTemplate.ObjectType.document);
        if (searchClause != null) {
            queries.put(SearchTemplate.ObjectType.document, CMISSearchUtil.getQuery(request, searchClause, commonClause, searchDefinition.getSourceSearchTemplate().getResultsDisplay().getColumns(), folders, versionSelection, searchDefinition));
        }
        if ((searchClause = searchDefinition.getSearchClause(SearchTemplate.ObjectType.folder)) != null) {
            queries.put(SearchTemplate.ObjectType.folder, CMISSearchUtil.getQuery(request, searchClause, commonClause, searchDefinition.getSourceSearchTemplate().getResultsDisplay().getColumns(), folders, null, null));
        }
        return queries;
    }

    private static String convertClassIdToQueryName(String classID, CMISSearchDefinition cmisSearchDefinition) {
        String retVal = classID;
        if (!classID.equalsIgnoreCase(BaseTypeId.CMIS_DOCUMENT.value()) && !classID.equalsIgnoreCase(BaseTypeId.CMIS_FOLDER.value())) {
            try {
                List<Session> tempSessionList;
                if (cmisSearchDefinition.getSourceSearchTemplate() != null && !(tempSessionList = cmisSearchDefinition.getSourceSearchTemplate().getSessions()).isEmpty()) {
                    Session s = tempSessionList.get(0);
                    retVal = s.getTypeDefinition(classID).getQueryName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retVal;
    }

    private static String getQuery(HttpServletRequest request, CMISSearchDefinition.SearchClause searchClause, CMISSearchDefinition.SearchClause commonClause, String[] additionalSelectProps, List<CMISSearchDefinition.SearchInFolder> folders, SearchTemplate.VersionOption versionSelection, CMISSearchDefinition cmisSearchDefinition) {
        String classClause;
        String cmisContainsClause;
        String searchClass;
        CMISSearchDefinition.Subclass subclass;
        if (searchClause == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        String selectClause = CMISSearchUtil.getSelectClause(searchClause.getSelectProperties(), additionalSelectProps);
        List<CMISSearchDefinition.Subclass> subclasses = searchClause.getSubclasses();
        CMISSearchDefinition.Subclass subclass2 = subclass = subclasses != null && subclasses.size() > 0 ? subclasses.get(0) : null;
        if (subclass != null && subclass.isSearchSubclasses()) {
            searchClass = subclass.getSymbolicName();
            subclasses.remove(subclass);
        } else {
            searchClass = searchClause.getFrom().toString();
        }
        searchClass = CMISSearchUtil.convertClassIdToQueryName(searchClass, cmisSearchDefinition);
        String from = searchClass + " " + TABLE_ALIAS;
        String orderByClause = CMISSearchUtil.getOrderByClause(searchClause.getSelectProperties());
        StringBuilder whereCumulative = new StringBuilder();
        String folderClause = CMISSearchUtil.getFolderClause(folders);
        if (folderClause != null) {
            whereCumulative.append(folderClause);
        }
        String whereClause = CMISSearchUtil.getWhereClause(request, searchClause.getWhereClause(), commonClause == null ? null : commonClause.getWhereClause());
        String string = cmisContainsClause = cmisSearchDefinition != null ? cmisSearchDefinition.getTextSearchBody() : null;
        if (whereClause != null && whereClause.length() > 0 || cmisContainsClause != null && cmisContainsClause.length() > 0) {
            if (whereCumulative.length() > 0) {
                whereCumulative.append(" AND ");
            }
            whereCumulative.append("(");
            if (whereClause != null && whereClause.length() > 0) {
                whereCumulative.append("(").append(whereClause).append(")");
            }
            if (whereClause != null && whereClause.length() > 0 && cmisContainsClause != null && cmisContainsClause.length() > 0) {
                whereCumulative.append(" AND ");
            }
            if (cmisContainsClause != null && cmisContainsClause.length() > 0) {
                whereCumulative.append(" Contains('").append(cmisContainsClause).append("')");
            }
            whereCumulative.append(")");
        }
        if ((classClause = CMISSearchUtil.getClassClause(searchClause.getSubclasses())) != null && classClause.length() > 0) {
            if (whereCumulative.length() > 0) {
                whereCumulative.append(" AND ");
            }
            whereCumulative.append(classClause);
        }
        buffer.append("SELECT ").append(selectClause);
        buffer.append(" FROM ").append(from);
        if (whereCumulative.length() > 0) {
            buffer.append(" WHERE ").append((CharSequence)whereCumulative);
        }
        if (orderByClause != null && orderByClause.length() > 0) {
            buffer.append(" ORDER BY ");
            buffer.append(orderByClause);
        }
        return buffer.toString();
    }

    private static String getFolderClause(List<CMISSearchDefinition.SearchInFolder> folders) {
        if (folders == null || folders.size() < 1) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (CMISSearchDefinition.SearchInFolder folder : folders) {
            String id = folder.getId();
            boolean subfolders = folder.isSearchSubfolders();
            if (buffer.length() > 0) {
                buffer.append(" OR ");
            }
            if (subfolders) {
                buffer.append(" In_Tree(");
            } else {
                buffer.append(" In_Folder(");
            }
            buffer.append("'").append(id).append("')");
        }
        if (buffer.length() > 0) {
            buffer.insert(0, "(");
            buffer.append(")");
        }
        return buffer.toString();
    }

    private static String getWhereClause(HttpServletRequest request, CMISSearchDefinition.WhereClause whereClause, CMISSearchDefinition.WhereClause commonWhereClause) {
        if (whereClause == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        if (whereClause.isContainer()) {
            CMISSearchDefinition.WhereClauseContainer wcc = (CMISSearchDefinition.WhereClauseContainer)whereClause;
            String join = wcc.getJoin().toString();
            List<CMISSearchDefinition.WhereClause> whereClauses = wcc.getWhereClauses();
            boolean wrap = false;
            for (CMISSearchDefinition.WhereClause wc : whereClauses) {
                String c = CMISSearchUtil.getWhereClause(request, wc, commonWhereClause);
                if (c == null || c.length() == 0) continue;
                if (buffer.length() > 0) {
                    buffer.append(" ").append(join).append(" ");
                    wrap = true;
                }
                buffer.append(c);
            }
            if (wrap) {
                buffer.insert(0, "(");
                buffer.append(")");
            }
        } else if (whereClause == CMISSearchDefinition.COMMON_CLAUSE) {
            buffer.append(CMISSearchUtil.getWhereClause(request, commonWhereClause, null));
        } else {
            CMISSearchDefinition.WhereClauseCondition wcc = (CMISSearchDefinition.WhereClauseCondition)whereClause;
            buffer.append(CMISSearchUtil.getWhereClauseCondition(request, wcc));
        }
        return buffer.toString();
    }

    private static String getWhereClauseCondition(HttpServletRequest request, CMISSearchDefinition.WhereClauseCondition whereClauseCondition) {
        String name = "t." + whereClauseCondition.getPropSymbolicName() + "";
        CMISSearchDefinition.Operator operator = whereClauseCondition.getOperator();
        CMISSearchDefinition.DataType dataType = whereClauseCondition.getPropDataType();
        String value = whereClauseCondition.getLiteral();
        if (value == null) {
            value = "";
        }
        if (operator != CMISSearchDefinition.Operator.isnull && operator != CMISSearchDefinition.Operator.isnotnull) {
            if (value.length() == 0) {
                return "";
            }
            if (dataType == CMISSearchDefinition.DataType.typestring) {
                value = "'" + value.replaceAll("'", "''") + "'";
            }
        }
        String condition = "";
        if (dataType == CMISSearchDefinition.DataType.typedate && value.length() > 0) {
            String[] dates;
            try {
                Calendar cal = WCDateFormat.parseW3CDate(value, null);
                dates = WCDateFormat.getDateRangeStrings(request, cal.getTimeInMillis(), WCDateFormat.UTC_DATE_FORMAT);
            }
            catch (ParseException e) {
                Logger.logError(CMISSearchUtil.class, "getWhereClauseCondition", (ServletRequest)request, (Throwable)e);
                throw new RuntimeException(e);
            }
            String currentDay = "TIMESTAMP '" + dates[0] + "'";
            String nextDay = "TIMESTAMP '" + dates[1] + "'";
            switch (operator) {
                case eq: {
                    condition = condition + "(" + name + " >= " + currentDay + " AND ";
                    condition = condition + name + " < " + nextDay + ")";
                    break;
                }
                case lte: {
                    condition = condition + name + " < " + nextDay;
                    break;
                }
                case neq: {
                    condition = condition + "(" + name + " < " + currentDay + " OR ";
                    condition = condition + name + " >= " + nextDay + ")";
                    break;
                }
                case gt: {
                    condition = condition + name + " >= " + nextDay;
                    break;
                }
                default: {
                    value = currentDay;
                }
            }
        }
        if (condition.length() < 1) {
            switch (operator) {
                case gt: {
                    condition = condition + name + " > " + value;
                    break;
                }
                case gte: {
                    condition = condition + name + " >= " + value;
                    break;
                }
                case lt: {
                    condition = condition + name + " < " + value;
                    break;
                }
                case lte: {
                    condition = condition + name + " <= " + value;
                    break;
                }
                case eq: {
                    if (dataType == CMISSearchDefinition.DataType.typeobject) {
                        condition = condition + name + " = Object('" + value + "')";
                        break;
                    }
                    condition = condition + name + " = " + value;
                    break;
                }
                case neq: {
                    if (dataType == CMISSearchDefinition.DataType.typeobject) {
                        condition = condition + "NOT (" + name + " = Object('" + value + "'))";
                        break;
                    }
                    condition = condition + name + " <> " + value;
                    break;
                }
                case like: {
                    condition = condition + name + " LIKE " + value;
                    break;
                }
                case notlike: {
                    condition = condition + "NOT (" + name + " LIKE " + value + ")";
                    break;
                }
                case in: 
                case notany: {
                    condition = condition + "NOT (" + value + " = ANY " + name + ")";
                    break;
                }
                case all: 
                case any: {
                    condition = condition + value + " = ANY " + name;
                    break;
                }
                case inany: {
                    condition = condition + name + " IN (" + value + ")";
                    break;
                }
                case notin: {
                    condition = condition + "NOT (" + name + " IN (" + value + "))";
                    break;
                }
                case isnull: {
                    condition = condition + name + " IS NULL";
                    break;
                }
                case isnotnull: {
                    condition = condition + name + " IS NOT NULL";
                    break;
                }
            }
        }
        return condition;
    }

    private static String getClassClause(List<CMISSearchDefinition.Subclass> classes) {
        if (classes == null || classes.size() < 1) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        return buffer.toString();
    }

    private static String getVersionClause(SearchTemplate.VersionOption versionSelection) {
        if (versionSelection == SearchTemplate.VersionOption.currentversion) {
            return "t.IsCurrentVersion = true";
        }
        if (versionSelection == SearchTemplate.VersionOption.releasedversion) {
            return "t.VersionStatus = 1";
        }
        return null;
    }

    private static String getVerityClause(CMISSearchDefinition.ContentClause verityClause, boolean showRank) {
        if (verityClause == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        return buffer.toString();
    }

    private static String getSelectClause(List<CMISSearchDefinition.SelectProperty> selectProps, String[] additionalSelectProps) {
        StringBuilder buffer = new StringBuilder();
        boolean findObjectId = false;
        String objectIdName = "cmis:objectId";
        if (selectProps != null) {
            for (CMISSearchDefinition.SelectProperty selectProp : selectProps) {
                String name = selectProp.getQueryName();
                if (name.equals(objectIdName)) {
                    findObjectId = true;
                }
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append("t.").append(name).append("");
            }
        }
        if (additionalSelectProps != null) {
            for (String name : additionalSelectProps) {
                if (name.equals(objectIdName)) {
                    findObjectId = true;
                }
                if (selectProps.contains(name) || CMISSearchUtil.isStringContainedInListAsQueryName(selectProps, name)) continue;
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append("t.").append(name).append("");
            }
        }
        if (!findObjectId) {
            buffer.append(", ");
            buffer.append("t.").append(objectIdName).append("");
        }
        return buffer.toString();
    }

    private static boolean isStringContainedInListAsQueryName(List<CMISSearchDefinition.SelectProperty> selectProps, String nameToSearch) {
        for (CMISSearchDefinition.SelectProperty selectProp : selectProps) {
            String name = selectProp.getQueryName();
            if (!nameToSearch.equals(name)) continue;
            return true;
        }
        return false;
    }

    private static String getOrderByClause(List<CMISSearchDefinition.SelectProperty> selectProps) {
        if (selectProps == null || selectProps.size() < 1) {
            return null;
        }
        Map<String, CMISSearchDefinition.SelectProperty> sortProps = CMISSearchUtil.getSortedProperties(selectProps);
        if (sortProps == null || sortProps.size() < 1) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (CMISSearchDefinition.SelectProperty selectProp : sortProps.values()) {
            String name = selectProp.getQueryName();
            CMISSearchDefinition.SortOrder so = CMISSearchDefinition.SortOrder.valueOf(selectProp.getSortOrder());
            if (so == CMISSearchDefinition.SortOrder.none) continue;
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("t.").append(name).append(" ");
            if (so == CMISSearchDefinition.SortOrder.ascending) {
                buffer.append("ASC");
                continue;
            }
            if (so != CMISSearchDefinition.SortOrder.descending) continue;
            buffer.append("DESC");
        }
        return buffer.toString();
    }

    static void convertToCMISSearchDefinition(CMISSearchTemplate searchTemplate, CMISSearchDefinition searchDefinition) throws Exception {
        if (searchDefinition == null) {
            searchDefinition = new CMISSearchDefinition();
        }
        searchDefinition.setSourceSearchTemplate(searchTemplate);
        SearchTemplate.ObjectType objectType = searchTemplate.getObjectType();
        if (searchDefinition.isNexusGenerated()) {
            CMISSearchDefinition.SearchClause searchClause = new CMISSearchDefinition.SearchClause(objectType.toString());
            searchDefinition.addSearchClause(searchClause);
        } else {
            CMISSearchDefinition.SearchClause searchClause = searchDefinition.getSearchClause(objectType);
        }
        String textSearchTerms = null;
        if (searchTemplate != null & searchTemplate.getTextSearchCriteria() != null && searchTemplate.getFirstTextSearchCriterion() != null && (textSearchTerms = searchTemplate.getFirstTextSearchCriterion().getText()) != null && textSearchTerms.length() > 0) {
            searchDefinition.setTextSearchBody(textSearchTerms);
        }
        CMISSearchUtil.convertCMISSearchTemplateSelectProperties(searchTemplate, searchDefinition);
        CMISSearchUtil.convertCMISSearchTemplateObjectStores(searchTemplate.getSessions(), searchDefinition);
        CMISSearchUtil.convertCMISSearchTemplateFolders(searchTemplate.getFolders(), searchDefinition);
        CMISSearchUtil.convertCMISSearchTemplateClass(searchTemplate, searchDefinition);
        CMISSearchUtil.convertCMISSearchTemplateSearchCriteria(searchTemplate, searchDefinition);
        SearchTemplate.VersionOption versionOption = searchTemplate.getVersionOption();
        if (versionOption != null) {
            searchDefinition.setVersionSelection(versionOption.toString());
        }
    }

    private static void convertCMISSearchTemplateObjectStores(List<Session> objectStores, CMISSearchDefinition searchDefinition) {
        ArrayList<CMISSearchDefinition.SearchInObjectStore> searchInObjectStores = new ArrayList<CMISSearchDefinition.SearchInObjectStore>();
        for (Session repository : objectStores) {
            searchInObjectStores.add(new CMISSearchDefinition.SearchInObjectStore(repository.getRepositoryInfo().getId(), repository.getRepositoryInfo().getName()));
        }
        searchDefinition.setObjectStores(searchInObjectStores);
    }

    private static void convertCMISSearchTemplateSelectProperties(CMISSearchTemplate searchTemplate, CMISSearchDefinition searchDefinition) {
        SearchTemplate.ObjectType objectType = searchTemplate.getObjectType();
        CMISSearchDefinition.SearchClause searchClause = searchDefinition.getSearchClause(objectType);
        String orderByPropName = "cmis:name";
        CMISSearchDefinition.SortOrder orderBySortOrder = CMISSearchDefinition.SortOrder.ascending;
        if (searchTemplate.getResultsDisplay() != null && searchTemplate.getResultsDisplay().getSortByProperty() != null && searchTemplate.getResultsDisplay().getSortByProperty().length() > 0) {
            orderByPropName = searchTemplate.getResultsDisplay().getSortByProperty();
            if (!searchTemplate.getResultsDisplay().getSortAscending()) {
                orderBySortOrder = CMISSearchDefinition.SortOrder.descending;
            }
        }
        if (searchDefinition.isNexusGenerated()) {
            ArrayList<CMISSearchDefinition.SelectProperty> selectProps = new ArrayList<CMISSearchDefinition.SelectProperty>();
            selectProps.add(new CMISSearchDefinition.SelectProperty(orderByPropName, null, objectType.toString(), 1, orderBySortOrder.toString(), null));
            List<SearchCriteria> searchCriteria = searchTemplate.getSearchCriteria();
            for (SearchCriteria criteriaEntry : searchCriteria) {
                SearchCriterion criterion = (SearchCriterion)criteriaEntry;
                if (criterion.getName().equals(orderByPropName)) continue;
                selectProps.add(new CMISSearchDefinition.SelectProperty(criterion.getName(), criterion.getDisplayName(), objectType.toString(), 0, null, null));
            }
            searchClause.setSelectProperties(selectProps);
        } else {
            List<CMISSearchDefinition.SelectProperty> selectProps = searchClause.getSelectProperties();
            CMISSearchDefinition.SelectProperty nameProp = searchClause.getSelectProperty(orderByPropName);
            if (nameProp == null) {
                nameProp = new CMISSearchDefinition.SelectProperty(orderByPropName, null, objectType.toString(), 0, null, null);
                Map<String, CMISSearchDefinition.SelectProperty> sortProps = CMISSearchUtil.getSortedProperties(selectProps);
                if (sortProps == null || sortProps.size() < 1) {
                    nameProp.setSortLevel(1);
                    nameProp.setSortOrder(CMISSearchDefinition.SortOrder.ascending.toString());
                }
                selectProps.add(nameProp);
            }
        }
    }

    private static void convertCMISSearchTemplateFolders(List<SearchTemplate.SearchFolder> folders, CMISSearchDefinition searchDefinition) {
        if (folders == null) {
            return;
        }
        ArrayList<CMISSearchDefinition.SearchInFolder> searchInFolders = new ArrayList<CMISSearchDefinition.SearchInFolder>();
        for (SearchTemplate.SearchFolder folder : folders) {
            CMISSearchDefinition.SearchInFolder searchInFolder = new CMISSearchDefinition.SearchInFolder(folder.getId(), folder.getPathName(), folder.isSearchSubfolders(), folder.getView().toString(), folder.getObjectStoreId());
            searchInFolder.setItemId(folder.getItemId());
            searchInFolders.add(searchInFolder);
        }
        searchDefinition.setFolders(searchInFolders);
    }

    private static void convertCMISSearchTemplateClass(CMISSearchTemplate searchTemplate, CMISSearchDefinition searchDefinition) {
        if (!searchDefinition.isNexusGenerated()) {
            return;
        }
        SearchTemplate.ObjectType objectType = searchTemplate.getObjectType();
        String className = searchTemplate.getFirstClassName();
        if (className == null) {
            className = objectType == SearchTemplate.ObjectType.folder ? "Folder" : "Document";
        }
        CMISSearchDefinition.Subclass subclass = new CMISSearchDefinition.Subclass(className, searchTemplate.getFirstClassDisplayName(), objectType.toString(), null);
        subclass.setSearchSubclasses(searchTemplate.isFirstClassSearchSubclasses());
        ArrayList<CMISSearchDefinition.Subclass> subclasses = new ArrayList<CMISSearchDefinition.Subclass>();
        subclasses.add(subclass);
        CMISSearchDefinition.SearchClause searchClause = searchDefinition.getSearchClause(objectType);
        searchClause.setSubclasses(subclasses);
    }

    private static void convertCMISSearchTemplateSearchCriteria(CMISSearchTemplate searchTemplate, CMISSearchDefinition searchDefinition) throws Exception {
        SearchTemplate.ObjectType objectType = searchTemplate.getObjectType();
        CMISSearchDefinition.SearchClause searchClause = searchDefinition.getSearchClause(objectType);
        ArrayList<CMISSearchDefinition.WhereClause> conditions = new ArrayList<CMISSearchDefinition.WhereClause>();
        List<SearchCriteria> searchCriteria = searchTemplate.getSearchCriteria();
        for (SearchCriteria criteriaEntry : searchCriteria) {
            String name;
            SearchCriterion criterion = (SearchCriterion)criteriaEntry;
            CMISSearchDefinition.SearchFieldOption view = criterion.isHidden() ? CMISSearchDefinition.SearchFieldOption.hidden : (criterion.isReadOnly() ? CMISSearchDefinition.SearchFieldOption.readonly : (criterion.isRequired() ? CMISSearchDefinition.SearchFieldOption.required : CMISSearchDefinition.SearchFieldOption.editable));
            String[] values = criterion.getValues();
            String criterionOperator = criterion.getOperator();
            String operator = CMISSearchUtil.convertCMISSearchTemplateOperator(criterionOperator);
            String dataType = CMISSearchUtil.convertCMISSearchTemplateDataType(criterion.getDataType());
            if (values != null && values.length > 0 && (operator.equals(CMISSearchDefinition.Operator.in.toString()) || operator.equals(CMISSearchDefinition.Operator.notin.toString()) || operator.equals(CMISSearchDefinition.Operator.inany.toString()))) {
                name = criterion.getName();
                String displayName = criterion.getDisplayName();
                CMISSearchDefinition.WhereClauseContainer container = CMISSearchUtil.explodeIncludeCondition(name, displayName, dataType, operator, values, view, criterion.getCardinality());
                conditions.add(container);
                continue;
            }
            if (operator.equals(CMISSearchDefinition.Operator.between.toString()) || operator.equals(CMISSearchDefinition.Operator.notbetween.toString())) {
                if (searchDefinition.isNexusGenerated()) {
                    String displayName;
                    name = criterion.getName();
                    CMISSearchDefinition.WhereClause clause = CMISSearchUtil.explodeBetweenCondition(name, displayName = criterion.getDisplayName(), dataType, operator, values, view);
                    if (clause == null) continue;
                    conditions.add(clause);
                    continue;
                }
                String[] itemIds = criterion.getItemId().split(",");
                boolean between = operator.equals(CMISSearchDefinition.Operator.between.toString());
                CMISSearchDefinition.WhereClauseCondition fromCondition = searchClause.getWhereClauseCondition(itemIds[0]);
                fromCondition.setOperator(between ? CMISSearchDefinition.Operator.gte.toString() : CMISSearchDefinition.Operator.lt.toString());
                String fromValue = values != null && values.length > 0 ? values[0] : null;
                fromCondition.setLiteral(CMISSearchUtil.convertCMISSearchTemplateConditionValue(fromValue, CMISSearchDefinition.DataType.valueOf(dataType)));
                CMISSearchDefinition.WhereClauseCondition toCondition = searchClause.getWhereClauseCondition(itemIds[0]);
                toCondition.setOperator(between ? CMISSearchDefinition.Operator.gte.toString() : CMISSearchDefinition.Operator.lt.toString());
                String toValue = values != null && values.length > 1 ? values[1] : null;
                toCondition.setLiteral(CMISSearchUtil.convertCMISSearchTemplateConditionValue(toValue, CMISSearchDefinition.DataType.valueOf(dataType)));
                continue;
            }
            String value = values == null || values.length < 1 ? null : values[0];
            value = CMISSearchUtil.convertCMISSearchTemplateConditionValue(value, CMISSearchDefinition.DataType.valueOf(dataType));
            if (operator.equals(CMISSearchDefinition.Operator.like.toString()) || operator.equals(CMISSearchDefinition.Operator.notlike.toString()) || operator.equals(CMISSearchDefinition.Operator.startswith.toString()) || operator.equals(CMISSearchDefinition.Operator.endswith.toString())) {
                value = CMISSearchUtil.convertLikeValue(value, CMISSearchDefinition.Operator.valueOf(operator));
                if (!operator.equals(CMISSearchDefinition.Operator.notlike.toString())) {
                    operator = CMISSearchDefinition.Operator.like.toString();
                }
            }
            if (searchDefinition.isNexusGenerated()) {
                CMISSearchDefinition.WhereClauseCondition condition = new CMISSearchDefinition.WhereClauseCondition(operator, criterion.getName(), criterion.getDisplayName(), null, dataType, false, null, false, view.toString(), value);
                conditions.add(condition);
                continue;
            }
            String itemId = criterion.getItemId();
            CMISSearchDefinition.WhereClauseCondition condition = searchClause.getWhereClauseCondition(itemId);
            condition.setOperator(operator);
            condition.setLiteral(value);
        }
        if (searchDefinition.isNexusGenerated()) {
            if (searchCriteria.size() > 1) {
                CMISSearchDefinition.WhereClauseContainer container = new CMISSearchDefinition.WhereClauseContainer(searchTemplate.isAndSearch() ? CMISSearchDefinition.Operator.and.toString() : CMISSearchDefinition.Operator.or.toString());
                container.setWhereClauses(conditions);
                searchClause.setWhereClause(container);
            } else if (!conditions.isEmpty()) {
                searchClause.setWhereClause((CMISSearchDefinition.WhereClause)conditions.get(0));
            }
        }
    }

    private static String convertCMISSearchTemplateConditionValue(String value, CMISSearchDefinition.DataType dataType) throws Exception {
        String literal = value;
        if (dataType.equals((Object)CMISSearchDefinition.DataType.typedate) && value != null && value.length() > 0) {
            Date date = DateUtil.parseISODate(value, true);
            literal = WCDateFormat.UTC_DATE_FORMAT.format(date);
        }
        return literal;
    }

    private static CMISSearchDefinition.WhereClauseContainer explodeIncludeCondition(String name, String displayName, String dataType, String operator, String[] values, CMISSearchDefinition.SearchFieldOption view, String cardinality) throws Exception {
        CMISSearchDefinition.WhereClauseContainer container = new CMISSearchDefinition.WhereClauseContainer(operator.equals(CMISSearchDefinition.Operator.inany.toString()) ? CMISSearchDefinition.Operator.or.toString() : CMISSearchDefinition.Operator.and.toString());
        if (cardinality.equals("SINGLE")) {
            operator = operator.equals(CMISSearchDefinition.Operator.inany.toString()) ? CMISSearchDefinition.Operator.eq.toString() : CMISSearchDefinition.Operator.neq.toString();
        } else if (cardinality.equals("LIST") || cardinality.equals("multi")) {
            if (operator.equals(CMISSearchDefinition.Operator.inany.toString())) {
                operator = CMISSearchDefinition.Operator.any.toString();
            } else if (operator.equals(CMISSearchDefinition.Operator.notin.toString())) {
                operator = CMISSearchDefinition.Operator.notany.toString();
            } else if (operator.equals(CMISSearchDefinition.Operator.in.toString())) {
                operator = CMISSearchDefinition.Operator.all.toString();
            }
        }
        for (int i = 0; i < values.length; ++i) {
            String value = CMISSearchUtil.convertCMISSearchTemplateConditionValue(values[i], CMISSearchDefinition.DataType.valueOf(dataType));
            CMISSearchDefinition.WhereClauseCondition condition = new CMISSearchDefinition.WhereClauseCondition(operator, name, displayName, null, dataType, false, null, false, view.toString(), value);
            container.addClause(condition);
        }
        return container;
    }

    private static CMISSearchDefinition.WhereClause explodeBetweenCondition(String name, String displayName, String dataType, String operator, String[] values, CMISSearchDefinition.SearchFieldOption view) throws Exception {
        CMISSearchDefinition.WhereClause clause = null;
        boolean between = operator.equals(CMISSearchDefinition.Operator.between.toString());
        if (values != null && values.length == 1 && values[0] != null && values[0].length() > 0) {
            String value = CMISSearchUtil.convertCMISSearchTemplateConditionValue(values[0], CMISSearchDefinition.DataType.valueOf(dataType));
            clause = new CMISSearchDefinition.WhereClauseCondition(between ? CMISSearchDefinition.Operator.gte.toString() : CMISSearchDefinition.Operator.lt.toString(), name, displayName, null, dataType, false, null, false, view.toString(), value);
        } else if (values != null && values.length > 1) {
            int size;
            CMISSearchDefinition.WhereClauseCondition condition;
            String value;
            CMISSearchDefinition.WhereClauseContainer container = new CMISSearchDefinition.WhereClauseContainer(between ? CMISSearchDefinition.Operator.and.toString() : CMISSearchDefinition.Operator.or.toString());
            if (values[0] != null && values[0].length() > 0) {
                value = CMISSearchUtil.convertCMISSearchTemplateConditionValue(values[0], CMISSearchDefinition.DataType.valueOf(dataType));
                condition = new CMISSearchDefinition.WhereClauseCondition(between ? CMISSearchDefinition.Operator.gte.toString() : CMISSearchDefinition.Operator.lt.toString(), name, displayName, null, dataType, false, null, false, view.toString(), value);
                container.addClause(condition);
            }
            if (values[1] != null && values[1].length() > 0) {
                value = CMISSearchUtil.convertCMISSearchTemplateConditionValue(values[1], CMISSearchDefinition.DataType.valueOf(dataType));
                condition = new CMISSearchDefinition.WhereClauseCondition(between ? CMISSearchDefinition.Operator.lte.toString() : CMISSearchDefinition.Operator.gt.toString(), name, displayName, null, dataType, false, null, false, view.toString(), value);
                container.addClause(condition);
            }
            if ((size = container.getWhereClauses().size()) > 0) {
                clause = size == 2 ? container : container.getWhereClauses().get(0);
            }
        }
        return clause;
    }

    private static String convertCMISSearchTemplateOperator(String operator) {
        if (operator.equals("EQUAL")) {
            operator = CMISSearchDefinition.Operator.eq.toString();
        } else if (operator.equals("NOTEQUAL")) {
            operator = CMISSearchDefinition.Operator.neq.toString();
        } else if (operator.equals("LIKE")) {
            operator = CMISSearchDefinition.Operator.like.toString();
        } else if (operator.equals("NOTLIKE")) {
            operator = CMISSearchDefinition.Operator.notlike.toString();
        } else if (operator.equals("LESS")) {
            operator = CMISSearchDefinition.Operator.lt.toString();
        } else if (operator.equals("LESSOREQUAL")) {
            operator = CMISSearchDefinition.Operator.lte.toString();
        } else if (operator.equals("GREATER")) {
            operator = CMISSearchDefinition.Operator.gt.toString();
        } else if (operator.equals("GREATEROREQUAL")) {
            operator = CMISSearchDefinition.Operator.gte.toString();
        } else if (operator.equals("IN")) {
            operator = CMISSearchDefinition.Operator.in.toString();
        } else if (operator.equals("NOTIN")) {
            operator = CMISSearchDefinition.Operator.notin.toString();
        } else if (operator.equals("INANY")) {
            operator = CMISSearchDefinition.Operator.inany.toString();
        } else if (operator.equals("NULL")) {
            operator = CMISSearchDefinition.Operator.isnull.toString();
        } else if (operator.equals("NOTNULL")) {
            operator = CMISSearchDefinition.Operator.isnotnull.toString();
        } else if (operator.equals("BETWEEN")) {
            operator = CMISSearchDefinition.Operator.between.toString();
        } else if (operator.equals("NOTBETWEEN")) {
            operator = CMISSearchDefinition.Operator.notbetween.toString();
        } else if (operator.equals("STARTSWITH")) {
            operator = CMISSearchDefinition.Operator.startswith.toString();
        } else if (operator.equals("ENDSWITH")) {
            operator = CMISSearchDefinition.Operator.endswith.toString();
        }
        return operator;
    }

    private static String convertCMISSearchDefinitionDataType(CMISSearchDefinition.DataType dataType) {
        String xsType;
        switch (dataType) {
            case typestring: {
                xsType = "xs:string";
                break;
            }
            case typedate: {
                xsType = "xs:date";
                break;
            }
            case typeboolean: {
                xsType = "xs:boolean";
                break;
            }
            case typedouble: {
                xsType = "xs:double";
                break;
            }
            case typelong: {
                xsType = "xs:long";
                break;
            }
            default: {
                xsType = "xs:string";
            }
        }
        return xsType;
    }

    private static String convertCMISSearchTemplateDataType(String dataType) {
        dataType = dataType.equals("xs:string") ? CMISSearchDefinition.DataType.typestring.toString() : (dataType.equals("xs:date") || dataType.equals("xs:timestamp") ? CMISSearchDefinition.DataType.typedate.toString() : (dataType.equals("xs:boolean") ? CMISSearchDefinition.DataType.typeboolean.toString() : (dataType.equals("xs:double") ? CMISSearchDefinition.DataType.typedouble.toString() : (dataType.equals("xs:long") ? CMISSearchDefinition.DataType.typelong.toString() : (dataType.equals("xs:guid") ? CMISSearchDefinition.DataType.typeguid.toString() : CMISSearchDefinition.DataType.typestring.toString())))));
        return dataType;
    }

    private static String convertLikeValue(String value, CMISSearchDefinition.Operator operator) {
        if (value != null && value.length() > 0) {
            value = operator == CMISSearchDefinition.Operator.startswith ? value + "%" : (operator == CMISSearchDefinition.Operator.endswith ? "%" + value : "%" + value + "%");
        }
        return value;
    }
}

