/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cmis;

import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.cmis.CMISSearchTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISSearchDefinition {
    public static final SelectProperty SELECT_PROPERTY_ALL = new SelectProperty("*", null, null, 0, null, null);
    public static final WhereClause COMMON_CLAUSE = new WhereClause(){

        public boolean isContainer() {
            return false;
        }
    };
    static final String NEXUS_PRODUCT_NAME = "IBM Content Navigator";
    private static final String NEW_LINE = System.getProperty("line.separator") + "    ";
    private String dtdVersion;
    private String searchVersion;
    private String productName;
    private String productVersion;
    private SearchTemplate.VersionOption versionSelection;
    private boolean showAndOrConditions;
    private boolean showMaxRecords;
    private boolean showOperators;
    private String mergeOption;
    private int maxRecords;
    private String textSearchBody;
    private CMISSearchTemplate sourceSearchTemplate;
    private List<SearchInObjectStore> objectStores = new ArrayList<SearchInObjectStore>();
    private List<SearchInFolder> folders = new ArrayList<SearchInFolder>();
    private List<SearchClause> searchClauses = new ArrayList<SearchClause>();

    public CMISSearchTemplate getSourceSearchTemplate() {
        return this.sourceSearchTemplate;
    }

    public void setSourceSearchTemplate(CMISSearchTemplate sourceSearchTemplate) {
        this.sourceSearchTemplate = sourceSearchTemplate;
    }

    public String getTextSearchBody() {
        return this.textSearchBody;
    }

    public void setTextSearchBody(String textSearchBody) {
        this.textSearchBody = textSearchBody;
    }

    String getDtdVersion() {
        return this.dtdVersion;
    }

    void setDtdVersion(String dtdVersion) {
        this.dtdVersion = dtdVersion;
    }

    public List<SearchInFolder> getFolders() {
        return this.folders;
    }

    void setFolders(List<SearchInFolder> folders) {
        this.folders = folders;
    }

    void addFolder(SearchInFolder folder) {
        this.folders.add(folder);
    }

    int getMaxRecords() {
        return this.maxRecords;
    }

    void setMaxRecords(int maxRecords) {
        this.maxRecords = maxRecords;
    }

    void setMaxRecords(String maxRecords) {
        this.maxRecords = Integer.parseInt(maxRecords);
    }

    String getMergeOption() {
        return this.mergeOption;
    }

    void setMergeOption(String mergeOption) {
        this.mergeOption = mergeOption;
    }

    List<SearchInObjectStore> getObjectStores() {
        return this.objectStores;
    }

    List<String> getObjectStoreNames() {
        ArrayList<String> osNames = new ArrayList<String>();
        for (SearchInObjectStore sos : this.objectStores) {
            osNames.add(sos.getName());
        }
        return osNames;
    }

    void setObjectStores(List<SearchInObjectStore> objectStores) {
        this.objectStores = objectStores;
    }

    void addObjectStore(SearchInObjectStore objectStore) {
        this.objectStores.add(objectStore);
    }

    String getProductName() {
        return this.productName;
    }

    void setProductName(String productName) {
        this.productName = productName;
    }

    public boolean isNexusGenerated() {
        return this.productName == null || this.productName.equals(NEXUS_PRODUCT_NAME);
    }

    String getProductVersion() {
        return this.productVersion;
    }

    void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public List<SearchClause> getSearchClauses() {
        return this.searchClauses;
    }

    void setSearchClauses(List<SearchClause> searchClauses) {
        this.searchClauses = searchClauses;
    }

    void addSearchClause(SearchClause searchClause) {
        searchClause.setSearchDefinition(this);
        this.searchClauses.add(searchClause);
    }

    public SearchClause getSearchClause(SearchTemplate.ObjectType objectType) {
        SearchClause searchClause = null;
        for (SearchClause sc : this.searchClauses) {
            if (!sc.getFrom().equals((Object)objectType)) continue;
            searchClause = sc;
            break;
        }
        return searchClause;
    }

    String getSearchVersion() {
        return this.searchVersion;
    }

    void setSearchVersion(String searchVersion) {
        this.searchVersion = searchVersion;
    }

    boolean isShowAndOrConditions() {
        return this.showAndOrConditions;
    }

    void setShowAndOrConditions(boolean showAndOrConditions) {
        this.showAndOrConditions = showAndOrConditions;
    }

    void setShowAndOrConditions(String showAndOrConditions) {
        this.showAndOrConditions = Boolean.valueOf(showAndOrConditions);
    }

    boolean isShowMaxRecords() {
        return this.showMaxRecords;
    }

    void setShowMaxRecords(boolean showMaxRecords) {
        this.showMaxRecords = showMaxRecords;
    }

    void setShowMaxRecords(String showMaxRecords) {
        this.showMaxRecords = Boolean.valueOf(showMaxRecords);
    }

    boolean isShowOperators() {
        return this.showOperators;
    }

    void setShowOperators(boolean showOperators) {
        this.showOperators = showOperators;
    }

    void setShowOperators(String showOperators) {
        this.showOperators = Boolean.valueOf(showOperators);
    }

    public SearchTemplate.VersionOption getVersionSelection() {
        return this.versionSelection;
    }

    void setVersionSelection(String versionSelection) {
        this.versionSelection = versionSelection == null ? null : SearchTemplate.VersionOption.valueOf(versionSelection);
    }

    boolean isVersionSelectionAll() {
        return this.versionSelection != null && this.versionSelection.equals((Object)SearchTemplate.VersionOption.allversions);
    }

    boolean isVersionSelectionReleased() {
        return this.versionSelection != null && this.versionSelection.equals((Object)SearchTemplate.VersionOption.releasedversion);
    }

    boolean isVersionSelectionCurrent() {
        return this.versionSelection != null && this.versionSelection.equals((Object)SearchTemplate.VersionOption.currentversion);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("(dtdVersion = ").append(this.dtdVersion);
        str.append(", searchVersion = ").append(this.searchVersion);
        str.append(", productName = ").append(this.productName);
        str.append(", productVersion = ").append(this.productVersion);
        str.append(", versionSelection = ").append((Object)this.versionSelection);
        str.append(", showAndOrConditions = ").append(this.showAndOrConditions);
        str.append(", showMaxRecords = ").append(this.showMaxRecords);
        str.append(", showOperators = ").append(this.showOperators);
        str.append(", mergeOption = ").append(this.mergeOption);
        str.append(", maxRecords = ").append(this.maxRecords);
        str.append(", ").append(NEW_LINE).append("OBJECTSTORES = ").append(this.objectStores);
        str.append(", ").append(NEW_LINE).append("FOLDERS = ").append(this.folders);
        str.append(", ").append(NEW_LINE).append("SEARCHCLAUSES = ").append(this.searchClauses).append(")");
        return str.toString();
    }

    public static class Subclass {
        private String symbolicName;
        private String displayName;
        private SearchTemplate.ObjectType objectType;
        private SearchFieldOption view;
        private String itemId;
        private boolean searchSubclasses;

        Subclass() {
        }

        Subclass(String symbolicName, String displayName, String objectType, String view) {
            this.symbolicName = symbolicName;
            this.displayName = displayName;
            this.objectType = objectType == null ? null : SearchTemplate.ObjectType.valueOf(objectType);
            this.view = view == null ? null : SearchFieldOption.valueOf(view);
        }

        String getItemId() {
            return this.itemId;
        }

        void setItemId(String itemId) {
            this.itemId = itemId;
        }

        String getDisplayName() {
            return this.displayName;
        }

        void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        SearchTemplate.ObjectType getObjectType() {
            return this.objectType;
        }

        void setObjectType(String objectType) {
            this.objectType = objectType == null ? null : SearchTemplate.ObjectType.valueOf(objectType);
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }

        void setSymbolicName(String symbolicName) {
            this.symbolicName = symbolicName;
        }

        SearchFieldOption getView() {
            return this.view;
        }

        void setView(String view) {
            this.view = view == null ? null : SearchFieldOption.valueOf(view);
        }

        boolean isHidden() {
            return this.view != null && this.view.equals((Object)SearchFieldOption.hidden);
        }

        boolean isReadOnly() {
            return this.view != null && this.view.equals((Object)SearchFieldOption.readonly);
        }

        boolean isSearchSubclasses() {
            return this.searchSubclasses;
        }

        void setSearchSubclasses(boolean searchSubclasses) {
            this.searchSubclasses = searchSubclasses;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(symbolicName = ").append(this.symbolicName);
            str.append(", displayName = ").append(this.displayName);
            str.append(", objectType = ").append((Object)this.objectType);
            str.append(", view = ").append((Object)this.view);
            str.append(", itemId = ").append(this.itemId);
            str.append(", searchSubclasses = ").append(this.searchSubclasses).append(")");
            return str.toString();
        }
    }

    public static class VerityClauseVQLItem
    extends ContentClauseItem {
        private String vql;

        VerityClauseVQLItem() {
        }

        VerityClauseVQLItem(String vql) {
            this.vql = vql;
        }

        public String getVql() {
            return this.vql;
        }

        void setVql(String vql) {
            this.vql = vql;
        }

        public String toString() {
            return "(vql = " + this.vql + ")";
        }
    }

    public static class VerityClauseInItem
    extends ContentClauseItem {
        private String zone;

        VerityClauseInItem() {
        }

        VerityClauseInItem(String zone) {
            this.zone = zone;
        }

        public String getZone() {
            return this.zone;
        }

        void setZone(String zone) {
            this.zone = zone;
        }

        public String toString() {
            return "(zone = " + this.zone + ")";
        }
    }

    public static class ContentTerm {
        private String value;
        private VeritySearchOperator wordVariation;
        private boolean caseSensitive;
        private boolean prohibited;
        private boolean phrase;

        ContentTerm() {
        }

        ContentTerm(String value, String wordVariation, boolean caseSensitive, boolean prohibited, boolean phrase) {
            this.setValue(value);
            this.setWordVariation(wordVariation);
            this.setCaseSensitive(caseSensitive);
            this.setProhibited(prohibited);
            this.setPhrase(phrase);
        }

        public String getValue() {
            return this.value;
        }

        void setValue(String value) {
            this.value = value;
        }

        public VeritySearchOperator getWordVariation() {
            return this.wordVariation;
        }

        void setWordVariation(String wordVariation) {
            this.wordVariation = wordVariation == null ? null : VeritySearchOperator.valueOf(wordVariation);
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public boolean isProhibited() {
            return this.prohibited;
        }

        void setProhibited(boolean prohibit) {
            this.prohibited = prohibit;
        }

        public boolean isPhrase() {
            return this.phrase;
        }

        void setPhrase(boolean phrase) {
            this.phrase = phrase;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(value = ").append(this.value);
            str.append(", wordVariation = ").append((Object)this.wordVariation);
            str.append(", caseSensitive = ").append(this.caseSensitive);
            str.append(", prohibit = ").append(this.prohibited);
            str.append(", phrase = ").append(this.phrase).append(")");
            return str.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContentClauseItem
    implements ContentClause {
        private GroupAction groupAction;
        private SearchModifier searchModifier;
        private int searchModifierRange;
        private RequiredState requiredState;
        private String userText;
        private List<ContentTerm> contentTerms = new ArrayList<ContentTerm>();
        private String itemId;
        private SearchFieldOption view;
        private SearchClause searchClause;

        ContentClauseItem() {
        }

        ContentClauseItem(String groupAction, String userText, String view) {
            this.groupAction = groupAction == null ? null : GroupAction.valueOf(groupAction);
            this.userText = userText;
            this.view = view == null ? null : SearchFieldOption.valueOf(view);
        }

        @Override
        public boolean isContainer() {
            return false;
        }

        String getItemId() {
            return this.itemId;
        }

        void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public GroupAction getGroupAction() {
            return this.groupAction;
        }

        void setGroupAction(String groupAction) {
            this.groupAction = groupAction == null ? null : GroupAction.valueOf(groupAction);
        }

        boolean isGroupActionAll() {
            return this.groupAction != null && this.groupAction == GroupAction.all;
        }

        boolean isGroupActionAny() {
            return this.groupAction != null && this.groupAction == GroupAction.any;
        }

        boolean isGroupActionVql() {
            return this.groupAction != null && this.groupAction == GroupAction.vql;
        }

        boolean isGroupActionNear() {
            return this.groupAction != null && this.groupAction == GroupAction.near;
        }

        SearchModifier getSearchModifier() {
            return this.searchModifier;
        }

        void setSearchModifier(String searchModifier) {
            this.searchModifier = searchModifier == null ? null : SearchModifier.valueOf(searchModifier);
        }

        boolean isSearchModifierProximity() {
            return this.searchModifier != null && this.searchModifier.equals((Object)SearchModifier.proximity);
        }

        int getSearchModifierRange() {
            return this.searchModifierRange;
        }

        void setSearchModifierRange(int searchModifierRange) {
            this.searchModifierRange = searchModifierRange;
        }

        RequiredState getRequiredState() {
            return this.requiredState;
        }

        void setRequiredState(String requiredState) {
            this.requiredState = requiredState == null ? null : RequiredState.valueOf(requiredState);
        }

        boolean isRequiredStateProhibited() {
            return this.requiredState != null && this.requiredState.equals((Object)RequiredState.prohibited);
        }

        public List<ContentTerm> getContentTerms() {
            return this.contentTerms;
        }

        void setContentTerms(List<ContentTerm> contentTerms) {
            this.contentTerms = contentTerms;
        }

        void addContentTerm(ContentTerm contentTerm) {
            this.contentTerms.add(contentTerm);
        }

        String getUserText() {
            return this.userText;
        }

        void setUserText(String userText) {
            this.userText = userText;
        }

        boolean isCascade() {
            return this.searchClause.getContentCriteria().isCascade();
        }

        SearchFieldOption getView() {
            return this.view;
        }

        void setView(String view) {
            this.view = view == null ? null : SearchFieldOption.valueOf(view);
        }

        boolean isHidden() {
            return this.view != null && this.view == SearchFieldOption.hidden;
        }

        boolean isReadOnly() {
            return this.view != null && this.view == SearchFieldOption.readonly;
        }

        boolean isRequired() {
            return this.view != null && this.view == SearchFieldOption.required;
        }

        SearchClause getSearchClause() {
            return this.searchClause;
        }

        void setSearchClause(SearchClause searchClause) {
            this.searchClause = searchClause;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(groupAction = ").append((Object)this.groupAction);
            str.append(", searchModifier = ").append((Object)this.searchModifier);
            str.append(", searchModifierRange = ").append(this.searchModifierRange);
            str.append(", requiredState = ").append((Object)this.requiredState);
            str.append(", userText = ").append(this.userText);
            str.append(", contentTerms = ").append(this.contentTerms);
            str.append(", itemId = ").append(this.itemId);
            str.append(", view = ").append((Object)this.view).append(")");
            return str.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContentClauseContainer
    extends Container
    implements ContentClause {
        private List<ContentClause> contentClauses = new ArrayList<ContentClause>();

        ContentClauseContainer() {
        }

        ContentClauseContainer(Operator join) {
            super(join);
        }

        @Override
        public boolean isContainer() {
            return true;
        }

        public List<ContentClause> getContentClauses() {
            return this.contentClauses;
        }

        void setContentClauses(List<ContentClause> contentClauses) {
            this.contentClauses = contentClauses;
        }

        void addClause(Clause contentClause) {
            this.contentClauses.add((ContentClause)contentClause);
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(join = ").append((Object)this.getJoin());
            str.append(", ").append(NEW_LINE).append("    contentClauses = ").append(this.contentClauses).append(")");
            return str.toString();
        }
    }

    public static class ContentCriteria {
        private String dialect;
        private JoinType join;
        private boolean showContentSummary;
        private boolean showRank;
        private ContentClause contentClause;
        private SearchClause searchClause;
        private boolean cascade;

        ContentCriteria() {
        }

        ContentCriteria(String dialect, String join, boolean showContentSummary, boolean showRank, boolean cascade) {
            this.dialect = dialect;
            this.join = join == null ? null : JoinType.valueOf(join);
            this.showContentSummary = showContentSummary;
            this.showRank = showRank;
            this.cascade = cascade;
        }

        String getDialect() {
            return this.dialect;
        }

        void setDialect(String dialect) {
            this.dialect = dialect;
        }

        public JoinType getJoin() {
            return this.join;
        }

        void setJoin(String join) {
            this.join = join == null ? null : JoinType.valueOf(join);
        }

        public boolean isShowContentSummary() {
            return this.showContentSummary;
        }

        void setShowContentSummary(boolean showContentSummary) {
            this.showContentSummary = showContentSummary;
        }

        void setShowContentSummary(String showContentSummary) {
            this.showContentSummary = Boolean.valueOf(showContentSummary);
        }

        public boolean isShowRank() {
            return this.showRank;
        }

        void setShowRank(boolean showRank) {
            this.showRank = showRank;
        }

        void setShowRank(String showRank) {
            this.showRank = Boolean.valueOf(showRank);
        }

        public ContentClause getContentClause() {
            return this.contentClause;
        }

        void setContentClause(ContentClause contentClause) {
            this.contentClause = contentClause;
        }

        SearchClause getSearchClause() {
            return this.searchClause;
        }

        void setSearchClause(SearchClause searchClause) {
            this.searchClause = searchClause;
        }

        public boolean isCascade() {
            return this.cascade;
        }

        void setCascade(boolean cascade) {
            this.cascade = cascade;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(dialect = ").append(this.dialect);
            str.append(", join = ").append((Object)this.join);
            str.append(", showContentSummary = ").append(this.showContentSummary);
            str.append(", showRank = ").append(this.showRank);
            str.append(", contentClause = ").append(this.contentClause);
            str.append(", cascade = ").append(this.cascade).append(")");
            return str.toString();
        }
    }

    public static class WhereClauseCondition
    implements WhereClause {
        private Operator operator;
        private String propSymbolicName;
        private String propName;
        private SearchTemplate.ObjectType propObjectType;
        private DataType propDataType;
        private boolean propHasChoices;
        private String propChoiceId;
        private boolean propHasMarkings;
        private SearchFieldOption view;
        private String literal;
        private String itemId;
        private SearchClause searchClause;
        private boolean valid = true;
        private Operator smartOperator;

        WhereClauseCondition() {
        }

        WhereClauseCondition(String operator, String propSymbolicName, String propName, String propObjectType, String propDataType, boolean propHasChoices, String propChoiceId, boolean propHasMarkings, String view, String literal) {
            this.operator = operator == null ? null : Operator.valueOf(operator);
            this.propSymbolicName = propSymbolicName;
            this.propName = propName;
            this.propObjectType = propObjectType == null ? null : SearchTemplate.ObjectType.valueOf(propObjectType);
            this.propDataType = propDataType == null ? null : DataType.valueOf(propDataType);
            this.propHasChoices = propHasChoices;
            this.propChoiceId = propChoiceId;
            this.propHasMarkings = propHasMarkings;
            this.view = view == null ? null : SearchFieldOption.valueOf(view);
            this.literal = literal;
        }

        public boolean isContainer() {
            return false;
        }

        String getItemId() {
            return this.itemId;
        }

        void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public String getLiteral() {
            return this.literal;
        }

        void setLiteral(String literal) {
            this.literal = literal;
        }

        public Operator getOperator() {
            return this.operator;
        }

        void setOperator(String operator) {
            this.operator = operator == null ? null : Operator.valueOf(operator);
        }

        boolean isOperatorNullOrNotNull() {
            return this.operator != null && (this.operator == Operator.isnull || this.operator == Operator.isnotnull);
        }

        public DataType getPropDataType() {
            return this.propDataType;
        }

        void setPropDataType(String propDataType) {
            this.propDataType = propDataType == null ? null : DataType.valueOf(propDataType);
        }

        boolean isPropHasChoices() {
            return this.propHasChoices;
        }

        void setPropHasChoices(boolean propHasChoices) {
            this.propHasChoices = propHasChoices;
        }

        String getPropChoiceId() {
            return this.propChoiceId;
        }

        void setPropChoiceId(String propChoiceId) {
            this.propChoiceId = propChoiceId;
        }

        boolean isPropHasMarkings() {
            return this.propHasMarkings;
        }

        void setPropHasMarkings(boolean propHasMarkings) {
            this.propHasMarkings = propHasMarkings;
        }

        String getPropName() {
            return this.propName;
        }

        void setPropName(String propName) {
            this.propName = propName;
        }

        SearchTemplate.ObjectType getPropObjectType() {
            return this.propObjectType;
        }

        void setPropObjectType(String propObjectType) {
            this.propObjectType = propObjectType == null ? null : SearchTemplate.ObjectType.valueOf(propObjectType);
        }

        public String getPropSymbolicName() {
            return this.propSymbolicName;
        }

        void setPropSymbolicName(String propSymbolicName) {
            this.propSymbolicName = propSymbolicName;
        }

        SearchFieldOption getView() {
            return this.view;
        }

        void setView(String view) {
            this.view = view == null ? null : SearchFieldOption.valueOf(view);
        }

        boolean isHidden() {
            return this.view != null && this.view == SearchFieldOption.hidden;
        }

        boolean isReadOnly() {
            return this.view != null && this.view == SearchFieldOption.readonly;
        }

        boolean isRequired() {
            return this.view != null && this.view == SearchFieldOption.required;
        }

        SearchClause getSearchClause() {
            return this.searchClause;
        }

        void setSearchClause(SearchClause searchClause) {
            this.searchClause = searchClause;
        }

        boolean isValid() {
            return this.valid;
        }

        void setValid(boolean valid) {
            this.valid = valid;
        }

        public Operator getSmartOperator() {
            return this.smartOperator;
        }

        void setSmartOperator(String smartOperator) {
            this.smartOperator = smartOperator == null ? null : Operator.valueOf(smartOperator);
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(operator = ").append((Object)this.operator);
            str.append(", propSymbolicName = ").append(this.propSymbolicName);
            str.append(", propName = ").append(this.propName);
            str.append(", propObjectType = ").append((Object)this.propObjectType);
            str.append(", propDataType = ").append((Object)this.propDataType);
            str.append(", propHasChoices = ").append(this.propHasChoices);
            str.append(", propChoiceId = ").append(this.propChoiceId);
            str.append(", propHasMarkings = ").append(this.propHasMarkings);
            str.append(", view = ").append((Object)this.view);
            str.append(", literal = ").append(this.literal);
            str.append(", itemId = ").append(this.itemId);
            str.append(", valid = ").append(this.valid).append(")");
            return str.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WhereClauseContainer
    extends Container
    implements WhereClause {
        private List<WhereClause> whereClauses = new ArrayList<WhereClause>();

        WhereClauseContainer() {
        }

        WhereClauseContainer(String join) {
            super(join == null ? null : Operator.valueOf(join));
        }

        @Override
        public boolean isContainer() {
            return true;
        }

        public List<WhereClause> getWhereClauses() {
            return this.whereClauses;
        }

        void setWhereClauses(List<WhereClause> whereClauses) {
            this.whereClauses = whereClauses;
        }

        void addClause(Clause whereClause) {
            this.whereClauses.add((WhereClause)whereClause);
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(join = ").append((Object)this.getJoin());
            str.append(", ").append(NEW_LINE).append("    whereClauses = ").append(this.whereClauses).append(")");
            return str.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Container<T extends Clause>
    implements Clause {
        private Operator join;
        private SearchClause searchClause;

        Container() {
        }

        Container(Operator join) {
            this.join = join;
        }

        @Override
        public abstract boolean isContainer();

        abstract void addClause(T var1);

        public Operator getJoin() {
            return this.join;
        }

        void setJoin(Operator join) {
            this.join = join;
        }

        SearchClause getSearchClause() {
            return this.searchClause;
        }

        void setSearchClause(SearchClause searchClause) {
            this.searchClause = searchClause;
        }
    }

    public static interface ContentClause
    extends Clause {
    }

    public static interface WhereClause
    extends Clause {
    }

    static interface Clause {
        public boolean isContainer();
    }

    public static class SelectProperty {
        private String queryName;
        private String displayName;
        private SearchTemplate.ObjectType objectType;
        private int sortLevel;
        private String sortOrder;
        private String alignment;
        private String itemId;
        private SearchClause searchClause;

        SelectProperty() {
        }

        SelectProperty(String queryName, String displayName, String objectType, int sortLevel, String sortOrder, String alignment) {
            this.queryName = queryName;
            this.displayName = displayName;
            this.objectType = objectType == null ? null : SearchTemplate.ObjectType.valueOf(objectType);
            this.sortLevel = sortLevel;
            this.sortOrder = sortOrder;
            this.alignment = alignment;
        }

        String getAlignment() {
            return this.alignment;
        }

        void setAlignment(String alignment) {
            this.alignment = alignment;
        }

        String getItemId() {
            return this.itemId;
        }

        void setItemId(String itemId) {
            this.itemId = itemId;
        }

        String getDisplayName() {
            return this.displayName;
        }

        void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        SearchTemplate.ObjectType getObjectType() {
            return this.objectType;
        }

        void setObjectType(String objectType) {
            this.objectType = objectType == null ? null : SearchTemplate.ObjectType.valueOf(objectType);
        }

        public int getSortLevel() {
            return this.sortLevel;
        }

        void setSortLevel(int sortLevel) {
            this.sortLevel = sortLevel;
        }

        public String getSortOrder() {
            return this.sortOrder;
        }

        void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        boolean isSortOrderDescending() {
            return this.sortOrder != null && this.sortOrder.equals((Object)SortOrder.descending);
        }

        public String getQueryName() {
            return this.queryName;
        }

        void setQueryName(String queryName) {
            this.queryName = queryName;
        }

        SearchClause getSearchClause() {
            return this.searchClause;
        }

        void setSearchClause(SearchClause searchClause) {
            this.searchClause = searchClause;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(queryName = ").append(this.queryName);
            str.append(", displayName = ").append(this.displayName);
            str.append(", objectType = ").append((Object)this.objectType);
            str.append(", sortLevel = ").append(this.sortLevel);
            str.append(", sortOrder = ").append(this.sortOrder);
            str.append(", alignment = ").append(this.alignment);
            str.append(", itemId = ").append(this.itemId).append(")");
            return str.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchClause {
        private List<SelectProperty> selectProperties = new ArrayList<SelectProperty>();
        private SearchTemplate.ObjectType from;
        private WhereClause whereClause;
        private ContentCriteria contentCriteria;
        private List<Subclass> subclasses = new ArrayList<Subclass>();
        private Map<String, WhereClauseCondition> whereConditions = new HashMap<String, WhereClauseCondition>();
        private Map<String, ContentClauseItem> contentClauseItems = new HashMap<String, ContentClauseItem>();
        private CMISSearchDefinition searchDefinition;

        SearchClause() {
        }

        boolean isSortingDefined() {
            Map<String, SelectProperty> sortProps = this.getSortedProperties(this.selectProperties);
            return sortProps != null && sortProps.size() > 0;
        }

        SearchClause(String from) {
            this.from = from == null ? null : SearchTemplate.ObjectType.valueOf(from);
        }

        public SearchTemplate.ObjectType getFrom() {
            return this.from;
        }

        void setFrom(String from) {
            this.from = from == null ? null : SearchTemplate.ObjectType.valueOf(from);
        }

        public List<SelectProperty> getSelectProperties() {
            return this.selectProperties;
        }

        SelectProperty getSelectProperty(String propertyName) {
            if (propertyName.startsWith("[")) {
                propertyName = propertyName.substring(1, propertyName.length() - 1);
            }
            SelectProperty selectProp = null;
            for (SelectProperty sp : this.selectProperties) {
                if (!sp.getQueryName().equals(propertyName)) continue;
                selectProp = sp;
                break;
            }
            return selectProp;
        }

        void setSelectProperties(List<SelectProperty> selectProperties) {
            this.selectProperties = selectProperties;
        }

        void addSelectProperty(SelectProperty selectProperty) {
            selectProperty.setSearchClause(this);
            this.selectProperties.add(selectProperty);
        }

        public List<Subclass> getSubclasses() {
            return this.subclasses;
        }

        void setSubclasses(List<Subclass> subclasses) {
            this.subclasses = subclasses;
        }

        void addSubclass(Subclass subclass) {
            this.subclasses.add(subclass);
        }

        public ContentCriteria getContentCriteria() {
            return this.contentCriteria;
        }

        void setContentCriteria(ContentCriteria contentCriteria) {
            this.contentCriteria = contentCriteria;
        }

        public WhereClause getWhereClause() {
            return this.whereClause;
        }

        void setWhereClause(WhereClause whereClause) {
            this.whereClause = whereClause;
        }

        WhereClauseCondition getWhereClauseCondition(String itemId) {
            return this.whereConditions.get(itemId);
        }

        void putWhereClauseCondition(String itemId, WhereClauseCondition wcc) {
            this.whereConditions.put(itemId, wcc);
        }

        Map<String, WhereClauseCondition> getWhereClauseConditions() {
            return this.whereConditions;
        }

        ContentClauseItem getContentClauseItem(String itemId) {
            return this.contentClauseItems.get(itemId);
        }

        void putContentClauseItem(String itemId, ContentClauseItem contentClauseItem) {
            this.contentClauseItems.put(itemId, contentClauseItem);
        }

        Map<String, ContentClauseItem> getContentClauseItems() {
            return this.contentClauseItems;
        }

        boolean isContentCriteriaDefined() {
            if (this.contentCriteria == null) {
                return false;
            }
            boolean defined = false;
            Set<String> itemIds = this.contentClauseItems.keySet();
            for (String itemId : itemIds) {
                ContentClauseItem item = this.contentClauseItems.get(itemId);
                String text = item.getUserText();
                if (text == null || text.length() <= 0) continue;
                defined = true;
                break;
            }
            return defined;
        }

        CMISSearchDefinition getSearchDefinition() {
            return this.searchDefinition;
        }

        void setSearchDefinition(CMISSearchDefinition searchDefinition) {
            this.searchDefinition = searchDefinition;
        }

        Map<String, SelectProperty> getSortedProperties(List<SelectProperty> selectProps) {
            if (selectProps == null || selectProps.size() < 1) {
                return null;
            }
            TreeMap<String, SelectProperty> sortProps = new TreeMap<String, SelectProperty>();
            for (SelectProperty selectProp : selectProps) {
                int sl = selectProp.getSortLevel();
                if (sl <= 0) continue;
                String sortLevel = String.valueOf(sl);
                sortProps.put(sortLevel, selectProp);
            }
            return sortProps;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(").append(NEW_LINE).append("SELECTCLAUSE = ").append(this.selectProperties);
            str.append(", ").append(NEW_LINE).append("FROMCLAUSE = ").append((Object)this.from);
            str.append(", ").append(NEW_LINE).append("SUBCLASSES = ").append(this.subclasses);
            str.append(", ").append(NEW_LINE).append("WHERECLAUSE = ").append(this.whereClause);
            str.append(", ").append(NEW_LINE).append("CONTENTCLAUSE = ").append(this.contentCriteria).append(")");
            return str.toString();
        }
    }

    public static class SearchInFolder {
        private String id;
        private String pathName;
        private boolean searchSubfolders;
        private String itemId;
        private SearchFieldOption view;
        private String objectStoreId;

        SearchInFolder() {
        }

        SearchInFolder(String id, String pathName, boolean searchSubfolders, String view, String objectStoreId) {
            this.id = id;
            this.pathName = pathName;
            this.searchSubfolders = searchSubfolders;
            this.view = view == null ? null : SearchFieldOption.valueOf(view);
            this.objectStoreId = objectStoreId;
        }

        public String getId() {
            return this.id;
        }

        void setId(String id) {
            this.id = id;
        }

        String getItemId() {
            return this.itemId;
        }

        void setItemId(String itemId) {
            this.itemId = itemId;
        }

        String getObjectStoreId() {
            return this.objectStoreId;
        }

        void setObjectStoreId(String objectStoreId) {
            this.objectStoreId = objectStoreId;
        }

        String getPathName() {
            return this.pathName;
        }

        void setPathName(String pathName) {
            this.pathName = pathName;
        }

        public boolean isSearchSubfolders() {
            return this.searchSubfolders;
        }

        void setSearchSubfolders(boolean searchSubfolders) {
            this.searchSubfolders = searchSubfolders;
        }

        SearchFieldOption getView() {
            return this.view;
        }

        void setView(String view) {
            this.view = view == null ? null : SearchFieldOption.valueOf(view);
        }

        boolean isHidden() {
            return this.view != null && this.view == SearchFieldOption.hidden;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(id = ").append(this.id);
            str.append(", pathName = ").append(this.pathName);
            str.append(", searchSubfolders = ").append(this.searchSubfolders);
            str.append(", itemId = ").append(this.itemId);
            str.append(", view = ").append((Object)this.view);
            str.append(", objectStoreId = ").append(this.objectStoreId).append(")");
            return str.toString();
        }
    }

    static class SearchInObjectStore {
        private String id;
        private String name;

        SearchInObjectStore() {
        }

        SearchInObjectStore(String id, String name) {
            this.id = id;
            this.name = name;
        }

        String getId() {
            return this.id;
        }

        void setId(String id) {
            this.id = id;
        }

        String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("(id = ").append(this.id);
            str.append(", name = ").append(this.name).append(")");
            return str.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VeritySearchOperator {
        soundex,
        stem,
        thesaurus,
        wildcard,
        word,
        none;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        and,
        commonplaceholder,
        eq,
        gt,
        gte,
        in,
        inany,
        notany,
        any,
        all,
        isnotnull,
        isnull,
        like,
        lt,
        lte,
        neq,
        notin,
        notlike,
        or,
        between,
        notbetween,
        startswith,
        endswith;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CbrColumn {
        rank,
        contentsummary;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JoinType {
        inner,
        leftouter,
        fullouter;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchModifier {
        proximity,
        boost,
        fuzzy;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequiredState {
        prohibited,
        required,
        none;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GroupAction {
        all,
        any,
        near,
        none,
        paragraph,
        sentence,
        in,
        vql;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataType {
        typestring,
        typeobject,
        typedate,
        typebinary,
        typeboolean,
        typedouble,
        typeguid,
        typelong;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchFieldOption {
        editable,
        hidden,
        required,
        readonly;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortOrder {
        ascending,
        descending,
        none;

    }
}

