/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cmis;

import java.util.ArrayList;
import java.util.List;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumPropertiesBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISQueryUtil {
    public static CmisObject convertQueryResultToCmisObject(QueryResult queryResult, Session session, OperationContext operationContext) {
        String id = (String)queryResult.getPropertyValueById(EnumPropertiesBase.CMIS_OBJECT_ID.value());
        CmisObject cmisObject = null;
        cmisObject = operationContext == null ? session.getObject(id) : session.getObject(id, operationContext);
        return cmisObject;
    }

    public static List<CmisObject> convertQueryResults(List queryResults, Session session, OperationContext operationContext) {
        ArrayList<CmisObject> objects = new ArrayList<CmisObject>();
        try {
            for (Object queryResult : queryResults) {
                QueryResult result = (QueryResult)queryResult;
                objects.add(CMISQueryUtil.convertQueryResultToCmisObject(result, session, operationContext));
            }
        }
        catch (ClassCastException e) {
            for (Object queryResult : queryResults) {
                objects.add((CmisObject)queryResult);
            }
        }
        return objects;
    }
}

