/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cmis;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class CMISQueryContinuationData {
    private static final String SALT = "za1uve3uzera2evu41pr";
    public boolean isWorkBasketData = false;
    public String serverName;
    public String sessionKey;
    public String documentSQL;
    public String folderSQL;
    public boolean returnOnlyFolders;
    public boolean descending;
    public String folderId;
    public long itemsToSkip;
    public String applicationSpaceName;
    public String processRoleName;
    public String queueName;
    public String inbasketName;
    public String lastWorkRecord;
    public String orderBy;

    public CMISQueryContinuationData(String serializedForm, boolean isWorkBasketData) throws UnsupportedEncodingException {
        this.isWorkBasketData = isWorkBasketData;
        String[] parts = StringUtils.splitPreserveAllTokens((String)serializedForm, (char)'*');
        this.sessionKey = CMISQueryContinuationData.dec(parts[0]);
        String checksum = "";
        if (isWorkBasketData) {
            this.applicationSpaceName = CMISQueryContinuationData.dec(parts[1]);
            this.processRoleName = CMISQueryContinuationData.dec(parts[2]);
            this.queueName = CMISQueryContinuationData.dec(parts[3]);
            this.inbasketName = CMISQueryContinuationData.dec(parts[4]);
            this.lastWorkRecord = CMISQueryContinuationData.dec(parts[5]);
            this.orderBy = CMISQueryContinuationData.dec(parts[6]);
            this.descending = CMISQueryContinuationData.decBool(parts[7]);
            checksum = parts[8];
        } else {
            this.documentSQL = CMISQueryContinuationData.dec(parts[1]);
            this.folderSQL = CMISQueryContinuationData.dec(parts[2]);
            this.returnOnlyFolders = CMISQueryContinuationData.decBool(parts[3]);
            this.descending = CMISQueryContinuationData.decBool(parts[4]);
            this.folderId = CMISQueryContinuationData.dec(parts[5]);
            this.itemsToSkip = Integer.parseInt(parts[6]);
            this.serverName = CMISQueryContinuationData.dec(parts[7]);
            checksum = parts[8];
        }
        String calculatedChecksum = this.calculateChecksum();
        if (!StringUtils.equals((String)checksum, (String)calculatedChecksum)) {
            throw new RuntimeException("Invalid checksum!");
        }
    }

    public CMISQueryContinuationData() {
    }

    public String saveToString() throws UnsupportedEncodingException {
        String checksum = this.calculateChecksum();
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(CMISQueryContinuationData.enc(this.sessionKey));
        if (this.isWorkBasketData) {
            parts.add(CMISQueryContinuationData.enc(this.applicationSpaceName));
            parts.add(CMISQueryContinuationData.enc(this.processRoleName));
            parts.add(CMISQueryContinuationData.enc(this.queueName));
            parts.add(CMISQueryContinuationData.enc(this.inbasketName));
            parts.add(CMISQueryContinuationData.enc(this.lastWorkRecord));
            parts.add(CMISQueryContinuationData.enc(this.orderBy));
            parts.add(CMISQueryContinuationData.enc(this.descending));
        } else {
            parts.add(CMISQueryContinuationData.enc(this.documentSQL));
            parts.add(CMISQueryContinuationData.enc(this.folderSQL));
            parts.add(CMISQueryContinuationData.enc(this.returnOnlyFolders));
            parts.add(CMISQueryContinuationData.enc(this.descending));
            parts.add(CMISQueryContinuationData.enc(this.folderId));
            parts.add(Long.toString(this.itemsToSkip));
            parts.add(CMISQueryContinuationData.enc(this.serverName));
        }
        parts.add(checksum);
        String result = StringUtils.join(parts, (char)'*');
        return result;
    }

    private static String dec(String encoded) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty((String)encoded)) {
            return "";
        }
        return new String(Base64.decodeBase64((String)encoded), "UTF-8");
    }

    private static boolean decBool(String encoded) {
        return StringUtils.equals((String)encoded, (String)"1");
    }

    private static String enc(String str) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty((String)str)) {
            return "";
        }
        return Base64.encodeBase64String((byte[])str.getBytes("UTF-8")).trim();
    }

    private static String enc(boolean bool) {
        return bool ? "1" : "0";
    }

    private String calculateChecksum() {
        if (this.documentSQL == null) {
            this.documentSQL = "";
        }
        if (this.folderSQL == null) {
            this.folderSQL = "";
        }
        String str = SALT + this.sessionKey + this.documentSQL + this.folderSQL;
        byte[] checksumBytes = DigestUtils.sha256((String)str);
        String checksumString = Base64.encodeBase64String((byte[])checksumBytes).trim();
        return checksumString;
    }
}

