/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cmis;

import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.cmis.CMISConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.QueryResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISQuery {
    private static final int STRING_BUFFER_SIZE = 400;
    private static final int DEFAULT_PAGE_SIZE = 100;
    private Collection<String> subProperties;
    private Collection<String> requestedProperties;
    private String fromClause;
    private String whereClause;
    private String orderByClause;
    private CMISConnection session;
    private int pageSize = 100;
    private boolean addBracketsAroundSelectProperties = false;

    public void setAddBracketsAroundSelectProperties(boolean value) {
        this.addBracketsAroundSelectProperties = value;
    }

    public CMISConnection getSession() {
        return this.session;
    }

    public void setSession(CMISConnection session) {
        this.session = session;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getFromClause() {
        return this.fromClause;
    }

    public void setFromClause(String fromClause) {
        this.fromClause = fromClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public Collection<String> getRequestedProperties() {
        return this.requestedProperties;
    }

    public void setRequestedProperties(String ... props) {
        this.requestedProperties = new HashSet<String>();
        this.requestedProperties.addAll(new HashSet<String>(Arrays.asList(props)));
    }

    public void setRequestedProperties(Collection<String> props) {
        this.requestedProperties = props;
    }

    public Collection<String> getSubProperties() {
        return this.subProperties;
    }

    public void setSubProperties(Collection<String> subProperties) {
        this.subProperties = subProperties;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    public String generateSQL() {
        StringBuilder sql = new StringBuilder(400);
        sql.append("SELECT ");
        if (this.requestedProperties != null && this.requestedProperties.size() != 0) {
            Iterator<String> iterator = this.requestedProperties.iterator();
            while (iterator.hasNext()) {
                String prop = iterator.next();
                if (this.addBracketsAroundSelectProperties) {
                    sql.append('[');
                }
                sql.append(prop);
                if (this.addBracketsAroundSelectProperties) {
                    sql.append(']');
                }
                if (!iterator.hasNext()) continue;
                sql.append(", ");
            }
        } else {
            sql.append("*");
        }
        sql.append(" FROM ");
        sql.append(this.fromClause);
        if (this.whereClause != null && this.whereClause.length() != 0) {
            sql.append(" WHERE ");
            sql.append(this.whereClause);
        }
        if (this.orderByClause != null && this.orderByClause.length() != 0) {
            sql.append(" ORDER BY ");
            sql.append(this.orderByClause);
        }
        String sqlString = sql.toString();
        return sqlString;
    }

    public static ItemIterable<QueryResult> executeQueryAsObjectsIterator(HttpServletRequest request, CMISConnection connection, String sql, Collection<String> subProperties, int pageSize) {
        String methodName = "executeQueryAsObjectsIterator";
        Logger.logInfo(CMISQuery.class, methodName, (ServletRequest)request, "query = " + sql);
        OperationContext operationContext = connection.getOperationContext();
        operationContext.setMaxItemsPerPage(pageSize);
        connection.setOperationContext(operationContext);
        ItemIterable q = connection.getCMISSession().query(sql, false, operationContext);
        return q;
    }

    public ItemIterable<QueryResult> executeQueryAsObjectsIterator(HttpServletRequest request) {
        String sql = this.generateSQL();
        return CMISQuery.executeQueryAsObjectsIterator(request, this.session, sql, this.subProperties, this.pageSize);
    }

    public String toString() {
        return "(" + this.generateSQL() + ")";
    }
}

