/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cmis;

import com.ibm.ecm.util.cmis.CMISDefinitionUtil;
import com.ibm.ecm.util.cmis.CMISUtil;
import java.util.List;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDecimalDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIntegerDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyStringDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumPropertiesBase;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumUpdatability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISPropertyDefinition {
    private PropertyDefinition<?> propertyDefinition;
    private PropertyType propertyType;
    private Updatability updatability;

    public CMISPropertyDefinition(PropertyDefinition<?> pd) {
        this.propertyDefinition = pd;
        this.propertyType = pd.getPropertyType();
        this.updatability = pd.getUpdatability();
    }

    public PropertyDefinition<?> getPropertyDefinition() {
        return this.propertyDefinition;
    }

    public CMISPropertyDefinition(Property<?> property) {
        this(property.getDefinition());
    }

    public boolean isUpdatabilityReadOnly() {
        return this.updatability.value() == EnumUpdatability.READONLY.value();
    }

    public boolean isUpdatabilityWhenCheckedOut() {
        return this.updatability.value() == EnumUpdatability.WHENCHECKEDOUT.value();
    }

    public boolean isUpdatabilityOnCreate() {
        return this.updatability.value() == EnumUpdatability.ONCREATE.value();
    }

    public boolean isUpdatabilityReadWrite() {
        return this.updatability.value() == EnumUpdatability.READWRITE.value();
    }

    public boolean isHidden() {
        return CMISUtil.isPropertyHidden(this.propertyDefinition);
    }

    public boolean isNameProperty() {
        return this.propertyDefinition.getId().equals(EnumPropertiesBase.CMIS_NAME.value());
    }

    public boolean isOpenChoice() {
        boolean result = false;
        try {
            result = this.propertyDefinition.isOpenChoice();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String getDataType() {
        return CMISUtil.getDataType(this.propertyType);
    }

    public String getId() {
        return this.propertyDefinition.getId();
    }

    public String getLocalName() {
        return this.propertyDefinition.getLocalName();
    }

    public String getCardinality() {
        return this.propertyDefinition.getCardinality() == Cardinality.MULTI ? "LIST" : "SINGLE";
    }

    public boolean isRequired() {
        if (this.propertyDefinition.getId().equals(EnumPropertiesBase.CMIS_NAME.value())) {
            return true;
        }
        return this.propertyDefinition.isRequired();
    }

    public String getDisplayName() {
        return this.propertyDefinition.getDisplayName();
    }

    public String getDescription() {
        return this.propertyDefinition.getDescription();
    }

    public String getMinValue() {
        PropertyIntegerDefinition pdInteger32;
        PropertyDecimalDefinition pdFloat64;
        String minValue = this.propertyDefinition instanceof PropertyDecimalDefinition ? ((pdFloat64 = (PropertyDecimalDefinition)this.propertyDefinition).getMinValue() != null ? pdFloat64.getMinValue().toString() : "4.9E-324") : (this.propertyDefinition instanceof PropertyIntegerDefinition ? ((pdInteger32 = (PropertyIntegerDefinition)this.propertyDefinition).getMinValue() != null ? pdInteger32.getMinValue().toString() : "-2147483648") : "");
        return minValue;
    }

    public String getMaxValue() {
        PropertyIntegerDefinition pdInteger32;
        PropertyDecimalDefinition pdFloat64;
        String maxValue = this.propertyDefinition instanceof PropertyDecimalDefinition ? ((pdFloat64 = (PropertyDecimalDefinition)this.propertyDefinition).getMaxValue() != null ? pdFloat64.getMaxValue().toString() : "1.7976931348623157E308") : (this.propertyDefinition instanceof PropertyIntegerDefinition ? ((pdInteger32 = (PropertyIntegerDefinition)this.propertyDefinition).getMaxValue() != null ? pdInteger32.getMaxValue().toString() : "2147483647") : "");
        return maxValue;
    }

    public String getMaxLength() {
        PropertyStringDefinition pdString;
        String maxEntry = "";
        if (this.propertyDefinition instanceof PropertyStringDefinition && (pdString = (PropertyStringDefinition)this.propertyDefinition).getMaxLength() != null) {
            maxEntry = pdString.getMaxLength().toString();
        }
        return maxEntry;
    }

    public String[] getChoiceListAsArray() {
        return CMISDefinitionUtil.getChoiceListAsArray(this.propertyDefinition);
    }

    public String getDefaultValue() {
        List vals = this.propertyDefinition.getDefaultValue();
        return vals == null || vals.size() == 0 ? "" : vals.get(0).toString();
    }

    public String getQueryName() {
        return this.propertyDefinition.getQueryName();
    }

    public boolean isSystemProperty() {
        if (this.getId().equals(EnumPropertiesBase.CMIS_NAME.value())) {
            return false;
        }
        return this.getId().startsWith("cmis");
    }

    public Object isOrderable() {
        return this.propertyDefinition.isOrderable();
    }

    public String[] getValidValues() {
        return new String[0];
    }
}

