/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cmis;

import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.cmis.CMISCreateObject;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.commons.definitions.PropertyBooleanDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDateTimeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDecimalDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyHtmlDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIdDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIntegerDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyStringDefinition;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISPropertiesUtils {
    public static Object getValue(Property<?> property) {
        Object value;
        if (property.isMultiValued()) {
            String methodName = "getValue";
            List list = property.getValues();
            int numValues = list.size();
            String[] valuesArray = new String[numValues];
            int i = 0;
            for (Object v : list) {
                valuesArray[i++] = (String)CMISPropertiesUtils.convertCmisPropertyValueToNexusValue(v, property);
            }
            value = valuesArray;
        } else {
            Object v = property.getValue();
            value = v != null ? CMISPropertiesUtils.convertCmisPropertyValueToNexusValue(v, property) : "";
        }
        return value;
    }

    public static Object convertCmisPropertyValueToNexusValue(Object value, Property property) {
        Object v;
        if (property.getType() == PropertyType.BOOLEAN) {
            v = value.toString();
        } else if (property.getType() == PropertyType.DATETIME) {
            try {
                v = DateUtil.getISODateString(((GregorianCalendar)value).getTime(), true);
            }
            catch (Exception e) {
                v = "";
            }
        } else {
            v = property.getType() == PropertyType.DECIMAL ? value.toString() : (property.getType() == PropertyType.INTEGER ? ((BigInteger)value).toString() : (property.getType() == PropertyType.ID ? value.toString() : value));
        }
        return v;
    }

    public static Object convertStringToProperty(PropertyDefinition<?> cmisPropertyDef, String criteriaValue) {
        Object propertyValue;
        String methodName = "convertStringToProperty";
        if (cmisPropertyDef instanceof PropertyBooleanDefinition) {
            propertyValue = Boolean.valueOf(criteriaValue);
        } else if (cmisPropertyDef instanceof PropertyDateTimeDefinition) {
            try {
                Date date = DateUtil.parseISODate(criteriaValue, true);
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(date);
                propertyValue = cal;
            }
            catch (ParseException e) {
                Logger.logError(CMISCreateObject.class, methodName, (ServletRequest)null, (Throwable)e);
                propertyValue = "N/A";
            }
            catch (DatatypeConfigurationException e) {
                Logger.logError(CMISCreateObject.class, methodName, (ServletRequest)null, (Throwable)e);
                propertyValue = "N/A";
            }
        } else {
            propertyValue = cmisPropertyDef instanceof PropertyDecimalDefinition ? Double.valueOf(criteriaValue) : (cmisPropertyDef instanceof PropertyHtmlDefinition ? criteriaValue : (cmisPropertyDef instanceof PropertyIdDefinition ? criteriaValue : (cmisPropertyDef instanceof PropertyIntegerDefinition ? new BigInteger(criteriaValue) : (cmisPropertyDef instanceof PropertyStringDefinition ? (criteriaValue.length() > 0 ? criteriaValue : null) : "N/A"))));
        }
        return propertyValue;
    }
}

