/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cmis;

import com.ibm.ecm.util.cmis.OperationContextFactory;
import java.util.List;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumPropertiesDocument;

public class CMISObjectUtils {
    public static final CmisObject getNonCachedObject(Session session, String objectId, boolean includeAllowableActions) {
        CmisObject item = session.getObject(objectId, OperationContextFactory.getOperationContextCacheDisabled(session, includeAllowableActions));
        return item;
    }

    public static CmisObject getNonCachedObject(Session session, ObjectId objectId, boolean includeAllowableActions) {
        CmisObject item = session.getObject(objectId, OperationContextFactory.getOperationContextCacheDisabled(session, includeAllowableActions));
        return item;
    }

    public static Document getLatestMajorVersion(Document doc, OperationContext opCtx) {
        return doc.getObjectOfLatestVersion(true, opCtx);
    }

    public static Document getLatestVersion(Document doc, Session session, OperationContext opCtx) {
        Document latestMinor;
        doc.refresh();
        Document latestVersion = doc.isLatestVersion() != false ? doc : ((latestMinor = doc.getObjectOfLatestVersion(false, opCtx)).isLatestVersion() != false ? latestMinor : doc.getObjectOfLatestVersion(true, opCtx));
        return latestVersion;
    }

    public static Document getLatestNonPwcVersion(Document doc, Session session) {
        Document latestVersion;
        if (doc.isVersionSeriesCheckedOut().booleanValue()) {
            String pwcId = doc.getVersionSeriesCheckedOutId();
            Document pwcDoc = (Document)session.getObject(pwcId);
            latestVersion = CMISObjectUtils.getLatestVersionFromPWC(pwcDoc);
        } else {
            Document latestMinor = doc.getObjectOfLatestVersion(false);
            latestVersion = latestMinor.isLatestVersion() != false ? latestMinor : doc.getObjectOfLatestVersion(true);
        }
        return latestVersion;
    }

    public static Document getLatestVersionFromPWC(Document pwc) {
        List versions = pwc.getAllVersions();
        int numVersions = versions.size();
        for (int i = numVersions - 1; i >= 0; --i) {
            if (pwc.getId().equals(((Document)versions.get(i)).getId())) continue;
            return (Document)versions.get(i);
        }
        return null;
    }

    public static boolean isPWC(Document doc) {
        return doc.isVersionSeriesCheckedOut() != false && doc.getId().equals(doc.getPropertyValue(EnumPropertiesDocument.CMIS_VERSION_SERIES_CHECKED_OUT_ID.value()));
    }

    public static Document getPwcNonCached(Document doc, Session session) {
        boolean isCheckedOut = doc.isVersionSeriesCheckedOut();
        Document pwc = isCheckedOut ? (Document)CMISObjectUtils.getNonCachedObject(session, doc.getVersionSeriesCheckedOutId(), true) : null;
        return pwc;
    }
}

