/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cmis;

import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.cmis.CMISUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.definitions.Choice;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumPropertiesDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISDefinitionUtil {
    public static boolean isContentLengthProperty(PropertyDefinition pd) {
        return pd.getId().equals(EnumPropertiesDocument.CMIS_CONTENT_STREAM_LENGTH.value());
    }

    public static String[] getChoiceListAsArray(PropertyDefinition pd) {
        String[] choiceValueArray;
        List choiceValuesList = pd.getChoices();
        if (choiceValuesList == null) {
            choiceValueArray = new String[]{};
        } else {
            ArrayList<String> tempList = new ArrayList<String>();
            CMISDefinitionUtil._buildChoicesValuesAsList(tempList, choiceValuesList);
            choiceValueArray = tempList.toArray(new String[tempList.size()]);
        }
        return choiceValueArray;
    }

    private static void _buildChoicesValuesAsList(List<String> choiceValueArray, List<Choice> choices) {
        for (Choice choice : choices) {
            List choiceValue = choice.getValue();
            if (choiceValue != null & choiceValue.size() > 0) {
                Object cValue = choiceValue.get(0);
                if (cValue == null) continue;
                choiceValueArray.add(cValue.toString());
                continue;
            }
            CMISDefinitionUtil._buildChoicesValuesAsList(choiceValueArray, choice.getChoice());
        }
    }

    public static void addChoiceList(HttpServletRequest request, PropertyDefinition propDef, JSONObject jsonObj) {
        if (propDef.getCardinality() != null && propDef.getChoices() != null && propDef.getChoices().size() > 0) {
            jsonObj.put("cardinality", propDef.getCardinality().value());
            List choiceList = propDef.getChoices();
            String choiceListName = propDef.getDisplayName();
            List extensions = propDef.getExtensions();
            if (extensions != null) {
                for (CmisExtensionElement e : extensions) {
                    if (!e.getName().equals("ChoiceListSymbolicName")) continue;
                    choiceListName = String.valueOf(e.getValue());
                    break;
                }
            }
            JSONObject jsonChoiceList = new JSONObject();
            jsonChoiceList.put("displayName", choiceListName);
            jsonChoiceList.put("choices", CMISDefinitionUtil._buildChoicesArray(request, choiceList));
            jsonObj.put("choiceList", jsonChoiceList);
        }
    }

    private static JSONArray _buildChoicesArray(HttpServletRequest request, List<Choice> choices) {
        String methodName = "_buildNestedChoices";
        Logger.logEntry(CMISUtil.class, methodName, (ServletRequest)request);
        JSONArray jsonChoices = new JSONArray();
        for (Choice choice : choices) {
            List choiceValue = choice.getValue();
            JSONObject jsonChoice = new JSONObject();
            jsonChoice.put("displayName", choice.getDisplayName());
            if (choiceValue != null & choiceValue.size() > 0) {
                Object cValue = choiceValue.get(0);
                if (cValue != null) {
                    jsonChoice.put("value", cValue);
                }
            } else {
                jsonChoice.put("choices", CMISDefinitionUtil._buildChoicesArray(request, choice.getChoice()));
            }
            jsonChoices.add(jsonChoice);
        }
        Logger.logExit(CMISUtil.class, methodName, (ServletRequest)request);
        return jsonChoices;
    }

    private static void printChoiceValues(Choice choice, List<?> choiceValue) {
        System.out.println(" printing choice value list for " + choice.getDisplayName());
        if (choiceValue == null) {
            System.out.print("  null");
        } else {
            for (Object v : choiceValue) {
                System.out.println("val=" + v);
            }
        }
    }
}

