/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cmis;

import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.FileUploadActionForm;
import com.ibm.ecm.util.BaseUtil;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.cmis.CMISPropertiesUtils;
import com.ibm.ecm.util.cmis.CMISPropertyDefinition;
import com.ibm.ecm.util.cmis.CMISProviderSpecific;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.DocumentType;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumPropertiesBase;
import org.apache.struts.action.ActionForm;
import org.apache.struts.upload.FormFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISCreateObject {
    public static FormFile getFormFile(ActionForm form) {
        FormFile formFile;
        block1: {
            formFile = ((FileUploadActionForm)form).getUploadFile();
            if (formFile != null) break block1;
            Hashtable fileElements = form.getMultipartRequestHandler().getFileElements();
            Iterator it = fileElements.values().iterator();
            while (it.hasNext() && (formFile = (FormFile)it.next()) == null) {
            }
        }
        return formFile;
    }

    public static Document createDocument(HttpServletRequest request, BaseUtil baseUtil, Folder parent, Session session, JSONArray criteriasJsonArray, ActionForm form, ObjectType typeDef, boolean asMinorVersion) {
        Document doc;
        block2: {
            String contentType = request.getParameter("parm_content_source_type");
            ContentStream contentStream = contentType.equals("Document") ? CMISCreateObject.createContentStream(request, baseUtil, session, form) : null;
            DocumentType docType = (DocumentType)typeDef;
            VersioningState versioningState = CMISCreateObject.getVersioningStateForCreateDocument(asMinorVersion, docType, session);
            Map<String, Object> props = CMISCreateObject.createPropertiesMapFromJSON(request, criteriasJsonArray, (TypeDefinition)typeDef, true, false);
            doc = null;
            try {
                doc = parent.createDocument(props, contentStream, versioningState);
            }
            catch (Exception e) {
                if (!(e instanceof CmisRuntimeException)) break block2;
                CmisRuntimeException re = (CmisRuntimeException)((Object)e);
            }
        }
        return doc;
    }

    private static VersioningState getVersioningStateForCreateDocument(boolean asMinorVersion, DocumentType docType, Session session) {
        VersioningState versioningState = docType.isVersionable() != false ? (asMinorVersion ? VersioningState.MINOR : VersioningState.MAJOR) : (CMISProviderSpecific.isCM(session) ? VersioningState.MAJOR : VersioningState.NONE);
        return versioningState;
    }

    public static ObjectId checkIn(HttpServletRequest request, BaseUtil baseUtil, Document doc, Session session, JSONArray criteriasJsonArray, ActionForm form, boolean asMinorVersion) {
        String contentType = request.getParameter("parm_content_source_type");
        ContentStream contentStream = contentType.equals("Document") ? CMISCreateObject.createContentStream(request, baseUtil, session, form) : null;
        Map<String, Object> props = CMISCreateObject.createPropertiesMapFromJSON(request, criteriasJsonArray, (TypeDefinition)doc.getType(), false, true);
        ObjectId checkedInDoc = doc.checkIn(!asMinorVersion, props, contentStream, "");
        return checkedInDoc;
    }

    public static ContentStream createContentStream(HttpServletRequest request, BaseUtil baseUtil, Session session, ActionForm form) {
        String methodName = "createContentStream";
        String partMimeType = (String)request.getAttribute("mimetype");
        String partFilePath = request.getParameter("parm_part_filename");
        String partFileName = Util.getFileNameFromPath(request, partFilePath);
        if ((partMimeType == null || partMimeType.length() == 0) && partFileName != null && partFileName.length() > 0) {
            try {
                partMimeType = baseUtil.getMimeTypeFromFileName(request, partFileName);
            }
            catch (Exception e) {
                partMimeType = "";
            }
        }
        if (partMimeType != null && partMimeType.length() > 0) {
            Logger.logDebug(CMISCreateObject.class, methodName, (ServletRequest)request, "MIME type of the new document is = " + partMimeType);
        } else {
            Logger.logDebug(CMISCreateObject.class, methodName, (ServletRequest)request, "MIME type of the new document is = <not provided - CE will determine the MIME type>");
        }
        FormFile ff = CMISCreateObject.getFormFile(form);
        ContentStream contentStream = null;
        try {
            InputStream is = ff != null ? ff.getInputStream() : request.getInputStream();
            contentStream = session.getObjectFactory().createContentStream(partFileName, (long)is.available(), partMimeType, is);
        }
        catch (FileNotFoundException e) {
            Logger.logError(CMISCreateObject.class, methodName, (ServletRequest)request, (Throwable)e);
        }
        catch (IOException e) {
            Logger.logError(CMISCreateObject.class, methodName, (ServletRequest)request, (Throwable)e);
        }
        return contentStream;
    }

    public static Folder createFolder(HttpServletRequest request, Folder parentFolder, Session session, JSONArray criteriasJsonArray, ObjectType typeDef) {
        Map<String, Object> props = CMISCreateObject.createPropertiesMapFromJSON(request, criteriasJsonArray, (TypeDefinition)typeDef, true, false);
        Folder folder = parentFolder.createFolder(props);
        return folder;
    }

    public static Map<String, Object> createPropertiesMapFromJSON(HttpServletRequest request, JSONArray criterias, TypeDefinition typeDef, boolean isCreate, boolean isCheckedOut) {
        String methodName = "createPropertiesMapFromJSON";
        Logger.logEntry(CMISCreateObject.class, methodName, (ServletRequest)request);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Map propertyDescriptionList = typeDef.getPropertyDefinitions();
        Logger.logDebug(CMISCreateObject.class, methodName, (ServletRequest)request, "criterias.size()" + criterias.size());
        Logger.logDebug(CMISCreateObject.class, methodName, (ServletRequest)request, "adding the attribute values for the newly created item");
        if (isCreate) {
            properties.put(EnumPropertiesBase.CMIS_OBJECT_TYPE_ID.value(), typeDef.getId());
        }
        for (Object objcriteria : criterias) {
            JSONObject criteria = (JSONObject)objcriteria;
            String criteriaName = criteria.get("name").toString();
            Object criteriaValue = criteria.get("value");
            Logger.logDebug(CMISCreateObject.class, methodName, (ServletRequest)request, "update Item: attrName=" + criteriaName + " attrValue=" + criteriaValue);
            PropertyDefinition propertyDef = (PropertyDefinition)propertyDescriptionList.get(criteriaName);
            CMISPropertyDefinition propertyDefWrapper = new CMISPropertyDefinition(propertyDef);
            Logger.logInfo(CMISCreateObject.class, methodName, (ServletRequest)request, "criteriaName=" + criteriaName + "  criteriaValue=" + criteriaValue + " updatability=" + propertyDefWrapper.getPropertyDefinition().getUpdatability().value());
            if (!propertyDefWrapper.isUpdatabilityReadWrite() && (!isCreate || !propertyDefWrapper.isUpdatabilityOnCreate()) && (isCreate || !isCheckedOut || !propertyDefWrapper.isUpdatabilityWhenCheckedOut())) continue;
            String propertyId = propertyDefWrapper.getId();
            if (propertyDef.getCardinality() == Cardinality.SINGLE) {
                String strVal = criteriaValue.toString();
                Object objVal = null;
                if (strVal.length() < 1) {
                    if (!propertyDefWrapper.isUpdatabilityWhenCheckedOut() && !propertyDefWrapper.isUpdatabilityOnCreate()) {
                        objVal = null;
                    }
                } else {
                    objVal = CMISPropertiesUtils.convertStringToProperty(propertyDef, strVal);
                }
                Logger.logInfo(CMISCreateObject.class, methodName, (ServletRequest)request, "set property:  " + propertyDef.getId() + "=" + objVal);
                properties.put(propertyId, objVal);
                continue;
            }
            JSONArray valuesJsonArray = (JSONArray)criteriaValue;
            ArrayList<Object> list = new ArrayList<Object>(valuesJsonArray.size());
            for (Object val : valuesJsonArray) {
                if (val.toString().length() <= 0) continue;
                Object objVal = CMISPropertiesUtils.convertStringToProperty(propertyDef, val.toString());
                Logger.logInfo(CMISCreateObject.class, methodName, (ServletRequest)request, "set property:  " + propertyDef.getId() + "=" + objVal);
                if (objVal == null) continue;
                list.add(objVal);
            }
            if (list.isEmpty()) continue;
            properties.put(propertyId, list);
        }
        Logger.logExit(CMISCreateObject.class, methodName, (ServletRequest)request);
        return properties;
    }
}

