/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cmis;

import com.ibm.ecm.extension.PluginServiceUtil;
import com.ibm.ecm.util.DocumentContent;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.cmis.CMISConnection;
import com.ibm.ecm.util.cmis.CMISUtil;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.commons.data.ContentStream;

public class CMISContentUtil {
    public static Document retrieveDocument(HttpServletRequest request, String repositoryId, String documentId) {
        CMISConnection connection = PluginServiceUtil.getCMISConnection(request, repositoryId);
        return CMISUtil.getDocument(request, connection, documentId, null);
    }

    public static DocumentContent retrieveContent(HttpServletRequest request, String repositoryId, String documentId) {
        CMISDocumentContent documentContent = null;
        CMISConnection connection = PluginServiceUtil.getCMISConnection(request, repositoryId);
        Document document = CMISUtil.getDocument(request, connection, documentId, null);
        ContentStream contentStream = document.getContentStream();
        if (contentStream != null) {
            documentContent = new CMISDocumentContent(contentStream);
        }
        return documentContent;
    }

    private static class CMISDocumentContent
    extends DocumentContent {
        private ContentStream cmisContentStream = null;

        private CMISDocumentContent(ContentStream contentStream) {
            this.cmisContentStream = contentStream;
            this.type = contentStream.getMimeType();
            this.size = contentStream.getLength();
            this.name = Util.getValidFileName(contentStream.getFileName());
        }

        public InputStream getInputStream() throws Exception {
            InputStream inputStream = null;
            if (this.cmisContentStream != null) {
                inputStream = this.cmisContentStream.getStream();
            }
            return inputStream;
        }
    }
}

