/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cm;

import com.ibm.ecm.beans.cm.CMEntity;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.BaseUtil;
import com.ibm.ecm.util.Util;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKAttrDefICM;
import com.ibm.mm.sdk.common.DKAttrGroupDefICM;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKComponentTypeViewDefICM;
import com.ibm.mm.sdk.common.DKConfigurationMgmtICM;
import com.ibm.mm.sdk.common.DKDatastoreAccessError;
import com.ibm.mm.sdk.common.DKDatastoreAdminICM;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKForeignKeyDefICM;
import com.ibm.mm.sdk.common.DKInvalidPasswordException;
import com.ibm.mm.sdk.common.DKItemTypeDefICM;
import com.ibm.mm.sdk.common.DKItemTypeRelationDefICM;
import com.ibm.mm.sdk.common.DKItemTypeViewDefICM;
import com.ibm.mm.sdk.common.DKLSCfgDefICM;
import com.ibm.mm.sdk.common.DKLSConfigurationMgmtICM;
import com.ibm.mm.sdk.common.DKLogonFailure;
import com.ibm.mm.sdk.common.DKLogonPromptException;
import com.ibm.mm.sdk.common.DKNVPair;
import com.ibm.mm.sdk.common.DKQueryException;
import com.ibm.mm.sdk.common.DKUsageError;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDatastore;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.common.dkIterator;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMUtil
extends Util {
    public static Vector<CMEntity> getFilteredEntities(DKDatastoreICM dsICM, String filterType, CMEntity[] entities, HttpServletRequest request) throws Exception {
        String methodName = "getItemClasses";
        Logger.logEntry(CMUtil.class, methodName, (ServletRequest)request);
        Vector<CMEntity> entityList = new Vector<CMEntity>(entities.length);
        for (int i = 0; i < entities.length; ++i) {
            boolean skipItemType = false;
            if (filterType != null && filterType.length() != 0 && !filterType.equalsIgnoreCase("navigation")) {
                DKComponentTypeDefICM componentType = (DKComponentTypeDefICM)dsICM.datastoreDef().retrieveEntity(entities[i].getName());
                DKItemTypeDefICM itemType = null;
                if (componentType instanceof DKItemTypeDefICM) {
                    itemType = (DKItemTypeDefICM)componentType;
                } else if (componentType instanceof DKComponentTypeViewDefICM) {
                    itemType = (DKItemTypeDefICM)dsICM.datastoreDef().retrieveEntity(((DKItemTypeViewDefICM)componentType).getItemTypeName());
                }
                if (itemType != null) {
                    String name = itemType.getName();
                    if (itemType.getClassification() == 3) {
                        skipItemType = true;
                    } else if (!(!name.startsWith("ICM") || name.equals("ICM$FOLDER") || filterType.equalsIgnoreCase("search") && name.equals("ICMSearch"))) {
                        skipItemType = true;
                        Logger.logDebug(CMUtil.class, methodName, (ServletRequest)request, "Entity \"" + itemType.getName() + "\" is a system item type (skipped)");
                    } else if (filterType.equalsIgnoreCase("createDocument")) {
                        skipItemType = itemType.foldersOnly();
                        Logger.logDebug(CMUtil.class, methodName, (ServletRequest)request, "Entity \"" + itemType.getName() + "\" allows documents = " + !skipItemType + (skipItemType ? " (skipped)" : ""));
                    } else if (filterType.equalsIgnoreCase("createFolder")) {
                        Logger.logDebug(CMUtil.class, methodName, (ServletRequest)request, "Entity \"" + itemType.getName() + "\" allows folders = " + !skipItemType);
                    } else if (filterType.equalsIgnoreCase("hierarchicalCreateDocument")) {
                        skipItemType = !itemType.isHierarchical() || itemType.foldersOnly();
                        Logger.logDebug(CMUtil.class, methodName, (ServletRequest)request, "Entity \"" + itemType.getName() + "\" is hierarchical and allows documents = " + !skipItemType + (skipItemType ? " (skipped)" : ""));
                    } else if (filterType.equalsIgnoreCase("hierarchicalCreateFolder")) {
                        skipItemType = !itemType.isHierarchical() || itemType.foldersNotAllowed();
                        Logger.logDebug(CMUtil.class, methodName, (ServletRequest)request, "Entity \"" + itemType.getName() + "\" is hierarchical and allows folders = " + !skipItemType + (skipItemType ? " (skipped)" : ""));
                    } else if (filterType.equalsIgnoreCase("nonHierarchicalDocument")) {
                        skipItemType = itemType.isHierarchical();
                        Logger.logDebug(CMUtil.class, methodName, (ServletRequest)request, "Entity \"" + itemType.getName() + "\" is hierarchical and allows folders = " + !skipItemType + (skipItemType ? " (skipped)" : ""));
                    } else {
                        Logger.logDebug(CMUtil.class, methodName, (ServletRequest)request, "Entity \"" + itemType.getName() + "\" is allowed");
                    }
                } else {
                    skipItemType = true;
                    Logger.logDebug(CMUtil.class, methodName, (ServletRequest)request, "Entity \"" + componentType.getName() + "\" unknown component type = " + skipItemType + (skipItemType ? " (skipped)" : ""));
                }
            }
            if (skipItemType) continue;
            entityList.add(entities[i]);
            Logger.logDebug(CMUtil.class, methodName, (ServletRequest)request, "Including item class = " + entities[i].getDisplayName());
        }
        Collections.sort(entityList, new ItemClassDisplayNameComparator());
        Logger.logExit(CMUtil.class, methodName, (ServletRequest)request);
        return entityList;
    }

    public static Vector getFilteredWorklists(String searchString, String[] worklists, HttpServletRequest request) throws Exception {
        String methodName = "getFilteredWorklists";
        Logger.logEntry(CMUtil.class, methodName, (ServletRequest)request);
        boolean filterByName = true;
        String wildcard = "*";
        if (searchString == null || searchString.trim().length() < 1) {
            filterByName = false;
        } else {
            if (searchString.trim().length() == 1 && searchString.trim().equals("%")) {
                filterByName = false;
            }
            searchString = searchString.replaceAll("%", "*");
            searchString = wildcard + searchString + wildcard;
        }
        Logger.logDebug(CMUtil.class, methodName, (ServletRequest)request, " the worklist search with proper pattern is : " + searchString);
        ArrayList<String> workItemsList = new ArrayList<String>();
        for (int i = 0; i < worklists.length; ++i) {
            if (!filterByName) {
                workItemsList.add(worklists[i]);
                Logger.logDebug(CMUtil.class, methodName, (ServletRequest)request, "Worklists \"" + i + "\" = " + worklists[i]);
                continue;
            }
            if (!BaseUtil.isMatch(worklists[i], searchString)) continue;
            workItemsList.add(worklists[i]);
            Logger.logDebug(CMUtil.class, methodName, (ServletRequest)request, "Worklists \"" + i + "\" = " + worklists[i]);
        }
        Object[] arrayWorklists = workItemsList.toArray();
        Vector<Object> sortedWorklists = new Vector<Object>(workItemsList.size());
        for (int i = 0; i < workItemsList.size(); ++i) {
            sortedWorklists.add(arrayWorklists[i]);
        }
        Logger.logExit(CMUtil.class, methodName, (ServletRequest)request);
        return sortedWorklists;
    }

    public static String getDisplayName(DKAttrDefICM attrDef, String langCode) {
        if (attrDef instanceof DKAttrDefICM) {
            try {
                if (attrDef.isRepresentative()) {
                    return attrDef.getDescription();
                }
                if (attrDef.getAttrGroupName() == null || attrDef.getAttrGroupName().length() == 0 || attrDef.getEntity() == null) {
                    return attrDef.getDescription();
                }
                DKComponentTypeDefICM compDef = (DKComponentTypeDefICM)attrDef.getEntity();
                DKAttrGroupDefICM attrGroupDef = (DKAttrGroupDefICM)compDef.getAttrGroup(attrDef.getAttrGroupName());
                String grpDescription = CMUtil.getDKDescription(attrGroupDef, langCode);
                String description = attrDef.getDescription();
                return grpDescription + "." + description;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return attrDef.getNLSKeywordObject().getName();
    }

    public static String getCriteriaType(DKAttrDefICM criteria) {
        short type = criteria.getType();
        String returnType = CMUtil.getCriteriaType(type);
        if (returnType.equals("xs:string")) {
            int stringType = criteria.getStringType();
            switch (stringType) {
                case 1: {
                    returnType = "xs:string:alpha";
                    break;
                }
                case 2: {
                    returnType = "xs:string:alphanum";
                    break;
                }
                case 8: {
                    returnType = "xs:string:num";
                    break;
                }
                case 4: {
                    returnType = "xs:string:ext";
                }
            }
        }
        return returnType;
    }

    public static String getCriteriaType(short type) {
        String returnType = null;
        switch (type) {
            case 3: 
            case 4: {
                returnType = "xs:integer";
                break;
            }
            case 5: 
            case 10: {
                returnType = "xs:double";
                break;
            }
            case 6: {
                returnType = "xs:decimal";
                break;
            }
            case 7: {
                returnType = "xs:date";
                break;
            }
            case 9: {
                returnType = "xs:timestamp";
                break;
            }
            case 8: {
                returnType = "xs:time";
                break;
            }
            case 19: {
                returnType = "xs:string:clob";
                break;
            }
            case 48: {
                returnType = "xs:reference";
                break;
            }
            default: {
                returnType = "xs:string";
            }
        }
        return returnType;
    }

    public static boolean isNumericCriteriaType(DKAttrDefICM criteria) {
        String criteriaType = CMUtil.getCriteriaType(criteria);
        return criteriaType != null && (criteriaType.equals("xs:integer") || criteriaType.equals("xs:double") || criteriaType.equals("xs:decimal") || criteriaType.equals("xs:string:num"));
    }

    public static String getMax(DKAttrDefICM criteria) {
        return CMUtil.getMax(criteria, false);
    }

    public static String getMax(DKAttrDefICM criteria, boolean ignoreAttrMinMax) {
        short type = criteria.getType();
        String returnType = "";
        switch (type) {
            case 10: {
                returnType = new Double(Double.MAX_VALUE).toString();
                break;
            }
            case 6: {
                int scaleValue = criteria.getScale();
                StringBuffer maxNumber = new StringBuffer();
                for (int precisionValue = criteria.getPrecision() - scaleValue; precisionValue > 0; --precisionValue) {
                    maxNumber.append("9");
                }
                if (scaleValue > 0) {
                    maxNumber.append(".");
                }
                while (scaleValue > 0) {
                    maxNumber.append("9");
                    --scaleValue;
                }
                returnType = maxNumber.toString();
                break;
            }
            case 4: {
                if (ignoreAttrMinMax || criteria.getMax() == 0 && criteria.getMin() == 0) {
                    returnType = "2147483647";
                    break;
                }
                returnType = String.valueOf(criteria.getMax());
                break;
            }
            case 3: {
                if (ignoreAttrMinMax || criteria.getMax() == 0 && criteria.getMin() == 0) {
                    returnType = "32767";
                    break;
                }
                returnType = String.valueOf(criteria.getMax());
                break;
            }
            default: {
                returnType = "";
            }
        }
        return returnType;
    }

    public static String getMin(DKAttrDefICM criteria) {
        return CMUtil.getMin(criteria, false);
    }

    public static String getMin(DKAttrDefICM criteria, boolean ignoreAttrMinMax) {
        short type = criteria.getType();
        String returnType = "";
        switch (type) {
            case 10: {
                returnType = new Double(-1.7976931348623157E308).toString();
                break;
            }
            case 6: {
                int scaleValue = criteria.getScale();
                StringBuffer maxNumber = new StringBuffer("-");
                for (int precisionValue = criteria.getPrecision() - scaleValue; precisionValue > 0; --precisionValue) {
                    maxNumber.append("9");
                }
                if (scaleValue > 0) {
                    maxNumber.append(".");
                }
                while (scaleValue > 0) {
                    maxNumber.append("9");
                    --scaleValue;
                }
                returnType = maxNumber.toString();
                break;
            }
            case 4: {
                if (ignoreAttrMinMax || criteria.getMax() == 0 && criteria.getMin() == 0) {
                    returnType = "-2147483648";
                    break;
                }
                returnType = String.valueOf(criteria.getMin());
                break;
            }
            case 3: {
                if (ignoreAttrMinMax || criteria.getMax() == 0 && criteria.getMin() == 0) {
                    returnType = "-32768";
                    break;
                }
                returnType = String.valueOf(criteria.getMin());
                break;
            }
            default: {
                returnType = "";
            }
        }
        return returnType;
    }

    public static String getUserFriendlyDkErrorMessage(Throwable t, MessageResources resources) {
        String message = null;
        if (t instanceof DKLogonPromptException || t instanceof DKLogonFailure || t instanceof DKDatastoreAccessError || t instanceof DKInvalidPasswordException || t instanceof DKQueryException || t instanceof DKUsageError) {
            // empty if block
        }
        return message;
    }

    static String getDKDescription(DKAttrGroupDefICM attrGroupDef, String langCode) throws Exception {
        String description = null;
        dkDatastore ds = attrGroupDef.getDatastore();
        if (ds instanceof dkDatastoreIntICM) {
            if (langCode.equalsIgnoreCase(((dkDatastoreIntICM)ds).languageCode())) {
                description = attrGroupDef.getDescription();
            } else {
                description = attrGroupDef.getDescription(langCode);
                if (description == null || description.length() == 0) {
                    description = attrGroupDef.getDescription();
                }
            }
        } else {
            description = attrGroupDef.getDescription();
        }
        return description;
    }

    public static DKItemTypeRelationDefICM getContentPart(DKItemTypeDefICM itemTypeDef, int mimeTypeFlag, String requestedPartTypeName) throws Exception {
        DKItemTypeRelationDefICM defaultPartType = null;
        DKItemTypeRelationDefICM firstPartType = null;
        DKItemTypeRelationDefICM requestedPartType = null;
        DKItemTypeRelationDefICM icmbasePartType = null;
        DKItemTypeRelationDefICM icmbasetextPartType = null;
        DKItemTypeRelationDefICM icmbasestreamPartType = null;
        DKItemTypeRelationDefICM icmbasecsPartType = null;
        DKItemTypeRelationDefICM icmbasetextcsPartType = null;
        dkCollection parts = itemTypeDef.listItemTypeRelations();
        dkIterator iterPartTypes = parts.createIterator();
        DKItemTypeRelationDefICM partType = null;
        String partName = null;
        while (iterPartTypes.more()) {
            partType = (DKItemTypeRelationDefICM)iterPartTypes.next();
            partName = partType.getTargetItemTypeName();
            if (firstPartType == null) {
                firstPartType = partType;
            }
            if (partName.equalsIgnoreCase(requestedPartTypeName)) {
                requestedPartType = partType;
            }
            if (partName.equalsIgnoreCase("ICMBASE")) {
                icmbasePartType = partType;
                continue;
            }
            if (partName.equalsIgnoreCase("ICMBASETEXT")) {
                icmbasetextPartType = partType;
                continue;
            }
            if (partName.equalsIgnoreCase("ICMBASESTREAM")) {
                icmbasestreamPartType = partType;
                continue;
            }
            if (partName.equalsIgnoreCase("ICMBASECS")) {
                icmbasecsPartType = partType;
                continue;
            }
            if (!partName.equalsIgnoreCase("ICMBASETEXTCS")) continue;
            icmbasetextcsPartType = partType;
        }
        switch (mimeTypeFlag) {
            case 1: {
                if (!itemTypeDef.isTextSearchable()) break;
                if (icmbasetextPartType != null) {
                    defaultPartType = icmbasetextPartType;
                    break;
                }
                if (icmbasetextcsPartType == null) break;
                defaultPartType = icmbasetextcsPartType;
                break;
            }
            case 2: {
                if (icmbasestreamPartType == null) break;
                defaultPartType = icmbasetextPartType;
                break;
            }
        }
        if (defaultPartType == null) {
            if (requestedPartType != null) {
                defaultPartType = requestedPartType;
            } else if (icmbasePartType != null) {
                defaultPartType = icmbasePartType;
            } else if (icmbasetextPartType != null) {
                defaultPartType = icmbasetextPartType;
            } else if (icmbasecsPartType != null) {
                defaultPartType = icmbasecsPartType;
            } else if (icmbasetextcsPartType != null) {
                defaultPartType = icmbasetextcsPartType;
            } else if (firstPartType != null) {
                defaultPartType = firstPartType;
            }
        }
        return defaultPartType;
    }

    public static String[] listPartTypes(DKItemTypeDefICM itemType) throws Exception {
        dkCollection parts = itemType.listItemTypeRelations();
        String[] partTypes = new String[parts.cardinality()];
        int partTypesCounter = 0;
        dkIterator iterParts = parts.createIterator();
        DKItemTypeRelationDefICM oneRelation = null;
        while (iterParts.more()) {
            oneRelation = (DKItemTypeRelationDefICM)iterParts.next();
            partTypes[partTypesCounter] = oneRelation.getTargetItemTypeName();
            ++partTypesCounter;
        }
        return partTypes;
    }

    public static boolean hasPartType(DKItemTypeDefICM itemType, String partTypeRequested) throws Exception {
        boolean answer = false;
        String[] partTypes = CMUtil.listPartTypes(itemType);
        for (int iPartCounter = 0; partTypeRequested != null && partTypes != null && iPartCounter < partTypes.length; ++iPartCounter) {
            if (partTypes[iPartCounter] == null || !partTypes[iPartCounter].equals(partTypeRequested)) continue;
            answer = true;
            break;
        }
        return answer;
    }

    public static String[] getValidValues(HttpServletRequest request, DKAttrDefICM attr, dkCollection foreignKeys, JSONObject jsonObject) {
        String methodName = "getValidValues";
        ArrayList values = null;
        String attrName = attr.getName();
        DKForeignKeyDefICM foreignKey = null;
        String criteriaColumnSequence = "";
        int columnSequence = -1;
        try {
            boolean found = false;
            Vector attrInfo = new Vector();
            if (foreignKeys != null) {
                dkIterator iterator = foreignKeys.createIterator();
                while (iterator.more() && !found) {
                    foreignKey = (DKForeignKeyDefICM)iterator.next();
                    attrInfo = foreignKey.listForeignKeyAttrInfo();
                    for (int i = 0; i < attrInfo.size() && !found; ++i) {
                        String[] attrInfoArray = (String[])attrInfo.elementAt(i);
                        if (!attrInfoArray[2].equals(attrName)) continue;
                        found = true;
                        criteriaColumnSequence = attrInfoArray[0];
                        Logger.logDebug(CMUtil.class, methodName, (ServletRequest)request, "criteriaColumnSequence: " + criteriaColumnSequence);
                        columnSequence = new Integer(criteriaColumnSequence);
                    }
                }
            }
            if (found) {
                String[] attrInfoArray;
                int j;
                JSONArray criteriasJsonArray;
                JSONObject criteria = null;
                Hashtable<String, String> criteriaNamesValues = new Hashtable<String, String>();
                if (jsonObject != null && (criteriasJsonArray = (JSONArray)jsonObject.get("criterias")) != null) {
                    for (int iCriteriaCounter = 0; iCriteriaCounter < criteriasJsonArray.size(); ++iCriteriaCounter) {
                        String criteriaValue;
                        criteria = (JSONObject)criteriasJsonArray.get(iCriteriaCounter);
                        String criteriaName = criteria.get("name").toString();
                        Object obj = criteria.get("values");
                        if (obj == null || (criteriaValue = criteria.get("values").toString()).length() <= 0) continue;
                        criteriaNamesValues.put(criteriaName, criteriaValue);
                        Logger.logDebug(CMUtil.class, methodName, (ServletRequest)request, "criteriaValue: " + criteriaValue);
                    }
                }
                Vector<String> keysVector = new Vector<String>();
                Vector<String> valuesVector = new Vector<String>();
                if (!criteriaNamesValues.isEmpty() && (j = 0) < attrInfo.size() && (attrInfoArray = (String[])attrInfo.elementAt(j))[0].compareTo(criteriaColumnSequence) < 0) {
                    keysVector.addElement(attrInfoArray[2]);
                    valuesVector.addElement(criteriaNamesValues.get(attrInfoArray[2]).toString());
                    Logger.logDebug(CMUtil.class, methodName, (ServletRequest)request, "criteriaNameValue: " + criteriaNamesValues.get(attrInfoArray[2]).toString());
                }
                DKNVPair[] foreignKeyValues = null;
                if (!keysVector.isEmpty()) {
                    foreignKeyValues = new DKNVPair[keysVector.size()];
                    for (int i = 0; i < foreignKeyValues.length; ++i) {
                        String value = (String)valuesVector.elementAt(i);
                        if (value.length() <= 0) continue;
                        foreignKeyValues[i] = new DKNVPair((String)keysVector.elementAt(i), (Object)value);
                        Logger.logDebug(CMUtil.class, methodName, (ServletRequest)request, "foreignKeyValues[" + i + "]: " + value);
                    }
                }
                String[] columnNames = new String[]{attrName};
                Logger.logDebug(CMUtil.class, methodName, (ServletRequest)request, "get foreignKey values for attr: " + attrName);
                values = foreignKey.getSpecificAttrsForForeignKey(foreignKeyValues, columnNames);
            }
        }
        catch (Exception e) {
            Logger.logError(CMUtil.class, methodName, (ServletRequest)request, (Throwable)e);
        }
        Object[] returnArrayList = null;
        String[] returnStringArray = null;
        if (values != null && values.size() > 0) {
            try {
                if (columnSequence != -1 && foreignKey != null && !foreignKey.getDisplayFlag(columnSequence)) {
                    Logger.logDebug(CMUtil.class, methodName, (ServletRequest)request, "foreignKey display choice list flag: false");
                    returnStringArray = new String[]{};
                }
                returnArrayList = values.toArray();
                returnStringArray = (String[])returnArrayList[0];
                Logger.logDebug(CMUtil.class, methodName, (ServletRequest)request, "foreignKey values: " + Arrays.asList(returnStringArray).toString());
                for (int i = 0; i < returnStringArray.length; ++i) {
                    returnStringArray[i] = returnStringArray[i].trim();
                }
            }
            catch (Exception e) {
                Logger.logWarning(CMUtil.class, methodName, (ServletRequest)request, e.getMessage());
            }
        } else {
            returnStringArray = new String[]{};
        }
        return returnStringArray;
    }

    public static String changeTimeZone(String tmStr, String tmFormat, TimeZone fromTimeZone, TimeZone toTimeZone) {
        try {
            tmStr = tmStr.substring(0, tmFormat.length() - 1);
            SimpleDateFormat dateFormat = new SimpleDateFormat(tmFormat);
            dateFormat.setTimeZone(fromTimeZone);
            Date convertedDate = dateFormat.parse(tmStr);
            dateFormat.setTimeZone(toTimeZone);
            return dateFormat.format(convertedDate);
        }
        catch (Exception e) {
            return tmStr;
        }
    }

    public static boolean isRecordsManagerEnabled(DKDatastoreICM datastore) {
        try {
            DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)datastore.datastoreDef();
            DKDatastoreAdminICM dsAdmin = (DKDatastoreAdminICM)dsDefICM.datastoreAdmin();
            DKConfigurationMgmtICM cfgMgmt = (DKConfigurationMgmtICM)dsAdmin.configurationManagement();
            DKLSConfigurationMgmtICM lsCfgMgmt = cfgMgmt.lsConfigurationMgmt();
            DKLSCfgDefICM configParms = lsCfgMgmt.retrieveConfigParameters();
            boolean isRecordsManagerEnabled = configParms != null && (configParms.isRecordsManagerEnabled() || configParms.isP8RecordsManagerEnabled());
            return isRecordsManagerEnabled;
        }
        catch (Exception exp) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ItemClassDisplayNameComparator
    implements Comparator<CMEntity> {
        ItemClassDisplayNameComparator() {
        }

        @Override
        public int compare(CMEntity class1, CMEntity class2) {
            return class1.getDisplayName().compareToIgnoreCase(class2.getDisplayName());
        }
    }
}

