/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.serviceability.Logger;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public class CMSessionListener
implements HttpSessionBindingListener {
    public void valueBound(HttpSessionBindingEvent event) {
        String methodName = "valueBound";
        HttpSession session = event.getSession();
        Logger.logEntry((Object)this, "valueBound", session);
        Logger.logInfo((Object)this, "valueBound", event.getSession(), "Session: " + event.getSession() + "    maxInactiveInterval=" + event.getSession().getMaxInactiveInterval());
        Logger.logExit((Object)this, "valueBound", session);
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        String methodName = "valueUnbound";
        HttpSession session = event.getSession();
        Logger.logEntry((Object)this, "valueUnbound", session);
        Hashtable servers = null;
        CMConnection theServer = null;
        try {
            if (session != null && (servers = (Hashtable)session.getAttribute("cm_servers")) != null) {
                if (servers.keySet() == null) {
                    return;
                }
                Enumeration eLoop = servers.keys();
                while (eLoop.hasMoreElements()) {
                    String serverName = (String)eLoop.nextElement();
                    theServer = (CMConnection)servers.get(serverName);
                    Logger.logInfo((Object)this, "valueUnbound", session, "invalidate " + serverName + " for " + Logger.getFormattedUser(theServer.getUserid(), null));
                    try {
                        theServer.logout();
                    }
                    catch (Exception e) {
                        Logger.logError((Object)this, "valueUnbound", session, (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, "valueUnbound", session, (Throwable)e);
        }
        Logger.logExit((Object)this, "valueUnbound", session);
    }
}

