/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cm;

import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.util.ChildSearchCriteria;
import com.ibm.ecm.util.SearchCriteria;
import com.ibm.ecm.util.SearchCriterion;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKPidICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class CMSearchTemplate
extends SearchTemplate {
    public JSONObject toPersistableJSON() {
        List<SearchTemplate.SearchFolder> folders;
        JSONObject json = new JSONObject();
        json.put("itemTypeName", this.getFirstClassName());
        json.put("objectType", this.getObjectType().toString());
        List<SearchTemplate.SearchClass> classes = this.getClasses();
        if (classes != null && classes.size() > 0) {
            JSONArray classesJSON = new JSONArray();
            for (SearchTemplate.SearchClass searchClass : classes) {
                JSONObject classJSON = new JSONObject();
                classJSON.put("itemTypeName", searchClass.getName());
                classesJSON.add(classJSON);
            }
            json.put("classes", classesJSON);
        }
        if ((folders = this.getFolders()) != null && folders.size() > 0) {
            JSONArray foldersJSON = new JSONArray();
            for (SearchTemplate.SearchFolder folder : folders) {
                JSONObject folderJSON = new JSONObject();
                folderJSON.put("id", folder.getId());
                folderJSON.put("includeSubfolders", (Object)folder.isSearchSubfolders());
                foldersJSON.add(folderJSON);
            }
            json.put("folders", foldersJSON);
        }
        JSONObject attribCriteriaJSON = new JSONObject();
        attribCriteriaJSON.put("join", this.isAndSearch() ? "and" : "or");
        JSONArray criteriaJSON = new JSONArray();
        for (SearchCriteria criteriaEntry : this.getSearchCriteria()) {
            if (criteriaEntry instanceof SearchCriterion) {
                SearchCriterion criterion = (SearchCriterion)criteriaEntry;
                JSONObject criterionJSON = new JSONObject();
                criterionJSON.put("id", criterion.getName());
                criterionJSON.put("dataType", criterion.getDataType());
                criterionJSON.put("operator", criterion.getOperator());
                JSONArray valuesJSON = new JSONArray();
                valuesJSON.addAll(Arrays.asList(criterion.getValues()));
                criterionJSON.put("values", valuesJSON);
                criteriaJSON.add(criterionJSON);
                continue;
            }
            if (!(criteriaEntry instanceof ChildSearchCriteria)) continue;
            ChildSearchCriteria child = (ChildSearchCriteria)criteriaEntry;
            JSONObject childJson = new JSONObject();
            childJson.put("childId", child.getName());
            JSONArray childCriteriaArray = new JSONArray();
            childJson.put("criteria", childCriteriaArray);
            for (SearchCriterion childEntry : child.getSearchCriteria()) {
                childCriteriaArray.add(this.createSearchCriterionJSON(childEntry));
            }
            criteriaJSON.add(childJson);
        }
        attribCriteriaJSON.put("criteria", criteriaJSON);
        json.put("attributeCriteria", attribCriteriaJSON);
        SearchTemplate.TextSearchCriterion textSearchCriteria = this.getFirstTextSearchCriterion();
        if (textSearchCriteria != null) {
            json.put("textCriteria", textSearchCriteria.toJSON());
        }
        JSONObject optionsJSON = new JSONObject();
        SearchTemplate.VersionOption verOption = this.getVersionOption();
        if (verOption != null) {
            optionsJSON.put("version", verOption.toString());
        }
        optionsJSON.put("join", this.isPropertyTextAnded() ? "and" : "or");
        SearchTemplate.Macros macros = this.getMacros();
        if (macros != null) {
            optionsJSON.put("filters", macros.toJSON());
        }
        json.put("options", optionsJSON);
        SearchTemplate.ResultsDisplay resultsDisplay = this.getResultsDisplay();
        if (resultsDisplay != null) {
            json.put("resultsDisplay", resultsDisplay.toJSON());
        }
        return json;
    }

    public JSONObject createSearchCriterionJSON(SearchCriterion criterion) {
        JSONObject criterionJSON = new JSONObject();
        criterionJSON.put("id", criterion.getName());
        criterionJSON.put("dataType", criterion.getDataType());
        criterionJSON.put("operator", criterion.getOperator());
        JSONArray valuesJSON = new JSONArray();
        valuesJSON.addAll(Arrays.asList(criterion.getValues()));
        criterionJSON.put("values", valuesJSON);
        return criterionJSON;
    }

    public void load(HttpServletRequest request, DKDatastoreICM dataStore, RepositoryConfig repositoryConfig, JSONObject json) throws DKException, Exception {
        this.fromPersistableJSON(json);
        String nameAttribute = null;
        if (!this.getFirstClassName().equals("$common")) {
            DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dataStore.datastoreDef();
            DKComponentTypeDefICM itemType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(this.getFirstClassName());
            nameAttribute = CMBaseUtil.getNameAttrForEntity(request, itemType);
        }
        this.normalizeResultsDisplay(nameAttribute, repositoryConfig);
    }

    private void normalizeResultsDisplay(String nameAttribute, RepositoryConfig repositoryConfig) {
        SearchTemplate.ResultsDisplay resultsDisplay = this.getResultsDisplay() == null ? new SearchTemplate.ResultsDisplay(nameAttribute, false, repositoryConfig.getSearchDefaultColumns()) : this.getResultsDisplay();
        SearchTemplate.ObjectType objectType = this.getObjectType();
        String[] filteredProperties = objectType == SearchTemplate.ObjectType.document ? repositoryConfig.getSearchFilteredDocumentProperties() : repositoryConfig.getSearchFilteredFolderProperties();
        HashSet<String> filteredSet = new HashSet<String>(Arrays.asList(filteredProperties));
        ArrayList<String> normalizedList = new ArrayList<String>();
        if (this.getResultsDisplay() != null && this.getResultsDisplay().getColumns() != null) {
            for (String selectProp : this.getResultsDisplay().getColumns()) {
                if (normalizedList.size() == 0 || !filteredSet.contains(selectProp)) {
                    normalizedList.add(selectProp);
                    continue;
                }
                if (!selectProp.equals(this.getResultsDisplay().getSortByProperty())) continue;
                resultsDisplay.setSortByProperty(nameAttribute);
                resultsDisplay.setSortAscending(true);
            }
        }
        String[] columns = new String[normalizedList.size()];
        resultsDisplay.setColumns(normalizedList.toArray(columns));
        this.setResultsDisplay(resultsDisplay);
    }

    public void fromPersistableJSON(JSONObject json) {
        JSONObject resultsDisplayJSON;
        JSONObject optionsJSON;
        JSONObject textCriteriaJSON;
        JSONArray classesJSON = (JSONArray)json.get("classes");
        if (classesJSON != null && classesJSON.size() > 0) {
            for (JSONObject classJSON : classesJSON) {
                SearchTemplate.SearchClass searchClass = new SearchTemplate.SearchClass();
                searchClass.setName((String)classJSON.get("itemTypeName"));
                this.addClass(searchClass);
            }
        } else {
            SearchTemplate.SearchClass searchClass = new SearchTemplate.SearchClass();
            searchClass.setName((String)json.get("itemTypeName"));
            this.addClass(searchClass);
        }
        this.setObjectType(SearchTemplate.ObjectType.valueOf((String)json.get("objectType")));
        JSONArray foldersJSON = (JSONArray)json.get("folders");
        if (foldersJSON != null && foldersJSON.size() > 0) {
            for (JSONObject folderJSON : foldersJSON) {
                SearchTemplate.SearchFolder folder;
                DKPidICM pid = null;
                String folderId = (String)folderJSON.get("id");
                if (folderId.equals(SearchTemplate.THIS_TEAMSPACE_ID)) {
                    folder = new SearchTemplate.SearchFolder(folderId, null, (Boolean)folderJSON.get("includeSubfolders"), SearchTemplate.SearchFolderView.editable, null, null, null);
                } else {
                    try {
                        pid = new DKPidICM((String)folderJSON.get("id"));
                        folderId = pid.toString();
                    }
                    catch (DKException e) {
                        // empty catch block
                    }
                    folder = new SearchTemplate.SearchFolder(pid.toString(), null, (Boolean)folderJSON.get("includeSubfolders"), SearchTemplate.SearchFolderView.editable, pid.getDatastoreName(), null, null);
                }
                this.addFolder(folder);
            }
        }
        JSONObject attribCriteriaJSON = (JSONObject)json.get("attributeCriteria");
        this.isAndSearch(attribCriteriaJSON.get("join").equals("and"));
        JSONArray criteriaJSON = (JSONArray)attribCriteriaJSON.get("criteria");
        for (int i = 0; i < criteriaJSON.size(); ++i) {
            JSONObject searchCriteriaEntryJSON = (JSONObject)criteriaJSON.get(i);
            if (searchCriteriaEntryJSON.get("childId") != null) {
                ChildSearchCriteria child = new ChildSearchCriteria();
                child.setName((String)searchCriteriaEntryJSON.get("childId"));
                ArrayList<SearchCriterion> criterionArray = new ArrayList<SearchCriterion>();
                JSONArray childCriteriaJSON = (JSONArray)searchCriteriaEntryJSON.get("criteria");
                if (childCriteriaJSON != null) {
                    for (int j = 0; j < childCriteriaJSON.size(); ++j) {
                        JSONObject childCriterionJSON = (JSONObject)childCriteriaJSON.get(j);
                        criterionArray.add(this.createSearchCriterionFromJson(childCriterionJSON));
                    }
                    child.setSearchCriteria(criterionArray);
                }
                this.addChild(child);
                continue;
            }
            this.addCriterion(this.createSearchCriterionFromJson(searchCriteriaEntryJSON));
        }
        Object childJSON = json.get("childCriteria");
        if (childJSON != null) {
            JSONArray childArray = (JSONArray)childJSON;
            for (int j = 0; j < childArray.size(); ++j) {
                JSONObject childObj = (JSONObject)childArray.get(j);
                ChildSearchCriteria child = new ChildSearchCriteria();
                child.setName((String)childObj.get("name"));
                JSONArray childCriterionJSON = (JSONArray)childObj.get("criteria");
                for (int k = 0; k < childCriterionJSON.size(); ++k) {
                    child.addCriterion(this.createSearchCriterionFromJson((JSONObject)childCriterionJSON.get(k)));
                }
                this.addChild(child);
            }
        }
        if ((textCriteriaJSON = (JSONObject)json.get("textCriteria")) != null) {
            SearchTemplate.TextSearchCriterion textSearchCriteria = new SearchTemplate.TextSearchCriterion();
            textSearchCriteria.fromJSON(textCriteriaJSON);
            this.addTextSearchCriterion(textSearchCriteria);
        }
        if ((optionsJSON = (JSONObject)json.get("options")) != null) {
            JSONObject filters;
            String join;
            String ver = (String)optionsJSON.get("version");
            if (ver != null) {
                this.setVersionOption(SearchTemplate.VersionOption.valueOf(ver));
            }
            if ((join = (String)optionsJSON.get("join")) != null) {
                this.setPropertyTextAnded(join.equals("and"));
            }
            if ((filters = (JSONObject)optionsJSON.get("filters")) != null) {
                SearchTemplate.Macros macros = new SearchTemplate.Macros();
                macros.fromJSON(filters);
                this.setMacros(macros);
            }
        }
        if ((resultsDisplayJSON = (JSONObject)json.get("resultsDisplay")) != null) {
            SearchTemplate.ResultsDisplay resultsDisplay = new SearchTemplate.ResultsDisplay();
            resultsDisplay.fromJSON(resultsDisplayJSON);
            this.setResultsDisplay(resultsDisplay);
        }
    }

    public SearchCriterion createSearchCriterionFromJson(JSONObject searchCriterionJSON) {
        SearchCriterion criterion = new SearchCriterion();
        criterion.setName(searchCriterionJSON.get("id").toString());
        criterion.setDataType((String)searchCriterionJSON.get("dataType"));
        criterion.setOperator((String)searchCriterionJSON.get("operator"));
        JSONArray valuesJSON = (JSONArray)searchCriterionJSON.get("values");
        String[] values = new String[valuesJSON.size()];
        valuesJSON.toArray(values);
        criterion.setValues(values);
        return criterion;
    }
}

