/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cm;

public class CMSearchConstants {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SystemAttribute {
        itemID,
        idValue,
        version,
        modifiedTimestamp,
        modifiedBy,
        createdTimestamp,
        createdBy,
        aclCode,
        semanticType;


        public String getAttributeName() {
            switch (this) {
                case version: {
                    return "VERSIONID";
                }
                case modifiedTimestamp: {
                    return "LASTCHANGEDTS";
                }
                case modifiedBy: {
                    return "LASTCHANGEDUSERID";
                }
                case createdTimestamp: {
                    return "CREATETS";
                }
                case createdBy: {
                    return "CREATEUSERID";
                }
                case itemID: 
                case idValue: {
                    return "ITEMID";
                }
                case aclCode: {
                    return "ACLCODE";
                }
                case semanticType: {
                    return "SEMANTICTYPE";
                }
            }
            return "";
        }

        public boolean isNumeric() {
            short type = this.getType();
            return type == 3 || type == 4 || type == 5 || type == 6 || type == 10;
        }

        public short getType() {
            switch (this) {
                case version: {
                    return 4;
                }
                case modifiedTimestamp: {
                    return 9;
                }
                case modifiedBy: {
                    return 2;
                }
                case createdTimestamp: {
                    return 9;
                }
                case createdBy: {
                    return 2;
                }
                case itemID: 
                case idValue: {
                    return 2;
                }
                case aclCode: {
                    return 4;
                }
                case semanticType: {
                    return 4;
                }
            }
            return 0;
        }

        public double getSize() {
            switch (this) {
                case version: {
                    return 6.0;
                }
                case modifiedTimestamp: {
                    return 12.0;
                }
                case modifiedBy: {
                    return 6.0;
                }
                case createdTimestamp: {
                    return 12.0;
                }
                case createdBy: {
                    return 6.0;
                }
            }
            return 6.0;
        }

        public String getMessageKey() {
            switch (this) {
                case version: {
                    return "systemcm.version.label";
                }
                case modifiedTimestamp: {
                    return "systemcm.modifiedTimestamp.label";
                }
                case modifiedBy: {
                    return "systemcm.modifiedBy.label";
                }
                case createdTimestamp: {
                    return "systemcm.createdTimestamp.label";
                }
                case createdBy: {
                    return "systemcm.createdBy.label";
                }
                case itemID: 
                case idValue: {
                    return "systemcm.itemID.label";
                }
                case aclCode: {
                    return "systemcm.aclCode.label";
                }
                case semanticType: {
                    return "systemcm.semanticType.label";
                }
            }
            return "";
        }

        public String getSortType() {
            switch (this) {
                case version: {
                    return "stringSort";
                }
                case modifiedTimestamp: {
                    return "timeSort";
                }
                case modifiedBy: {
                    return "stringSort";
                }
                case createdTimestamp: {
                    return "timeSort";
                }
                case createdBy: {
                    return "stringSort";
                }
                case itemID: 
                case idValue: {
                    return "stringSort";
                }
                case aclCode: {
                    return "stringSort";
                }
                case semanticType: {
                    return "stringSort";
                }
            }
            return "stringSort";
        }
    }
}

