/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.sql.Date;
import java.sql.Time;
import java.text.Collator;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Comparator;
import java.util.Locale;

public class CMItemComparator
implements Comparator {
    String _server;
    String _entity;
    String _attribute;
    int _attrIndex;
    boolean _ascending;
    Collator _nlsCollator = Collator.getInstance();
    boolean _traceEnabled = false;
    CMConnection _connBean = null;
    WCDateFormat _dateFormats = null;
    public static short LESS_THAN = (short)-1;
    public static short EQUAL = 0;
    public static short GREATER_THAN = 1;
    String _contextAttribute = "";
    CMItem _contextItem = null;

    public CMItemComparator(String attribute, boolean ascending, DKDatastoreICM conn, WCDateFormat dateFormats) {
        this._server = null;
        this._entity = null;
        this._attribute = attribute;
        this._attrIndex = -1;
        this._ascending = ascending;
        this._dateFormats = dateFormats;
    }

    public CMItemComparator(String attribute, boolean ascending, WCDateFormat dateFormats) {
        this._server = null;
        this._entity = null;
        this._attribute = attribute;
        this._attrIndex = -1;
        this._ascending = ascending;
        this._dateFormats = dateFormats;
    }

    public CMItemComparator(boolean ascending, WCDateFormat dateFormats) {
        this("", ascending, null, dateFormats);
    }

    public CMItemComparator(String server, String entity, String attribute, boolean ascending, DKDatastoreICM conn, WCDateFormat dateFormats) {
        this._server = server;
        this._entity = entity;
        this._attribute = attribute;
        this._attrIndex = -1;
        this._ascending = ascending;
        this._dateFormats = dateFormats;
    }

    public CMItemComparator(String server, String entity, String attribute, boolean ascending, WCDateFormat dateFormats) {
        this._server = server;
        this._entity = entity;
        this._attribute = attribute;
        this._attrIndex = -1;
        this._ascending = ascending;
        this._dateFormats = dateFormats;
    }

    public void setAscending(boolean ascending) {
        this._ascending = ascending;
    }

    public boolean getAscending() {
        return this._ascending;
    }

    public void setSortAttribute(String attribute) {
        this._attribute = attribute;
    }

    public String getSortAttribute() {
        return this._attribute;
    }

    public void setContextAttribute(String attribute) {
        this._contextAttribute = attribute;
    }

    public String getContextAttribute() {
        return this._contextAttribute;
    }

    public void setContextItem(CMItem item) {
        this._contextItem = item;
    }

    public CMItem getContextItem() {
        return this._contextItem;
    }

    public void setEntity(String entity) {
        this._entity = entity;
    }

    public String getEntity() {
        return this._entity;
    }

    public int compare(Object o1, Object o2) {
        short result = EQUAL;
        if (!(o1 instanceof CMItem) || !(o2 instanceof CMItem)) {
            return this.compareValues(o1, o2);
        }
        if (!(o1 instanceof CMItem)) {
            return this._ascendingTransform(LESS_THAN);
        }
        if (!(o2 instanceof CMItem)) {
            return this._ascendingTransform(GREATER_THAN);
        }
        try {
            String attr;
            CMItem item1 = (CMItem)o1;
            CMItem item2 = (CMItem)o2;
            if (this._entity != null) {
                if (!item1.getEntityName().equals(this._entity) && !item2.getEntityName().equals(this._entity)) {
                    return EQUAL;
                }
                if (!item1.getEntityName().equals(this._entity)) {
                    return this._ascendingTransform(LESS_THAN);
                }
                if (!item2.getEntityName().equals(this._entity)) {
                    return this._ascendingTransform(GREATER_THAN);
                }
            }
            if ((attr = this._attribute).indexOf(47) > -1) {
                String parentPath = item1.getParentPath();
                if (!this._attribute.startsWith(parentPath)) {
                    return EQUAL;
                }
                attr = this._attribute.substring(parentPath.length());
                if (attr.startsWith("/")) {
                    attr = attr.substring(1);
                }
                if (attr.indexOf(47) > -1) {
                    attr = attr.substring(0, attr.indexOf(47));
                }
            }
            if (attr.length() == 0) {
                return this._compareFirstValues(item1, item2);
            }
            if (this._attrIndex < 0) {
                String[] attrNames = item1.getAttrName();
                for (int i = 0; this._attrIndex == -1 && i < attrNames.length; ++i) {
                    if (!attrNames[i].equals(attr)) continue;
                    this._attrIndex = i;
                }
            }
            int _attrIndex2 = -1;
            String[] attrNames = item2.getAttrName();
            for (int i = 0; _attrIndex2 == -1 && i < attrNames.length; ++i) {
                if (!attrNames[i].equals(attr)) continue;
                _attrIndex2 = i;
            }
            if (this._attrIndex < 0 && _attrIndex2 < 0) {
                return EQUAL;
            }
            if (this._attrIndex < 0 && _attrIndex2 >= 0) {
                return this._ascendingTransform(LESS_THAN);
            }
            if (this._attrIndex >= 0 && _attrIndex2 < 0) {
                return this._ascendingTransform(GREATER_THAN);
            }
            Object value1 = this._getAttrValue(item1, attr);
            Object value2 = this._getAttrValue(item2, attr);
            return this.compare(value1, value2);
        }
        catch (Exception e) {
            return EQUAL;
        }
    }

    public boolean equals(Object obj) {
        CMItemComparator comp;
        return obj != null && obj.getClass().getName().equals(this.getClass().getName()) && this._ascending == (comp = (CMItemComparator)obj).getAscending() && this._attribute == comp.getSortAttribute() && this._entity == comp.getEntity() && this._server == comp._server;
    }

    private int _ascendingTransform(int value) {
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    private int _compareFirstValues(CMItem item1, CMItem item2) {
        int result = EQUAL;
        try {
            if (item1 == null && item2 == null) {
                return EQUAL;
            }
            if (item1 == null && item2 != null) {
                return this._ascendingTransform(LESS_THAN);
            }
            if (item1 != null && item2 == null) {
                return this._ascendingTransform(GREATER_THAN);
            }
            String[] names1 = item1.getAttrNames();
            String[] values1 = item1.getAttrValues();
            short[] types1 = item1.getAttrTypes();
            String[] names2 = item2.getAttrNames();
            String[] values2 = item2.getAttrValues();
            short[] types2 = item2.getAttrTypes();
            for (int i = 0; i < values1.length && result == EQUAL; ++i) {
                if (types1[i] == 1072 || types1[i] == 48) {
                    CMItem[] children1 = item1.getAttrItems(names1[i]);
                    CMItem child1 = null;
                    if (children1 != null && children1.length > 0) {
                        child1 = children1[0];
                    } else {
                        result = EQUAL;
                    }
                    CMItem[] children2 = item2.getAttrItems(names2[i]);
                    CMItem child2 = null;
                    if (children2 != null && children2.length > 0) {
                        child2 = children1[0];
                    } else {
                        result = EQUAL;
                    }
                    result = this._compareFirstValues(child1, child2);
                    continue;
                }
                Object value1 = this._getAttrValue(item1, names1[i]);
                Object value2 = this._getAttrValue(item2, names2[i]);
                result = this.compareValues(value1, value2);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    private Object _findLeastAttrValue(CMItem item, String attrName) {
        Object value = null;
        int type = -1;
        String attr = attrName;
        int index = -1;
        String dsType = "";
        if (item.getDDO() != null && item.getDDO().getPidObject() != null) {
            dsType = item.getDDO().getPidObject().getDatastoreType();
        }
        if ((index = attr.indexOf(47)) > -1) {
            attr = attr.substring(0, index);
        }
        try {
            type = item.getAttrType(attr);
            value = item.getAttrValue(attr);
            if (value != null) {
                if (type == 1072 || type == 48) {
                    CMItem[] children = item.getAttrItems(attr);
                    CMItem child = null;
                    if (children == null || children.length <= 0) {
                        return null;
                    }
                    child = children[0];
                    String subAttr = attrName.substring(index + 1);
                    value = this._findLeastAttrValue(child, subAttr);
                    type = 4;
                } else {
                    value = item.isMultiValuedAttr(attr) ? (item.getAttrValues(attr).length > 0 ? item.getAttrValues(attr)[0] : null) : item.getAttrValue(attr);
                }
            }
        }
        catch (Exception e) {
            value = null;
        }
        if (value instanceof String) {
            value = this.attributeValueAsObject((String)value, (short)type);
        }
        return value;
    }

    private Object _getAttrValue(CMItem item, String attrName) throws Exception {
        Object value;
        if (item.isMultiValuedAttr(attrName) || item.getAttrType(attrName) == 1072 || item.getAttrType(attrName) == 48) {
            value = this._findLeastAttrValue(item, this._attribute.substring(item.getParentPath().length()));
        } else {
            String temp = item.getAttrValue(attrName);
            short type = item.getAttrType(attrName);
            value = this.attributeValueAsObject(temp, type);
        }
        return value;
    }

    private Object attributeValueAsObject(String value, short type) {
        if (type == 2) {
            return value.trim();
        }
        if (type == 1) {
            return value.trim();
        }
        if (type == 7) {
            Date sqlDate;
            Object retValue;
            block42: {
                retValue = value;
                sqlDate = null;
                try {
                    if (null == value || "".equals(value)) {
                        sqlDate = new Date(0, 0, 1);
                    } else {
                        DateFormat dformat = this.getDateFormats().getDateFormat();
                        sqlDate = CMBaseUtil.getDKDateFromString(value, dformat);
                    }
                }
                catch (Exception e) {
                    if (null != value && !"".equals(value)) break block42;
                    sqlDate = new Date(0, 0, 1);
                }
            }
            if (sqlDate != null) {
                retValue = new DisplayableDate(sqlDate.getTime(), this.getDateFormats().getDateFormat());
            }
            return retValue;
        }
        if (type == 9) {
            Date sqlDate;
            Object retValue;
            block43: {
                retValue = value;
                sqlDate = null;
                try {
                    if (null == value || "".equals(value)) {
                        sqlDate = new Date(0, 0, 1);
                    } else {
                        DateFormat dformat = this.getDateFormats().getTimestampFormat();
                        sqlDate = CMBaseUtil.getDKDateFromString(value, dformat);
                    }
                }
                catch (Exception e) {
                    if (null != value && !"".equals(value)) break block43;
                    sqlDate = new Date(0, 0, 1);
                }
            }
            if (sqlDate != null) {
                retValue = new DisplayableDate(sqlDate.getTime(), this.getDateFormats().getTimestampFormat());
            }
            return retValue;
        }
        if (type == 8) {
            try {
                Time sqlTime = (Time)this.getDateFormats().getTimeFormat().parse(value);
                return new DisplayableTime(sqlTime.getTime(), this.getDateFormats().getTimeFormat());
            }
            catch (Exception e) {
                return value;
            }
        }
        if (type == 3) {
            try {
                return this.formatForCurrentLocale(value);
            }
            catch (ParseException e) {
                try {
                    return Short.valueOf(value);
                }
                catch (NumberFormatException ex) {
                    return new Short(Short.MIN_VALUE);
                }
            }
        }
        if (type == 4) {
            try {
                return this.formatForCurrentLocale(value);
            }
            catch (ParseException e) {
                try {
                    return Long.valueOf(value);
                }
                catch (NumberFormatException ex) {
                    return new Long(Long.MIN_VALUE);
                }
            }
        }
        if (type == 5) {
            try {
                return this.formatForCurrentLocale(value);
            }
            catch (ParseException e) {
                try {
                    return Float.valueOf(value);
                }
                catch (NumberFormatException ex) {
                    return new Float(Float.MIN_VALUE);
                }
            }
        }
        if (type == 10) {
            try {
                return this.formatForCurrentLocale(value);
            }
            catch (ParseException e) {
                try {
                    return Double.valueOf(value);
                }
                catch (NumberFormatException ex) {
                    return new Double(Double.MIN_VALUE);
                }
            }
        }
        if (type == 6) {
            try {
                return this.formatForCurrentLocale(value);
            }
            catch (ParseException e) {
                try {
                    return Double.valueOf(value);
                }
                catch (NumberFormatException ex) {
                    return new Double(Double.MIN_VALUE);
                }
            }
        }
        return value;
    }

    Object formatForCurrentLocale(String value) throws ParseException {
        ParsePosition pos;
        NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
        Number num = nf.parse(value, pos = new ParsePosition(0));
        if (num == null || pos.getIndex() < value.length()) {
            throw new ParseException(value, pos.getIndex());
        }
        return num;
    }

    private int compareValues(Object o1, Object o2) {
        Boolean bool2;
        boolean b2;
        Boolean bool1;
        boolean b1;
        java.util.Date d2;
        long n2;
        java.util.Date d1;
        long n1;
        Number n22;
        double d22;
        Number n12;
        double d12;
        String s2;
        String s1;
        int result = EQUAL;
        result = o1 == null && o2 == null ? EQUAL : (o1 == null ? LESS_THAN : (o2 == null ? GREATER_THAN : (o1 instanceof String && o2 instanceof String ? ((result = this._nlsCollator.compare(s1 = (String)o1, s2 = (String)o2)) < EQUAL ? (int)LESS_THAN : (result > EQUAL ? (int)GREATER_THAN : (int)EQUAL)) : (o1 instanceof Number && o2 instanceof Number ? ((d12 = (n12 = (Number)o1).doubleValue()) < (d22 = (n22 = (Number)o2).doubleValue()) ? (int)LESS_THAN : (d12 > d22 ? (int)GREATER_THAN : (int)EQUAL)) : (o1 instanceof java.util.Date && o2 instanceof java.util.Date ? ((n1 = (d1 = (java.util.Date)o1).getTime()) < (n2 = (d2 = (java.util.Date)o2).getTime()) ? (int)LESS_THAN : (n1 > n2 ? (int)GREATER_THAN : (int)EQUAL)) : (o1 instanceof Boolean & o2 instanceof Boolean ? ((b1 = (bool1 = (Boolean)o1).booleanValue()) == (b2 = (bool2 = (Boolean)o2).booleanValue()) ? (int)EQUAL : (b1 ? (int)GREATER_THAN : (int)LESS_THAN)) : EQUAL))))));
        if (!this._ascending) {
            result = -result;
        }
        return result;
    }

    public WCDateFormat getDateFormats() {
        return this._dateFormats;
    }

    public void setDateFormats(WCDateFormat dateFormat) {
        this._dateFormats = dateFormat;
    }

    class DisplayableTime
    extends java.util.Date {
        DateFormat timeFormat;

        public DisplayableTime(long time, DateFormat format) {
            super(time);
            this.timeFormat = format;
        }

        public String toString() {
            return this.timeFormat.format(this);
        }
    }

    class DisplayableDate
    extends java.util.Date {
        DateFormat dateFormat;

        public DisplayableDate(long time, DateFormat format) {
            super(time);
            this.dateFormat = format;
        }

        public String toString() {
            return this.dateFormat.format(this);
        }
    }
}

