/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMEntity;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMObject;
import com.ibm.ecm.extension.PluginServiceUtil;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMAnnotationsMediator;
import com.ibm.ecm.mediator.cm.CMBookmarksMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.ContentUtil;
import com.ibm.ecm.util.DocumentContent;
import com.ibm.ecm.util.MimeTypeUtil;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.io.InputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.util.MessageResources;

public class CMContentUtil {
    private static final int DEFAULT_ANNOTATION_POSITION = 1400;

    public static Object getSynchObject(HttpServletRequest request, String repositoryId) {
        DKDatastoreICM synchObject = null;
        CMConnection connection = PluginServiceUtil.getCMConnection(request, repositoryId);
        if (connection != null) {
            synchObject = CMContentUtil.getDsIcm(request, connection);
        }
        return synchObject;
    }

    public static CMItem retrieveDocument(HttpServletRequest request, String repositoryId, String documentId, DKRetrieveOptionsICM dkRetrieveOptions) throws Exception {
        CMRetriever cmRetriever = new CMRetriever(request, repositoryId);
        return cmRetriever.retrieveItem(request, documentId, dkRetrieveOptions);
    }

    public static DocumentContent retrieveContent(HttpServletRequest request, String repositoryId, String documentId, int partNum) throws Exception {
        CMRetriever cmRetriever = new CMRetriever(request, repositoryId);
        return cmRetriever.retrieveContent(request, documentId, partNum);
    }

    public static CMAnnotationsMediator retrieveAnnotations(HttpServletRequest request, MessageResources resources, String repositoryId, String documentId, Integer annotationPosition) {
        CMRetriever cmRetriever = new CMRetriever(request, repositoryId);
        return cmRetriever.retrieveAnnotations(request, resources, repositoryId, documentId, annotationPosition);
    }

    public static CMBookmarksMediator retrieveBookmarks(HttpServletRequest request, MessageResources resources, String repositoryId, String documentId) {
        CMRetriever cmRetriever = new CMRetriever(request, repositoryId);
        return cmRetriever.retrieveBookmarks(request, resources, repositoryId, documentId);
    }

    public static CMObject retrieveNativeAnnotations(HttpServletRequest request, CMItem document, String repositoryId, int partNum) throws Exception {
        CMRetriever cmRetriever = new CMRetriever(request, repositoryId);
        return cmRetriever.retrieveAnnotationPart(request, document, partNum);
    }

    public static CMObject retrieveNativeAnnotations(HttpServletRequest request, CMItem document, String repositoryId) throws Exception {
        return CMContentUtil.retrieveNativeAnnotations(request, document, repositoryId, 0);
    }

    public static CMObject retrieveNativeBookmarks(HttpServletRequest request, CMItem document, String repositoryId) throws Exception {
        return CMContentUtil.retrieveNativeAnnotations(request, document, repositoryId, 1);
    }

    public static CMAnnotationsMediator updateAnnotations(HttpServletRequest request, MessageResources resources, String repositoryId, String documentId, Integer annotationPosition) {
        CMRetriever cmRetriever = new CMRetriever(request, repositoryId);
        return (CMAnnotationsMediator)cmRetriever.updateAnnotationsPart(request, resources, repositoryId, documentId, annotationPosition, 0);
    }

    public static CMBookmarksMediator updateBookmarks(HttpServletRequest request, MessageResources resources, String repositoryId, String documentId) {
        CMRetriever cmRetriever = new CMRetriever(request, repositoryId);
        return (CMBookmarksMediator)cmRetriever.updateAnnotationsPart(request, resources, repositoryId, documentId, null, 1);
    }

    private static Integer getAnnotationPosition(HttpServletRequest request, CMConnection connection, Integer annotationPosition, CMAnnotationsMediator annotationsMediator) {
        block8: {
            String methodName = "getAnnotationPosition";
            if (annotationPosition == null) {
                annotationPosition = 1400;
            }
            try {
                String apiVersion = CMContentUtil.getDsIcm(request, connection).getAPIVersion();
                Logger.logDebug(CMContentUtil.class, methodName, (ServletRequest)request, "CM API Version: " + apiVersion);
                if (apiVersion.startsWith("8.3") && apiVersion.compareTo("8.3.0.950") < 0) {
                    annotationPosition = annotationPosition & 0xFFFFFF;
                } else if (apiVersion.startsWith("8.4.0")) {
                    annotationPosition = annotationPosition & 0xFFFFFF;
                } else if (apiVersion.startsWith("8.4.1") && apiVersion.compareTo("8.4.1.100") < 0) {
                    annotationPosition = annotationPosition & 0xFFFFFF;
                }
                Logger.logDebug(CMContentUtil.class, methodName, (ServletRequest)request, "adjusted annotation position: " + annotationPosition);
            }
            catch (NumberFormatException e) {
                Logger.logError(CMContentUtil.class, methodName, (ServletRequest)request, (Throwable)e);
                if (annotationsMediator == null) break block8;
                annotationsMediator.addError("error.exception.general", e.getMessage());
            }
        }
        return annotationPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DKDatastoreICM getDsIcm(HttpServletRequest request, CMConnection connection) {
        DKDatastoreICM dsICM = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            HttpSession httpSession = session;
            synchronized (httpSession) {
                dsICM = connection.getDatastore();
            }
        } else {
            dsICM = connection.getDatastore();
        }
        return dsICM;
    }

    private static class CMRetriever {
        CMConnection connection = null;
        DKDatastoreICM dsICM = null;

        private CMRetriever(HttpServletRequest request, String repositoryId) {
            this.connection = PluginServiceUtil.getCMConnection(request, repositoryId);
            if (this.connection != null) {
                this.dsICM = CMContentUtil.getDsIcm(request, this.connection);
            }
        }

        private DocumentContent retrieveContent(HttpServletRequest request, String documentId, int partNum) throws Exception {
            String methodName = "retrieveDocumentContent";
            CMDocumentContent documentContent = null;
            if (this.connection != null && this.dsICM != null) {
                CMItem item = this.retrieveItem(request, documentId, false);
                int partCount = item.getContentCount();
                if (partNum < 0 || partNum >= partCount) {
                    Logger.logDebug(CMContentUtil.class, methodName, (ServletRequest)request, "Requested content part does not exist");
                    throw new Exception("Requested content part does not exist");
                }
                Logger.logDebug(CMContentUtil.class, methodName, (ServletRequest)request, "partNum: " + partNum + ", partCount: " + partCount);
                CMObject part = item.getContent(Math.max(0, partNum));
                documentContent = new CMDocumentContent(item, part, partNum, partCount);
            }
            return documentContent;
        }

        private CMObject retrieveAnnotationPart(HttpServletRequest request, CMItem item, int partNum) throws Exception {
            int annotationCount;
            CMObject cmObject = null;
            if (this.connection != null && this.dsICM != null && (annotationCount = item.getAnnotationCount()) > partNum) {
                cmObject = item.getAnnotation(partNum);
            }
            return cmObject;
        }

        private CMAnnotationsMediator retrieveAnnotations(HttpServletRequest request, MessageResources resources, String repositoryId, String documentId, Integer annotationPosition) {
            return (CMAnnotationsMediator)this.retrieveAnnotationPart(request, resources, repositoryId, documentId, annotationPosition, 0);
        }

        private CMBookmarksMediator retrieveBookmarks(HttpServletRequest request, MessageResources resources, String repositoryId, String documentId) {
            return (CMBookmarksMediator)this.retrieveAnnotationPart(request, resources, repositoryId, documentId, null, 1);
        }

        private BaseMediator retrieveAnnotationPart(HttpServletRequest request, MessageResources resources, String repositoryId, String documentId, Integer annotationPosition, int partNum) {
            BaseMediator mediator;
            block8: {
                String methodName = "retrieveAnnotationPart";
                mediator = this.createMediator(request, resources, partNum);
                if (this.connection != null && this.dsICM != null) {
                    try {
                        CMItem item = this.retrieveItem(request, documentId, true);
                        int annotationCount = item.getAnnotationCount();
                        if (annotationCount <= partNum) break block8;
                        CMEntity entity = this.connection.getEntity(item.getEntityName());
                        short versionPolicy = entity.getPartTypeVersionPolicy("ICMANNOTATION");
                        if (partNum == 0) {
                            if (annotationPosition == null) {
                                annotationPosition = 1400;
                            }
                            CMAnnotationsMediator annotationsMediator = (CMAnnotationsMediator)mediator;
                            CMObject annotation = item.getAnnotation(partNum);
                            annotationsMediator.setAnnotationPosition(annotationPosition);
                            annotationsMediator.setAnnotation(annotation);
                            annotationsMediator.setVersioningPolicy(versionPolicy);
                            mediator = annotationsMediator;
                        } else if (partNum == 1) {
                            CMBookmarksMediator bookmarksMediator = (CMBookmarksMediator)mediator;
                            CMObject bookmarkAnnotation = item.getAnnotation(partNum);
                            bookmarksMediator.setBookmarks(bookmarkAnnotation);
                            bookmarksMediator.setVersioningPolicy(versionPolicy);
                            mediator = bookmarksMediator;
                        }
                    }
                    catch (Exception exc) {
                        Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)exc);
                        mediator.addError("error.exception.general", exc.getMessage());
                    }
                } else {
                    mediator.addError("error.no.connection");
                }
            }
            return mediator;
        }

        public CMItem retrieveItem(HttpServletRequest request, String documentId, DKRetrieveOptionsICM dkRetrieveOptions) throws Exception {
            if (dkRetrieveOptions == null) {
                dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this.connection.getDatastore());
                dkRetrieveOptions.baseAttributes(true);
                dkRetrieveOptions.partsList(true);
                dkRetrieveOptions.partsAttributes(true);
            }
            return this.connection.retrieveItem(documentId, request, dkRetrieveOptions);
        }

        private CMItem retrieveItem(HttpServletRequest request, String documentId, boolean forAnnotations) throws Exception {
            DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this.connection.getDatastore());
            if (!forAnnotations) {
                dkRetrieveOptions.baseAttributes(true);
            }
            dkRetrieveOptions.partsList(true);
            dkRetrieveOptions.partsAttributes(true);
            return this.connection.retrieveItem(documentId, request, dkRetrieveOptions);
        }

        private BaseMediator updateAnnotationsPart(HttpServletRequest request, MessageResources resources, String repositoryId, String documentId, Integer annotationPosition, int partNum) {
            BaseMediator mediator;
            block9: {
                String methodName = "updateAnnotations";
                Logger.logEntry((Object)this, methodName, (ServletRequest)request);
                mediator = this.createMediator(request, resources, partNum);
                if (this.connection != null) {
                    try {
                        byte[] annotationData = ContentUtil.getRequestData(request);
                        CMObject newAnnotation = null;
                        boolean newVersion = false;
                        String jsonString = new String(annotationData, "UTF-8");
                        JSONObject jsonObject = JSONObject.parse(jsonString);
                        if (partNum == 0) {
                            CMAnnotationsMediator annotationsMediator = (CMAnnotationsMediator)mediator;
                            mediator = annotationsMediator;
                            annotationPosition = CMContentUtil.getAnnotationPosition(request, this.connection, annotationPosition, annotationsMediator);
                            annotationsMediator.fromJSONObject(jsonObject, annotationPosition);
                            newAnnotation = annotationsMediator.getAnnotation();
                            newVersion = annotationsMediator.isNewVersion();
                        } else if (partNum == 1) {
                            CMBookmarksMediator bookmarksMediator = (CMBookmarksMediator)mediator;
                            mediator = bookmarksMediator;
                            bookmarksMediator.fromJSONObject(jsonObject);
                            newAnnotation = bookmarksMediator.getBookmarks();
                            newVersion = bookmarksMediator.isNewVersion();
                        }
                        request.setAttribute("mediator", (Object)mediator);
                        CMItem item = this.retrieveItem(request, documentId, false);
                        int currentAnnotationCount = item.getAnnotationCount();
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Current annotation part count: " + currentAnnotationCount + "; part being replaced=" + partNum);
                        if (currentAnnotationCount > partNum) {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Updating existing annotation part");
                            item.updateAnnotation(partNum, newAnnotation, newVersion);
                            break block9;
                        }
                        if (currentAnnotationCount > partNum) break block9;
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Adding new annotation part");
                        if (newVersion) {
                            CMObject emptyAnnotation = new CMObject(new byte[0], "application/vnd.ibm.modcap");
                            item.addAnnotation(emptyAnnotation);
                            item.updateAnnotation(partNum, newAnnotation, true);
                            break block9;
                        }
                        item.addAnnotation(newAnnotation);
                    }
                    catch (Exception exc) {
                        Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)exc);
                        mediator.addError("error.exception.general", exc.getMessage());
                    }
                } else {
                    mediator.addError("error.no.connection");
                }
            }
            return mediator;
        }

        private BaseMediator createMediator(HttpServletRequest request, MessageResources resources, int partNum) {
            BaseMediator mediator = partNum == 0 ? new CMAnnotationsMediator(request, resources, request.getLocale()) : new CMBookmarksMediator(request, resources, request.getLocale());
            return mediator;
        }
    }

    private static class CMDocumentContent
    extends DocumentContent {
        private CMObject cmDocumentPart = null;
        private int contentPartCount;
        private String textEncoding;

        private CMDocumentContent(CMItem item, CMObject part, int partNum, int partCount) throws Exception {
            this.cmDocumentPart = part;
            this.type = part.getMimeType();
            String fileName = part.getOriginalFileName();
            String fileNameExt = "." + MimeTypeUtil.getExtFromMimeType(this.type);
            if (fileName != null && fileName.length() > 1 && !fileName.endsWith(fileNameExt)) {
                fileName = fileName + fileNameExt;
            }
            if (fileName == null) {
                String itemName = item.getName();
                String string = fileName = itemName != null && itemName.length() > 0 ? itemName : "cmDocument";
                if (partCount > 1) {
                    fileName = fileName + "-" + partNum;
                }
                if (!fileName.endsWith(fileNameExt)) {
                    fileName = fileName + fileNameExt;
                }
            }
            this.size = part.getSize();
            this.name = fileName;
            this.contentPartCount = partCount;
            this.textEncoding = this.type.equals("text/plain") ? part.getEncoding() : null;
        }

        public InputStream getInputStream() throws Exception {
            return this.cmDocumentPart.getDataStream();
        }

        public int getContentPartCount() {
            return this.contentPartCount;
        }

        public String getTextEncoding() {
            return this.textEncoding;
        }
    }
}

