/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util;

import com.ibm.ecm.Constants;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.serviceability.Logger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class WCDateFormat
implements Constants {
    public static final String DATE_FORMAT_STRING = "yyyy-MM-dd";
    public static final String TIME_FORMAT_STRING = "HH.mm.ss";
    public static final String TIMESTAMP_FORMAT_STRING = "yyyy-MM-dd-HH.mm.ss.SSS";
    public static final String OD_DATE_FORMAT_STRING = "MM/dd/yy";
    public static final SimpleDateFormat UTC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final TimeZone TIME_ZONE_GMT = TimeZone.getTimeZone("GMT");
    protected DateFormat dateFormat = null;
    protected DateFormat timeFormat = null;
    protected DateFormat timestampFormat = null;

    public void setAllDateFormats(DateFormat dateFormat, DateFormat timeFormat, DateFormat timestampFormat) {
        this.setDateFormat(dateFormat);
        this.setTimeFormat(timeFormat);
        this.setTimestampFormat(timestampFormat);
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public DateFormat getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(DateFormat timeFormat) {
        this.timeFormat = timeFormat;
    }

    public DateFormat getTimestampFormat() {
        return this.timestampFormat;
    }

    public void setTimestampFormat(DateFormat timestampFormat) {
        this.timestampFormat = timestampFormat;
    }

    public static WCDateFormat getDateFormats(HttpServletRequest request, RepositoryConfig repositoryConfig) {
        String methodName = "getDateFormats";
        WCDateFormat wcDateFormats = WCDateFormat.getDefaultDateFormats(request);
        SimpleDateFormat dateFormat = (SimpleDateFormat)wcDateFormats.getDateFormat();
        SimpleDateFormat timeFormat = (SimpleDateFormat)wcDateFormats.getTimeFormat();
        SimpleDateFormat timestampFormat = (SimpleDateFormat)wcDateFormats.getTimestampFormat();
        try {
            if (repositoryConfig.getDateFormat() != null && repositoryConfig.getDateFormat().length() > 0) {
                dateFormat.applyPattern(repositoryConfig.getDateFormat());
                Logger.logDebug(WCDateFormat.class, methodName, (ServletRequest)request, "repositoryConfig date format: " + repositoryConfig.getDateFormat());
            }
        }
        catch (RuntimeException e) {
            Logger.logWarning(WCDateFormat.class, methodName, (ServletRequest)request, "dateFormat property not valid ('" + repositoryConfig.getDateFormat() + "'), will use default ('" + DATE_FORMAT_STRING + "').\n" + e.toString());
            dateFormat.applyPattern(DATE_FORMAT_STRING);
        }
        try {
            if (repositoryConfig.getTimeFormat() != null && repositoryConfig.getTimeFormat().length() > 0) {
                timeFormat.applyPattern(repositoryConfig.getTimeFormat());
                Logger.logDebug(WCDateFormat.class, methodName, (ServletRequest)request, "repositoryConfig time format: " + repositoryConfig.getTimeFormat());
            }
        }
        catch (RuntimeException e) {
            Logger.logWarning(WCDateFormat.class, methodName, (ServletRequest)request, "timeFormat property not valid ('" + repositoryConfig.getTimeFormat() + "'), will use default ('" + TIME_FORMAT_STRING + "').\n" + e.toString());
            timeFormat.applyPattern(TIME_FORMAT_STRING);
        }
        try {
            if (repositoryConfig.getTimestampFormat() != null && repositoryConfig.getTimestampFormat().length() > 0) {
                timestampFormat.applyPattern(repositoryConfig.getTimestampFormat());
                String timestampPattern = timestampFormat.toPattern();
                Logger.logDebug(WCDateFormat.class, methodName, (ServletRequest)request, "timestampPattern: " + timestampPattern);
                boolean hasMilliHolder = timestampPattern.indexOf("S") > -1;
                int numMilliHolders = timestampPattern.lastIndexOf("S") - timestampPattern.indexOf("S") + 1;
                Logger.logDebug(WCDateFormat.class, methodName, (ServletRequest)request, "numMilliHolders: " + numMilliHolders);
                if (hasMilliHolder && numMilliHolders > 3) {
                    String newMilliFormat = "";
                    while (newMilliFormat.length() <= 3) {
                        newMilliFormat = newMilliFormat + "S";
                    }
                    timestampPattern.replaceAll("/[S]{" + numMilliHolders + "}/", newMilliFormat);
                }
                Logger.logDebug(WCDateFormat.class, methodName, (ServletRequest)request, "[post-processing] timestampPattern: " + timestampPattern);
            }
        }
        catch (RuntimeException e) {
            Logger.logWarning(WCDateFormat.class, methodName, (ServletRequest)request, "timeFormat property not valid ('" + repositoryConfig.getTimestampFormat() + "'), will use default ('" + TIME_FORMAT_STRING + "').\n" + e.toString());
            timestampFormat.applyPattern(TIMESTAMP_FORMAT_STRING);
        }
        Logger.logDebug(WCDateFormat.class, methodName, (ServletRequest)request, new StringBuffer().append("{\"").append(dateFormat.toPattern()).append("\",\"").append(timeFormat.toPattern()).append("\",\"").append(timestampFormat.toPattern()).append("\"}").toString());
        wcDateFormats.setAllDateFormats(dateFormat, timeFormat, timestampFormat);
        return wcDateFormats;
    }

    public static WCDateFormat getDefaultDateFormats(HttpServletRequest request) {
        String methodName = "getDefaultDateFormats";
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_STRING);
        SimpleDateFormat timeFormat = new SimpleDateFormat(TIME_FORMAT_STRING);
        SimpleDateFormat timestampFormat = new SimpleDateFormat(TIMESTAMP_FORMAT_STRING);
        WCDateFormat wcDateFormats = new WCDateFormat();
        Logger.logDebug(WCDateFormat.class, methodName, (ServletRequest)request, new StringBuffer().append("{\"").append(dateFormat.toPattern()).append("\",\"").append(timeFormat.toPattern()).append("\",\"").append(timestampFormat.toPattern()).append("\"}").toString());
        wcDateFormats.setAllDateFormats(dateFormat, timeFormat, timestampFormat);
        return wcDateFormats;
    }

    public static String[] getDateRangeStrings(HttpServletRequest request, long timestamp, DateFormat dateFormat) throws ParseException {
        String methodName = "getDateRangeStrings";
        Logger.logEntry(WCDateFormat.class, methodName, (ServletRequest)request);
        Date date = new Date(timestamp);
        dateFormat.setTimeZone(TIME_ZONE_GMT);
        String date1 = dateFormat.format(date);
        long t = date.getTime();
        String date2 = dateFormat.format(new Date(t += 86400000L));
        Logger.logExit(WCDateFormat.class, methodName, (ServletRequest)request);
        return new String[]{date1, date2};
    }

    public static String getDateString(HttpServletRequest request, long timestamp, DateFormat dateFormat, boolean timeZoneAdjust) {
        String methodName = "getDateString";
        Logger.logEntry(WCDateFormat.class, methodName, (ServletRequest)request);
        TimeZone tz = timeZoneAdjust ? TimeZone.getDefault() : TIME_ZONE_GMT;
        dateFormat.setTimeZone(tz);
        Date date = new Date(timestamp);
        String date1 = dateFormat.format(date);
        Logger.logExit(WCDateFormat.class, methodName, (ServletRequest)request, "date: " + date1);
        return date1;
    }

    public static String getDateString(HttpServletRequest request, long timestamp, DateFormat dateFormat) {
        return WCDateFormat.getDateString(request, timestamp, dateFormat, false);
    }

    public static Date parseDate(String dateString, DateFormat dateFormat) throws ParseException {
        return WCDateFormat.parseDate(null, dateString, dateFormat);
    }

    public static Date parseDate(HttpServletRequest request, String dateString, DateFormat dateFormat) throws ParseException {
        String methodName = "parseDate";
        Logger.logEntry(WCDateFormat.class, methodName, (ServletRequest)request);
        dateFormat.setLenient(false);
        Date dt = dateFormat.parse(dateString);
        Logger.logExit(WCDateFormat.class, methodName, (ServletRequest)request);
        return dt;
    }

    public static Calendar parseW3CDate(String str, TimeZone defaultTimeZone) {
        int signPosition;
        char sign;
        TimeZone tz;
        if (str == null || str.isEmpty()) {
            return null;
        }
        int hour = 0;
        int min = 0;
        int sec = 0;
        int msec = 0;
        int[] form = new int[]{0, 4, 5, 7, 8, 10, 11, 13, 14, 16, 17, 19, 16, 19};
        int len = str.length();
        Calendar cal = Calendar.getInstance();
        cal.setLenient(false);
        int year = Integer.parseInt(str.substring(form[0], form[1]));
        int month = Integer.parseInt(str.substring(form[2], form[3]));
        int day = Integer.parseInt(str.substring(form[4], form[5]));
        if (len >= form[13]) {
            hour = Integer.parseInt(str.substring(form[6], form[7]));
            min = Integer.parseInt(str.substring(form[8], form[9]));
            sec = Integer.parseInt(str.substring(form[10], form[11]));
            msec = WCDateFormat.parseMilliseconds(str, len);
        }
        TimeZone timeZone = tz = defaultTimeZone == null ? TimeZone.getDefault() : defaultTimeZone;
        if (str.charAt(len - 1) == 'Z') {
            tz = TIME_ZONE_GMT;
        } else if (len >= form[12] && ((sign = str.charAt(signPosition = len - 6)) == '+' || sign == '-')) {
            String timeZone2 = str.substring(signPosition);
            tz = TimeZone.getTimeZone("GMT" + timeZone2);
        }
        cal.setTimeZone(tz);
        cal.set(year, month - 1, day, hour, min, sec);
        cal.set(14, msec);
        return cal;
    }

    private static int parseMilliseconds(String str, int len) {
        int d;
        int msec = 0;
        if (len >= 21 && str.charAt(19) == '.' && (d = Character.digit(str.charAt(20), 10)) != -1) {
            msec = d * 100;
            if (len >= 22 && (d = Character.digit(str.charAt(21), 10)) != -1) {
                msec += d * 10;
                if (len >= 23 && (d = Character.digit(str.charAt(22), 10)) != -1) {
                    msec += d;
                }
            }
        }
        return msec;
    }

    public static String convertDateToW3CDate(Calendar cal, boolean dateOnly) {
        int offset;
        StringBuilder sb = new StringBuilder(30);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int dayOfMonth = cal.get(5);
        sb.append(year);
        sb.append('-');
        if (month < 10) {
            sb.append('0');
        }
        sb.append(month);
        sb.append('-');
        if (dayOfMonth < 10) {
            sb.append('0');
        }
        sb.append(dayOfMonth);
        if (!dateOnly) {
            int hour = cal.get(11);
            int min = cal.get(12);
            int sec = cal.get(13);
            int msec = cal.get(14);
            sb.append('T');
            if (hour < 10) {
                sb.append('0');
            }
            sb.append(hour);
            sb.append(':');
            if (min < 10) {
                sb.append('0');
            }
            sb.append(min);
            sb.append(':');
            if (sec < 10) {
                sb.append('0');
            }
            sb.append(sec);
            if (msec != 0) {
                sb.append('.');
                sb.append(msec);
            }
        }
        if ((offset = cal.get(15) + cal.get(16)) < 0) {
            offset = -offset;
            sb.append('-');
        } else {
            sb.append('+');
        }
        int nMilliSeconsPerHour = 3600000;
        int nMilliSeconsPerMinute = 60000;
        int offsetHour = offset / nMilliSeconsPerHour;
        int offsetMin = (offset - nMilliSeconsPerHour * offsetHour) / nMilliSeconsPerMinute;
        if (offsetHour < 10) {
            sb.append('0');
        }
        sb.append(offsetHour);
        sb.append(':');
        if (offsetMin < 10) {
            sb.append('0');
        }
        sb.append(offsetMin);
        return sb.toString();
    }
}

