/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util;

import com.ibm.ecm.configuration.ViewerContentTypeConfig;
import com.ibm.ecm.configuration.ViewerDefConfig;
import com.ibm.ecm.configuration.ViewerMappingConfig;
import com.ibm.ecm.extension.Plugin;
import com.ibm.ecm.extension.PluginViewerDef;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.MessageUtil;
import com.ibm.ecm.util.PluginUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewerUtil {
    private static final String allRepositories = "p8,cmis,cm,od";
    private static Map<String, String[]> contentTypeMap = new HashMap<String, String[]>();

    public static List<ViewerMappingConfig> getDefaultViewerMapping(HttpServletRequest request, String applicationName) {
        ArrayList<ViewerMappingConfig> list = new ArrayList<ViewerMappingConfig>();
        String idPrefix = "default";
        int counter = 0;
        String id = idPrefix + counter;
        ViewerMappingConfig mapping = new ViewerMappingConfig(null, applicationName, id);
        mapping.setViewerName("afp2pdf");
        mapping.setContentTypes("application/afp");
        mapping.setServerType("od");
        list.add(mapping);
        id = idPrefix + ++counter;
        mapping = new ViewerMappingConfig(null, applicationName, id);
        mapping.setViewerName("lineDataApplet");
        mapping.setContentTypes("application/line");
        mapping.setServerType("od");
        list.add(mapping);
        id = idPrefix + ++counter;
        mapping = new ViewerMappingConfig(null, applicationName, id);
        mapping.setViewerName("browser");
        mapping.setContentTypes("text/plain");
        mapping.setServerType("");
        list.add(mapping);
        id = idPrefix + ++counter;
        mapping = new ViewerMappingConfig(null, applicationName, id);
        mapping.setViewerName("adobeReader");
        mapping.setContentTypes("application/pdf");
        mapping.setServerType("cm");
        list.add(mapping);
        id = idPrefix + ++counter;
        mapping = new ViewerMappingConfig(null, applicationName, id);
        mapping.setViewerName("adobeReader");
        mapping.setContentTypes("application/pdf");
        mapping.setServerType("ci");
        list.add(mapping);
        id = idPrefix + ++counter;
        mapping = new ViewerMappingConfig(null, applicationName, id);
        mapping.setViewerName("adobeReader");
        mapping.setContentTypes("application/pdf");
        mapping.setServerType("od");
        list.add(mapping);
        id = idPrefix + ++counter;
        mapping = new ViewerMappingConfig(null, applicationName, id);
        mapping.setViewerName("appletViewer");
        mapping.setContentTypes("image/bmp,image/gif,image/jpeg,application/vnd.ibm.modcap,image/pcx,image/png,image/tiff,image/x-dcx,image/x-png");
        mapping.setServerType("cm");
        list.add(mapping);
        id = idPrefix + ++counter;
        mapping = new ViewerMappingConfig(null, applicationName, id);
        mapping.setViewerName("appletViewer");
        mapping.setContentTypes("image/tiff");
        mapping.setServerType("ci");
        list.add(mapping);
        id = idPrefix + ++counter;
        mapping = new ViewerMappingConfig(null, applicationName, id);
        mapping.setViewerName("appletViewer");
        mapping.setContentTypes("image/bmp,image/gif,image/jpeg,application/vnd.ibm.modcap,image/pcx,image/png,image/tiff,image/x-dcx,image/x-png");
        mapping.setServerType("od");
        list.add(mapping);
        id = idPrefix + ++counter;
        mapping = new ViewerMappingConfig(null, applicationName, id);
        mapping.setViewerName("filenetViewer");
        mapping.setContentTypes("image/pjpeg,image/jpg,image/jpeg,image/bmp,image/gif,image/tiff,image/x-png,application/pdf,application/x-cold,application/vnd.filenet.im-image,application/vnd.filenet.im-cold,application/vnd.filenet.im-form,application/vnd.filenet.im-other,image/png");
        mapping.setServerType("p8");
        list.add(mapping);
        id = idPrefix + ++counter;
        mapping = new ViewerMappingConfig(null, applicationName, id);
        mapping.setViewerName("appletViewer");
        mapping.setContentTypes("image/bmp,image/gif,image/jpeg,application/vnd.ibm.modcap,image/pcx,image/png,image/tiff,image/x-dcx,image/x-png");
        mapping.setServerType("cmis");
        list.add(mapping);
        id = idPrefix + ++counter;
        mapping = new ViewerMappingConfig(null, applicationName, id);
        mapping.setViewerName("browser");
        mapping.setContentTypes("");
        mapping.setServerType("p8");
        list.add(mapping);
        id = idPrefix + ++counter;
        mapping = new ViewerMappingConfig(null, applicationName, id);
        mapping.setViewerName("browser");
        mapping.setContentTypes("");
        mapping.setServerType("cmis");
        list.add(mapping);
        id = idPrefix + ++counter;
        mapping = new ViewerMappingConfig(null, applicationName, id);
        mapping.setViewerName("browser");
        mapping.setContentTypes("");
        mapping.setServerType("cm");
        list.add(mapping);
        id = idPrefix + ++counter;
        mapping = new ViewerMappingConfig(null, applicationName, id);
        mapping.setViewerName("browser");
        mapping.setContentTypes("");
        mapping.setServerType("od");
        list.add(mapping);
        ++counter;
        return list;
    }

    public static List<ViewerContentTypeConfig> getDefaultViewerContentTypes(HttpServletRequest request, String applicationName) {
        HashMap<String, StringBuffer> mimeToViewersMap = new HashMap<String, StringBuffer>();
        for (String viewer : contentTypeMap.keySet()) {
            ViewerUtil.addMimeToViewerMappings(mimeToViewersMap, viewer, contentTypeMap.get(viewer));
        }
        Plugin[] plugins = null;
        try {
            plugins = PluginUtil.getPlugins(request);
        }
        catch (Exception e) {
            Logger.logError(ViewerUtil.class, "getDefaultViewerContentTypes", request.getSession(), (Throwable)e);
        }
        if (plugins != null) {
            for (int i = 0; i < plugins.length; ++i) {
                Plugin plugin = plugins[i];
                PluginViewerDef[] pluginViewers = plugin.getViewers();
                for (int j = 0; j < pluginViewers.length; ++j) {
                    PluginViewerDef pluginViewer = pluginViewers[j];
                    String viewer = pluginViewer.getId();
                    ViewerUtil.addMimeToViewerMappings(mimeToViewersMap, viewer, pluginViewer.getSupportedContentTypes());
                }
            }
        }
        ArrayList<ViewerContentTypeConfig> list = new ArrayList<ViewerContentTypeConfig>();
        for (String mimeType : mimeToViewersMap.keySet()) {
            String viewers = ((StringBuffer)mimeToViewersMap.get(mimeType)).toString();
            ViewerContentTypeConfig viewerContentType = new ViewerContentTypeConfig(null, applicationName, mimeType);
            viewerContentType.setViewers(viewers);
            list.add(viewerContentType);
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object object1, Object object2) {
                ViewerContentTypeConfig item1 = (ViewerContentTypeConfig)object1;
                ViewerContentTypeConfig item2 = (ViewerContentTypeConfig)object2;
                return item1.getObjectId().compareToIgnoreCase(item2.getObjectId());
            }
        });
        return list;
    }

    private static void addMimeToViewerMappings(Map<String, StringBuffer> mimeToViewersMap, String viewer, String[] mimeTypes) {
        if (mimeTypes != null) {
            for (int n = 0; n < mimeTypes.length; ++n) {
                StringBuffer sBuf = mimeToViewersMap.get(mimeTypes[n]);
                if (sBuf == null) {
                    sBuf = new StringBuffer(viewer);
                    mimeToViewersMap.put(mimeTypes[n], sBuf);
                    continue;
                }
                sBuf.append(",").append(viewer);
            }
        }
    }

    public static List<ViewerDefConfig> getDefaultViewerDefinitions(HttpServletRequest request, String applicationName) {
        ArrayList<ViewerDefConfig> list = new ArrayList<ViewerDefConfig>();
        String id = "ajaxViewer";
        ViewerDefConfig viewerDef = new ViewerDefConfig(null, applicationName, id);
        viewerDef.setViewerName(id);
        viewerDef.setServerTypes("cm,od");
        viewerDef.setLabel(ViewerUtil.getLabel(id, request));
        viewerDef.setLaunchUrl("servicesUrl+'/viewers/ajaxViewer.jsp?docUrl='+encodeURIComponent(docUrl)+'&contentType='+mimeType+'&serverType='+serverType+privs");
        viewerDef.setViewerClass("ecm.widget.viewer.AjaxViewer");
        list.add(viewerDef);
        id = "appletViewer";
        viewerDef = new ViewerDefConfig(null, applicationName, id);
        viewerDef.setViewerName(id);
        viewerDef.setServerTypes("cm,od,cmis");
        viewerDef.setLabel(ViewerUtil.getLabel(id, request));
        viewerDef.setLaunchUrl("servicesUrl+'/viewers/appletViewer.jsp?docUrl='+encodeURIComponent(docUrl)+'&docName='+encodeURIComponent(docName)+'&contentType='+mimeType+'&serverType='+serverType+'&propertiesFile='+servicesUrl+'/applets/ViewerApplet_properties.jsp'+'&servicesUrl='+servicesUrl+privs");
        viewerDef.setViewerClass("ecm.widget.viewer.AppletViewer");
        list.add(viewerDef);
        id = "htmlConversion";
        viewerDef = new ViewerDefConfig(null, applicationName, id);
        viewerDef.setViewerName(id);
        viewerDef.setServerTypes(allRepositories);
        viewerDef.setLabel(ViewerUtil.getLabel(id, request));
        viewerDef.setLaunchUrl("servicesUrl+'/viewers/convertViewer.jsp?docUrl='+encodeURIComponent(docUrl)+'&contentType='+mimeType+'&targetContentType=text/html&serverType='+serverType+'&servicesUrl='+servicesUrl+privs");
        viewerDef.setViewerClass("ecm.widget.viewer.HTMLDocViewer");
        list.add(viewerDef);
        id = "pdfConversion";
        viewerDef = new ViewerDefConfig(null, applicationName, id);
        viewerDef.setViewerName(id);
        viewerDef.setServerTypes(allRepositories);
        viewerDef.setLabel(ViewerUtil.getLabel(id, request));
        viewerDef.setLaunchUrl("servicesUrl+'/viewers/convertViewer.jsp?docUrl='+encodeURIComponent(docUrl)+'&contentType='+mimeType+'&targetContentType=application/pdf&serverType='+serverType+'&servicesUrl='+servicesUrl+privs");
        viewerDef.setViewerClass("ecm.widget.viewer.PDFDocViewer");
        list.add(viewerDef);
        id = "browser";
        viewerDef = new ViewerDefConfig(null, applicationName, id);
        viewerDef.setViewerName(id);
        viewerDef.setServerTypes(allRepositories);
        viewerDef.setLabel(ViewerUtil.getLabel(id, request));
        viewerDef.setLaunchUrl("servicesUrl+'/viewers/getContentViewer.jsp?docUrl='+encodeURIComponent(docUrl)+'&serverType='+serverType");
        viewerDef.setLaunchInSeparateWindow("true");
        viewerDef.setViewerClass("ecm.widget.viewer.IframeDocViewer");
        list.add(viewerDef);
        id = "afp2pdf";
        viewerDef = new ViewerDefConfig(null, applicationName, id);
        viewerDef.setViewerName(id);
        viewerDef.setServerTypes("od");
        viewerDef.setLabel(ViewerUtil.getLabel(id, request));
        viewerDef.setLaunchUrl("servicesUrl+'/viewers/getContentViewer.jsp?docUrl='+encodeURIComponent(docUrl+'&transform=pdf')+'&serverType='+serverType");
        viewerDef.setViewerClass("ecm.widget.viewer.IframeDocViewer");
        list.add(viewerDef);
        id = "xenos";
        viewerDef = new ViewerDefConfig(null, applicationName, id);
        viewerDef.setViewerName(id);
        viewerDef.setServerTypes("od");
        viewerDef.setLabel(ViewerUtil.getLabel(id, request));
        viewerDef.setLaunchUrl("servicesUrl+'/viewers/getContentViewer.jsp?docUrl='+encodeURIComponent(docUrl+'&transform=xenos')+'&serverType='+serverType");
        viewerDef.setViewerClass("ecm.widget.viewer.IframeDocViewer");
        list.add(viewerDef);
        id = "lineDataApplet";
        viewerDef = new ViewerDefConfig(null, applicationName, id);
        viewerDef.setViewerName(id);
        viewerDef.setServerTypes("od");
        viewerDef.setLabel(ViewerUtil.getLabel(id, request));
        viewerDef.setLaunchUrl("servicesUrl+'/viewers/getContentViewer.jsp?docUrl='+encodeURIComponent(docUrl+'&transform=applet')+'&serverType='+serverType");
        viewerDef.setViewerClass("ecm.widget.viewer.IframeDocViewer");
        list.add(viewerDef);
        id = "adobeReader";
        viewerDef = new ViewerDefConfig(null, applicationName, id);
        viewerDef.setViewerName(id);
        viewerDef.setServerTypes(allRepositories);
        viewerDef.setLabel(ViewerUtil.getLabel(id, request));
        viewerDef.setLaunchUrl("servicesUrl+'/viewers/adobeReader.jsp?docUrl='+encodeURIComponent(docUrl)+'&contentType='+mimeType+'&serverType='+serverType+'&servicesUrl='+servicesUrl+privs");
        viewerDef.setViewerClass("ecm.widget.viewer.IframeDocViewer");
        list.add(viewerDef);
        id = "filenetViewer";
        viewerDef = new ViewerDefConfig(null, applicationName, id);
        viewerDef.setViewerName(id);
        viewerDef.setServerTypes("p8");
        viewerDef.setLabel(ViewerUtil.getLabel(id, request));
        viewerDef.setLaunchUrl("servicesUrl+'/viewers/filenetViewer.jsp?docUrl='+encodeURIComponent(docUrl)+'&docName='+encodeURIComponent(docName)+'&contentType='+mimeType+'&serverType='+serverType+'&servicesUrl='+servicesUrl+privs");
        viewerDef.setViewerClass("ecm.widget.viewer.FilenetViewer");
        list.add(viewerDef);
        id = "noViewerViewer";
        viewerDef = new ViewerDefConfig(null, applicationName, id);
        viewerDef.setViewerName(id);
        viewerDef.setServerTypes(allRepositories);
        viewerDef.setLabel(ViewerUtil.getLabel(id, request));
        viewerDef.setLaunchUrl("servicesUrl+'/viewers/noViewerViewer.jsp?docUrl='+encodeURIComponent(docUrl)+'&docName='+encodeURIComponent(docName)+'&contentType='+mimeType+'&serverType='+serverType+privs");
        viewerDef.setViewerClass("ecm.widget.viewer.IframeDocViewer");
        list.add(viewerDef);
        Set<Map.Entry<String, PluginViewerDef>> keys = PluginUtil.getPluginViewers(request).entrySet();
        for (Map.Entry<String, PluginViewerDef> entry : keys) {
            PluginViewerDef pluginViewer = entry.getValue();
            viewerDef = new ViewerDefConfig(null, applicationName, pluginViewer.getId());
            viewerDef.setViewerName(pluginViewer.getId());
            String serverTypes = "";
            if (pluginViewer.getSupportedServerTypes() != null && pluginViewer.getSupportedServerTypes().length > 0) {
                for (int i = 0; i < pluginViewer.getSupportedServerTypes().length; ++i) {
                    serverTypes = serverTypes + serverTypes + ",";
                }
            } else {
                serverTypes = allRepositories;
            }
            viewerDef.setServerTypes(serverTypes);
            viewerDef.setLabel(pluginViewer.getName(request.getLocale()));
            viewerDef.setLaunchUrl(pluginViewer.getLaunchUrlPattern());
            viewerDef.setViewerClass(pluginViewer.getViewerClass());
            list.add(viewerDef);
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object object1, Object object2) {
                ViewerDefConfig item1 = (ViewerDefConfig)object1;
                ViewerDefConfig item2 = (ViewerDefConfig)object2;
                return item1.getLabel().compareToIgnoreCase(item2.getLabel());
            }
        });
        return list;
    }

    private static String getLabel(String id, HttpServletRequest request) {
        String messageKey = "viewer." + id + ".label";
        return MessageUtil.getMessage(request, messageKey);
    }

    public static String getReloginUrl(HttpServletRequest request) {
        String reloginUrl = request.getContextPath() + "/viewerRelogin.jsp";
        String debug = request.getParameter("debug");
        if (debug != null && Boolean.valueOf(debug).booleanValue()) {
            reloginUrl = reloginUrl + "?debug=" + debug + "&useConsole=false";
        }
        return reloginUrl;
    }

    static {
        contentTypeMap.put("adobeReader", new String[]{"application/pdf"});
        contentTypeMap.put("afp2pdf", new String[]{"application/afp"});
        String[] outsideInTypes = new String[]{"application/pdf", "image/bmp", "image/cals", "image/dicom", "image/gif", "image/jpeg", "image/pcx", "image/png", "image/x-png", "image/tiff", "application/vnd.ibm.modcap", "image/x-dcx", "application/vnd.lotus-1-2-3", "application/x-lotus123", "application/vnd.lotus-freelance", "application/x-lotus-freelance", "application/vnd.lotus-wordpro", "application/x-lotus-wordpro", "application/vnd.ms-excel", "application/vnd.ms-powerpoint", "application/msword", "application/vnd.oasis.opendocument.graphics", "application/vnd.oasis.opendocument.presentation", "application/vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.text", "application/x-vnd.oasis.opendocument.graphics", "application/x-vnd.oasis.opendocument.presentation", "application/x-vnd.oasis.opendocument.spreadsheet", "application/x-vnd.oasis.opendocument.text", "application/rtf", "application/x-rtf", "text/richtext"};
        contentTypeMap.put("ajaxViewer", outsideInTypes);
        contentTypeMap.put("htmlConversion", outsideInTypes);
        contentTypeMap.put("pdfConversion", outsideInTypes);
        contentTypeMap.put("appletViewer", outsideInTypes);
        contentTypeMap.put("browser", new String[]{"application/afp", "application/line", "application/pdf", "image/bmp", "image/cals", "image/dicom", "image/gif", "image/jpeg", "image/jpg", "image/pjpeg", "image/pcx", "image/png", "image/x-png", "image/tiff", "application/vnd.ms-outlook", "application/x-filenet-filetype-msg", "message/rfc822", "application/x-cold", "application/vnd.filenet.im-cold", "application/vnd.filenet.im-form", "application/vnd.filenet.im-image", "application/vnd.filenet.im-other", "application/vnd.lotus-1-2-3", "application/x-lotus123", "application/vnd.lotus-freelance", "application/x-lotus-freelance", "application/vnd.lotus-wordpro", "application/x-lotus-wordpro", "application/vnd.ms-excel", "application/vnd.ms-powerpoint", "application/msword", "application/rtf", "application/x-rtf", "text/richtext", "application/vnd.oasis.opendocument.presentation", "application/x-vnd.oasis.opendocument.presentation", "application/vnd.oasis.opendocument.spreadsheet", "application/x-vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.text", "application/x-vnd.oasis.opendocument.text", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.sun.xml.calc", "application/vnd.sun.xml.impress", "application/vnd.sun.xml.writer"});
        contentTypeMap.put("filenetViewer", new String[]{"application/pdf", "image/bmp", "image/gif", "image/jpeg", "image/jpg", "image/pjpeg", "image/png", "image/x-png", "image/tiff", "application/x-filenet-filetype-msg", "message/rfc822", "application/pdf", "application/x-cold", "application/vnd.filenet.im-cold", "application/vnd.filenet.im-form", "application/vnd.filenet.im-image", "application/vnd.filenet.im-other", "application/vnd.ms-excel", "application/vnd.ms-powerpoint", "application/msword", "application/vnd.oasis.opendocument.presentation", "application/x-vnd.oasis.opendocument.presentation", "application/vnd.oasis.opendocument.spreadsheet", "application/x-vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.text", "application/x-vnd.oasis.opendocument.text", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.sun.xml.calc", "application/vnd.sun.xml.impress", "application/vnd.sun.xml.writer"});
        contentTypeMap.put("lineDataApplet", new String[]{"application/line"});
        contentTypeMap.put("xenos", new String[]{"application/afp"});
    }
}

