/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util;

import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMLogonAction;
import com.ibm.ecm.struts.actions.cmis.CMISLogonAction;
import com.ibm.ecm.struts.actions.container.ContainerLogonAction;
import com.ibm.ecm.struts.actions.od.ODLogonAction;
import com.ibm.ecm.struts.actions.p8.P8LogonAction;
import com.ibm.ecm.util.cm.CMSessionListener;
import com.ibm.ecm.util.cmis.CMISConnection;
import com.ibm.ecm.util.cmis.CMISSessionListener;
import com.ibm.ecm.util.od.ODSessionListener;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8SessionListener;
import com.ibm.edms.od.ODServer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.Deflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final String CM_SERVERS = "cm_servers";
    public static final String OD_SERVERS = "od_servers";
    public static final String P8_SERVERS = "p8_servers";
    public static final String CMIS_SERVERS = "CMIS_servers";
    public static final String[] connectionMapKeys = new String[]{"cm_servers", "od_servers", "p8_servers", "CMIS_servers"};

    public static void dumpSession(HttpServletRequest request) {
        String methodName = "dumpSession";
        Logger.logEntry(Util.class, methodName, (ServletRequest)request);
        HttpSession session = request.getSession(false);
        if (session != null) {
            Logger.logDebug(Util.class, methodName, (ServletRequest)request, "session creation time: " + session.getCreationTime());
            Enumeration sessionAttributeNames = session.getAttributeNames();
            Logger.logDebug(Util.class, methodName, (ServletRequest)request, "sessionAttributeNames: " + sessionAttributeNames);
            while (sessionAttributeNames != null && sessionAttributeNames.hasMoreElements()) {
                String name = (String)sessionAttributeNames.nextElement();
                Logger.logDebug(Util.class, methodName, (ServletRequest)request, "found " + name + " in sesion");
            }
        }
        Logger.logExit(Util.class, methodName, (ServletRequest)request);
    }

    public static boolean isConnected(HttpServletRequest request, String repositoryId) {
        String methodName = "isConnected";
        Logger.logEntry(Util.class, methodName, (ServletRequest)request);
        HttpSession session = request.getSession(false);
        boolean connected = false;
        String serverType = request.getParameter("serverType");
        if (session != null) {
            Hashtable connectionList;
            if (serverType.equals("cm")) {
                Hashtable connectionList2 = (Hashtable)session.getAttribute(CM_SERVERS);
                if (connectionList2 != null) {
                    connected = connectionList2.containsKey(repositoryId);
                }
            } else if (serverType.equals("od")) {
                Hashtable connectionList3 = (Hashtable)session.getAttribute(OD_SERVERS);
                if (connectionList3 != null) {
                    ODServer connection = (ODServer)connectionList3.get(repositoryId);
                    connected = connection != null;
                }
            } else if (serverType.equals("p8")) {
                Hashtable connectionList4 = (Hashtable)session.getAttribute(P8_SERVERS);
                if (connectionList4 != null) {
                    P8Connection connection = (P8Connection)connectionList4.get(repositoryId);
                    connected = connection != null;
                }
            } else if (serverType.equals("cmis") && (connectionList = (Hashtable)session.getAttribute(CMIS_SERVERS)) != null) {
                CMISConnection connection = (CMISConnection)connectionList.get(repositoryId);
                connected = connection != null;
            }
        }
        Logger.logExit(Util.class, methodName, (ServletRequest)request);
        return connected;
    }

    public static boolean hasConnections(HttpSession session) {
        boolean returnValue = false;
        Hashtable containers = (Hashtable)session.getAttribute(ContainerLogonAction.CONTAINERS);
        boolean bl = returnValue = containers != null && containers.size() > 0;
        if (!returnValue) {
            for (int n = 0; n < connectionMapKeys.length && !returnValue; ++n) {
                Hashtable connectionMap = (Hashtable)session.getAttribute(connectionMapKeys[n]);
                if (connectionMap == null || connectionMap.size() <= 0) continue;
                returnValue = true;
            }
        }
        return returnValue;
    }

    public static String getUrlForm(String formId, String action, HttpServletRequest request) throws UnsupportedEncodingException {
        String method = request.getMethod();
        URLForm urlForm = new URLForm(formId);
        String queryString = null;
        urlForm.setAction(action);
        if (method.equalsIgnoreCase("GET")) {
            queryString = request.getQueryString();
            urlForm.addParameters(queryString);
        } else if (method.equalsIgnoreCase("POST")) {
            Map requestMap = request.getParameterMap();
            for (Map.Entry entry : requestMap.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    urlForm.addParameter((String)entry.getKey(), (String)value);
                    continue;
                }
                if (!(value instanceof String[])) continue;
                urlForm.addParameter((String)entry.getKey(), ((String[])value)[0]);
            }
        }
        return urlForm.toString();
    }

    public static String getUrlForm(String formId, String docUrl, Map<String, String> parameterMap) throws UnsupportedEncodingException {
        URLForm urlForm = new URLForm(formId);
        int qPos = docUrl.indexOf("?");
        if (qPos >= 0) {
            urlForm.setAction(docUrl.substring(0, qPos));
            for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
                urlForm.addParameter(entry.getKey(), URLDecoder.decode(entry.getValue(), "UTF-8"));
            }
        }
        return urlForm.toString();
    }

    public static Map<String, String> getParameterMap(String docUrl) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        int qPos = docUrl.indexOf("?");
        if (qPos > -1) {
            String queryString = docUrl.substring(qPos + 1);
            StringTokenizer docUrlTok = new StringTokenizer(queryString, "&");
            while (docUrlTok.hasMoreTokens()) {
                String nextToken = docUrlTok.nextToken();
                if (nextToken.indexOf("=") <= -1) continue;
                StringTokenizer keyValue = new StringTokenizer(nextToken, "=");
                parameterMap.put(keyValue.nextToken(), keyValue.nextToken());
            }
        }
        return parameterMap;
    }

    public static String getContentDispositionHeader(HttpServletRequest request, String fileName) {
        String methodName = "getContentDispositionHeader";
        StringBuffer contentDisposition = new StringBuffer();
        String disposition = request.getParameter("disposition");
        String userAgent = request.getHeader("user-agent");
        if (disposition == null || !disposition.equals("attachment")) {
            disposition = "inline";
        }
        contentDisposition.append(disposition);
        if (fileName != null) {
            try {
                if (userAgent != null && userAgent.indexOf("MSIE") > -1) {
                    if (fileName.matches("\\A\\p{ASCII}*\\z")) {
                        contentDisposition.append("; filename=\"" + fileName + "\"");
                    } else {
                        contentDisposition.append("; filename=" + URLEncoder.encode(fileName, "UTF-8"));
                    }
                } else if (userAgent != null && userAgent.indexOf("Safari") > -1) {
                    if (fileName.matches("\\A\\p{ASCII}*\\z")) {
                        contentDisposition.append("; filename=" + fileName);
                    } else {
                        contentDisposition.append("; filename=" + fileName);
                    }
                } else if (fileName.matches("\\A\\p{ASCII}*\\z")) {
                    contentDisposition.append("; filename=\"" + fileName + "\"");
                } else {
                    contentDisposition.append("; filename*=UTF-8''" + URLEncoder.encode(fileName, "UTF-8"));
                }
            }
            catch (UnsupportedEncodingException uee) {
                Logger.logDebug(Util.class, methodName, (ServletRequest)request, uee.getLocalizedMessage());
                Logger.logDebug(Util.class, methodName, (ServletRequest)request, "Using alternate encoding method");
                contentDisposition.append("\"").append(fileName).append("\"");
            }
        }
        return contentDisposition.toString();
    }

    public static String compressString(HttpServletRequest request, String longString) {
        String methodName = "compressString";
        byte[] myByte = longString.getBytes();
        Logger.logDebug(Util.class, methodName, (ServletRequest)request, "longString = " + longString);
        Logger.logDebug(Util.class, methodName, (ServletRequest)request, "bytes length = " + myByte.length);
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compressor.setInput(myByte);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(myByte.length);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (Exception e) {
            Logger.logError(Util.class, methodName, (ServletRequest)request, (Throwable)e);
        }
        byte[] compressedMyByte = bos.toByteArray();
        Logger.logDebug(Util.class, methodName, (ServletRequest)request, "compressedMyByte length = " + compressedMyByte.length);
        String compressedMyString = new String(compressedMyByte);
        Logger.logDebug(Util.class, methodName, (ServletRequest)request, "compressedMyString = " + compressedMyString);
        return compressedMyString;
    }

    public static String rightPad(String s, int length, char pad) {
        StringBuffer buffer = new StringBuffer(s);
        int curLen = s.length();
        if (curLen < length) {
            for (int i = 0; i < length; ++i) {
                buffer.append(pad);
            }
        }
        return buffer.toString();
    }

    public static String getLocaleHTMLTag(ServletRequest req) {
        String methodName = "getLocaleHTMLTag";
        Logger.logEntry(Util.class, methodName, req);
        String htmlTag = "";
        htmlTag = Util.isBidi(req).equals("true") ? "<html DIR=\"RTL\" LANG=\"" + req.getLocale().getLanguage() + "\">" : "<html>";
        Logger.logDebug(Util.class, methodName, req, "htmlTag = " + htmlTag);
        Logger.logExit(Util.class, methodName, req);
        return htmlTag;
    }

    public static String isBidi(ServletRequest req) {
        String methodName = "isBidi";
        Logger.logEntry(Util.class, methodName, req);
        Locale locale = req.getLocale();
        String language = locale.toString();
        String isBIDI = "false";
        Logger.logDebug(Util.class, methodName, req, "locale = " + locale);
        Logger.logDebug(Util.class, methodName, req, "language = " + language);
        if (locale.getLanguage().equals("ar") || language.equals("he") || language.equals("iw") || language.equals("iw_IL")) {
            isBIDI = "true";
        }
        Logger.logDebug(Util.class, methodName, req, "isBIDI = " + isBIDI);
        Logger.logExit(Util.class, methodName, req);
        return isBIDI;
    }

    public static String getLanguageCode(Locale locale) {
        String langCode = "ENU";
        String isoLanguage = locale.getLanguage();
        String isoCountry = locale.getCountry();
        if (isoLanguage.equals("en")) {
            langCode = locale == Locale.UK ? "ENG" : (isoCountry.equals("AU") ? "ENA" : "ENU");
        } else if (isoLanguage.equals("af")) {
            langCode = "AFR";
        } else if (isoLanguage.equals("sq")) {
            langCode = "SQI";
        } else if (isoLanguage.equals("ar")) {
            langCode = "ARA";
        } else if (isoLanguage.equals("bg")) {
            langCode = "BGR";
        } else if (isoLanguage.equals("be")) {
            langCode = "BEL";
        } else if (isoLanguage.equals("ca")) {
            langCode = "CAT";
        } else if (isoLanguage.equals("zh")) {
            langCode = locale.toString().equalsIgnoreCase(Locale.TRADITIONAL_CHINESE.toString()) ? "CHT" : "CHS";
        } else if (isoLanguage.equals("hr")) {
            langCode = "HRV";
        } else if (isoLanguage.equals("cs")) {
            langCode = isoCountry.equals("CZ") ? "CZE" : "CSY";
        } else if (isoLanguage.equals("da")) {
            langCode = "DAN";
        } else if (isoLanguage.equals("nl")) {
            langCode = isoCountry.equals("BE") ? "NLB" : "NLD";
        } else if (isoLanguage.equals("fi")) {
            langCode = "FIN";
        } else if (isoLanguage.equals("fr")) {
            langCode = isoCountry.equals("BE") ? "FRB" : (isoCountry.equals("CA") ? "FRC" : (isoCountry.equals("CH") ? "FRS" : "FRA"));
        } else if (isoLanguage.equals("de")) {
            langCode = isoCountry.equals("CH") ? "DES" : "DEU";
        } else if (isoLanguage.equals("el")) {
            langCode = "ELL";
        } else if (isoLanguage.equals("he") || isoLanguage.equals("iw")) {
            langCode = "HEB";
        } else if (isoLanguage.equals("hu")) {
            langCode = "HUN";
        } else if (isoLanguage.equals("ga")) {
            langCode = "GAE";
        } else if (isoLanguage.equals("is")) {
            langCode = "ISL";
        } else if (isoLanguage.equals("it")) {
            langCode = isoCountry.equals("CH") ? "ITS" : "ITA";
        } else if (isoLanguage.equals("ja")) {
            langCode = "JPN";
        } else if (isoLanguage.equals("ko")) {
            langCode = "KOR";
        } else if (isoLanguage.equals("lt")) {
            langCode = "LTH";
        } else if (isoLanguage.equals("mk")) {
            langCode = "MKD";
        } else if (isoLanguage.equals("no")) {
            langCode = "NOR";
        } else if (isoLanguage.equals("pl")) {
            langCode = "PLK";
        } else if (isoLanguage.equals("pt")) {
            langCode = isoCountry.equals("BR") ? "PTB" : "PTG";
        } else if (isoLanguage.equals("rm")) {
            langCode = "RMS";
        } else if (isoLanguage.equals("ro")) {
            langCode = "ROM";
        } else if (isoLanguage.equals("ru")) {
            langCode = "RUS";
        } else if (isoLanguage.equals("sr")) {
            langCode = "SRB";
        } else if (isoLanguage.equals("sk")) {
            langCode = "SKY";
        } else if (isoLanguage.equals("sl")) {
            langCode = "SLO";
        } else if (isoLanguage.equals("es")) {
            langCode = "ESP";
        } else if (isoLanguage.equals("sv")) {
            langCode = "SVE";
        } else if (isoLanguage.equals("th")) {
            langCode = "THA";
        } else if (isoLanguage.equals("tr")) {
            langCode = "TRK";
        } else if (isoLanguage.equals("uk")) {
            langCode = "UKR";
        } else if (isoLanguage.equals("ur")) {
            langCode = "URD";
        }
        return langCode;
    }

    public static Locale getLanguageLocale(String languageCode) {
        Locale locale = null;
        String isoLanguage = "en";
        String isoCountry = null;
        if (languageCode.equals("ENU")) {
            isoCountry = "US";
        } else if (languageCode.equals("ENG")) {
            isoCountry = "GB";
        } else if (languageCode.equals("ENA")) {
            isoCountry = "AU";
        } else if (languageCode.equals("AFR")) {
            isoLanguage = "af";
        } else if (languageCode.equals("SQI")) {
            isoLanguage = "sq";
        } else if (languageCode.equals("ARA")) {
            isoLanguage = "ar";
        } else if (languageCode.equals("BEL")) {
            isoLanguage = "be";
        } else if (languageCode.equals("BGR")) {
            isoLanguage = "bg";
        } else if (languageCode.equals("CAT")) {
            isoLanguage = "ca";
        } else if (languageCode.equals("CHT")) {
            locale = Locale.TRADITIONAL_CHINESE;
        } else if (languageCode.equals("CHS")) {
            locale = Locale.SIMPLIFIED_CHINESE;
        } else if (languageCode.equals("HRV")) {
            isoLanguage = "hr";
        } else if (languageCode.equals("CZE")) {
            isoLanguage = "cs";
            isoCountry = "CZ";
        } else if (languageCode.equals("CSY")) {
            isoLanguage = "cs";
        } else if (languageCode.equals("DAN")) {
            isoLanguage = "da";
        } else if (languageCode.equals("NLB")) {
            isoLanguage = "nl";
            isoCountry = "BE";
        } else if (languageCode.equals("NLD")) {
            isoLanguage = "nl";
        } else if (languageCode.equals("FIN")) {
            isoLanguage = "fi";
        } else if (languageCode.equals("FRB")) {
            isoLanguage = "fr";
            isoCountry = "BE";
        } else if (languageCode.equals("FRC")) {
            isoLanguage = "fr";
            isoCountry = "CA";
        } else if (languageCode.equals("FRS")) {
            isoLanguage = "fr";
            isoCountry = "CH";
        } else if (languageCode.equals("FRA")) {
            isoLanguage = "fr";
        } else if (languageCode.equals("DES")) {
            isoLanguage = "de";
            isoCountry = "CH";
        } else if (languageCode.equals("DEU")) {
            isoLanguage = "de";
        } else if (languageCode.equals("ELL")) {
            isoLanguage = "el";
        } else if (languageCode.equals("HEB")) {
            isoLanguage = "iw";
        } else if (languageCode.equals("HUN")) {
            isoLanguage = "hu";
        } else if (languageCode.equals("GAE")) {
            isoLanguage = "ga";
        } else if (languageCode.equals("ISL")) {
            isoLanguage = "is";
        } else if (languageCode.equals("ITS")) {
            isoLanguage = "it";
            isoCountry = "CH";
        } else if (languageCode.equals("ITA")) {
            isoLanguage = "it";
        } else if (languageCode.equals("JPN")) {
            isoLanguage = "ja";
        } else if (languageCode.equals("KOR")) {
            isoLanguage = "ko";
        } else if (languageCode.equals("LTH")) {
            isoLanguage = "lt";
        } else if (languageCode.equals("MKD")) {
            isoLanguage = "mk";
        } else if (languageCode.equals("NOR")) {
            isoLanguage = "no";
        } else if (languageCode.equals("PLK")) {
            isoLanguage = "pl";
        } else if (languageCode.equals("PTB")) {
            isoLanguage = "pt";
            isoCountry = "BR";
        } else if (languageCode.equals("PTG")) {
            isoLanguage = "pt";
        } else if (languageCode.equals("RMS")) {
            isoLanguage = "rm";
        } else if (languageCode.equals("ROM")) {
            isoLanguage = "ro";
        } else if (languageCode.equals("RUS")) {
            isoLanguage = "ru";
        } else if (languageCode.equals("SRB")) {
            isoLanguage = "sr";
        } else if (languageCode.equals("SKY")) {
            isoLanguage = "sk";
        } else if (languageCode.equals("SLO")) {
            isoLanguage = "sl";
        } else if (languageCode.equals("ESP")) {
            isoLanguage = "es";
        } else if (languageCode.equals("SVE")) {
            isoLanguage = "sv";
        } else if (languageCode.equals("THA")) {
            isoLanguage = "th";
        } else if (languageCode.equals("TRK")) {
            isoLanguage = "tr";
        } else if (languageCode.equals("UKR")) {
            isoLanguage = "uk";
        } else if (languageCode.equals("URD")) {
            isoLanguage = "ur";
        }
        if (locale == null) {
            locale = isoCountry == null ? new Locale(isoLanguage) : new Locale(isoLanguage, isoCountry);
        }
        return locale;
    }

    public static String urlXSSEncode(String value) {
        return Util.xSSEncode(value, true);
    }

    public static String xSSEncode(String value) {
        return Util.xSSEncode(value, false);
    }

    private static String xSSEncode(String value, boolean forUrl) {
        value = value.replaceAll("<", "& lt;").replaceAll(">", "& gt;");
        if (!forUrl) {
            value = value.replaceAll("\\(", "& #40;").replaceAll("\\)", "& #41;");
            value = value.replaceAll("'", "& #39;");
        }
        value = value.replaceAll("eval\\((.*)\\)", "");
        value = value.replaceAll("[\\\"\\'][\\s]*javascript:(.*)[\\\"\\']", "\"\"");
        value = value.replaceAll("script", "");
        return value;
    }

    public static String htmlEncode(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        StringCharacterIterator iterator = new StringCharacterIterator(value);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '\\') {
                result.append("&#092;");
            } else if (character == '&') {
                result.append("&amp;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String stringEncode(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        StringCharacterIterator iterator = new StringCharacterIterator(value);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '\'') {
                result.append("\\'");
            } else if (character == '\"') {
                result.append("\\\"");
            } else if (character == '\\') {
                result.append("\\\\");
            } else if (character == '/') {
                result.append("\\/");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String getFileNameFromPath(HttpServletRequest request, String path) {
        String methodName = "getFileNameFromPath";
        Logger.logEntry(Util.class, methodName, (ServletRequest)request);
        int index = path.lastIndexOf(File.separator);
        if (index < path.lastIndexOf(92)) {
            index = path.lastIndexOf(92);
        }
        if (index < path.lastIndexOf(47)) {
            index = path.lastIndexOf(47);
        }
        if (index == -1) {
            Logger.logDebug(Util.class, methodName, (ServletRequest)request, "Possible invalid filepath detected : " + path);
            return path;
        }
        String fileName = path.substring(index + 1, path.length());
        Logger.logDebug(Util.class, methodName, (ServletRequest)request, "File name is " + fileName);
        int extIndex = fileName.lastIndexOf(".");
        if (extIndex != -1) {
            fileName = fileName.substring(0, extIndex);
            Logger.logDebug(Util.class, methodName, (ServletRequest)request, "File name is " + fileName);
        }
        Logger.logExit(Util.class, methodName, (ServletRequest)request);
        return fileName;
    }

    public static void addEntryToZipFile(ZipOutputStream zipOutStream, InputStream fileInStream, String fileName, int maxAttempts) throws Exception {
        int attemptCount = 0;
        boolean noException = false;
        while (attemptCount < maxAttempts && !noException) {
            try {
                zipOutStream.putNextEntry(new ZipEntry(fileName));
                noException = true;
            }
            catch (ZipException ze) {
                int index = fileName.lastIndexOf(46);
                fileName = fileName.substring(0, index) + "(" + (attemptCount + 2) + ")" + fileName.substring(index);
                ++attemptCount;
            }
        }
        Util.copyStream(fileInStream, zipOutStream, false);
        zipOutStream.closeEntry();
    }

    public static void copyStream(InputStream inStream, OutputStream outStream, boolean closeOutputStream) throws IOException {
        byte[] buf = new byte[4096];
        int len = inStream.read(buf);
        while (len != -1) {
            outStream.write(buf, 0, len);
            len = inStream.read(buf);
        }
        inStream.close();
        outStream.flush();
        if (closeOutputStream) {
            outStream.close();
        }
    }

    public static String getValidFileName(String fileName) {
        String validFileName = "";
        if (fileName != null) {
            validFileName = fileName.replaceAll("[\\/:*?\"<>|]", "-");
            validFileName = validFileName.replace('\\', '-');
        }
        return validFileName;
    }

    public static final HttpSession replaceSession(HttpServletRequest request) {
        return Util.replaceSession(request, null);
    }

    public static final HttpSession replaceSession(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "replaceSession";
        HttpSession session = null;
        Logger.logEntry(Util.class, methodName, (ServletRequest)request);
        if (request != null) {
            session = request.getSession();
            if (session != null) {
                Logger.logDebug(Util.class, methodName, (ServletRequest)request, "get current session attribute map from: " + session.getId());
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                Enumeration enames = session.getAttributeNames();
                while (enames.hasMoreElements()) {
                    String name = (String)enames.nextElement();
                    Object value = session.getAttribute(name);
                    if (value instanceof String && ((String)value).indexOf(session.getId()) != -1) {
                        Logger.logDebug(Util.class, methodName, (ServletRequest)request, "   session cookie attribute: " + name + " - " + value);
                        continue;
                    }
                    Logger.logDebug(Util.class, methodName, (ServletRequest)request, "   copy attribute: " + name + " - " + value);
                    attributes.put(name, value);
                }
                Logger.logDebug(Util.class, methodName, (ServletRequest)request, "copy " + attributes.size() + " session attributes from current session: " + session.getId());
                Hashtable cm_server_List = null;
                try {
                    Class<?> connectionObj = Class.forName("com.ibm.mm.sdk.common.DKDatastoreDefICM");
                    if (connectionObj != null && (cm_server_List = CMLogonAction.getServerList(request)) != null) {
                        Logger.logDebug(Util.class, methodName, (ServletRequest)request, "current CM connection list size: " + cm_server_List.size());
                        CMLogonAction.removeServerList(request);
                        attributes.remove(CM_SERVERS);
                        attributes.remove("cm_session_listener");
                    }
                }
                catch (ClassNotFoundException e) {
                    Logger.logDebug(Util.class, methodName, (ServletRequest)request, "can not load CM jars");
                }
                catch (Throwable t) {
                    Logger.logDebug(Util.class, methodName, (ServletRequest)request, "can not load CM libs");
                }
                Hashtable od_server_List = null;
                try {
                    Class<?> connectionObj = Class.forName("com.ibm.edms.od.ODServer");
                    if (connectionObj != null && (od_server_List = ODLogonAction.getServerList(request)) != null) {
                        Logger.logDebug(Util.class, methodName, (ServletRequest)request, "current OD connection list size: " + od_server_List.size());
                        ODLogonAction.removeServerList(request);
                        attributes.remove(OD_SERVERS);
                        attributes.remove("od_connection_listener");
                    }
                }
                catch (ClassNotFoundException e) {
                    Logger.logDebug(Util.class, methodName, (ServletRequest)request, "can not load OD jars");
                }
                catch (Throwable t) {
                    Logger.logDebug(Util.class, methodName, (ServletRequest)request, "can not load OD libs");
                }
                Hashtable p8_server_List = null;
                try {
                    Class<?> connectionObj = Class.forName("com.filenet.api.core.ObjectStore");
                    if (connectionObj != null && (p8_server_List = P8LogonAction.getServerList(request)) != null) {
                        Logger.logDebug(Util.class, methodName, (ServletRequest)request, "current P8 connection list size: " + p8_server_List.size());
                        P8LogonAction.removeServerList(request);
                        attributes.remove(P8_SERVERS);
                        attributes.remove("p8_connection_listener");
                    }
                }
                catch (ClassNotFoundException e) {
                    Logger.logDebug(Util.class, methodName, (ServletRequest)request, "can not load p8 jars");
                }
                catch (Throwable t) {
                    Logger.logDebug(Util.class, methodName, (ServletRequest)request, "can not load p8 libs");
                }
                Hashtable cmis_server_List = null;
                try {
                    Class<?> connectionObj = Class.forName("org.apache.chemistry.opencmis.client.api.Session");
                    if (connectionObj != null && (cmis_server_List = CMISLogonAction.getServerList(request)) != null) {
                        Logger.logDebug(Util.class, methodName, (ServletRequest)request, "current CMIS connection list size: " + cmis_server_List.size());
                        CMISLogonAction.removeServerList(request);
                        attributes.remove(CMIS_SERVERS);
                        attributes.remove("cmis_connection_listener");
                    }
                }
                catch (ClassNotFoundException e) {
                    Logger.logDebug(Util.class, methodName, (ServletRequest)request, "can not load CMIS jars");
                }
                catch (Throwable t) {
                    Logger.logDebug(Util.class, methodName, (ServletRequest)request, "can not load CMIS libs");
                }
                String userid = (String)attributes.get("session_userid");
                if (userid != null) {
                    request.setAttribute("userid", (Object)userid);
                }
                Logger.logInfo(Util.class, methodName, (ServletRequest)request, "invalidate current session: " + session.getId());
                session.invalidate();
                session = request.getSession(true);
                int counter = 0;
                if (userid != null) {
                    session.setAttribute("session_userid", (Object)userid);
                    ++counter;
                    attributes.remove("session_userid");
                }
                Logger.logInfo(Util.class, methodName, (ServletRequest)request, "populate new session: " + session.getId());
                Logger.logDebug(Util.class, methodName, (ServletRequest)request, "add session attributes to new session: " + session.getId());
                if (cm_server_List != null) {
                    Logger.logDebug(Util.class, methodName, (ServletRequest)request, "   add CM connections to new session: " + cm_server_List.size());
                    CMLogonAction.setServerList(request, cm_server_List);
                    counter += cm_server_List.size();
                }
                if (od_server_List != null) {
                    Logger.logDebug(Util.class, methodName, (ServletRequest)request, "   add OD connections to new session: " + od_server_List.size());
                    ODLogonAction.setServerList(request, od_server_List);
                    counter += od_server_List.size();
                }
                if (p8_server_List != null) {
                    Logger.logDebug(Util.class, methodName, (ServletRequest)request, "   add P8 connections to new session: " + p8_server_List.size());
                    P8LogonAction.setServerList(request, p8_server_List);
                    counter += p8_server_List.size();
                }
                if (cmis_server_List != null) {
                    Logger.logDebug(Util.class, methodName, (ServletRequest)request, "   add CMIS connections to new session: " + cmis_server_List.size());
                    CMISLogonAction.setServerList(request, cmis_server_List);
                    counter += cmis_server_List.size();
                }
                Set set = attributes.keySet();
                for (String key : set) {
                    Object object = attributes.get(key);
                    Logger.logDebug(Util.class, methodName, (ServletRequest)request, "   add attribute: " + key + " - " + object);
                    session.setAttribute(key, object);
                    ++counter;
                }
                Logger.logInfo(Util.class, methodName, (ServletRequest)request, "   finished copying " + counter + " session attrs to: " + session.getId());
            } else {
                Logger.logDebug(Util.class, methodName, (ServletRequest)request, "request does not have a session");
                session = request.getSession(true);
            }
        } else {
            Logger.logInfo(Util.class, methodName, (ServletRequest)request, "request is null");
        }
        Logger.logExit(Util.class, methodName, (ServletRequest)request);
        return session;
    }

    public static String formatElapsed(long millis) {
        StringBuffer sb = new StringBuffer();
        long seconds = millis / 1000L;
        int minutes = (int)seconds / 60;
        int minuteSeconds = minutes * 60;
        sb.append(" (elapsed time: ").append(minutes).append(":").append(seconds - (long)minuteSeconds).append(" minutes) ");
        return sb.toString();
    }

    public static void sessionDestroyed(HttpSessionEvent event) {
        String methodName = "sessionDestroyed";
        Logger.logEntry(Util.class, methodName, event.getSession());
        Util.valueUnbound(new HttpSessionBindingEvent(event.getSession(), methodName));
        Logger.logExit(Util.class, methodName, event.getSession());
    }

    public static void valueUnbound(HttpSessionBindingEvent event) {
        Class<?> connectionObj;
        String methodName = "valueUnbound";
        HttpSession session = event.getSession();
        Logger.logEntry(Util.class, "valueUnbound", session);
        Logger.logInfo(Util.class, "valueUnbound", event.getSession(), "Session: " + event.getSession().getId() + "    " + Util.formatElapsed(System.currentTimeMillis() - session.getCreationTime()));
        try {
            connectionObj = Class.forName("com.ibm.mm.sdk.common.DKDatastoreDefICM");
            if (connectionObj != null) {
                new CMSessionListener().valueUnbound(event);
            }
        }
        catch (ClassNotFoundException e) {
            Logger.logDebug(Util.class, "valueUnbound", session, "can not load CM jars");
        }
        catch (Throwable t) {
            Logger.logDebug(Util.class, "valueUnbound", session, "can not load CM libs");
        }
        try {
            connectionObj = Class.forName("com.ibm.edms.od.ODServer");
            if (connectionObj != null) {
                new ODSessionListener().valueUnbound(event);
            }
        }
        catch (ClassNotFoundException e) {
            Logger.logDebug(Util.class, "valueUnbound", session, "can not load OD jars");
        }
        catch (Throwable t) {
            Logger.logDebug(Util.class, "valueUnbound", session, "can not load OD libs");
        }
        try {
            connectionObj = Class.forName("com.filenet.api.core.ObjectStore");
            if (connectionObj != null) {
                new P8SessionListener().valueUnbound(event);
            }
        }
        catch (ClassNotFoundException e) {
            Logger.logDebug(Util.class, "valueUnbound", session, "can not load P8 jars");
        }
        catch (Throwable t) {
            Logger.logDebug(Util.class, "valueUnbound", session, "can not load P8 libs");
        }
        try {
            connectionObj = Class.forName("org.apache.chemistry.opencmis.client.api.Session");
            if (connectionObj != null) {
                new CMISSessionListener().valueUnbound(event);
            }
        }
        catch (ClassNotFoundException e) {
            Logger.logDebug(Util.class, "valueUnbound", session, "can not load CMIS jars");
        }
        catch (Throwable t) {
            Logger.logDebug(Util.class, "valueUnbound", session, "can not load CMIS libs");
        }
        Logger.logExit(Util.class, "valueUnbound", session);
    }

    private static class URLForm {
        StringBuffer parameterBuf = new StringBuffer();
        String formId;
        String action = "";

        public URLForm(String formId) {
            this.formId = formId;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public void addParameter(String key, String value) {
            this.parameterBuf.append("<input type='hidden' name='").append(key);
            this.parameterBuf.append("' value='").append(value).append("'>");
        }

        public void addParameters(String queryString) {
            if (queryString != null) {
                StringTokenizer docUrlTok = new StringTokenizer(queryString, "&");
                while (docUrlTok.hasMoreTokens()) {
                    String nextToken = docUrlTok.nextToken();
                    if (nextToken.indexOf("=") <= -1) continue;
                    StringTokenizer keyValue = new StringTokenizer(nextToken, "=");
                    this.addParameter(keyValue.nextToken(), keyValue.nextToken());
                }
            }
        }

        public String toString() {
            StringBuffer urlFormBuf = new StringBuffer();
            if (this.parameterBuf.length() > 0) {
                urlFormBuf.append("<form id='").append(this.formId).append("' ");
                urlFormBuf.append("action='").append(this.action).append("' method='POST'>");
                urlFormBuf.append(this.parameterBuf);
                urlFormBuf.append("</form>");
            }
            urlFormBuf.append("\n<script>");
            urlFormBuf.append("function submit");
            urlFormBuf.append(this.formId);
            urlFormBuf.append("(docUrl) { var form = document.getElementById('");
            urlFormBuf.append(this.formId);
            urlFormBuf.append("'); if ( form != null ) { form.submit(); } else { window.location = docUrl; } }");
            urlFormBuf.append("</script>");
            return urlFormBuf.toString();
        }
    }
}

