/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util;

import com.ibm.ecm.serviceability.Logger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemInfo {
    private static SystemInfo systemInfo = null;
    private String osName;
    private String osArch;
    private String osVersion;
    private String distroName = null;
    private String distroRelease = null;
    private List<String> redhatRelease = null;
    private List<String> suseRelease = null;

    private SystemInfo() {
        this.initialize();
    }

    public static SystemInfo getSystemInfo() {
        if (systemInfo == null) {
            systemInfo = new SystemInfo();
        }
        return systemInfo;
    }

    private void initialize() {
        this.osName = System.getProperty("os.name");
        this.osArch = System.getProperty("os.arch");
        this.osVersion = System.getProperty("os.version");
        this.redhatRelease = null;
        if (this.osName.equalsIgnoreCase("Linux")) {
            this.redhatRelease = this.getReleaseInfo("/etc/redhat-release");
            if (this.redhatRelease.size() >= 1) {
                this.distroName = "Red Hat";
                this.distroRelease = this.findRelease(this.redhatRelease.get(0));
            }
            this.suseRelease = this.getReleaseInfo("/etc/SuSE-release");
            if (this.suseRelease.size() >= 1) {
                this.distroName = "SuSE";
                for (String line : this.suseRelease) {
                    if (!line.startsWith("VERSION")) continue;
                    this.distroRelease = this.findRelease(line);
                }
                if (this.distroRelease == null) {
                    this.distroRelease = this.findRelease(this.suseRelease.get(0));
                }
            }
        }
    }

    private String findRelease(String releaseLine) {
        String release = null;
        StringTokenizer st = new StringTokenizer(releaseLine, " ");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (!Character.isDigit(token.charAt(0))) continue;
            release = token;
            break;
        }
        return release;
    }

    private List<String> getReleaseInfo(String filename) {
        ArrayList<String> releaseInfo;
        block3: {
            String methodName = "getReleaseInfo";
            releaseInfo = new ArrayList<String>();
            try {
                BufferedReader br = new BufferedReader(new FileReader(filename));
                String line = br.readLine();
                while (line != null) {
                    releaseInfo.add(line);
                    line = br.readLine();
                }
            }
            catch (Exception exc) {
                if (!Logger.isDebugLogged()) break block3;
                Logger.logError((Object)this, methodName, "/etc/redhat-release", (Throwable)exc);
            }
        }
        return releaseInfo;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsArch() {
        return this.osArch;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getDistroName() {
        return this.distroName;
    }

    public String getDistroRelease() {
        return this.distroRelease;
    }

    public List<String> getRedhatRelease() {
        return this.redhatRelease;
    }

    public List<String> getSuseRelease() {
        return this.suseRelease;
    }
}

