/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util;

import com.ibm.ecm.serviceability.Logger;
import java.io.Serializable;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;

public class SendMailUtil
implements Serializable {
    private transient InternetAddress[] to = null;
    private transient InternetAddress[] cc = null;
    private transient InternetAddress[] bcc = null;
    private InternetAddress from = null;
    private InternetAddress replyTo = null;
    private String subject = null;
    private String bodyTxt = null;
    private String mailHost = null;
    private String mailPort = "25";
    private String mailUser = null;
    private String mailPassword = "";
    private boolean smtpAuthentication = false;
    private boolean mailDebugOn = false;
    private int numAttachments = 0;
    private Vector attachmentNames = new Vector();
    private Vector attachmentTypes = new Vector();
    private Vector attachments = new Vector();
    public static String newline = System.getProperty("line.separator");
    private HttpServletRequest request = null;
    private static final long serialVersionUID = 983062132518584559L;

    public SendMailUtil() {
        this.setReplyTo((InternetAddress)null);
        this.setMailHost(null);
        this.removeAllAttachments();
    }

    public SendMailUtil(String mailHost, String mailUser, String to, String from, String subject, String bodyTxt) throws Exception {
        this.setTo(to);
        this.setFrom(from);
        this.setSubject(subject);
        this.setBodyTxt(bodyTxt);
        this.setMailHost(mailHost);
        this.removeAllAttachments();
    }

    public void send() throws Exception {
        String methodName = "send";
        try {
            InternetAddress[] temp;
            Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
            Properties props = System.getProperties();
            props.put("mail.smtp.host", this.getMailHost());
            props.put("mail.smtp.port", this.getMailPort());
            props.put("mail.smtp.auth", Boolean.valueOf(this.isSMTPAuthentication()).toString());
            props.put("mail.user", this.getMailUser());
            props.put("mail.host", this.getMailHost());
            props.put("mail.debug", Boolean.valueOf(this.isMailDebugOn()).toString());
            Session session = Session.getDefaultInstance((Properties)props, null);
            session.setDebug(this.isMailDebugOn());
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)this.getFrom());
            msg.setRecipients(Message.RecipientType.TO, (Address[])this.getTo());
            msg.setRecipients(Message.RecipientType.CC, (Address[])this.getCc());
            msg.setRecipients(Message.RecipientType.BCC, (Address[])this.getBcc());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "TO=" + this.getTo());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "CC=" + this.getCc());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "BCC=" + this.getBcc());
            if (this.getReplyTo() == null) {
                temp = new InternetAddress[]{this.getFrom()};
                msg.setReplyTo((Address[])temp);
            } else {
                temp = new InternetAddress[]{this.getReplyTo()};
                msg.setReplyTo((Address[])temp);
            }
            msg.setSubject(this.getSubject(), "UTF-8");
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Subject=" + this.getSubject());
            MimeBodyPart mbp1 = new MimeBodyPart();
            mbp1.setContent((Object)this.getBodyTxt(), "text/html; charset=UTF-8");
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Message body=" + this.getBodyTxt());
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)mbp1);
            MimeBodyPart separatorPart = new MimeBodyPart();
            separatorPart.setText(newline + newline);
            mp.addBodyPart((BodyPart)separatorPart);
            if (this.getNumAttachments() > 0) {
                for (int i = 0; i < this.getNumAttachments(); ++i) {
                    InternetHeaders internetHeaders = new InternetHeaders();
                    String strTemp = this.getAttachmentType(i) + "; charset=\"UTF-8\"" + "; name=\"" + MimeUtility.encodeText((String)this.getAttachmentName(i), (String)"UTF-8", null) + "\"";
                    internetHeaders.addHeader("Content-Type", strTemp);
                    strTemp = "attachment; filename=\"" + MimeUtility.encodeText((String)this.getAttachmentName(i), (String)"UTF-8", null) + "\"";
                    internetHeaders.addHeader("Content-Disposition", strTemp);
                    internetHeaders.addHeader("Content-Transfer-Encoding", "base64");
                    MimeBodyPart part = null;
                    StringBuffer buff = new StringBuffer(Base64.encodeBase64String((byte[])this.getAttachment(i)));
                    part = new MimeBodyPart(internetHeaders, buff.toString().getBytes());
                    part.setFileName(MimeUtility.encodeText((String)this.getAttachmentName(i), (String)"UTF-8", null));
                    mp.addBodyPart((BodyPart)part);
                }
            }
            msg.setContent((Multipart)mp);
            msg.setSentDate(new Date());
            if (this.isSMTPAuthentication()) {
                Transport transport = session.getTransport("smtp");
                transport.connect(this.getMailHost(), this.getMailUser(), this.getMailPassword());
                msg.saveChanges();
                transport.sendMessage((Message)msg, msg.getAllRecipients());
                transport.close();
            } else {
                Transport.send((Message)msg);
            }
        }
        catch (Exception mex) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, mex.getMessage());
            throw new Exception(mex.toString());
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    protected InternetAddress[] parseMultipleAddresses(String addresses) throws AddressException {
        return this.parseMultipleAddresses(addresses, ";,");
    }

    protected InternetAddress[] parseMultipleAddresses(String addresses, String delimiters) throws AddressException {
        StringTokenizer st = new StringTokenizer(addresses, delimiters);
        InternetAddress[] addressObjs = new InternetAddress[st.countTokens()];
        int RecipientCounter = 0;
        while (st.hasMoreTokens()) {
            addressObjs[RecipientCounter] = new InternetAddress(st.nextToken());
            ++RecipientCounter;
        }
        return addressObjs;
    }

    public void setTo(String to) throws Exception {
        this.to = this.parseMultipleAddresses(to);
    }

    public void setTo(InternetAddress[] to) {
        this.to = to;
    }

    public InternetAddress[] getTo() throws Exception {
        return this.to;
    }

    public void setCc(String cc) throws Exception {
        this.cc = this.parseMultipleAddresses(cc);
    }

    public void setCc(InternetAddress[] cc) {
        this.cc = cc;
    }

    public InternetAddress[] getCc() {
        return this.cc;
    }

    public void setBcc(String bcc) throws Exception {
        this.bcc = this.parseMultipleAddresses(bcc);
    }

    public void setBcc(InternetAddress[] bcc) {
        this.bcc = bcc;
    }

    public InternetAddress[] getBcc() {
        return this.bcc;
    }

    public void setFrom(String from) throws Exception {
        InternetAddress address;
        this.from = address = new InternetAddress(from);
    }

    public void setFrom(InternetAddress from) {
        this.from = from;
    }

    public InternetAddress getFrom() {
        return this.from;
    }

    public void setReplyTo(String replyTo) throws Exception {
        InternetAddress address;
        this.replyTo = address = new InternetAddress(replyTo);
    }

    public void setReplyTo(InternetAddress replyTo) {
        this.replyTo = replyTo;
    }

    public InternetAddress getReplyTo() {
        return this.replyTo;
    }

    public void setSubject(String subject) {
        if (subject == null) {
            subject = "";
        }
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setBodyTxt(String bodyTxt) {
        if (bodyTxt == null) {
            bodyTxt = "";
        }
        this.bodyTxt = bodyTxt;
    }

    public String getBodyTxt() {
        return this.bodyTxt;
    }

    public void setMailHost(String mailHost) {
        this.mailHost = mailHost;
    }

    public String getMailHost() {
        return this.mailHost;
    }

    public String getMailUser() {
        return this.mailUser;
    }

    public void setMailUser(String mailUser) {
        this.mailUser = mailUser;
    }

    public String getMailPassword() {
        return this.mailPassword;
    }

    public void setMailPassword(String mailPassword) {
        if (mailPassword == null) {
            this.mailPassword = "";
        }
        this.mailPassword = mailPassword;
    }

    public String getMailPort() {
        return this.mailPort;
    }

    public void setMailPort(String mailPort) {
        if (mailPort == null) {
            this.mailPort = "25";
        }
        this.mailPort = mailPort;
    }

    public boolean isSMTPAuthentication() {
        return this.smtpAuthentication;
    }

    public void setSMTPAuthentication(boolean smtpAuthentication) {
        this.smtpAuthentication = smtpAuthentication;
    }

    public boolean isMailDebugOn() {
        return this.mailDebugOn;
    }

    public void setMailDebugOn(boolean mailDebugOn) {
        this.mailDebugOn = mailDebugOn;
    }

    public String getAttachmentFileName(int attachmentIndex) {
        return (String)this.attachments.elementAt(attachmentIndex);
    }

    public String getAttachmentName(int attachmentIndex) {
        return (String)this.attachmentNames.elementAt(attachmentIndex);
    }

    public String getAttachmentType(int attachmentIndex) {
        return (String)this.attachmentTypes.elementAt(attachmentIndex);
    }

    public void addAttachmentFile(String fileName, String simpleFileName, String attachmentType) {
        ++this.numAttachments;
        this.attachments.addElement(fileName);
        this.attachmentNames.addElement(simpleFileName);
        this.attachmentTypes.addElement(attachmentType);
    }

    public void addAttachment(byte[] attachment, String attachmentName, String attachmentType) {
        ++this.numAttachments;
        this.attachments.addElement(attachment);
        this.attachmentNames.addElement(attachmentName);
        this.attachmentTypes.addElement(attachmentType);
    }

    public byte[] getAttachment(int attachmentIndex) {
        return (byte[])this.attachments.elementAt(attachmentIndex);
    }

    public void removeAllAttachments() {
        this.numAttachments = 0;
        this.attachments.removeAllElements();
        this.attachmentNames.removeAllElements();
        this.attachmentTypes.removeAllElements();
    }

    public int getNumAttachments() {
        return this.numAttachments;
    }
}

