/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util;

import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.util.ChildSearchCriteria;
import com.ibm.ecm.util.SearchCriteria;
import com.ibm.ecm.util.SearchCriterion;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchTemplate {
    public static String THIS_TEAMSPACE_ID = "{this_teamspace_id}";
    private String displayName;
    private boolean autoRun;
    private boolean showInTree;
    private List<SearchFolder> folders;
    private List<SearchClass> classes;
    private boolean isAndSearch = true;
    private ObjectType objectType;
    private List<SearchCriteria> criteria = new ArrayList<SearchCriteria>();
    private List<TextSearchCriterion> textSearchCriteria = new ArrayList<TextSearchCriterion>();
    private TextSearchType textSearchType;
    private VersionOption versionOption;
    private Macros macros;
    private boolean propertyTextAnded = true;
    private ResultsDisplay resultDisplay;
    private boolean autoResolved;

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setAutoRun(boolean autoRun) {
        this.autoRun = autoRun;
    }

    public boolean isAutoRun() {
        return this.autoRun;
    }

    public void setShowInTree(boolean showInTree) {
        this.showInTree = showInTree;
    }

    public boolean isShowInTree() {
        return this.showInTree;
    }

    public void addFolder(SearchFolder folder) {
        if (this.folders == null) {
            this.folders = new ArrayList<SearchFolder>();
        }
        this.folders.add(folder);
    }

    public List<SearchFolder> getFolders() {
        return this.folders;
    }

    public void addClass(SearchClass searchClass) {
        if (this.classes == null) {
            this.classes = new ArrayList<SearchClass>();
        }
        this.classes.add(searchClass);
    }

    public List<SearchClass> getClasses() {
        return this.classes;
    }

    public void isAndSearch(boolean isAndSearch) {
        this.isAndSearch = isAndSearch;
    }

    public boolean isAndSearch() {
        return this.isAndSearch;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    public String getFirstClassName() {
        return this.classes != null && this.classes.size() > 0 ? this.classes.get(0).getName() : null;
    }

    public String getFirstClassDisplayName() {
        return this.classes != null && this.classes.size() > 0 ? this.classes.get(0).getDisplayName() : null;
    }

    public boolean isFirstClassSearchSubclasses() {
        return this.classes != null && this.classes.size() > 0 ? this.classes.get(0).isSearchSubclasses() : false;
    }

    public void addCriterion(SearchCriterion criterion) {
        if (this.criteria == null) {
            this.criteria = new ArrayList<SearchCriteria>();
        }
        this.criteria.add(criterion);
    }

    public void addChild(ChildSearchCriteria childCriterion) {
        if (this.criteria == null) {
            this.criteria = new ArrayList<SearchCriteria>();
        }
        this.criteria.add(childCriterion);
    }

    public List<SearchCriteria> getSearchCriteria() {
        return this.criteria;
    }

    public List<SearchCriterion> getPropertySearchCriteria() {
        ArrayList<SearchCriterion> textCriteria = new ArrayList<SearchCriterion>();
        if (this.criteria != null && this.criteria.size() > 0) {
            for (SearchCriteria criterion : this.criteria) {
                SearchCriterion sc;
                if (!(criterion instanceof SearchCriterion) || (sc = (SearchCriterion)criterion).getOperator().equals("CONTAINS")) continue;
                textCriteria.add(sc);
            }
        }
        return textCriteria;
    }

    public List<SearchCriterion> getPropertyTextSearchCriteria() {
        ArrayList<SearchCriterion> textCriteria = new ArrayList<SearchCriterion>();
        if (this.criteria != null && this.criteria.size() > 0) {
            for (SearchCriteria criterion : this.criteria) {
                SearchCriterion sc;
                if (!(criterion instanceof SearchCriterion) || !(sc = (SearchCriterion)criterion).getOperator().equals("CONTAINS")) continue;
                textCriteria.add(sc);
            }
        }
        return textCriteria;
    }

    public void addTextSearchCriterion(TextSearchCriterion textSearchCriteria) {
        this.textSearchCriteria.add(textSearchCriteria);
    }

    public List<TextSearchCriterion> getTextSearchCriteria() {
        return this.textSearchCriteria;
    }

    public TextSearchCriterion getFirstTextSearchCriterion() {
        return this.textSearchCriteria.size() > 0 ? this.textSearchCriteria.get(0) : null;
    }

    public TextSearchType getTextSearchType() {
        return this.textSearchType;
    }

    public void setTextSearchType(TextSearchType textSearchType) {
        this.textSearchType = textSearchType;
    }

    public VersionOption getVersionOption() {
        return this.versionOption;
    }

    public void setVersionOption(VersionOption versionOption) {
        this.versionOption = versionOption;
    }

    public Macros getMacros() {
        return this.macros;
    }

    public void setMacros(Macros macros) {
        this.macros = macros;
    }

    public boolean isPropertyTextAnded() {
        return this.propertyTextAnded;
    }

    public void setPropertyTextAnded(boolean propertyTextAnded) {
        this.propertyTextAnded = propertyTextAnded;
    }

    public ResultsDisplay getResultsDisplay() {
        return this.resultDisplay;
    }

    public void setResultsDisplay(ResultsDisplay resultDisplay) {
        this.resultDisplay = resultDisplay;
    }

    public boolean isAutoResolved() {
        return this.autoResolved;
    }

    public void setAutoResolved(boolean autoResolved) {
        this.autoResolved = autoResolved;
    }

    public void fromJSON(JSONObject searchTemplateJson) {
        String textSearchType;
        JSONObject resultsDisplayJson;
        JSONObject moreOptionsJson;
        JSONArray classesJSON;
        JSONArray foldersJSON;
        Object showInTree;
        Object autoRun;
        Object objectTypeParam = searchTemplateJson.get("objectType");
        ObjectType objectType = objectTypeParam != null && ((String)objectTypeParam).length() > 0 ? ObjectType.valueOf((String)objectTypeParam) : null;
        this.setObjectType(objectType);
        Object andSearch = searchTemplateJson.get("andSearch");
        if (andSearch != null) {
            this.isAndSearch(Boolean.parseBoolean(andSearch.toString()));
        }
        if ((autoRun = searchTemplateJson.get("autoRun")) != null) {
            this.setAutoRun(Boolean.parseBoolean(autoRun.toString()));
        }
        if ((showInTree = searchTemplateJson.get("showInTree")) != null) {
            this.setShowInTree(Boolean.parseBoolean(showInTree.toString()));
        }
        if ((foldersJSON = (JSONArray)searchTemplateJson.get("search_folders")) != null && foldersJSON.size() > 0) {
            for (JSONObject folderJSON : foldersJSON) {
                String id = P8Util.getObjectIdentity((String)folderJSON.get("id"));
                SearchFolder folder = new SearchFolder(id, (String)folderJSON.get("pathName"), (Boolean)folderJSON.get("searchSubfolders"), SearchFolderView.valueOf((String)folderJSON.get("view")), (String)folderJSON.get("objectStoreId"), null, (String)folderJSON.get("itemId"));
                this.addFolder(folder);
            }
        }
        if ((classesJSON = (JSONArray)searchTemplateJson.get("search_classes")) != null && classesJSON.size() > 0) {
            for (JSONObject classJSON : classesJSON) {
                String className = (String)classJSON.get("name");
                String displayName = (String)classJSON.get("displayName");
                Object classTypeParam = classJSON.get("objectType");
                ObjectType classType = classTypeParam != null && ((String)classTypeParam).length() > 0 ? ObjectType.valueOf((String)classTypeParam) : null;
                Object subClassesParam = classJSON.get("searchSubclasses");
                boolean subClasses = subClassesParam == null ? false : (Boolean)subClassesParam;
                Object editPropertyParam = classJSON.get("editProperty");
                SearchEditProperty editProperty = editPropertyParam != null && ((String)editPropertyParam).length() > 0 ? SearchEditProperty.valueOf((String)editPropertyParam) : SearchEditProperty.editable;
                String itemId = (String)classJSON.get("itemId");
                SearchClass searchClass = new SearchClass(className, displayName, classType, subClasses, editProperty, itemId);
                this.addClass(searchClass);
            }
        } else {
            String className = (String)searchTemplateJson.get("template_name");
            String displayName = (String)searchTemplateJson.get("template_label");
            Object subClassesParam = searchTemplateJson.get("searchSubclasses");
            boolean subClasses = subClassesParam == null ? false : (Boolean)subClassesParam;
            SearchClass searchClass = new SearchClass(className, displayName, objectType, subClasses, SearchEditProperty.editable, null);
            this.addClass(searchClass);
        }
        JSONArray searchCriteriaJson = (JSONArray)searchTemplateJson.get("searchCriteria");
        if (searchCriteriaJson != null) {
            for (int i = 0; i < searchCriteriaJson.size(); ++i) {
                JSONObject searchCriterionJson = (JSONObject)searchCriteriaJson.get(i);
                if (searchCriterionJson.get("id") != null) {
                    this.addCriterion(this.createSearchCriterionFromJSON(searchCriterionJson));
                    continue;
                }
                if (searchCriterionJson.get("template_name") == null) continue;
                ChildSearchCriteria childCriteria = new ChildSearchCriteria();
                childCriteria.setName((String)searchCriterionJson.get("template_name"));
                JSONArray childCriteriaJson = (JSONArray)searchCriterionJson.get("searchCriteria");
                for (int j = 0; j < childCriteriaJson.size(); ++j) {
                    JSONObject childSearchCriterionJson = (JSONObject)childCriteriaJson.get(j);
                    childCriteria.addCriterion(this.createSearchCriterionFromJSON(childSearchCriterionJson));
                }
                this.addChild(childCriteria);
            }
        }
        if ((moreOptionsJson = (JSONObject)searchTemplateJson.get("moreOptions")) != null) {
            JSONObject macrosJson;
            Boolean propertyTextAnded;
            String versionOption = (String)moreOptionsJson.get("versionOption");
            if (versionOption != null && versionOption.length() > 0) {
                this.setVersionOption(VersionOption.valueOf(versionOption));
            }
            if ((propertyTextAnded = (Boolean)moreOptionsJson.get("propertyTextAnded")) != null) {
                this.setPropertyTextAnded(propertyTextAnded);
            }
            if ((macrosJson = (JSONObject)moreOptionsJson.get("macros")) != null) {
                Macros macros = new Macros();
                macros.fromJSON(macrosJson);
                this.setMacros(macros);
            }
        }
        if ((resultsDisplayJson = (JSONObject)searchTemplateJson.get("resultsDisplay")) != null) {
            ResultsDisplay resultsDisplay = new ResultsDisplay();
            resultsDisplay.fromJSON(resultsDisplayJson);
            this.setResultsDisplay(resultsDisplay);
        }
        JSONArray searchTextCriteriaJSON = (JSONArray)searchTemplateJson.get("search_text_criteria");
        JSONObject textSearchCriteriaJSON = (JSONObject)searchTemplateJson.get("textSearchCriteria");
        if (searchTextCriteriaJSON != null) {
            for (int i = 0; i < searchTextCriteriaJSON.size(); ++i) {
                JSONObject searchCriterionJson = (JSONObject)searchTextCriteriaJSON.get(i);
                TextSearchCriterion textSearchCriteria = new TextSearchCriterion();
                textSearchCriteria.fromJSON(searchCriterionJson);
                this.addTextSearchCriterion(textSearchCriteria);
            }
        } else if (textSearchCriteriaJSON != null) {
            TextSearchCriterion textSearchCriteria = new TextSearchCriterion();
            textSearchCriteria.fromJSON(textSearchCriteriaJSON);
            this.addTextSearchCriterion(textSearchCriteria);
        }
        if ((textSearchType = (String)searchTemplateJson.get("textSearchType")) != null && textSearchType.length() > 0) {
            this.setTextSearchType(TextSearchType.valueOf(textSearchType));
        }
    }

    public SearchCriterion createSearchCriterionFromJSON(JSONObject searchCriterionJson) {
        SearchCriterion criterion = new SearchCriterion();
        criterion.setName((String)searchCriterionJson.get("id"));
        criterion.setDisplayName(searchCriterionJson.get("name").toString());
        criterion.setOperator((String)searchCriterionJson.get("selectedOperator"));
        criterion.setDataType((String)searchCriterionJson.get("dataType"));
        criterion.setCardinality((String)searchCriterionJson.get("cardinality"));
        JSONArray criteriaJSONArray = (JSONArray)searchCriterionJson.get("values");
        String[] values = new String[criteriaJSONArray.size()];
        criteriaJSONArray.toArray(values);
        criterion.setValues(values);
        criterion.setItemId((String)searchCriterionJson.get("itemId"));
        return criterion;
    }

    private static String[] getJsonArrayValues(JSONObject json, String key) {
        if (json == null) {
            return null;
        }
        Object jsonValue = json.get(key);
        int size = jsonValue instanceof JSONArray ? ((JSONArray)jsonValue).size() : 1;
        String[] values = new String[size];
        if (jsonValue instanceof JSONArray) {
            ((JSONArray)jsonValue).toArray(values);
        } else if (jsonValue instanceof String) {
            values[0] = (String)jsonValue;
        } else {
            values = null;
        }
        return values;
    }

    public static class UserAction {
        private String action;
        private String[] users;
        private String[] dates;
        private String dateOperator;
        private String[] userDisplayNames;

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String[] getUsers() {
            return this.users;
        }

        public void setUsers(String[] users) {
            this.users = users;
        }

        public String[] getDates() {
            return this.dates;
        }

        public void setDates(String[] dates) {
            this.dates = dates;
        }

        public String getDateOperator() {
            return this.dateOperator;
        }

        public void setDateOperator(String dateOperator) {
            this.dateOperator = dateOperator;
        }

        public String[] getUserDisplayNames() {
            return this.userDisplayNames;
        }

        public void setUserDisplayNames(String[] userDisplayNames) {
            this.userDisplayNames = userDisplayNames;
        }

        public void fromJSON(JSONObject json) {
            this.setAction((String)json.get("action"));
            this.setUsers(SearchTemplate.getJsonArrayValues(json, "users"));
            this.setDates(SearchTemplate.getJsonArrayValues(json, "dates"));
            this.setDateOperator((String)json.get("dateOperator"));
        }

        public JSONObject toJSON() {
            JSONObject json = new JSONObject();
            json.put("action", this.action);
            json.put("dateOperator", this.dateOperator);
            if (this.users != null && this.users.length > 0) {
                for (String user : this.users) {
                    JSONUtils.accumulate(json, "users", user);
                }
            }
            if (this.dates != null && this.dates.length > 0) {
                for (String date : this.dates) {
                    JSONUtils.accumulate(json, "dates", date);
                }
            }
            if (this.userDisplayNames != null && this.userDisplayNames.length > 0) {
                for (String userDisplayName : this.userDisplayNames) {
                    JSONUtils.accumulate(json, "userDisplayNames", userDisplayName);
                }
            }
            return json;
        }
    }

    public static class Macros {
        private String[] fileTypes;
        private UserAction[] userActions;

        public String[] getFileTypes() {
            return this.fileTypes;
        }

        public void setFileTypes(String[] fileTypes) {
            this.fileTypes = fileTypes;
        }

        public UserAction[] getUserActions() {
            return this.userActions;
        }

        public void setUserActions(UserAction[] userActions) {
            this.userActions = userActions;
        }

        public void fromJSON(JSONObject json) {
            this.setFileTypes(SearchTemplate.getJsonArrayValues(json, "fileTypes"));
            JSONArray actions = (JSONArray)json.get("userActions");
            if (actions != null) {
                UserAction[] userActions = new UserAction[actions.size()];
                for (int i = 0; i < actions.size(); ++i) {
                    userActions[i] = new UserAction();
                    userActions[i].fromJSON((JSONObject)actions.get(i));
                }
                this.setUserActions(userActions);
            }
        }

        public JSONObject toJSON() {
            JSONObject json = new JSONObject();
            if (this.fileTypes != null && this.fileTypes.length > 0) {
                for (String type : this.fileTypes) {
                    JSONUtils.accumulate(json, "fileTypes", type);
                }
            }
            if (this.userActions != null && this.userActions.length > 0) {
                for (UserAction action : this.userActions) {
                    JSONUtils.accumulate(json, "userActions", action.toJSON());
                }
            }
            return json;
        }
    }

    public static class ResultsDisplay {
        private String sortBy;
        private boolean sortAscending;
        private String[] columns;

        public ResultsDisplay() {
        }

        public ResultsDisplay(String sortByProperty, boolean ascending, String[] columns) {
            this.sortBy = sortByProperty;
            this.sortAscending = ascending;
            this.columns = columns;
        }

        public String getSortByProperty() {
            return this.sortBy;
        }

        public void setSortByProperty(String sortBy) {
            this.sortBy = sortBy;
        }

        public boolean getSortAscending() {
            return this.sortAscending;
        }

        public void setSortAscending(boolean ascending) {
            this.sortAscending = ascending;
        }

        public String[] getColumns() {
            return this.columns;
        }

        public void setColumns(String[] columns) {
            this.columns = columns;
        }

        public String getSortOrder() {
            return this.sortAscending ? SORT_ORDER.ascending.name() : SORT_ORDER.descending.name();
        }

        public JSONObject toJSON() {
            JSONObject json = new JSONObject();
            if (this.sortBy != null) {
                json.put("sortBy", this.sortBy);
            }
            json.put("sortAsc", (Object)this.sortAscending);
            if (this.columns != null && this.columns.length > 0) {
                for (String col : this.columns) {
                    JSONUtils.accumulate(json, "columns", col);
                }
            }
            return json;
        }

        public void fromJSON(JSONObject json) {
            this.setSortByProperty((String)json.get("sortBy"));
            this.setSortAscending((Boolean)json.get("sortAsc"));
            JSONArray columnsJSON = (JSONArray)json.get("columns");
            if (columnsJSON != null) {
                this.columns = new String[columnsJSON.size()];
                columnsJSON.toArray(this.columns);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum SORT_ORDER {
            ascending,
            descending;

        }
    }

    public static class TextSearchCriterion {
        private String text;
        private String operator;
        private int distance;
        SearchEditProperty editProperty;
        String itemId;

        public TextSearchCriterion() {
            this.text = "";
        }

        public TextSearchCriterion(String text, String operator, int distance) {
            this.text = text == null ? "" : text;
            this.operator = operator;
            this.distance = distance;
        }

        public TextSearchCriterion(String text, String operator, int distance, SearchEditProperty editProperty, String itemId) {
            this.text = text == null ? "" : text;
            this.operator = operator;
            this.distance = distance;
            this.editProperty = editProperty;
            this.itemId = itemId;
        }

        public String getText() {
            return this.text == null ? "" : this.text;
        }

        public void setText(String text) {
            this.text = text == null ? "" : text;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public int getDistance() {
            return this.distance;
        }

        public void setDistance(int distance) {
            this.distance = distance;
        }

        public SearchEditProperty getEditProperty() {
            return this.editProperty == null ? SearchEditProperty.editable : this.editProperty;
        }

        public void setEditProperty(SearchEditProperty editProperty) {
            this.editProperty = editProperty;
        }

        public String getItemId() {
            return this.itemId;
        }

        public void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public JSONObject toJSON() {
            JSONObject json = new JSONObject();
            if (this.text != null) {
                json.put("text", this.text);
            }
            if (this.operator != null) {
                json.put("operator", this.operator);
            }
            json.put("proximityDistance", (Object)this.distance);
            json.put("editProperty", this.getEditProperty().toString());
            json.put("itemId", this.itemId);
            return json;
        }

        public void fromJSON(JSONObject json) {
            Object itemId;
            Object text = json.get("text");
            if (text != null) {
                this.setText((String)text);
            }
            this.setOperator((String)json.get("operator"));
            Long distance = (Long)json.get("proximityDistance");
            this.setDistance(distance == null ? 0 : distance.intValue());
            Object editProp = json.get("editProperty");
            if (editProp != null && ((String)editProp).length() > 0) {
                this.setEditProperty(SearchEditProperty.valueOf((String)editProp));
            }
            if ((itemId = json.get("itemId")) != null && ((String)itemId).length() > 0) {
                this.setItemId((String)itemId);
            }
        }
    }

    public static class SearchClass {
        private String name;
        private String displayName;
        private ObjectType objectType;
        private boolean searchSubclasses;
        private SearchEditProperty editProperty;
        private String itemId;

        public SearchClass() {
        }

        public SearchClass(String name, String displayName, ObjectType objectType, boolean searchSubclasses, SearchEditProperty editProperty, String itemId) {
            this.name = name;
            this.displayName = displayName;
            this.objectType = objectType;
            this.searchSubclasses = searchSubclasses;
            this.editProperty = editProperty;
            this.itemId = itemId;
        }

        public String getItemId() {
            return this.itemId;
        }

        public void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public ObjectType getObjectType() {
            return this.objectType == null ? ObjectType.document : this.objectType;
        }

        public void setObjectType(String objectType) {
            this.objectType = objectType == null || objectType.length() < 1 ? ObjectType.document : ObjectType.valueOf(objectType);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public SearchEditProperty getEditProperty() {
            return this.editProperty == null ? SearchEditProperty.editable : this.editProperty;
        }

        public void setEditProperty(String editProperty) {
            this.editProperty = editProperty == null || editProperty.length() < 1 ? SearchEditProperty.editable : SearchEditProperty.valueOf(editProperty);
        }

        public boolean isHidden() {
            return this.editProperty != null && this.editProperty.equals((Object)SearchEditProperty.hidden);
        }

        public boolean isReadOnly() {
            return this.editProperty != null && this.editProperty.equals((Object)SearchEditProperty.readonly);
        }

        public boolean isSearchSubclasses() {
            return this.searchSubclasses;
        }

        public void setSearchSubclasses(boolean searchSubclasses) {
            this.searchSubclasses = searchSubclasses;
        }
    }

    public static class SearchFolder {
        private String id;
        private String pathName;
        private boolean searchSubfolders;
        private SearchFolderView view;
        private String objectStoreId;
        private String objectStoreName;
        private String itemId;

        public SearchFolder() {
        }

        public SearchFolder(String id, String pathName, boolean searchSubfolders, SearchFolderView view, String objectStoreId, String objectStoreName, String itemId) {
            this.id = id;
            this.pathName = pathName;
            this.searchSubfolders = searchSubfolders;
            this.view = view;
            this.objectStoreId = objectStoreId;
            this.objectStoreName = objectStoreName;
            this.itemId = itemId;
        }

        public boolean isHidden() {
            return this.view != null && this.view == SearchFolderView.hidden;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getPathName() {
            return this.pathName;
        }

        public void setPathName(String pathName) {
            this.pathName = pathName;
        }

        public boolean isSearchSubfolders() {
            return this.searchSubfolders;
        }

        public void setSearchSubfolders(boolean searchSubfolders) {
            this.searchSubfolders = searchSubfolders;
        }

        public SearchFolderView getView() {
            return this.view;
        }

        public void setView(SearchFolderView view) {
            this.view = view;
        }

        public String getObjectStoreId() {
            return this.objectStoreId;
        }

        public void setObjectStoreId(String objectStoreId) {
            this.objectStoreId = objectStoreId;
        }

        public String getObjectStoreName() {
            return this.objectStoreName;
        }

        public void setObjectStoreName(String objectStoreName) {
            this.objectStoreName = objectStoreName;
        }

        public void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public String getItemId() {
            return this.itemId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchFolderView {
        editable,
        hidden;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchEditProperty {
        editable,
        hidden,
        required,
        readonly;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextSearchType {
        cascade,
        verity,
        basic;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ObjectType {
        document,
        folder,
        all,
        common,
        customobject;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VersionOption {
        currentversion,
        releasedversion,
        allversions,
        none;

    }
}

