/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util;

import com.ibm.ecm.configuration.ApplicationConfig;
import com.ibm.ecm.configuration.Cache;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.PluginConfig;
import com.ibm.ecm.extension.Plugin;
import com.ibm.ecm.extension.PluginAction;
import com.ibm.ecm.extension.PluginFeature;
import com.ibm.ecm.extension.PluginLayout;
import com.ibm.ecm.extension.PluginMenu;
import com.ibm.ecm.extension.PluginMenuType;
import com.ibm.ecm.extension.PluginRequestFilter;
import com.ibm.ecm.extension.PluginResponseFilter;
import com.ibm.ecm.extension.PluginService;
import com.ibm.ecm.extension.PluginServiceCallbacks;
import com.ibm.ecm.extension.PluginViewerDef;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginUtil {
    private static ArrayList<Plugin> plugins;
    private static boolean pluginsInitialized;
    private static boolean pluginInitializationFailed;

    public static boolean didPluginInitializationFail() {
        return pluginInitializationFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Plugin[] getPlugins(HttpServletRequest request) throws Exception {
        if (plugins == null) {
            Class<PluginUtil> clazz = PluginUtil.class;
            // MONITORENTER : com.ibm.ecm.util.PluginUtil.class
            if (plugins == null) {
                ApplicationConfig appConfig = Config.getApplicationConfig("navigator");
                plugins = new ArrayList();
                for (PluginConfig pluginConfig : appConfig.getPluginList()) {
                    if (pluginConfig == null || pluginConfig.getFileName() == null) continue;
                    File pluginFile = new File(pluginConfig.getFileName());
                    Plugin plugin = null;
                    boolean canLoad = true;
                    if (!pluginFile.exists()) {
                        String urlString = null;
                        if (pluginConfig.getFileName().indexOf("http") > -1) {
                            urlString = pluginConfig.getFileName();
                        } else if (pluginConfig.getFileName().indexOf(":") == -1 && !pluginConfig.getFileName().startsWith("/")) {
                            urlString = "http://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/" + pluginConfig.getFileName();
                        } else {
                            Logger.logError(PluginUtil.class, "loadPlugins", (ServletRequest)request, "Plug-in file " + pluginConfig.getFileName() + " was not found");
                            canLoad = false;
                        }
                        if (!canLoad) continue;
                        try {
                            plugin = PluginUtil.loadPlugin(request, urlString, pluginConfig.isOptional());
                        }
                        catch (Exception e) {
                            Logger.logError(PluginUtil.class, "loadPlugins", "Exception loading plug-in " + pluginConfig.getFileName(), (Throwable)e);
                        }
                        continue;
                    }
                    plugin = PluginUtil.loadPlugin(request, pluginFile, pluginConfig.isOptional());
                }
            }
            // MONITOREXIT : clazz
        }
        Plugin[] pluginsArray = new Plugin[plugins.size()];
        plugins.toArray(pluginsArray);
        return pluginsArray;
    }

    public static synchronized Plugin loadNewPlugin(HttpServletRequest request, String pluginFileName) throws Exception {
        Logger.logEntry(PluginUtil.class, "loadNewPlugin", (ServletRequest)request);
        Plugin plugin = null;
        File pluginFile = new File(pluginFileName);
        boolean canLoad = true;
        if (!pluginFile.exists()) {
            String urlString = null;
            if (pluginFileName.indexOf("http") > -1) {
                urlString = pluginFileName;
            } else if (pluginFileName.indexOf(":") == -1 && !pluginFileName.startsWith("/")) {
                urlString = "http://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/" + pluginFileName;
            } else {
                Logger.logError(PluginUtil.class, "loadNewPlugin", (ServletRequest)request, "Plug-in file " + pluginFileName + " was not found");
                canLoad = false;
            }
            if (canLoad) {
                try {
                    plugin = PluginUtil.loadPlugin(request, urlString, false);
                }
                catch (Exception e) {
                    Logger.logError(PluginUtil.class, "loadNewPlugin", (ServletRequest)request, "Exception loading plug-in " + pluginFileName, e);
                }
            }
        } else {
            try {
                plugin = PluginUtil.loadPlugin(request, pluginFile, false);
            }
            catch (Exception e) {
                Logger.logError(PluginUtil.class, "loadNewPlugin", (ServletRequest)request, "Exception loading plug-in " + pluginFileName, e);
            }
        }
        if (plugin != null) {
            PluginUtil.initializePlugin(request, plugin);
        }
        pluginInitializationFailed = false;
        PluginUtil.unloadPluginDataCache(request);
        Logger.logExit(PluginUtil.class, "loadNewPlugin", (ServletRequest)request);
        return plugin;
    }

    private static Plugin loadPlugin(HttpServletRequest request, String pluginFileURL, boolean optional) throws Exception {
        JarFile jarLibFile;
        Plugin plugin;
        block8: {
            plugin = null;
            Logger.logEntry(PluginUtil.class, "loadPlugin", (ServletRequest)request);
            jarLibFile = null;
            try {
                Logger.logInfo(PluginUtil.class, "loadPlugin", (ServletRequest)request, "Loading plugin " + pluginFileURL);
                URL pluginURL = new URL(pluginFileURL);
                URL jarURL = new URL("jar:" + pluginURL.toString() + "!/");
                JarURLConnection jarLib = null;
                try {
                    jarLib = (JarURLConnection)jarURL.openConnection();
                    jarLibFile = jarLib.getJarFile();
                }
                catch (Exception exc) {
                    if (!optional) {
                        Logger.logError(PluginUtil.class, "loadPlugins", (ServletRequest)request, "Plug-in file " + pluginFileURL + " was not found");
                        pluginInitializationFailed = true;
                    } else {
                        Logger.logInfo(PluginUtil.class, "loadPlugins", (ServletRequest)request, "Optional plug-in file " + pluginFileURL + " was not found");
                    }
                    return plugin;
                }
                Manifest jarManifest = jarLibFile.getManifest();
                Attributes jarAttributes = jarManifest.getMainAttributes();
                String pluginClassName = jarAttributes.getValue("Plugin-Class");
                jarLibFile.close();
                if (pluginClassName == null) {
                    throw new Exception("Invalid IBM Content Navigator plug-in -- missing Plugin-Class attribute in manifest.mf");
                }
                URLClassLoader pluginClassLoader = URLClassLoader.newInstance(new URL[]{pluginURL}, PluginUtil.class.getClassLoader());
                Class<?> pluginClass = pluginClassLoader.loadClass(pluginClassName);
                plugin = (Plugin)pluginClass.newInstance();
            }
            catch (Exception e) {
                Logger.logError(PluginUtil.class, "loadPlugins", (ServletRequest)request, "Exception loading plug-in " + pluginFileURL, e);
                if (optional) break block8;
                pluginInitializationFailed = true;
            }
        }
        if (plugin != null) {
            plugin.setJarFile(jarLibFile);
            PluginUtil.addOrReplace(plugin);
        }
        Logger.logExit(PluginUtil.class, "loadPlugin", (ServletRequest)request);
        return plugin;
    }

    private static Plugin loadPlugin(HttpServletRequest request, File pluginFile, boolean optional) throws Exception {
        Plugin plugin = null;
        Logger.logEntry(PluginUtil.class, "loadPlugin", (ServletRequest)request);
        if (!pluginFile.exists()) {
            if (!optional) {
                Logger.logError(PluginUtil.class, "loadPlugins", (ServletRequest)request, "Plug-in file " + pluginFile.getPath() + " was not found");
                pluginInitializationFailed = true;
            } else {
                Logger.logInfo(PluginUtil.class, "loadPlugins", (ServletRequest)request, "Optional plug-in file " + pluginFile.getPath() + " was not found");
            }
        } else {
            try {
                Logger.logInfo(PluginUtil.class, "loadPlugin", (ServletRequest)request, "Loading plugin " + pluginFile.toString());
                URL pluginURL = pluginFile.toURL();
                URL jarURL = new URL("jar:" + pluginURL.toString() + "!/");
                JarURLConnection jarLib = (JarURLConnection)jarURL.openConnection();
                JarFile jarLibFile = jarLib.getJarFile();
                Manifest jarManifest = jarLibFile.getManifest();
                Attributes jarAttributes = jarManifest.getMainAttributes();
                String pluginClassName = jarAttributes.getValue("Plugin-Class");
                jarLibFile.close();
                if (pluginClassName == null) {
                    throw new Exception("Invalid IBM Content Navigator plug-in -- missing Plugin-Class attribute in manifest.mf");
                }
                URLClassLoader pluginClassLoader = URLClassLoader.newInstance(new URL[]{pluginURL}, PluginUtil.class.getClassLoader());
                Class<?> pluginClass = pluginClassLoader.loadClass(pluginClassName);
                plugin = (Plugin)pluginClass.newInstance();
                if (plugin != null) {
                    plugin.setJarFile(jarLibFile);
                    PluginUtil.addOrReplace(plugin);
                }
            }
            catch (Exception e) {
                Logger.logError(PluginUtil.class, "loadPlugins", (ServletRequest)request, "Exception loading plug-in " + pluginFile.getPath(), e);
                pluginInitializationFailed = true;
            }
        }
        Logger.logExit(PluginUtil.class, "loadPlugin", (ServletRequest)request);
        return plugin;
    }

    private static void addOrReplace(Plugin plugin) {
        for (int i = 0; i < plugins.size(); ++i) {
            if (!plugins.get(i).getId().equals(plugin.getId())) continue;
            plugins.remove(i);
            --i;
        }
        plugins.add(plugin);
    }

    public static void unloadPlugin(HttpServletRequest request, String pluginId) {
        for (int i = 0; i < plugins.size(); ++i) {
            Plugin plugin = plugins.get(i);
            if (!plugin.getId().equals(pluginId)) continue;
            plugins.remove(i);
            JarFile jarFile = plugin.getJarFile();
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    Logger.logError(PluginUtil.class, "unloadPlugin", (ServletRequest)request, (Throwable)e);
                }
            }
            System.gc();
            System.runFinalization();
            PluginUtil.unloadPluginDataCache(request);
            return;
        }
    }

    public static Plugin getPlugin(HttpServletRequest request, String pluginId) throws Exception {
        Plugin[] plugins = PluginUtil.getPlugins(request);
        for (int i = 0; i < plugins.length; ++i) {
            if (!plugins[i].getId().equals(pluginId)) continue;
            return plugins[i];
        }
        return null;
    }

    public static Map<String, PluginLayout> getPluginLayouts(HttpServletRequest request) {
        String key = "getPluginLayouts";
        Hashtable<String, PluginLayout> pluginLayouts = (Hashtable<String, PluginLayout>)Cache.getInstance().get(key);
        if (pluginLayouts == null) {
            pluginLayouts = new Hashtable<String, PluginLayout>();
            try {
                for (Plugin plugin : PluginUtil.getPlugins(request)) {
                    for (PluginLayout pluginLayout : plugin.getLayouts()) {
                        pluginLayout.setPluginId(plugin.getId());
                        pluginLayouts.put(pluginLayout.getId(), pluginLayout);
                    }
                }
            }
            catch (Exception e) {
                Logger.logError(PluginUtil.class, "getPluginLayouts", (ServletRequest)request, (Throwable)e);
            }
            Cache.getInstance().add(key, pluginLayouts);
        }
        return pluginLayouts;
    }

    public static Map<String, PluginFeature> getPluginFeatures(HttpServletRequest request) {
        String key = "getPluginFeatures";
        Hashtable<String, PluginFeature> pluginFeatures = (Hashtable<String, PluginFeature>)Cache.getInstance().get(key);
        if (pluginFeatures == null) {
            pluginFeatures = new Hashtable<String, PluginFeature>();
            try {
                for (Plugin plugin : PluginUtil.getPlugins(request)) {
                    for (PluginFeature pluginFeature : plugin.getFeatures()) {
                        pluginFeature.setPluginId(plugin.getId());
                        pluginFeatures.put(pluginFeature.getId(), pluginFeature);
                    }
                }
            }
            catch (Exception e) {
                Logger.logError(PluginUtil.class, "getPluginFeatures", (ServletRequest)request, (Throwable)e);
            }
            Cache.getInstance().add(key, pluginFeatures);
        }
        return pluginFeatures;
    }

    public static void loadPluginFeatures(HttpServletRequest request, String pluginId) {
        try {
            PluginFeature[] features;
            Plugin plugin = PluginUtil.getPlugin(request, pluginId);
            if (plugin != null && (features = plugin.getFeatures()) != null) {
                Map cachedPluginFeatures = (Map)Cache.getInstance().get("getPluginFeatures");
                for (PluginFeature feature : features) {
                    feature.setPluginId(plugin.getId());
                    cachedPluginFeatures.put(feature.getId(), feature);
                }
            }
        }
        catch (Exception e) {
            Logger.logError(PluginUtil.class, "loadPluginFeatures", (ServletRequest)request, (Throwable)e);
        }
    }

    public static Map<String, PluginViewerDef> getPluginViewers(HttpServletRequest request) {
        String key = "getPluginViewers";
        Hashtable<String, PluginViewerDef> pluginViewers = (Hashtable<String, PluginViewerDef>)Cache.getInstance().get(key);
        if (pluginViewers == null) {
            pluginViewers = new Hashtable<String, PluginViewerDef>();
            try {
                for (Plugin plugin : PluginUtil.getPlugins(request)) {
                    for (PluginViewerDef pluginViewerDef : plugin.getViewers()) {
                        pluginViewers.put(pluginViewerDef.getId(), pluginViewerDef);
                    }
                }
            }
            catch (Exception e) {
                Logger.logError(PluginUtil.class, "getPluginViewers", (ServletRequest)request, (Throwable)e);
            }
            Cache.getInstance().add(key, pluginViewers);
        }
        return pluginViewers;
    }

    public static Map<String, PluginAction> getPluginActions(HttpServletRequest request) {
        String key = "getPluginActions";
        Hashtable<String, PluginAction> pluginActions = (Hashtable<String, PluginAction>)Cache.getInstance().get(key);
        if (pluginActions == null) {
            pluginActions = new Hashtable<String, PluginAction>();
            try {
                for (Plugin plugin : PluginUtil.getPlugins(request)) {
                    for (PluginAction pluginAction : plugin.getActions()) {
                        pluginAction.setPluginId(plugin.getId());
                        pluginActions.put(pluginAction.getId(), pluginAction);
                    }
                }
            }
            catch (Exception e) {
                Logger.logError(PluginUtil.class, "getPluginActions", (ServletRequest)request, (Throwable)e);
            }
            Cache.getInstance().add(key, pluginActions);
        }
        return pluginActions;
    }

    public static void unloadPluginDataCache(HttpServletRequest request) {
        Cache.getInstance().remove("getPluginMenuTypes");
        Cache.getInstance().remove("getPluginMenus");
        Cache.getInstance().remove("getPluginViewers");
        Cache.getInstance().remove("getPluginActions");
        Cache.getInstance().remove("getPluginLayouts");
        Cache.getInstance().remove("getPluginFeatures");
    }

    public static Map<String, PluginMenu> getPluginMenus(HttpServletRequest request) {
        String key = "getPluginMenus";
        Hashtable<String, PluginMenu> pluginMenus = (Hashtable<String, PluginMenu>)Cache.getInstance().get(key);
        if (pluginMenus == null) {
            pluginMenus = new Hashtable<String, PluginMenu>();
            try {
                for (Plugin plugin : PluginUtil.getPlugins(request)) {
                    for (PluginMenu pluginMenu : plugin.getMenus()) {
                        pluginMenu.setPluginId(plugin.getId());
                        pluginMenus.put(pluginMenu.getId(), pluginMenu);
                    }
                }
            }
            catch (Exception e) {
                Logger.logError(PluginUtil.class, "getPluginActions", (ServletRequest)request, (Throwable)e);
            }
            Cache.getInstance().add(key, pluginMenus);
        }
        return pluginMenus;
    }

    public static Map<String, PluginMenuType> getPluginMenuTypes(HttpServletRequest request) {
        Hashtable<String, PluginMenuType> pluginMenuTypes;
        String key = "getPluginMenuTypes";
        ServletContext context = null;
        if (request != null) {
            context = request.getSession(false).getServletContext();
        }
        if ((pluginMenuTypes = (Hashtable<String, PluginMenuType>)Cache.getInstance().get(key)) == null) {
            pluginMenuTypes = new Hashtable<String, PluginMenuType>();
            try {
                for (Plugin plugin : PluginUtil.getPlugins(request)) {
                    for (PluginMenuType pluginMenuType : plugin.getMenuTypes()) {
                        pluginMenuType.setPluginId(plugin.getId());
                        pluginMenuTypes.put(pluginMenuType.getId(), pluginMenuType);
                    }
                }
            }
            catch (Exception e) {
                Logger.logError(PluginUtil.class, "getPluginActions", (ServletRequest)request, (Throwable)e);
            }
            Cache.getInstance().add(key, pluginMenuTypes);
        }
        return pluginMenuTypes;
    }

    public static String loadPluginConfig(Plugin plugin) throws Exception {
        return Config.getPluginConfig("navigator", plugin.getId()).getConfiguration();
    }

    public static void savePluginConfig(Plugin plugin, String config) throws Exception {
        Config.getPluginConfig("navigator", plugin.getId()).setConfiguration(config);
    }

    public static boolean isPluginInitializationNeeded() {
        return !pluginsInitialized;
    }

    public static synchronized void initializePlugins(HttpServletRequest request) throws Exception {
        pluginsInitialized = true;
        Plugin[] plugins = PluginUtil.getPlugins(request);
        for (int i = 0; i < plugins.length; ++i) {
            Plugin plugin = plugins[i];
            boolean pluginInitialized = PluginUtil.initializePlugin(request, plugin);
            if (pluginInitialized) continue;
            pluginInitializationFailed = true;
        }
    }

    public static boolean initializePlugin(HttpServletRequest request, Plugin plugin) {
        try {
            plugin.applicationInit(request, new PluginServiceCallbacks(request, plugin));
            plugin.setInitialized(true);
        }
        catch (Exception e) {
            Logger.logError(PluginUtil.class, "initializePlugin", (ServletRequest)request, (Throwable)e);
            return false;
        }
        return true;
    }

    public static synchronized void dropPlugins(HttpServletRequest request) {
        ArrayList<Plugin> localPlugins = plugins;
        plugins = null;
        System.gc();
        System.runFinalization();
        if (localPlugins != null) {
            for (int i = 0; i < localPlugins.size(); ++i) {
                JarFile jarFile = localPlugins.get(i).getJarFile();
                if (jarFile == null) continue;
                try {
                    jarFile.close();
                    continue;
                }
                catch (IOException e) {
                    Logger.logError(PluginUtil.class, "dropPlugins", (ServletRequest)request, (Throwable)e);
                }
            }
        }
    }

    public static void invokeService(Plugin plugin, String actionId, HttpServletRequest request, HttpServletResponse response) {
        PluginService[] services = plugin.getServices();
        for (int i = 0; i < services.length; ++i) {
            PluginService service = services[i];
            if (!actionId.equals(service.getId())) continue;
            response.setContentType("text/json");
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Cache-Control", "no-cache");
            try {
                service.execute(new PluginServiceCallbacks(request, plugin), request, response);
                continue;
            }
            catch (Throwable t) {
                Logger.logError(PluginUtil.class, "invokeService", (ServletRequest)request, t);
                try {
                    response.sendError(599, t.getMessage());
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    public static Boolean isSecureService(Plugin plugin, String actionId, HttpServletRequest request) {
        Boolean isSecure = null;
        if (plugin != null) {
            PluginService[] services = plugin.getServices();
            for (int i = 0; i < services.length; ++i) {
                PluginService service = services[i];
                if (!actionId.equals(service.getId())) continue;
                isSecure = service.isSecureService();
                break;
            }
        }
        return isSecure;
    }

    public static boolean requestFilterExists(HttpServletRequest request) throws Exception {
        String service = request.getServletPath().substring(0, request.getServletPath().length() - 3);
        Plugin[] plugins = PluginUtil.getPlugins(request);
        for (int i = 0; i < plugins.length; ++i) {
            Plugin plugin = plugins[i];
            PluginRequestFilter[] requestFilters = plugin.getRequestFilters();
            for (int j = 0; j < requestFilters.length; ++j) {
                String[] filteredServices = requestFilters[j].getFilteredServices();
                for (int k = 0; k < filteredServices.length; ++k) {
                    if (!filteredServices[k].equals(service)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static JSONObject invokeRequestFilters(HttpServletRequest request, JSONArtifact jsonRequest) throws Exception {
        String service = request.getServletPath().substring(0, request.getServletPath().length() - 3);
        Plugin[] plugins = PluginUtil.getPlugins(request);
        for (int i = 0; i < plugins.length; ++i) {
            Plugin plugin = plugins[i];
            if (!plugin.isInitialized()) continue;
            PluginRequestFilter[] requestFilters = plugin.getRequestFilters();
            for (int j = 0; j < requestFilters.length; ++j) {
                String[] filteredServices = requestFilters[j].getFilteredServices();
                for (int k = 0; k < filteredServices.length; ++k) {
                    JSONObject jsonResponse;
                    if (!filteredServices[k].equals(service) || (jsonResponse = requestFilters[j].filter(new PluginServiceCallbacks(request, plugin), request, jsonRequest)) == null) continue;
                    return jsonResponse;
                }
            }
        }
        return null;
    }

    public static boolean responseFilterExists(HttpServletRequest request) throws Exception {
        String path = request.getServletPath();
        if (path != null && path.length() > 3) {
            String service = path.substring(0, path.length() - 3);
            Plugin[] plugins = PluginUtil.getPlugins(request);
            for (int i = 0; i < plugins.length; ++i) {
                Plugin plugin = plugins[i];
                PluginResponseFilter[] responseFilters = plugin.getResponseFilters();
                for (int j = 0; j < responseFilters.length; ++j) {
                    String[] filteredServices = responseFilters[j].getFilteredServices();
                    for (int k = 0; k < filteredServices.length; ++k) {
                        if (!filteredServices[k].equals(service)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static void invokeResponseFilters(HttpServletRequest request, JSONObject jsonResponse) throws Exception {
        String service = request.getServletPath().substring(0, request.getServletPath().length() - 3);
        Plugin[] plugins = PluginUtil.getPlugins(request);
        for (int i = 0; i < plugins.length; ++i) {
            Plugin plugin = plugins[i];
            if (!plugin.isInitialized()) continue;
            PluginResponseFilter[] responseFilters = plugin.getResponseFilters();
            for (int j = 0; j < responseFilters.length; ++j) {
                String[] filteredServices = responseFilters[j].getFilteredServices();
                for (int k = 0; k < filteredServices.length; ++k) {
                    if (!filteredServices[k].equals(service)) continue;
                    try {
                        responseFilters[j].filter(service, new PluginServiceCallbacks(request, plugin), request, jsonResponse);
                        continue;
                    }
                    catch (NullPointerException npe) {
                        Logger.logError(PluginUtil.class, "invokeResponseFilters", (ServletRequest)request, (Throwable)npe);
                    }
                }
            }
        }
    }
}

