/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util;

import com.ibm.ecm.configuration.ApplicationConfig;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.serviceability.Logger;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpSession;

public class PasswordEncrypter {
    private static int cipherKeyLength = 128;
    private static String digestAlgorithm = "SHA";
    private static String cipherAlgorithm = "AES";
    private static String keyHint = "February 14-15 marks the one year anniversary of IBM Watson's victory over Jeopardy!'s greatest human champions. Now, just 365 days later, the competition has shifted from Man vs. Machine, to Man & Machine. In one year, the IBM Watson Solutions team has worked to see what man and machine can accomplish together in a way that provides better diagnosis and treatment of disease, better insight into financial investments and planning, and countless other opportunities that allow humans to win time and time again. Watson is a system of systems\ufffdone of the most complex since System 360 and Deep Blue. Built on POWER7 technology, Watson also sits at the intersection of two big technology plays: Big Data and business analytics. In its debut on Jeopardy!, Watson analyzed more than 200 million pages in seconds, showcasing its natural ability to address ever-changing and growing amounts of information, a fact that stands to benefit healthcare clients. In September 2011, just 30 days after its official launch, Watson Solutions announced that the U.S.\ufffds largest healthcare insurer would be the first customer to collaborate on the development of a commercial application on Watson technology. Together with Wellpoint, Watson is hard at work ingesting millions of pages of patient information and medical data to assist clinicians in making decisions as they relate to patient care.";
    private static byte[] sessionKey = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        block7: {
            try {
                if (sessionKey != null) {
                    return;
                }
                ApplicationConfig appConfig = Config.getApplicationConfig("navigator");
                String key = appConfig.getEncryptionKey();
                if (key != null && !key.trim().equals("")) {
                    sessionKey = PasswordEncrypter.stringToByteArray(key);
                    break block7;
                }
                if (sessionKey != null) break block7;
                ApplicationConfig applicationConfig = appConfig;
                synchronized (applicationConfig) {
                    sessionKey = PasswordEncrypter.generateKey();
                    key = PasswordEncrypter.byteArrayToString(sessionKey);
                    appConfig.setEncryptionKey(key);
                    appConfig.save();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String encrypt(String password) throws Exception {
        if (password == null || password.trim().equals("")) {
            return null;
        }
        String methodName = "encrypt";
        String encryptedPassword = PasswordEncrypter.encrypt(password, sessionKey);
        Logger.logDebug(PasswordEncrypter.class, methodName, (HttpSession)null, "The Encrypted Password  is  encryptedPassword = " + encryptedPassword);
        PasswordEncrypter.validate(password, encryptedPassword);
        return encryptedPassword;
    }

    private static void validate(String password, String encryptedPassword) {
        String methodName = "validate";
        try {
            if (!password.equals(PasswordEncrypter.decrypt(encryptedPassword))) {
                Logger.logWarning(PasswordEncrypter.class, methodName, (HttpSession)null, "The Encrypted Password   encryptedPassword = " + encryptedPassword + " failed to decrypt with the key ");
            }
        }
        catch (Exception e) {
            Logger.logWarning(PasswordEncrypter.class, methodName, (HttpSession)null, "The Encrypted Password   encryptedPassword = " + encryptedPassword + " failed to decrypt with the key ");
        }
    }

    private static String encrypt(String password, byte[] keyBytes) throws Exception {
        byte[] raw;
        SecretKeySpec keySpec = new SecretKeySpec(keyBytes, cipherAlgorithm);
        IvParameterSpec ivParamSpec = new IvParameterSpec(PasswordEncrypter.hashKey());
        Cipher cipher = PasswordEncrypter.getCypher(keySpec, ivParamSpec, 1);
        byte[] stringBytes = password.getBytes("UTF8");
        try {
            raw = cipher.doFinal(stringBytes);
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception(e);
        }
        catch (BadPaddingException e) {
            throw new Exception(e);
        }
        return PasswordEncrypter.byteArrayToString(raw);
    }

    public static String decrypt(String encrypted) throws Exception {
        return PasswordEncrypter.decrypt(encrypted, sessionKey);
    }

    public static String decrypt(String encrypted, byte[] keyBytes) throws Exception {
        String clearPassword;
        if (encrypted == null || encrypted.trim().equals("")) {
            return encrypted;
        }
        SecretKeySpec keySpec = new SecretKeySpec(keyBytes, cipherAlgorithm);
        IvParameterSpec ivParamSpec = new IvParameterSpec(PasswordEncrypter.hashKey());
        Cipher cipher = PasswordEncrypter.getCypher(keySpec, ivParamSpec, 2);
        try {
            byte[] passwordDecoded = PasswordEncrypter.stringToByteArray(encrypted);
            clearPassword = new String(cipher.doFinal(passwordDecoded), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception("Reading error", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception("Encrypted password was corrupted", e);
        }
        catch (BadPaddingException e) {
            throw new Exception("Encrypted password was corrupted", e);
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        return clearPassword;
    }

    private static Cipher getCypher(SecretKeySpec keySpec, IvParameterSpec ivSpec, int mode) throws Exception {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(cipherAlgorithm);
            cipher.init(mode, (Key)keySpec, ivSpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Invalid Algorithm", e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("Invalid Padding", e);
        }
        catch (InvalidKeyException e) {
            throw new Exception("Invalid Key", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("Invalid Algorithm Parameter.", e);
        }
        return cipher;
    }

    private static byte[] hashKey() throws Exception {
        byte[] result = new byte[cipherKeyLength / 8];
        MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
        md.update(keyHint.getBytes());
        byte[] mdb = md.digest();
        for (int i = 0; i < result.length; ++i) {
            result[i] = mdb[i % mdb.length];
        }
        return result;
    }

    private static byte[] generateKey() throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance(cipherAlgorithm);
        generator.init(new SecureRandom());
        generator.init(128);
        SecretKey key = generator.generateKey();
        return key.getEncoded();
    }

    public static byte[] stringToByteArray(String data) throws Exception {
        String methodName = "stringToByteArray";
        if (data == null) {
            return null;
        }
        if ((data = data.trim()).equals("")) {
            return null;
        }
        byte[] result = new byte[data.length() / 2];
        try {
            for (int i = 0; i < result.length; ++i) {
                result[i] = (byte)Integer.parseInt(data.substring(i * 2, i * 2 + 2), 16);
            }
        }
        catch (NumberFormatException ex) {
            Logger.logWarning(PasswordEncrypter.class, methodName, (HttpSession)null, ex.getMessage());
            return null;
        }
        return result;
    }

    public static String byteArrayToString(byte[] data) {
        if (data == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            int value = data[i] & 0xFF;
            if (value <= 15) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(value));
        }
        return sb.toString();
    }
}

