/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util;

import com.ibm.ecm.serviceability.Logger;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class MessageUtil {
    private static final String PARM_RESOURCE_BUNDLE_NAME = "com.ibm.ecm.nls.ServicesMessages";
    private static final String I18N_PARMS = "I18N_PARMS";

    private static ResourceBundle getResourceBundle(Locale locale) {
        ClassLoader loader = MessageUtil.class.getClassLoader();
        return ResourceBundle.getBundle(PARM_RESOURCE_BUNDLE_NAME, locale, loader);
    }

    private static String replace(String string, String token, String replacementText) {
        StringBuffer resource = new StringBuffer().append(string);
        String str = resource.toString();
        int start = str.indexOf(token, 0);
        while (start != -1) {
            resource.replace(start, start + token.length(), replacementText);
            start = str.indexOf(token, start + 1);
        }
        return resource.toString();
    }

    public static String getMessage(PageContext page, String messageKey) {
        return MessageUtil.getMessage(page.getRequest().getLocale(), messageKey);
    }

    public static String getMessageWithToken(PageContext page, String messageKey, String text) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(text);
        return MessageUtil.getMessagePrivateArrayList(page.getRequest(), page.getRequest().getLocale(), messageKey, list);
    }

    public static String getMessageWithTokens(PageContext page, String messageKey) {
        return MessageUtil.getMessagePrivateArrayList(page.getRequest(), page.getRequest().getLocale(), messageKey, MessageUtil.getList(page));
    }

    private static String getMessagePrivateArrayList(ServletRequest request, Locale locale, String messageKey, ArrayList tokenValues) {
        String methodName = "getMessagePrivateArrayList";
        String nlsMessage = null;
        try {
            nlsMessage = MessageUtil.getResourceBundle(locale).getString(messageKey);
        }
        catch (Exception e) {
            Logger.logWarning(MessageUtil.class, methodName, request, messageKey + " not found");
            return messageKey + " not found";
        }
        if (nlsMessage == null) {
            return messageKey + " not found";
        }
        for (int i = 0; i < tokenValues.size(); ++i) {
            nlsMessage = MessageUtil.replace(nlsMessage, "{" + i + "}", tokenValues.get(i).toString());
        }
        return nlsMessage;
    }

    private static ArrayList getList(PageContext page) {
        ArrayList list = (ArrayList)page.getAttribute(I18N_PARMS);
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    private static void setList(PageContext page, ArrayList list) {
        if (list != null) {
            page.setAttribute(I18N_PARMS, (Object)list);
        }
    }

    private static void clearList(PageContext page) {
        ArrayList list = (ArrayList)page.getAttribute(I18N_PARMS);
        if (list != null) {
            list.clear();
            page.removeAttribute(I18N_PARMS);
        }
    }

    private static String getParm(PageContext page, int i) {
        ArrayList list = MessageUtil.getList(page);
        return (String)list.get(i);
    }

    public static void setParm(PageContext page, int i, Object parm) {
        ArrayList list = MessageUtil.getList(page);
        if (i == 0) {
            MessageUtil.clearList(page);
        }
        list.add(i, parm.toString());
        MessageUtil.setList(page, list);
    }

    public static void setClear(PageContext page) {
        ArrayList list = MessageUtil.getList(page);
        MessageUtil.clearList(page);
    }

    public static boolean containsKey(HttpServletRequest request, String messageKey) {
        try {
            ResourceBundle bundle = MessageUtil.getResourceBundle(request.getLocale());
            return bundle.containsKey(messageKey);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getMessage(HttpServletRequest request, String messageKey) {
        return MessageUtil.getMessage(request.getLocale(), messageKey);
    }

    public static String getMessage(HttpServletRequest request, String messageKey, String text) {
        ArrayList<String> al = new ArrayList<String>();
        al.add(text);
        return MessageUtil.getMessage(request.getLocale(), messageKey, al.toArray());
    }

    public static String getMessage(HttpServletRequest request, String messageKey, ArrayList list) {
        return MessageUtil.getMessage(request.getLocale(), messageKey, list.toArray());
    }

    public static String getMessage(HttpServletRequest request, String messageKey, Object[] tokenValues) {
        return MessageUtil.getMessage(request.getLocale(), messageKey, tokenValues);
    }

    public static String getMessage(Locale locale, String messageKey) {
        ArrayList al = new ArrayList();
        return MessageUtil.getMessage(locale, messageKey, al.toArray());
    }

    private static String getMessage(Locale locale, String messageKey, String text) {
        ArrayList<String> al = new ArrayList<String>();
        al.add(text);
        return MessageUtil.getMessage(locale, messageKey, al.toArray());
    }

    private static String getMessage(Locale locale, String messageKey, Object[] tokenValues) {
        String nlsMessage = null;
        try {
            ResourceBundle bundle = MessageUtil.getResourceBundle(locale);
            nlsMessage = bundle.getString(messageKey);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (nlsMessage == null) {
            nlsMessage = messageKey;
        }
        if (tokenValues != null) {
            for (int i = 0; i < tokenValues.length; ++i) {
                nlsMessage = MessageUtil.replace(nlsMessage, "{" + i + "}", tokenValues[i].toString());
            }
        }
        return nlsMessage;
    }
}

