/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util;

import com.ibm.ecm.configuration.ApplicationConfig;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.InterfaceTextConfig;
import com.ibm.ecm.configuration.InterfaceTextLabelConfig;
import com.ibm.ecm.configuration.MenuConfig;
import com.ibm.ecm.configuration.exception.MissingValueException;
import com.ibm.ecm.util.ActionUtil;
import com.ibm.ecm.util.MessageUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LabelUtil {
    public static List<InterfaceTextConfig> getApplicationUILabels(HttpServletRequest request, ApplicationConfig appConfig) throws ConfigurationException, MissingValueException {
        ArrayList<InterfaceTextConfig> list = new ArrayList<InterfaceTextConfig>();
        String applicationName = appConfig.getObjectId();
        String applicationIdPrefix = "app_";
        String labelKey = "class_label";
        InterfaceTextConfig labelUI = new InterfaceTextConfig(appConfig.getConfigurationObject(), applicationName, applicationIdPrefix + labelKey);
        labelUI.setLabelKey(labelKey);
        labelUI.setType("application");
        list.add(labelUI);
        labelKey = "repository";
        labelUI = new InterfaceTextConfig(appConfig.getConfigurationObject(), applicationName, applicationIdPrefix + labelKey);
        labelUI.setLabelKey(labelKey);
        labelUI.setType("application");
        list.add(labelUI);
        labelKey = "full_control_privilege";
        labelUI = new InterfaceTextConfig(appConfig.getConfigurationObject(), applicationName, applicationIdPrefix + labelKey);
        labelUI.setLabelKey(labelKey);
        labelUI.setType("application");
        list.add(labelUI);
        labelKey = "edit_privilege";
        labelUI = new InterfaceTextConfig(appConfig.getConfigurationObject(), applicationName, applicationIdPrefix + labelKey);
        labelUI.setLabelKey(labelKey);
        labelUI.setType("application");
        list.add(labelUI);
        labelKey = "read_only_privilege";
        labelUI = new InterfaceTextConfig(appConfig.getConfigurationObject(), applicationName, applicationIdPrefix + labelKey);
        labelUI.setLabelKey(labelKey);
        labelUI.setType("application");
        list.add(labelUI);
        return list;
    }

    public static List<InterfaceTextConfig> getSystemCMUILabels(HttpServletRequest request, ApplicationConfig appConfig) throws ConfigurationException, MissingValueException {
        ArrayList<InterfaceTextConfig> list = new ArrayList<InterfaceTextConfig>();
        String id = "createdTimestamp";
        InterfaceTextConfig labelUI = LabelUtil.createSystem(id, "cm", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document_folder");
        list.add(labelUI);
        id = "createdBy";
        labelUI = LabelUtil.createSystem(id, "cm", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document_folder");
        list.add(labelUI);
        id = "modifiedTimestamp";
        labelUI = LabelUtil.createSystem(id, "cm", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document_folder");
        list.add(labelUI);
        id = "modifiedBy";
        labelUI = LabelUtil.createSystem(id, "cm", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document_folder");
        list.add(labelUI);
        id = "version";
        labelUI = LabelUtil.createSystem(id, "cm", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document_folder");
        list.add(labelUI);
        id = "itemID";
        labelUI = LabelUtil.createSystem(id, "cm", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document_folder");
        list.add(labelUI);
        id = "expirationDate";
        labelUI = LabelUtil.createSystem(id, "cm", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document_folder");
        list.add(labelUI);
        id = "semanticType";
        labelUI = LabelUtil.createSystem(id, "cm", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document_folder");
        list.add(labelUI);
        id = "aclCode";
        labelUI = LabelUtil.createSystem(id, "cm", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document_folder");
        list.add(labelUI);
        id = "componentId";
        labelUI = LabelUtil.createSystem(id, "cm", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document_folder");
        list.add(labelUI);
        Collections.sort(list, new Comparator<InterfaceTextConfig>(){

            @Override
            public int compare(InterfaceTextConfig item1, InterfaceTextConfig item2) {
                return item1.getLabelKey().compareToIgnoreCase(item2.getLabelKey());
            }
        });
        return list;
    }

    public static List<InterfaceTextConfig> getSystemP8UILabels(HttpServletRequest request, ApplicationConfig appConfig) throws ConfigurationException, MissingValueException {
        ArrayList<InterfaceTextConfig> list = new ArrayList<InterfaceTextConfig>();
        String id = "Creator";
        InterfaceTextConfig labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document_folder");
        list.add(labelUI);
        id = "PathName";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_folder");
        list.add(labelUI);
        id = "VersionStatus";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document");
        list.add(labelUI);
        id = "DateCreated";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document_folder");
        list.add(labelUI);
        id = "LastModifier";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document_folder");
        list.add(labelUI);
        id = "DateLastModified";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document_folder");
        list.add(labelUI);
        id = "Id";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document_folder");
        list.add(labelUI);
        id = "MajorVersionNumber";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document");
        list.add(labelUI);
        id = "MinorVersionNumber";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document");
        list.add(labelUI);
        id = "ContentSize";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document");
        list.add(labelUI);
        id = "MimeType";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document");
        list.add(labelUI);
        id = "CoordinatedTasks";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document_folder");
        list.add(labelUI);
        id = "ActiveMarkings";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document_folder");
        list.add(labelUI);
        id = "IsFrozenVersion";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document");
        list.add(labelUI);
        id = "IsVersioningEnabled";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document");
        list.add(labelUI);
        id = "ReservationType";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document");
        list.add(labelUI);
        id = "DateCheckedIn";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document");
        list.add(labelUI);
        id = "DateContentLastAccessed";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document");
        list.add(labelUI);
        id = "ContentRetentionDate";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document");
        list.add(labelUI);
        id = "CurrentState";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document");
        list.add(labelUI);
        id = "IsInExceptionState";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document");
        list.add(labelUI);
        id = "ClassificationStatus";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document");
        list.add(labelUI);
        id = "IndexationId";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document");
        list.add(labelUI);
        id = "Publications";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document");
        list.add(labelUI);
        id = "IsReserved";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document");
        list.add(labelUI);
        id = "IsCurrentVersion";
        labelUI = LabelUtil.createSystem(id, "p8", appConfig, request);
        labelUI.setDisplayedIn("admin_interface_text_displayed_in_document");
        list.add(labelUI);
        Collections.sort(list, new Comparator<InterfaceTextConfig>(){

            @Override
            public int compare(InterfaceTextConfig item1, InterfaceTextConfig item2) {
                return item1.getLabelKey().compareToIgnoreCase(item2.getLabelKey());
            }
        });
        return list;
    }

    public static InterfaceTextConfig createSystem(String id, String repositoryType, ApplicationConfig appConfig, HttpServletRequest request) throws ConfigurationException, MissingValueException {
        String applicationName = appConfig.getObjectId();
        String systemIdPrefix = "sys_";
        InterfaceTextConfig labelUI = new InterfaceTextConfig(appConfig.getConfigurationObject(), applicationName, systemIdPrefix + id);
        String messageKey = "system" + repositoryType + "." + id + ".label";
        String translatedValue = MessageUtil.getMessage(request, messageKey);
        InterfaceTextLabelConfig labelConfig = labelUI.getLabelData();
        labelConfig.setLabel(request.getLocale().getLanguage(), translatedValue);
        String[] locales = appConfig.getLocales();
        for (int j = 0; j < locales.length; ++j) {
            String localeString = locales[j];
            Locale locale = new Locale(localeString);
            String messageValue = MessageUtil.getMessage(locale, messageKey);
            labelConfig.setLabel(localeString, messageValue);
        }
        labelUI.setLabelKey(translatedValue);
        labelUI.setType("system");
        labelUI.setRepositoryType(repositoryType);
        return labelUI;
    }

    public static List<InterfaceTextConfig> getDesktopUILabels(HttpServletRequest request, ApplicationConfig appConfig) throws Exception {
        ArrayList<InterfaceTextConfig> list = new ArrayList<InterfaceTextConfig>();
        Collection<DesktopConfig> desktopList = appConfig.getDesktopList();
        for (DesktopConfig desktopConfig : desktopList) {
            list.addAll(LabelUtil.getLabels(request, appConfig, desktopConfig.getApplicationSpaceLabels()));
        }
        return list;
    }

    public static List<InterfaceTextConfig> getLabels(HttpServletRequest request, ApplicationConfig appConfig, String[] ids) throws Exception {
        ArrayList<InterfaceTextConfig> list = new ArrayList<InterfaceTextConfig>();
        String appName = appConfig.getObjectId();
        if (ids != null && ids.length > 0) {
            for (String id : ids) {
                InterfaceTextConfig itConfig = new InterfaceTextConfig(appConfig.getConfigurationObject(), appName, id);
                list.add(itConfig);
            }
        }
        return list;
    }

    public static List<InterfaceTextConfig> getActionUILabels(HttpServletRequest request, ApplicationConfig appConfig) throws Exception {
        String applicationName = appConfig.getObjectId();
        String actionIdPrefix = "act_";
        ArrayList<InterfaceTextConfig> list = new ArrayList<InterfaceTextConfig>();
        List<MenuConfig> menuItemList = ActionUtil.getAllActions(request, applicationName);
        Collections.sort(menuItemList, new Comparator<MenuConfig>(){

            @Override
            public int compare(MenuConfig item1, MenuConfig item2) {
                return item1.getLabel().compareToIgnoreCase(item2.getLabel());
            }
        });
        String[] locales = appConfig.getLocales();
        String[] serverIds = appConfig.getServersId();
        for (int i = 0; i < serverIds.length; ++i) {
            String serverType = serverIds[i];
            for (MenuConfig menu : menuItemList) {
                if (!menu.containsServer(serverType)) continue;
                String id = actionIdPrefix + serverType + "_" + menu.getId();
                InterfaceTextConfig labelUI = new InterfaceTextConfig(appConfig.getConfigurationObject(), applicationName, id);
                if (menu.getPluginId() == null) {
                    String messageKey = "action." + menu.getId() + ".label";
                    String translatedValue = MessageUtil.getMessage(request, messageKey);
                    InterfaceTextLabelConfig labelConfig = labelUI.getLabelData();
                    labelConfig.setLabel(request.getLocale().getLanguage(), translatedValue);
                    for (int j = 0; j < locales.length; ++j) {
                        String localeString = locales[j];
                        Locale locale = new Locale(localeString);
                        String messageValue = MessageUtil.getMessage(locale, messageKey);
                        labelConfig.setLabel(localeString, messageValue);
                    }
                    labelUI.setLabelKey(translatedValue);
                } else {
                    InterfaceTextLabelConfig labelConfig = labelUI.getLabelData();
                    labelConfig.setLabel(request.getLocale().getLanguage(), menu.getLabel());
                    for (int j = 0; j < locales.length; ++j) {
                        String localeString = locales[j];
                        Locale locale = new Locale(localeString);
                        labelConfig.setLabel(localeString, menu.getLabel());
                    }
                    labelUI.setLabelKey(menu.getLabel());
                }
                labelUI.setType("action");
                labelUI.setRepositoryType(serverType);
                StringBuffer sb = new StringBuffer();
                String[] serverTypes = menu.getServerTypes();
                for (int k = 0; k < serverTypes.length; ++k) {
                    String menuServerType = serverTypes[k];
                    if (k != 0) {
                        sb.append(":");
                    }
                    sb.append(menuServerType);
                }
                labelUI.setUserData(new String[]{menu.getId(), sb.toString()});
                list.add(labelUI);
            }
        }
        return list;
    }
}

