/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class JarManifest {
    public static final String BUILD_DATE = "Build-Date";
    public static final String COPYRIGHT = "Copyright";
    public static final String IMPLEMENTATION_TITLE = "Implementation-Title";
    public static final String IMPLEMENTATION_VENDOR = "Implementation-Vendor";
    public static final String IMPLEMENTATION_VERSION = "Implementation-Version";
    public static final String SPECIFICATION_TITLE = "Specification-Title";
    public static final String SPECIFICATION_VENDOR = "Specification-Vendor";
    public static final String SPECIFICATION_VERSION = "Specification-Version";

    public static List getManifestAttributes(Object instance, String jarNameOrPath, String[] attributeNames) {
        if (jarNameOrPath == null || attributeNames == null) {
            return null;
        }
        List results = null;
        ClassLoader classLoader = null;
        if (instance != null) {
            classLoader = instance.getClass().getClassLoader();
            results = JarManifest.getManifestAttributesViaAClassLoader(jarNameOrPath, attributeNames, classLoader);
        }
        if (results != null) {
            return results;
        }
        try {
            classLoader = JarManifest.getPrivilegedSystemClassLoader();
            results = JarManifest.getManifestAttributesViaAClassLoader(jarNameOrPath, attributeNames, classLoader);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (results != null) {
            return results;
        }
        try {
            classLoader = JarManifest.getPrivilegedThreadClassLoader();
            results = JarManifest.getManifestAttributesViaAClassLoader(jarNameOrPath, attributeNames, classLoader);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        return results;
    }

    private static List getManifestAttributesViaAClassLoader(String jarNameOrPath, String[] attributeNames, ClassLoader classLoader) {
        Enumeration<URL> urls;
        try {
            urls = classLoader.getResources("META-INF/MANIFEST.MF");
        }
        catch (IOException e) {
            return null;
        }
        String pathComponent = null;
        String jarWithoutSlash = null;
        String jarWithSlash = null;
        if (jarNameOrPath.indexOf(47) >= 0) {
            pathComponent = (jarNameOrPath + (jarNameOrPath.endsWith("/") ? "" : "/") + "META-INF/MANIFEST.MF").toLowerCase();
        } else {
            jarWithoutSlash = (jarNameOrPath + "!/" + "META-INF/MANIFEST.MF").toLowerCase();
            jarWithSlash = "/" + jarWithoutSlash;
        }
        while (urls.hasMoreElements()) {
            Manifest mf;
            URL url = urls.nextElement();
            String path = url.getPath().toLowerCase();
            if ((jarWithSlash == null || !path.endsWith(jarWithSlash)) && !path.equals(jarWithoutSlash) && (pathComponent == null || !path.endsWith(pathComponent))) continue;
            ArrayList<String> results = new ArrayList<String>(attributeNames.length);
            try {
                mf = new Manifest(url.openStream());
            }
            catch (IOException e) {
                return results;
            }
            Attributes attributes = mf.getMainAttributes();
            for (int ii = 0; ii < attributeNames.length; ++ii) {
                String attributeName = attributeNames[ii];
                String attributeValue = attributes.getValue(attributeName);
                results.add(attributeValue);
            }
            return results;
        }
        return null;
    }

    private static final ClassLoader getPrivilegedSystemClassLoader() {
        Object o = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
        return (ClassLoader)o;
    }

    private static final ClassLoader getPrivilegedThreadClassLoader() {
        Object o = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return (ClassLoader)o;
    }
}

