/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorWrapper<T>
implements Iterator<T> {
    private Iterator<T> current;
    private LinkedList<Iterator<T>> iterators = new LinkedList();

    public IteratorWrapper(Collection<Iterator<T>> iters) {
        for (Iterator<T> it : iters) {
            if (!it.hasNext()) continue;
            if (this.current == null) {
                this.current = it;
                continue;
            }
            this.iterators.addLast(it);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.current != null && this.current.hasNext()) {
            return true;
        }
        return !this.iterators.isEmpty();
    }

    @Override
    public T next() {
        if (this.current != null && this.current.hasNext()) {
            return this.current.next();
        }
        if (this.iterators.isEmpty()) {
            return null;
        }
        this.current = this.iterators.removeFirst();
        return this.current.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

