/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util;

import com.ibm.ecm.configuration.ApplicationConfig;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.IconConfig;
import com.ibm.ecm.configuration.IconStatusConfig;
import com.ibm.ecm.configuration.IdLabelConfig;
import com.ibm.ecm.configuration.exception.MissingValueException;
import com.ibm.ecm.util.MessageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IconMappingUtil {
    public static String[] getDefaultContentTypes() {
        Object[] contentTypes = new String[]{"application/vnd.ms-outlook", "application/iccxit", "message/rfc822", "application/icccsn", "application/csbundled", "application/afp", "application/pdf", "text/plain", "application/rtf", "application/x-rtf", "text/richtext", "application/dca-rft", "text/html", "text/htm", "application/x-compress", "application/x-compressed", "application/x-zip-compressed", "application/zip", "multipart/x-zip", "text/xml", "application/xml", "application/x-vnd.oasis.opendocument.presentation", "application/vnd.ms-powerpoint", "application/vnd.lotus-freelance", "application/vnd.oasis.opendocument.presentation", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/vnd.openxmlformats-officedocument.presentationml.template", "application/vnd.ms-powerpoint.presentation.macroEnabled.12", "application/vnd.ms-powerpoint.template.macroEnabled.12", "application/line", "application/x-vnd.oasis.opendocument.spreadsheet", "application/vnd.ms-excel", "application/vnd.ms-excel.sheet.binary.macroEnabled.12", "application/vnd.ms-excel.addin.macroEnabled.12", "application/vnd.ms-excel.sheet.macroEnabled.12", "application/vnd.lotus-1-2-3", "application/vnd.openxmlformats-officedocument.spreadsheetml.template", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.oasis.opendocument.spreadsheet", "application/x-vnd.oasis.opendocument.text", "application/msword", "application/vnd.lotus-wordpro", "application/wordperfect5.1", "application/vnd.oasis.opendocument.text", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.wordprocessingml.template", "application/vnd.ms-word.template.macroEnabled.12", "application/vnd.ms-word.document.macroEnabled.12", "application/x-filenet-filetype-msg", "application/x-filenet-searchtemplate", "application/x-filenet-entrytemplate", "application/x-filenet-formdataentrytemplate", "application/x-filenet-itxformtemplate", "application/x-filenet-customobjectentrytemplate", "application/x-filenet-documententrytemplate", "application/x-filenet-folderentrytemplate", "application/x-filenet-declarerecordentrytemplate", "application/x-filenet-search", "application/x-filenet-workflowdefinition", "application/x-filenet-xpdlworkflowdefinition", "application/x-workitem", "application/x-tracker", "application/x-filenet-documentpolicy", "application/x-filenet-workflowpolicy", "application/x-filenet-formdata", "application/x-filenet-external"};
        Arrays.sort(contentTypes);
        return contentTypes;
    }

    public static List<IdLabelConfig> getDefaultStatusClasses(HttpServletRequest request, ApplicationConfig appConfig) throws ConfigurationException, MissingValueException {
        String[] classes = new String[]{"ecmHoldIcon", "ecmNoteIcon", "ecmHasMinorIcon", "ecmRecordIcon", "ecmBookmarkIcon", "ecmLockIcon", "ecmSuspendedIcon", "ecmImportanceIcon", "ecmMessageSentIcon"};
        return IconMappingUtil.getList(request, appConfig, classes, "iconStatusClass");
    }

    public static List<IdLabelConfig> getDefaultContentTypeClasses(HttpServletRequest request, ApplicationConfig appConfig) throws ConfigurationException, MissingValueException {
        String[] classes = new String[]{"ftNoContent", "ftAudio", "ftAfp", "ftPdf", "ftPlain", "ftWeb", "ftCompressed", "ftCode", "ftPresentation", "ftData", "ftWordProcessing", "ftMail", "ftOutlookMail", "ftNotesMail", "ftSearchTemplate", "ftEntryTemplate", "ftTemplateForm", "ftCustomObjectEntryTemplate", "ftSearchStored", "ftWorkflow", "ftWorkItem", "ftTracker", "ftPolicyDocument", "ftPolicyWorkflow", "ftFormData", "ftExternalFile", "ftDocumentEntryTemplate", "ftFolderEntryTemplate", "ftDeclareRecordEntryTemplate", "ftGraphic", "ftVideo"};
        return IconMappingUtil.getList(request, appConfig, classes, "iconMappingClass");
    }

    public static List<IdLabelConfig> getList(HttpServletRequest request, ApplicationConfig appConfig, String[] array, String prefix) throws ConfigurationException, MissingValueException {
        String applicationName = appConfig.getObjectId();
        ArrayList<IdLabelConfig> list = new ArrayList<IdLabelConfig>();
        for (int i = 0; i < array.length; ++i) {
            String arrayValue = array[i];
            IdLabelConfig config = Config.getIdLabelConfig(applicationName, arrayValue);
            String messageKey = prefix + "." + arrayValue + ".label";
            String label = MessageUtil.getMessage(request, messageKey);
            config.setLabel(label);
            Config.removeConfigurationFromCache(config);
            list.add(config);
        }
        Collections.sort(list, new Comparator<IdLabelConfig>(){

            @Override
            public int compare(IdLabelConfig item1, IdLabelConfig item2) {
                return item1.getLabel().compareToIgnoreCase(item2.getLabel());
            }
        });
        return list;
    }

    public static List<IconConfig> getIconConfigs(HttpServletRequest request, ApplicationConfig appConfig) throws ConfigurationException, MissingValueException {
        Configuration propertiesConfig = appConfig.getConfigurationObject();
        String applicationName = appConfig.getObjectId();
        ArrayList<IconConfig> list = new ArrayList<IconConfig>();
        String idPrefix = "default";
        int counter = 0;
        String iconId = idPrefix + counter;
        String key = "icon." + applicationName + "." + iconId;
        if (!propertiesConfig.containsKey(key)) {
            AbstractConfiguration defaultConfig = Config.getDefaultConfiguration();
            while (defaultConfig.containsKey(key)) {
                IconConfig mapping = Config.getIconConfig(applicationName, iconId);
                list.add(mapping);
                iconId = idPrefix + ++counter;
                key = "icon." + applicationName + "." + iconId;
            }
        } else {
            while (propertiesConfig.containsKey(key)) {
                IconConfig mapping = Config.getIconConfig(applicationName, iconId);
                list.add(mapping);
                iconId = idPrefix + ++counter;
                key = "icon." + applicationName + "." + iconId;
            }
        }
        return list;
    }

    public static List<IconStatusConfig> getIconStatusConfigs(HttpServletRequest request, ApplicationConfig appConfig) throws ConfigurationException, MissingValueException {
        Collection<IconStatusConfig> collection = appConfig.getIconStatusList();
        ArrayList<IconStatusConfig> list = new ArrayList<IconStatusConfig>();
        for (IconStatusConfig config : collection) {
            String messageKey = "iconStatus." + config.getObjectId() + ".label";
            String label = MessageUtil.getMessage(request, messageKey);
            config.setLabel(label);
            Config.removeConfigurationFromCache(config);
            list.add(config);
        }
        Collections.sort(list, new Comparator<IconStatusConfig>(){

            @Override
            public int compare(IconStatusConfig item1, IconStatusConfig item2) {
                return item1.getLabel().compareToIgnoreCase(item2.getLabel());
            }
        });
        return list;
    }
}

